/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.event2;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.event2.NodeResourceHelper;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.BDDMockito;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class NodeResourceHelperUnitTest {
    @Mock
    private NodeService nodeServiceMock;
    @InjectMocks
    private NodeResourceHelper nodeResourceHelper;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.openMocks((Object)this);
    }

    @Test
    public void shouldExtractOnlyRelevantPropertiesForBeforeNode() {
        Map<String, LocalizedValues> before = Map.of("unchanged-empty", this.locValues(), "unchanged-non-empty", this.locValues("pl", "Kie\u0142basa", "en", "Sausage"), "changed-added", this.locValues("pl", "Kie\u0142basa"), "changed-modified", this.locValues("pl", "XYZ", "en", "Sausage"), "changed-deleted", this.locValues("pl", "Kie\u0142basa", "en", "Sausage"), "changed-added-modified-deleted", this.locValues("pl", "XYZ", "en", "Sausage"), "changed-to-empty", this.locValues("pl", "Kie\u0142basa", "en", "Sausage"), "changed-from-empty", this.locValues(), "removed-empty", this.locValues(), "removed-non-empty", this.locValues("pl", "Kie\u0142basa", "en", "Sausage"));
        Map<String, LocalizedValues> after = Map.of("unchanged-empty", this.locValues(), "unchanged-non-empty", this.locValues("pl", "Kie\u0142basa", "en", "Sausage"), "changed-added", this.locValues("pl", "Kie\u0142basa", "en", "Sausage"), "changed-modified", this.locValues("pl", "Kie\u0142basa", "en", "Sausage"), "changed-deleted", this.locValues("en", "Sausage"), "changed-added-modified-deleted", this.locValues("pl", "Kie\u0142basa", "de", "W\u00fcrst"), "changed-to-empty", this.locValues(), "changed-from-empty", this.locValues("pl", "Kie\u0142basa", "en", "Sausage"), "new-empty", this.locValues(), "new-non-empty", this.locValues("de", "W\u00fcrst"));
        Map diff = NodeResourceHelper.getLocalizedPropertiesBefore(before, after);
        Assert.assertFalse((boolean)diff.containsKey("unchanged-empty"));
        Assert.assertFalse((boolean)diff.containsKey("unchanged-non-empty"));
        Assert.assertEquals((Object)this.locValues("en", null), diff.get("changed-added"));
        Assert.assertEquals((Object)this.locValues("pl", "XYZ"), diff.get("changed-modified"));
        Assert.assertEquals((Object)this.locValues("pl", "Kie\u0142basa"), diff.get("changed-deleted"));
        Assert.assertEquals((Object)this.locValues("pl", "XYZ", "en", "Sausage", "de", null), diff.get("changed-added-modified-deleted"));
        Assert.assertEquals((Object)this.locValues("pl", "Kie\u0142basa", "en", "Sausage"), diff.get("changed-to-empty"));
        Assert.assertEquals((Object)this.locValues("pl", null, "en", null), diff.get("changed-from-empty"));
        Assert.assertFalse((boolean)diff.containsKey("removed-empty"));
        Assert.assertEquals((Object)this.locValues("pl", "Kie\u0142basa", "en", "Sausage"), diff.get("removed-non-empty"));
        Assert.assertFalse((boolean)diff.containsKey("new-empty"));
        Assert.assertEquals((Object)this.locValues("de", null), diff.get("new-non-empty"));
    }

    private LocalizedValues locValues(String l1, String v1, String l2, String v2, String l3, String v3) {
        return this.locValues(l1, v1, l2, v2).append(l3, v3);
    }

    private LocalizedValues locValues(String l1, String v1, String l2, String v2) {
        return this.locValues(l1, v1).append(l2, v2);
    }

    private LocalizedValues locValues(String l1, String v1) {
        return this.locValues().append(l1, v1);
    }

    private LocalizedValues locValues() {
        return new LocalizedValues();
    }

    @Test
    public void testGetSecondaryParents() {
        NodeRef nodeRefMock = (NodeRef)Mockito.mock(NodeRef.class);
        NodeRef parentRefMock = (NodeRef)Mockito.mock(NodeRef.class);
        ChildAssociationRef secondaryParentMock = (ChildAssociationRef)Mockito.mock(ChildAssociationRef.class);
        BDDMockito.given((Object)this.nodeServiceMock.getParentAssocs((NodeRef)ArgumentMatchers.any(NodeRef.class))).willReturn(List.of(secondaryParentMock));
        BDDMockito.given((Object)secondaryParentMock.isPrimary()).willReturn((Object)false);
        BDDMockito.given((Object)secondaryParentMock.getParentRef()).willReturn((Object)parentRefMock);
        List secondaryParents = this.nodeResourceHelper.getSecondaryParents(nodeRefMock);
        ((NodeService)BDDMockito.then((Object)this.nodeServiceMock).should()).getParentAssocs(nodeRefMock);
        BDDMockito.then((Object)this.nodeServiceMock).shouldHaveNoMoreInteractions();
        ((ChildAssociationRef)BDDMockito.then((Object)secondaryParentMock).should()).isPrimary();
        ((ChildAssociationRef)BDDMockito.then((Object)secondaryParentMock).should()).getParentRef();
        BDDMockito.then((Object)secondaryParentMock).shouldHaveNoMoreInteractions();
        ((NodeRef)BDDMockito.then((Object)parentRefMock).should()).getId();
        BDDMockito.then((Object)parentRefMock).shouldHaveNoMoreInteractions();
        Assert.assertNotNull((Object)secondaryParents);
    }

    @Test
    public void testGetNoneSecondaryParents() {
        NodeRef nodeRefMock = (NodeRef)Mockito.mock(NodeRef.class);
        List secondaryParents = this.nodeResourceHelper.getSecondaryParents(nodeRefMock);
        Assert.assertNotNull((Object)secondaryParents);
        Assert.assertTrue((boolean)secondaryParents.isEmpty());
    }

    private static class LocalizedValues
    extends HashMap<String, String> {
        private LocalizedValues() {
        }

        public LocalizedValues append(String language, String value) {
            this.put(language, value);
            return this;
        }
    }
}

