/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.tools;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.tools.ToolArgumentException;
import org.alfresco.tools.ToolContext;
import org.alfresco.tools.ToolException;
import org.alfresco.util.ApplicationContextHelper;
import org.springframework.context.ApplicationContext;

public abstract class Tool {
    private ToolContext toolContext;
    private ApplicationContext appContext;
    private ServiceRegistry serviceRegistry;

    protected ToolContext processArgs(String[] args) throws ToolArgumentException {
        return new ToolContext();
    }

    protected void displayHelp() {
        this.logError("Sorry.  Help is not available.");
    }

    protected abstract int execute() throws ToolException;

    protected abstract String getToolName();

    protected void logInfo(String msg) {
        if (!this.toolContext.isQuiet()) {
            System.out.println(msg);
        }
    }

    protected void logVerbose(String msg) {
        if (this.toolContext.isVerbose()) {
            this.logInfo(msg);
        }
    }

    protected void logError(String msg) {
        System.out.println(msg);
    }

    protected int handleError(Throwable e) {
        if (e instanceof ToolArgumentException) {
            this.logError(e.getMessage());
            this.logError("");
            this.displayHelp();
        } else if (e instanceof ToolException) {
            if (e.getCause() != null) {
                this.logError(String.valueOf(e.getMessage()) + " caused by: " + e.getCause().getMessage());
            } else {
                this.logError(e.getMessage());
            }
            if (this.toolContext != null && this.toolContext.isVerbose()) {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                e.printStackTrace(printWriter);
                this.logError(stringWriter.toString());
            }
        } else {
            this.logError("The following error has occurred:" + e.getMessage());
            if (this.toolContext != null && this.toolContext.isVerbose()) {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                e.printStackTrace(printWriter);
                this.logError(stringWriter.toString());
            }
        }
        return -1;
    }

    protected void exit(int status) {
        System.exit(status);
    }

    protected final ApplicationContext getApplicationContext() {
        return this.appContext;
    }

    protected final ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    public final void start(String[] args) {
        long startTime = System.nanoTime();
        int status = -1;
        try {
            this.toolContext = this.processArgs(args);
            this.toolContext.validate();
            if (this.toolContext.isHelp()) {
                this.displayHelp();
            } else {
                this.logInfo(this.getToolName());
                this.initialiseRepository();
                if (this.toolContext.isLogin()) {
                    this.login();
                }
                long loginTime = System.nanoTime();
                if (this.toolContext.isLogin()) {
                    this.logInfo("Time to login " + (float)(loginTime - startTime) / 1.0E9f + " seconds");
                }
                status = this.execute();
                long executeTime = System.nanoTime();
                this.logInfo("Time to execute " + (float)(executeTime - loginTime) / 1.0E9f + " seconds");
                this.logInfo(String.valueOf(this.getToolName()) + " successfully completed.");
            }
        }
        catch (Throwable e) {
            status = this.handleError(e);
        }
        this.exit(status);
    }

    private void login() {
        MutableAuthenticationService auth = this.serviceRegistry.getAuthenticationService();
        auth.authenticate(this.toolContext.getUsername(), this.toolContext.getPassword().toCharArray());
        this.logInfo("Connected as " + this.toolContext.getUsername());
    }

    private void initialiseRepository() {
        this.appContext = ApplicationContextHelper.getApplicationContext();
        this.serviceRegistry = (ServiceRegistry)this.appContext.getBean("ServiceRegistry");
    }
}

