/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.solr;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import org.alfresco.httpclient.HttpClientFactory;
import org.alfresco.repo.search.QueryParserException;
import org.alfresco.util.ParameterCheck;
import org.apache.commons.codec.net.URLCodec;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class SolrAdminHTTPClient {
    static Log s_logger = LogFactory.getLog(SolrAdminHTTPClient.class);
    private String adminUrl;
    private String baseUrl;
    private HttpClient httpClient;
    private HttpClientFactory httpClientFactory;

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public void init() {
        ParameterCheck.mandatory((String)"baseUrl", (Object)this.baseUrl);
        StringBuilder sb = new StringBuilder();
        sb.append(String.valueOf(this.baseUrl) + "/admin/cores");
        this.adminUrl = sb.toString();
        this.httpClient = this.httpClientFactory.getHttpClient();
        HttpClientParams params = this.httpClient.getParams();
        params.setBooleanParameter("http.authentication.preemptive", true);
        this.httpClient.getState().setCredentials(new AuthScope(AuthScope.ANY_HOST, -1), (Credentials)new UsernamePasswordCredentials("admin", "admin"));
    }

    public void setHttpClientFactory(HttpClientFactory httpClientFactory) {
        this.httpClientFactory = httpClientFactory;
    }

    public JSONObject execute(HashMap<String, String> args) {
        return this.execute(this.adminUrl, args);
    }

    public JSONObject execute(String relativeHandlerPath, HashMap<String, String> args) {
        JSONObject jSONObject;
        ParameterCheck.mandatory((String)"relativeHandlerPath", (Object)relativeHandlerPath);
        ParameterCheck.mandatory((String)"args", args);
        String path = this.getPath(relativeHandlerPath);
        URLCodec encoder = new URLCodec();
        StringBuilder url = new StringBuilder();
        for (String key : args.keySet()) {
            String value = args.get(key);
            if (url.length() == 0) {
                url.append(path);
                url.append("?");
                url.append(encoder.encode(key, "UTF-8"));
                url.append("=");
                url.append(encoder.encode(value, "UTF-8"));
                continue;
            }
            url.append("&");
            url.append(encoder.encode(key, "UTF-8"));
            url.append("=");
            url.append(encoder.encode(value, "UTF-8"));
        }
        GetMethod get = new GetMethod(url.toString());
        try {
            JSONObject json;
            Header locationHeader;
            this.httpClient.executeMethod((HttpMethod)get);
            if ((get.getStatusCode() == 301 || get.getStatusCode() == 302) && (locationHeader = get.getResponseHeader("location")) != null) {
                String redirectLocation = locationHeader.getValue();
                get.setURI(new URI(redirectLocation, true));
                this.httpClient.executeMethod((HttpMethod)get);
            }
            if (get.getStatusCode() != 200) {
                throw new QueryParserException("Request failed " + get.getStatusCode() + " " + url.toString());
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(get.getResponseBodyAsStream()));
            jSONObject = json = new JSONObject(new JSONTokener((Reader)reader));
        }
        catch (Throwable throwable) {
            try {
                get.releaseConnection();
                throw throwable;
            }
            catch (UnsupportedEncodingException e) {
                throw new QueryParserException("", e);
            }
            catch (HttpException e) {
                throw new QueryParserException("", e);
            }
            catch (IOException e) {
                throw new QueryParserException("", e);
            }
            catch (JSONException e) {
                throw new QueryParserException("", e);
            }
        }
        get.releaseConnection();
        return jSONObject;
    }

    private String getPath(String path) {
        if (path.startsWith(this.baseUrl)) {
            return path;
        }
        if (path.startsWith("/")) {
            return String.valueOf(this.baseUrl) + path;
        }
        return String.valueOf(this.baseUrl) + '/' + path;
    }
}

