/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.download;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.attribute.FileTime;
import java.util.Date;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.download.BaseExporter;
import org.alfresco.repo.download.DownloadCancelledException;
import org.alfresco.repo.download.DownloadStatusUpdateService;
import org.alfresco.repo.download.DownloadStorage;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.coci.CheckOutCheckInService;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.download.DownloadStatus;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.view.ExporterContext;
import org.alfresco.service.cmr.view.ExporterException;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipDownloadExporter
extends BaseExporter {
    private static Logger log = LoggerFactory.getLogger(ZipDownloadExporter.class);
    private static final String PATH_SEPARATOR = "/";
    protected ZipArchiveOutputStream zipStream;
    private NodeRef downloadNodeRef;
    private int sequenceNumber = 1;
    private long total;
    private long done;
    private long totalFileCount;
    private long filesAddedCount;
    private RetryingTransactionHelper transactionHelper;
    private DownloadStorage downloadStorage;
    private DictionaryService dictionaryService;
    private DownloadStatusUpdateService updateService;
    private Deque<Pair<String, NodeRef>> path = new LinkedList<Pair<String, NodeRef>>();
    private String currentName;
    private OutputStream outputStream;
    private Date zipTimestampCreated;
    private Date zipTimestampModified;

    public ZipDownloadExporter(File zipFile, CheckOutCheckInService checkOutCheckInService, NodeService nodeService, RetryingTransactionHelper transactionHelper, DownloadStatusUpdateService updateService, DownloadStorage downloadStorage, DictionaryService dictionaryService, NodeRef downloadNodeRef, long total, long totalFileCount) {
        super(checkOutCheckInService, nodeService);
        try {
            this.outputStream = new FileOutputStream(zipFile);
            this.updateService = updateService;
            this.transactionHelper = transactionHelper;
            this.downloadStorage = downloadStorage;
            this.dictionaryService = dictionaryService;
            this.downloadNodeRef = downloadNodeRef;
            this.total = total;
            this.totalFileCount = totalFileCount;
        }
        catch (FileNotFoundException e) {
            throw new ExporterException("Failed to create zip file", e);
        }
    }

    @Override
    public void start(ExporterContext context) {
        this.zipStream = new ZipArchiveOutputStream(this.outputStream);
        this.zipStream.setEncoding("UTF-8");
        this.zipStream.setCreateUnicodeExtraFields(ZipArchiveOutputStream.UnicodeExtraFieldPolicy.ALWAYS);
        this.zipStream.setUseLanguageEncodingFlag(true);
        this.zipStream.setFallbackToUTF8(true);
    }

    @Override
    public void startNode(NodeRef nodeRef) {
        this.currentName = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_NAME));
        this.zipTimestampCreated = (Date)this.nodeService.getProperty(nodeRef, ContentModel.PROP_CREATED);
        this.zipTimestampModified = (Date)this.nodeService.getProperty(nodeRef, ContentModel.PROP_MODIFIED);
        this.path.push((Pair<String, NodeRef>)new Pair((Object)this.currentName, (Object)nodeRef));
        if (this.dictionaryService.isSubClass(this.nodeService.getType(nodeRef), ContentModel.TYPE_FOLDER)) {
            String path = String.valueOf(this.getPath()) + PATH_SEPARATOR;
            ZipArchiveEntry archiveEntry = new ZipArchiveEntry(path);
            try {
                archiveEntry.setTime(this.zipTimestampCreated.getTime());
                archiveEntry.setCreationTime(FileTime.fromMillis(this.zipTimestampCreated.getTime()));
                archiveEntry.setLastModifiedTime(FileTime.fromMillis(this.zipTimestampModified.getTime()));
                this.zipStream.putArchiveEntry(archiveEntry);
                this.zipStream.closeArchiveEntry();
            }
            catch (IOException e) {
                throw new ExporterException("Unexpected IOException adding folder entry", e);
            }
        }
    }

    @Override
    public void contentImpl(NodeRef nodeRef, QName property, InputStream content, ContentData contentData, int index) {
        if (content == null) {
            return;
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug("Archiving content for nodeRef: " + nodeRef + " with contentURL: " + contentData.getContentUrl());
            }
            ZipArchiveEntry zipEntry = new ZipArchiveEntry(this.getPath());
            zipEntry.setTime(this.zipTimestampCreated.getTime());
            zipEntry.setCreationTime(FileTime.fromMillis(this.zipTimestampCreated.getTime()));
            zipEntry.setLastModifiedTime(FileTime.fromMillis(this.zipTimestampModified.getTime()));
            this.zipStream.putArchiveEntry(zipEntry);
            this.copyStream((OutputStream)this.zipStream, content);
            this.zipStream.closeArchiveEntry();
            ++this.filesAddedCount;
        }
        catch (IOException e) {
            throw new ExporterException("Failed to zip export stream", e);
        }
    }

    @Override
    public void endNode(NodeRef nodeRef) {
        this.path.pop();
    }

    @Override
    public void end() {
        try {
            this.zipStream.close();
        }
        catch (IOException error) {
            throw new ExporterException("Unexpected error closing zip stream!", error);
        }
    }

    private String getPath() {
        if (this.path.size() < 1) {
            throw new IllegalStateException("No elements in path!");
        }
        Iterator<Pair<String, NodeRef>> iter = this.path.descendingIterator();
        StringBuilder pathBuilder = new StringBuilder();
        while (iter.hasNext()) {
            Pair<String, NodeRef> element = iter.next();
            pathBuilder.append((String)element.getFirst());
            if (!iter.hasNext()) continue;
            pathBuilder.append(PATH_SEPARATOR);
        }
        return pathBuilder.toString();
    }

    private void copyStream(OutputStream output, InputStream in) throws IOException {
        byte[] buffer = new byte[20480];
        int read = in.read(buffer, 0, 20480);
        int i = 0;
        while (read != -1) {
            output.write(buffer, 0, read);
            this.done += (long)read;
            if (i++ % 500 == 0) {
                this.updateStatus();
                this.checkCancelled();
            }
            read = in.read(buffer, 0, 20480);
        }
    }

    private void checkCancelled() {
        boolean downloadCancelled = this.transactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Boolean>(){

            @Override
            public Boolean execute() throws Throwable {
                return ZipDownloadExporter.this.downloadStorage.isCancelled(ZipDownloadExporter.this.downloadNodeRef);
            }
        }, true, true);
        if (downloadCancelled) {
            log.debug("Download cancelled");
            throw new DownloadCancelledException();
        }
    }

    private void updateStatus() {
        this.transactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Throwable {
                DownloadStatus status = new DownloadStatus(DownloadStatus.Status.IN_PROGRESS, ZipDownloadExporter.this.done, ZipDownloadExporter.this.total, ZipDownloadExporter.this.filesAddedCount, ZipDownloadExporter.this.totalFileCount);
                ZipDownloadExporter.this.updateService.update(ZipDownloadExporter.this.downloadNodeRef, status, ZipDownloadExporter.this.getNextSequenceNumber());
                return null;
            }
        }, false, true);
    }

    public int getNextSequenceNumber() {
        return this.sequenceNumber++;
    }

    public long getDone() {
        return this.done;
    }

    public long getTotal() {
        return this.total;
    }

    public long getFilesAdded() {
        return this.filesAddedCount;
    }

    public long getTotalFiles() {
        return this.totalFileCount;
    }
}

