/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.mimetype;

import java.io.Serializable;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.domain.mimetype.MimetypeDAO;
import org.alfresco.repo.domain.mimetype.MimetypeEntity;
import org.alfresco.util.Pair;
import org.springframework.dao.ConcurrencyFailureException;
import org.springframework.extensions.surf.util.ParameterCheck;

public abstract class AbstractMimetypeDAOImpl
implements MimetypeDAO {
    private static final Long CACHE_NULL_LONG = Long.MIN_VALUE;
    private static final String NULL_SAFE_STRING = ".null";
    private SimpleCache<Serializable, Serializable> mimetypeEntityCache;

    public void setMimetypeEntityCache(SimpleCache<Serializable, Serializable> mimetypeEntityCache) {
        this.mimetypeEntityCache = mimetypeEntityCache;
    }

    @Override
    public Pair<Long, String> getMimetype(Long id) {
        String mimetype = (String)this.mimetypeEntityCache.get((Serializable)id);
        if (mimetype != null) {
            return new Pair((Object)id, (Object)mimetype);
        }
        MimetypeEntity mimetypeEntity = this.getMimetypeEntity(id);
        if (mimetypeEntity == null) {
            throw new AlfrescoRuntimeException("The MimetypeEntity ID " + id + " doesn't exist.");
        }
        mimetype = mimetypeEntity.getMimetype();
        this.mimetypeEntityCache.put((Serializable)((Object)mimetype), (Object)id);
        this.mimetypeEntityCache.put((Serializable)id, (Object)mimetype);
        return new Pair((Object)id, (Object)mimetype);
    }

    @Override
    public Pair<Long, String> getMimetype(String mimetype) {
        ParameterCheck.mandatory((String)"mimetype", (Object)mimetype);
        mimetype = this.sanitizeMimetype(mimetype);
        Long id = (Long)this.mimetypeEntityCache.get((Serializable)((Object)mimetype));
        if (id != null) {
            if (id.equals(CACHE_NULL_LONG)) {
                return null;
            }
            return new Pair((Object)id, (Object)mimetype);
        }
        MimetypeEntity result = this.getMimetypeEntity(mimetype);
        if (result == null) {
            this.mimetypeEntityCache.put((Serializable)((Object)mimetype), (Object)CACHE_NULL_LONG);
            return null;
        }
        id = result.getId();
        this.mimetypeEntityCache.put((Serializable)id, (Object)mimetype);
        this.mimetypeEntityCache.put((Serializable)((Object)mimetype), (Object)id);
        return new Pair((Object)id, (Object)mimetype);
    }

    @Override
    public Pair<Long, String> getOrCreateMimetype(String mimetype) {
        ParameterCheck.mandatory((String)"mimetype", (Object)mimetype);
        mimetype = this.sanitizeMimetype(mimetype);
        Pair result = this.getMimetype(mimetype);
        if (result == null) {
            MimetypeEntity mimetypeEntity = this.createMimetypeEntity(mimetype);
            Long id = mimetypeEntity.getId();
            result = new Pair((Object)id, (Object)mimetype);
            this.mimetypeEntityCache.put((Serializable)id, (Object)mimetype);
            this.mimetypeEntityCache.put((Serializable)((Object)mimetype), (Object)id);
        }
        return result;
    }

    @Override
    public int updateMimetype(String oldMimetype, String newMimetype) {
        ParameterCheck.mandatory((String)"oldMimetype", (Object)oldMimetype);
        oldMimetype = this.sanitizeMimetype(oldMimetype);
        ParameterCheck.mandatory((String)"newMimetype", (Object)newMimetype);
        newMimetype = this.sanitizeMimetype(newMimetype);
        Pair<Long, String> oldMimetypePair = this.getMimetype(oldMimetype);
        if (oldMimetypePair == null) {
            this.getOrCreateMimetype(newMimetype);
            return 0;
        }
        Long id = (Long)oldMimetypePair.getFirst();
        int count = this.updateMimetypeEntity(id, newMimetype);
        if (count != 1) {
            throw new ConcurrencyFailureException("Concurrent update of mimetype: " + oldMimetype);
        }
        this.mimetypeEntityCache.remove((Serializable)((Object)oldMimetype));
        this.mimetypeEntityCache.put((Serializable)id, (Object)newMimetype);
        this.mimetypeEntityCache.put((Serializable)((Object)newMimetype), (Object)id);
        return count;
    }

    protected String sanitizeMimetype(String mimetype) {
        assert (mimetype != null);
        return mimetype.toLowerCase();
    }

    protected abstract MimetypeEntity getMimetypeEntity(Long var1);

    protected abstract MimetypeEntity getMimetypeEntity(String var1);

    protected abstract MimetypeEntity createMimetypeEntity(String var1);

    protected abstract int updateMimetypeEntity(Long var1, String var2);
}

