/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.rendition.RenditionDefinition;
import org.alfresco.service.cmr.rendition.RenditionService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.apache.chemistry.opencmis.commons.data.RenditionData;
import org.apache.chemistry.opencmis.commons.exceptions.CmisFilterNotValidException;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.RenditionDataImpl;

@Deprecated
public class CMISRenditionMapping {
    private NodeService nodeService;
    private ContentService contentService;
    private RenditionService renditionService;
    private TransactionService transactionService;
    private Map<String, List<String>> kindToRenditionNames;
    private Map<String, String> renditionNamesToKind;
    private Map<String, BigInteger[]> renditionNameToSize;

    public CMISRenditionMapping(NodeService nodeService, ContentService contentService, RenditionService renditionService, TransactionService transactionService, Map<String, List<String>> renditionKinds) {
        this.nodeService = nodeService;
        this.contentService = contentService;
        this.renditionService = renditionService;
        this.transactionService = transactionService;
        this.kindToRenditionNames = renditionKinds == null ? new HashMap<String, List<String>>() : renditionKinds;
        this.renditionNamesToKind = new HashMap<String, String>();
        for (Map.Entry<String, List<String>> entry : renditionKinds.entrySet()) {
            for (String renditionName : entry.getValue()) {
                this.renditionNamesToKind.put(renditionName, entry.getKey());
            }
        }
        this.cacheRenditionSizes();
    }

    private void cacheRenditionSizes() {
        this.renditionNameToSize = (Map)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Map<String, BigInteger[]>>(){

            public Map<String, BigInteger[]> doWork() throws Exception {
                return CMISRenditionMapping.this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Map<String, BigInteger[]>>(){

                    @Override
                    public Map<String, BigInteger[]> execute() throws Exception {
                        HashMap<String, BigInteger[]> rn2s = new HashMap<String, BigInteger[]>();
                        List<RenditionDefinition> allRenditionDefs = CMISRenditionMapping.this.renditionService.loadRenditionDefinitions();
                        for (RenditionDefinition rd : allRenditionDefs) {
                            QName renditionDefinitionName = rd.getRenditionName();
                            Number width = (Number)rd.getParameterValue("xsize");
                            Number height = (Number)rd.getParameterValue("ysize");
                            if (width == null && height == null) continue;
                            BigInteger[] size = new BigInteger[]{width == null ? null : BigInteger.valueOf(width.longValue()), height == null ? null : BigInteger.valueOf(height.longValue())};
                            rn2s.put(renditionDefinitionName.getLocalName(), size);
                        }
                        return rn2s;
                    }
                }, true);
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    public List<RenditionData> getRenditions(NodeRef nodeRef, String renditionFilter, BigInteger maxItems, BigInteger skipCount) {
        ArrayList<RenditionData> result;
        block11: {
            int skip;
            result = new ArrayList<RenditionData>();
            Set<String> filterSet = this.splitRenditionFilter(renditionFilter);
            if (filterSet != null && filterSet.contains("cmis:none")) {
                return result;
            }
            int max = maxItems == null ? Integer.MAX_VALUE : maxItems.intValue();
            int n = skip = skipCount == null || skipCount.intValue() < 0 ? 0 : skipCount.intValue();
            if (max <= 0) break block11;
            List<ChildAssociationRef> renditionList = this.renditionService.getRenditions(nodeRef);
            int lastIndex = (max + skip > renditionList.size() ? renditionList.size() : max + skip) - 1;
            int i = skip;
            while (i <= lastIndex) {
                block12: {
                    String mimeType;
                    ContentReader reader;
                    String rendName;
                    NodeRef rendNodeRef;
                    block13: {
                        ChildAssociationRef rendition = renditionList.get(i);
                        rendNodeRef = rendition.getChildRef();
                        rendName = rendition.getQName().getLocalName();
                        QName contentProperty = ContentModel.PROP_CONTENT;
                        Serializable contentPropertyName = this.nodeService.getProperty(rendNodeRef, ContentModel.PROP_CONTENT_PROPERTY_NAME);
                        if (contentPropertyName != null) {
                            contentProperty = (QName)contentPropertyName;
                        }
                        if ((reader = this.contentService.getReader(rendNodeRef, contentProperty)) == null || !reader.exists()) break block12;
                        mimeType = reader.getMimetype();
                        if (mimeType.indexOf(59) > 3) {
                            mimeType = mimeType.substring(0, mimeType.indexOf(59)).trim();
                        }
                        if (filterSet == null) break block13;
                        boolean include = false;
                        for (String f : filterSet) {
                            if (f.indexOf(47) == -1) {
                                List<String> renditionNames = this.kindToRenditionNames.get(f);
                                if (renditionNames == null || !renditionNames.contains(rendName)) continue;
                                include = true;
                                break;
                            }
                            if (f.endsWith("*")) {
                                if (!mimeType.startsWith(f.substring(0, f.length() - 2))) continue;
                                include = true;
                                break;
                            }
                            if (!mimeType.equals(f)) continue;
                            include = true;
                            break;
                        }
                        if (!include) break block12;
                    }
                    String title = rendName;
                    String kind = this.renditionNamesToKind.containsKey(rendName) ? this.renditionNamesToKind.get(rendName) : rendName;
                    BigInteger length = BigInteger.valueOf(reader.getSize());
                    BigInteger width = null;
                    BigInteger height = null;
                    if (this.renditionNameToSize.containsKey(rendName)) {
                        BigInteger[] size = this.renditionNameToSize.get(rendName);
                        width = size[0];
                        height = size[1];
                    }
                    result.add(this.createRenditionData(rendNodeRef, mimeType, title, kind, length, width, height));
                }
                ++i;
            }
        }
        return result;
    }

    private Set<String> splitRenditionFilter(String filter) {
        if (filter == null) {
            return null;
        }
        if (filter.trim().length() == 0) {
            return null;
        }
        HashSet<String> result = new HashSet<String>();
        String[] stringArray = filter.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if ((s = s.trim()).equals("*")) {
                return null;
            }
            if (s.indexOf(42) > -1) {
                if (!s.endsWith("*")) {
                    throw new CmisFilterNotValidException("Rendition filter is invalid: " + s);
                }
                result.add(s);
            } else {
                if (s.equalsIgnoreCase("cmis:none")) {
                    result.clear();
                    result.add("cmis:none");
                    break;
                }
                if (s.length() > 0) {
                    result.add(s);
                }
            }
            ++n2;
        }
        return result;
    }

    private RenditionData createRenditionData(NodeRef rendNodeRef, String mimeType, String title, String kind, BigInteger length, BigInteger width, BigInteger height) {
        RenditionDataImpl result = new RenditionDataImpl();
        result.setStreamId(rendNodeRef.getId());
        result.setMimeType(mimeType);
        result.setTitle(title);
        result.setKind(kind);
        result.setBigLength(length);
        result.setBigWidth(width);
        result.setBigHeight(height);
        result.setRenditionDocumentId(rendNodeRef.getId());
        return result;
    }
}

