/*
 * Decompiled with CFR 0.152.
 */
package lib3party.org.apache.chemistry.opencmis.server.support.wrapper;

import java.math.BigInteger;
import java.util.List;
import lib3party.org.apache.chemistry.opencmis.server.support.wrapper.AbstractCmisServiceWrapper;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.AllowableActions;
import org.apache.chemistry.opencmis.commons.data.BulkUpdateObjectIdAndChangeToken;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.FailedToDeleteData;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderContainer;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderList;
import org.apache.chemistry.opencmis.commons.data.ObjectList;
import org.apache.chemistry.opencmis.commons.data.ObjectParentData;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.data.RenditionData;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionContainer;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionList;
import org.apache.chemistry.opencmis.commons.enums.AclPropagation;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.enums.RelationshipDirection;
import org.apache.chemistry.opencmis.commons.enums.UnfileObject;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.commons.spi.Holder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConformanceCmisServiceWrapper
extends AbstractCmisServiceWrapper {
    public static final BigInteger MINUS_ONE = BigInteger.valueOf(-1L);
    private static final Logger LOG = LoggerFactory.getLogger(ConformanceCmisServiceWrapper.class);
    private BigInteger defaultTypesMaxItems = null;
    private BigInteger defaultTypesDepth = MINUS_ONE;
    private BigInteger defaultMaxItems = null;
    private BigInteger defaultDepth = MINUS_ONE;

    public ConformanceCmisServiceWrapper(CmisService service) {
        super(service);
    }

    public ConformanceCmisServiceWrapper(CmisService service, BigInteger defaultTypesMaxItems, BigInteger defaultTypesDepth, BigInteger defaultMaxItems, BigInteger defaultDepth) {
        super(service);
        this.defaultTypesMaxItems = defaultTypesMaxItems;
        this.defaultTypesDepth = defaultTypesDepth;
        this.defaultMaxItems = defaultMaxItems;
        this.defaultDepth = defaultDepth;
    }

    @Override
    public void initialize(Object[] params) {
        if (params == null) {
            return;
        }
        if (params.length > 0) {
            this.defaultTypesMaxItems = this.convertToBigInteger(params[0]);
        }
        if (params.length > 1) {
            this.defaultTypesDepth = this.convertToBigInteger(params[1]);
        }
        if (params.length > 2) {
            this.defaultMaxItems = this.convertToBigInteger(params[2]);
        }
        if (params.length > 3) {
            this.defaultDepth = this.convertToBigInteger(params[3]);
        }
    }

    private BigInteger convertToBigInteger(Object obj) {
        try {
            if (obj instanceof BigInteger) {
                return (BigInteger)obj;
            }
            if (obj instanceof String) {
                return new BigInteger((String)obj);
            }
            if (obj instanceof Number) {
                return BigInteger.valueOf(((Number)obj).longValue());
            }
        }
        catch (NumberFormatException e) {
            throw new CmisRuntimeException("Invalid number: " + obj.toString(), (Throwable)e);
        }
        return null;
    }

    protected void setDefaultTypesMaxItems(BigInteger defaultTypesMaxItems) {
        this.defaultTypesMaxItems = defaultTypesMaxItems;
    }

    protected void setDefaultTypesDepth(BigInteger defaultTypesDepth) {
        this.defaultTypesDepth = defaultTypesDepth;
    }

    protected void setDefaultMaxItems(BigInteger defaultMaxItems) {
        this.defaultMaxItems = defaultMaxItems;
    }

    protected void setDefaultDepth(BigInteger defaultDepth) {
        this.defaultDepth = defaultDepth;
    }

    protected CmisBaseException createCmisException(Exception e) {
        if (e == null) {
            return new CmisRuntimeException("Unknown exception!");
        }
        if (e instanceof CmisBaseException) {
            return (CmisBaseException)e;
        }
        LOG.warn(e.toString(), (Throwable)e);
        return new CmisRuntimeException(e.getMessage(), (Throwable)e);
    }

    protected void checkId(String name, String id) {
        if (id == null) {
            throw new CmisInvalidArgumentException(String.valueOf(name) + " must be set!");
        }
        if (id.length() == 0) {
            throw new CmisInvalidArgumentException(String.valueOf(name) + " must not be empty!");
        }
    }

    protected void checkIds(String name, String ... ids) {
        String[] stringArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            if (id != null && id.length() > 0) {
                return;
            }
            ++n2;
        }
        throw new CmisInvalidArgumentException(String.valueOf(name) + " must be set!");
    }

    protected void checkHolderId(String name, Holder<String> holder) {
        if (holder == null) {
            throw new CmisInvalidArgumentException(String.valueOf(name) + " must be set!");
        }
        this.checkId(name, (String)holder.getValue());
    }

    protected void checkRepositoryId(String repositoryId) {
        this.checkId("Repository Id", repositoryId);
    }

    protected void checkPath(String name, String path) {
        if (path == null) {
            throw new CmisInvalidArgumentException(String.valueOf(name) + " must be set!");
        }
        if (path.length() == 0) {
            throw new CmisInvalidArgumentException(String.valueOf(name) + " must not be empty!");
        }
        if (path.charAt(0) != '/') {
            throw new CmisInvalidArgumentException(String.valueOf(name) + " must start with '/'!");
        }
    }

    protected void checkProperties(Properties properties) {
        if (properties == null) {
            throw new CmisInvalidArgumentException("Properties must be set!");
        }
    }

    protected void checkProperty(Properties properties, String propertyId, Class<?> clazz) {
        if (properties.getProperties() == null) {
            throw new CmisInvalidArgumentException("Property " + propertyId + " must be set!");
        }
        PropertyData property = (PropertyData)properties.getProperties().get(propertyId);
        if (property == null) {
            throw new CmisInvalidArgumentException("Property " + propertyId + " must be set!");
        }
        Object value = property.getFirstValue();
        if (value == null) {
            throw new CmisInvalidArgumentException("Property " + propertyId + " must have a value!");
        }
        if (!clazz.isAssignableFrom(value.getClass())) {
            throw new CmisInvalidArgumentException("Property " + propertyId + " has the wrong type!");
        }
    }

    protected void checkContentStream(ContentStream content) {
        if (content == null) {
            throw new CmisInvalidArgumentException("Content must be set!");
        }
    }

    protected void checkQueryStatement(String statement) {
        if (statement == null) {
            throw new CmisInvalidArgumentException("Statement must be set!");
        }
        if (statement.length() == 0) {
            throw new CmisInvalidArgumentException("Statement must not be empty!");
        }
    }

    protected void checkTypeDefinition(TypeDefinition typeDef) {
        if (typeDef == null) {
            throw new CmisInvalidArgumentException("Type definition must be set!");
        }
    }

    protected void checkList(String name, List<?> list) {
        if (list == null) {
            throw new CmisInvalidArgumentException(String.valueOf(name) + " must be set!");
        }
        if (list.isEmpty()) {
            throw new CmisInvalidArgumentException(String.valueOf(name) + " must not be empty!");
        }
    }

    protected void checkBulkUpdateList(List<BulkUpdateObjectIdAndChangeToken> list) {
        if (list == null) {
            throw new CmisInvalidArgumentException("Object Id list must be set!");
        }
        if (list.isEmpty()) {
            throw new CmisInvalidArgumentException("Object Id list must not be empty!");
        }
        for (BulkUpdateObjectIdAndChangeToken entry : list) {
            if (entry == null) {
                throw new CmisInvalidArgumentException("Object Id list has gaps!");
            }
            if (entry.getId() == null) {
                throw new CmisInvalidArgumentException("Object Id list contains an entry without ID!");
            }
            if (entry.getId().length() != 0) continue;
            throw new CmisInvalidArgumentException("Object Id list contains an entry with an empty ID!");
        }
    }

    protected Boolean getDefaultTrue(Boolean value) {
        if (value == null) {
            return Boolean.TRUE;
        }
        return value;
    }

    protected Boolean getDefaultFalse(Boolean value) {
        if (value == null) {
            return Boolean.FALSE;
        }
        return value;
    }

    protected IncludeRelationships getDefault(IncludeRelationships value) {
        if (value == null) {
            return IncludeRelationships.NONE;
        }
        return value;
    }

    protected UnfileObject getDefault(UnfileObject value) {
        if (value == null) {
            return UnfileObject.DELETE;
        }
        return value;
    }

    protected AclPropagation getDefault(AclPropagation value) {
        if (value == null) {
            return AclPropagation.REPOSITORYDETERMINED;
        }
        return value;
    }

    protected RelationshipDirection getDefault(RelationshipDirection value) {
        if (value == null) {
            return RelationshipDirection.SOURCE;
        }
        return value;
    }

    protected String getDefaultRenditionFilter(String value) {
        if (value == null || value.length() == 0) {
            return "cmis:none";
        }
        return value;
    }

    protected BigInteger getTypesMaxItems(BigInteger maxItems) {
        if (maxItems == null) {
            return this.defaultTypesMaxItems;
        }
        if (maxItems.compareTo(BigInteger.ZERO) == -1) {
            throw new CmisInvalidArgumentException("maxItems must not be negative!");
        }
        return maxItems;
    }

    protected BigInteger getTypesDepth(BigInteger depth) {
        if (depth == null) {
            return this.defaultTypesDepth;
        }
        if (depth.compareTo(BigInteger.ZERO) == 0) {
            throw new CmisInvalidArgumentException("depth must not be 0!");
        }
        if (depth.compareTo(MINUS_ONE) == -1) {
            throw new CmisInvalidArgumentException("depth must not be <-1!");
        }
        return depth;
    }

    protected BigInteger getMaxItems(BigInteger maxItems) {
        if (maxItems == null) {
            return this.defaultMaxItems;
        }
        if (maxItems.compareTo(BigInteger.ZERO) == -1) {
            throw new CmisInvalidArgumentException("maxItems must not be negative!");
        }
        return maxItems;
    }

    protected BigInteger getSkipCount(BigInteger skipCount) {
        if (skipCount == null) {
            return BigInteger.ZERO;
        }
        if (skipCount.compareTo(BigInteger.ZERO) == -1) {
            throw new CmisInvalidArgumentException("skipCount must not be negative!");
        }
        return skipCount;
    }

    protected BigInteger getDepth(BigInteger depth) {
        if (depth == null) {
            return this.defaultDepth;
        }
        if (depth.compareTo(BigInteger.ZERO) == 0) {
            throw new CmisInvalidArgumentException("depth must not be 0!");
        }
        if (depth.compareTo(MINUS_ONE) == -1) {
            throw new CmisInvalidArgumentException("depth must not be <-1!");
        }
        return depth;
    }

    protected void checkNullOrPositive(String name, BigInteger value) {
        if (value == null) {
            return;
        }
        if (value.compareTo(BigInteger.ZERO) == -1) {
            throw new CmisInvalidArgumentException(String.valueOf(name) + " must not be negative!");
        }
    }

    @Override
    public RepositoryInfo getRepositoryInfo(String repositoryId, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        try {
            return this.getWrappedService().getRepositoryInfo(repositoryId, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    @Override
    public List<RepositoryInfo> getRepositoryInfos(ExtensionsData extension) {
        try {
            return this.getWrappedService().getRepositoryInfos(extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    @Override
    public TypeDefinitionList getTypeChildren(String repositoryId, String typeId, Boolean includePropertyDefinitions, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        includePropertyDefinitions = this.getDefaultFalse(includePropertyDefinitions);
        maxItems = this.getTypesMaxItems(maxItems);
        skipCount = this.getSkipCount(skipCount);
        try {
            return this.getWrappedService().getTypeChildren(repositoryId, typeId, includePropertyDefinitions, maxItems, skipCount, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    @Override
    public TypeDefinition getTypeDefinition(String repositoryId, String typeId, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkId("Type Id", typeId);
        try {
            return this.getWrappedService().getTypeDefinition(repositoryId, typeId, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    @Override
    public List<TypeDefinitionContainer> getTypeDescendants(String repositoryId, String typeId, BigInteger depth, Boolean includePropertyDefinitions, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        includePropertyDefinitions = this.getDefaultFalse(includePropertyDefinitions);
        depth = this.getTypesDepth(depth);
        try {
            return this.getWrappedService().getTypeDescendants(repositoryId, typeId, depth, includePropertyDefinitions, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    @Override
    public TypeDefinition createType(String repositoryId, TypeDefinition type, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkTypeDefinition(type);
        try {
            return this.getWrappedService().createType(repositoryId, type, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    @Override
    public TypeDefinition updateType(String repositoryId, TypeDefinition type, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkTypeDefinition(type);
        try {
            return this.getWrappedService().updateType(repositoryId, type, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    @Override
    public void deleteType(String repositoryId, String typeId, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkId("Type Id", typeId);
        try {
            this.getWrappedService().deleteType(repositoryId, typeId, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    @Override
    public ObjectList getCheckedOutDocs(String repositoryId, String folderId, String filter, String orderBy, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        includeAllowableActions = this.getDefaultFalse(includeAllowableActions);
        includeRelationships = this.getDefault(includeRelationships);
        renditionFilter = this.getDefaultRenditionFilter(renditionFilter);
        maxItems = this.getMaxItems(maxItems);
        skipCount = this.getSkipCount(skipCount);
        try {
            return this.getWrappedService().getCheckedOutDocs(repositoryId, folderId, filter, orderBy, includeAllowableActions, includeRelationships, renditionFilter, maxItems, skipCount, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    @Override
    public ObjectInFolderList getChildren(String repositoryId, String folderId, String filter, String orderBy, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePathSegment, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkId("Folder Id", folderId);
        includeAllowableActions = this.getDefaultFalse(includeAllowableActions);
        includeRelationships = this.getDefault(includeRelationships);
        renditionFilter = this.getDefaultRenditionFilter(renditionFilter);
        includePathSegment = this.getDefaultFalse(includePathSegment);
        maxItems = this.getMaxItems(maxItems);
        skipCount = this.getSkipCount(skipCount);
        try {
            return this.getWrappedService().getChildren(repositoryId, folderId, filter, orderBy, includeAllowableActions, includeRelationships, renditionFilter, includePathSegment, maxItems, skipCount, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    @Override
    public List<ObjectInFolderContainer> getDescendants(String repositoryId, String folderId, BigInteger depth, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePathSegment, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkId("Folder Id", folderId);
        depth = this.getDepth(depth);
        includeAllowableActions = this.getDefaultFalse(includeAllowableActions);
        includeRelationships = this.getDefault(includeRelationships);
        renditionFilter = this.getDefaultRenditionFilter(renditionFilter);
        includePathSegment = this.getDefaultFalse(includePathSegment);
        try {
            return this.getWrappedService().getDescendants(repositoryId, folderId, depth, filter, includeAllowableActions, includeRelationships, renditionFilter, includePathSegment, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    @Override
    public ObjectData getFolderParent(String repositoryId, String folderId, String filter, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkId("Folder Id", folderId);
        try {
            return this.getWrappedService().getFolderParent(repositoryId, folderId, filter, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    @Override
    public List<ObjectInFolderContainer> getFolderTree(String repositoryId, String folderId, BigInteger depth, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePathSegment, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkId("Folder Id", folderId);
        depth = this.getDepth(depth);
        includeAllowableActions = this.getDefaultFalse(includeAllowableActions);
        includeRelationships = this.getDefault(includeRelationships);
        renditionFilter = this.getDefaultRenditionFilter(renditionFilter);
        includePathSegment = this.getDefaultFalse(includePathSegment);
        try {
            return this.getWrappedService().getFolderTree(repositoryId, folderId, depth, filter, includeAllowableActions, includeRelationships, renditionFilter, includePathSegment, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    @Override
    public List<ObjectParentData> getObjectParents(String repositoryId, String objectId, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includeRelativePathSegment, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkId("Object Id", objectId);
        includeAllowableActions = this.getDefaultFalse(includeAllowableActions);
        includeRelationships = this.getDefault(includeRelationships);
        renditionFilter = this.getDefaultRenditionFilter(renditionFilter);
        includeRelativePathSegment = this.getDefaultFalse(includeRelativePathSegment);
        try {
            return this.getWrappedService().getObjectParents(repositoryId, objectId, filter, includeAllowableActions, includeRelationships, renditionFilter, includeRelativePathSegment, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    @Override
    public String create(String repositoryId, Properties properties, String folderId, ContentStream contentStream, VersioningState versioningState, List<String> policies, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkProperties(properties);
        this.checkProperty(properties, "cmis:objectTypeId", String.class);
        try {
            return this.getWrappedService().create(repositoryId, properties, folderId, contentStream, versioningState, policies, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    @Override
    public String createDocument(String repositoryId, Properties properties, String folderId, ContentStream contentStream, VersioningState versioningState, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkProperties(properties);
        this.checkProperty(properties, "cmis:objectTypeId", String.class);
        try {
            return this.getWrappedService().createDocument(repositoryId, properties, folderId, contentStream, versioningState, policies, addAces, removeAces, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    @Override
    public String createDocumentFromSource(String repositoryId, String sourceId, Properties properties, String folderId, VersioningState versioningState, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkId("Source Id", sourceId);
        try {
            return this.getWrappedService().createDocumentFromSource(repositoryId, sourceId, properties, folderId, versioningState, policies, addAces, removeAces, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    @Override
    public String createFolder(String repositoryId, Properties properties, String folderId, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkProperties(properties);
        this.checkProperty(properties, "cmis:objectTypeId", String.class);
        this.checkId("Folder Id", folderId);
        try {
            return this.getWrappedService().createFolder(repositoryId, properties, folderId, policies, addAces, removeAces, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    @Override
    public String createPolicy(String repositoryId, Properties properties, String folderId, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkProperties(properties);
        this.checkProperty(properties, "cmis:objectTypeId", String.class);
        try {
            return this.getWrappedService().createPolicy(repositoryId, properties, folderId, policies, addAces, removeAces, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    @Override
    public String createItem(String repositoryId, Properties properties, String folderId, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkProperties(properties);
        this.checkProperty(properties, "cmis:objectTypeId", String.class);
        try {
            return this.getWrappedService().createItem(repositoryId, properties, folderId, policies, addAces, removeAces, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    @Override
    public String createRelationship(String repositoryId, Properties properties, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkProperties(properties);
        this.checkProperty(properties, "cmis:objectTypeId", String.class);
        try {
            return this.getWrappedService().createRelationship(repositoryId, properties, policies, addAces, removeAces, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    @Override
    public void deleteContentStream(String repositoryId, Holder<String> objectId, Holder<String> changeToken, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkHolderId("Object Id", objectId);
        try {
            this.getWrappedService().deleteContentStream(repositoryId, objectId, changeToken, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    @Override
    public void deleteObject(String repositoryId, String objectId, Boolean allVersions, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkId("Object Id", objectId);
        allVersions = this.getDefaultTrue(allVersions);
        try {
            this.getWrappedService().deleteObject(repositoryId, objectId, allVersions, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    @Override
    public void deleteObjectOrCancelCheckOut(String repositoryId, String objectId, Boolean allVersions, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkId("Object Id", objectId);
        allVersions = this.getDefaultTrue(allVersions);
        try {
            this.getWrappedService().deleteObjectOrCancelCheckOut(repositoryId, objectId, allVersions, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    @Override
    public FailedToDeleteData deleteTree(String repositoryId, String folderId, Boolean allVersions, UnfileObject unfileObjects, Boolean continueOnFailure, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkId("Folder Id", folderId);
        allVersions = this.getDefaultTrue(allVersions);
        unfileObjects = this.getDefault(unfileObjects);
        continueOnFailure = this.getDefaultFalse(continueOnFailure);
        try {
            return this.getWrappedService().deleteTree(repositoryId, folderId, allVersions, unfileObjects, continueOnFailure, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    @Override
    public AllowableActions getAllowableActions(String repositoryId, String objectId, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkId("Object Id", objectId);
        try {
            return this.getWrappedService().getAllowableActions(repositoryId, objectId, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    @Override
    public ContentStream getContentStream(String repositoryId, String objectId, String streamId, BigInteger offset, BigInteger length, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkId("Object Id", objectId);
        this.checkNullOrPositive("Offset", offset);
        this.checkNullOrPositive("Length", length);
        try {
            return this.getWrappedService().getContentStream(repositoryId, objectId, streamId, offset, length, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    @Override
    public ObjectData getObject(String repositoryId, String objectId, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeAcl, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkId("Object Id", objectId);
        includeAllowableActions = this.getDefaultFalse(includeAllowableActions);
        includeRelationships = this.getDefault(includeRelationships);
        renditionFilter = this.getDefaultRenditionFilter(renditionFilter);
        includePolicyIds = this.getDefaultFalse(includePolicyIds);
        includeAcl = this.getDefaultFalse(includeAcl);
        try {
            return this.getWrappedService().getObject(repositoryId, objectId, filter, includeAllowableActions, includeRelationships, renditionFilter, includePolicyIds, includeAcl, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    @Override
    public ObjectData getObjectByPath(String repositoryId, String path, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeAcl, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkPath("Path", path);
        includeAllowableActions = this.getDefaultFalse(includeAllowableActions);
        includeRelationships = this.getDefault(includeRelationships);
        renditionFilter = this.getDefaultRenditionFilter(renditionFilter);
        includePolicyIds = this.getDefaultFalse(includePolicyIds);
        includeAcl = this.getDefaultFalse(includeAcl);
        try {
            return this.getWrappedService().getObjectByPath(repositoryId, path, filter, includeAllowableActions, includeRelationships, renditionFilter, includePolicyIds, includeAcl, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    @Override
    public Properties getProperties(String repositoryId, String objectId, String filter, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkId("Object Id", objectId);
        try {
            return this.getWrappedService().getProperties(repositoryId, objectId, filter, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    @Override
    public List<RenditionData> getRenditions(String repositoryId, String objectId, String renditionFilter, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkId("Object Id", objectId);
        renditionFilter = this.getDefaultRenditionFilter(renditionFilter);
        maxItems = this.getMaxItems(maxItems);
        skipCount = this.getSkipCount(skipCount);
        try {
            return this.getWrappedService().getRenditions(repositoryId, objectId, renditionFilter, maxItems, skipCount, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    @Override
    public void moveObject(String repositoryId, Holder<String> objectId, String targetFolderId, String sourceFolderId, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkHolderId("Object Id", objectId);
        this.checkId("Target Folder Id", targetFolderId);
        try {
            this.getWrappedService().moveObject(repositoryId, objectId, targetFolderId, sourceFolderId, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    @Override
    public void setContentStream(String repositoryId, Holder<String> objectId, Boolean overwriteFlag, Holder<String> changeToken, ContentStream contentStream, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkHolderId("Object Id", objectId);
        overwriteFlag = this.getDefaultTrue(overwriteFlag);
        this.checkContentStream(contentStream);
        try {
            this.getWrappedService().setContentStream(repositoryId, objectId, overwriteFlag, changeToken, contentStream, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    @Override
    public void appendContentStream(String repositoryId, Holder<String> objectId, Holder<String> changeToken, ContentStream contentStream, boolean isLastChunk, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkHolderId("Object Id", objectId);
        this.checkContentStream(contentStream);
        try {
            this.getWrappedService().appendContentStream(repositoryId, objectId, changeToken, contentStream, isLastChunk, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    @Override
    public void updateProperties(String repositoryId, Holder<String> objectId, Holder<String> changeToken, Properties properties, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkHolderId("Object Id", objectId);
        this.checkProperties(properties);
        try {
            this.getWrappedService().updateProperties(repositoryId, objectId, changeToken, properties, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    @Override
    public List<BulkUpdateObjectIdAndChangeToken> bulkUpdateProperties(String repositoryId, List<BulkUpdateObjectIdAndChangeToken> objectIdAndChangeToken, Properties properties, List<String> addSecondaryTypeIds, List<String> removeSecondaryTypeIds, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkBulkUpdateList(objectIdAndChangeToken);
        this.checkProperties(properties);
        try {
            return this.getWrappedService().bulkUpdateProperties(repositoryId, objectIdAndChangeToken, properties, addSecondaryTypeIds, removeSecondaryTypeIds, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    @Override
    public void cancelCheckOut(String repositoryId, String objectId, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkId("Object Id", objectId);
        try {
            this.getWrappedService().cancelCheckOut(repositoryId, objectId, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    @Override
    public void checkIn(String repositoryId, Holder<String> objectId, Boolean major, Properties properties, ContentStream contentStream, String checkinComment, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkHolderId("Object Id", objectId);
        major = this.getDefaultTrue(major);
        try {
            this.getWrappedService().checkIn(repositoryId, objectId, major, properties, contentStream, checkinComment, policies, addAces, removeAces, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    @Override
    public void checkOut(String repositoryId, Holder<String> objectId, ExtensionsData extension, Holder<Boolean> contentCopied) {
        this.checkRepositoryId(repositoryId);
        this.checkHolderId("Object Id", objectId);
        try {
            this.getWrappedService().checkOut(repositoryId, objectId, extension, contentCopied);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    @Override
    public ObjectData getObjectOfLatestVersion(String repositoryId, String objectId, String versionSeriesId, Boolean major, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeAcl, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkIds("Version Series Id", objectId, versionSeriesId);
        major = this.getDefaultFalse(major);
        includeAllowableActions = this.getDefaultFalse(includeAllowableActions);
        includeRelationships = this.getDefault(includeRelationships);
        renditionFilter = this.getDefaultRenditionFilter(renditionFilter);
        includePolicyIds = this.getDefaultFalse(includePolicyIds);
        includeAcl = this.getDefaultFalse(includeAcl);
        try {
            return this.getWrappedService().getObjectOfLatestVersion(repositoryId, objectId, versionSeriesId, major, filter, includeAllowableActions, includeRelationships, renditionFilter, includePolicyIds, includeAcl, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    @Override
    public Properties getPropertiesOfLatestVersion(String repositoryId, String objectId, String versionSeriesId, Boolean major, String filter, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkIds("Version Series Id", objectId, versionSeriesId);
        major = this.getDefaultFalse(major);
        try {
            return this.getWrappedService().getPropertiesOfLatestVersion(repositoryId, objectId, versionSeriesId, major, filter, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    @Override
    public List<ObjectData> getAllVersions(String repositoryId, String objectId, String versionSeriesId, String filter, Boolean includeAllowableActions, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkIds("Version Series Id", objectId, versionSeriesId);
        includeAllowableActions = this.getDefaultFalse(includeAllowableActions);
        try {
            return this.getWrappedService().getAllVersions(repositoryId, objectId, versionSeriesId, filter, includeAllowableActions, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    @Override
    public ObjectList getContentChanges(String repositoryId, Holder<String> changeLogToken, Boolean includeProperties, String filter, Boolean includePolicyIds, Boolean includeAcl, BigInteger maxItems, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        includeProperties = this.getDefaultFalse(includeProperties);
        includePolicyIds = this.getDefaultFalse(includePolicyIds);
        includeAcl = this.getDefaultFalse(includeAcl);
        maxItems = this.getMaxItems(maxItems);
        try {
            return this.getWrappedService().getContentChanges(repositoryId, changeLogToken, includeProperties, filter, includePolicyIds, includeAcl, maxItems, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    @Override
    public ObjectList query(String repositoryId, String statement, Boolean searchAllVersions, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkQueryStatement(statement);
        searchAllVersions = this.getDefaultFalse(searchAllVersions);
        includeAllowableActions = this.getDefaultFalse(includeAllowableActions);
        includeRelationships = this.getDefault(includeRelationships);
        renditionFilter = this.getDefaultRenditionFilter(renditionFilter);
        maxItems = this.getMaxItems(maxItems);
        skipCount = this.getSkipCount(skipCount);
        try {
            return this.getWrappedService().query(repositoryId, statement, searchAllVersions, includeAllowableActions, includeRelationships, renditionFilter, maxItems, skipCount, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    @Override
    public void addObjectToFolder(String repositoryId, String objectId, String folderId, Boolean allVersions, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkId("Object Id", objectId);
        this.checkId("Folder Id", folderId);
        allVersions = this.getDefaultTrue(allVersions);
        try {
            this.getWrappedService().addObjectToFolder(repositoryId, objectId, folderId, allVersions, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    @Override
    public void removeObjectFromFolder(String repositoryId, String objectId, String folderId, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkId("Object Id", objectId);
        try {
            this.getWrappedService().removeObjectFromFolder(repositoryId, objectId, folderId, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    @Override
    public ObjectList getObjectRelationships(String repositoryId, String objectId, Boolean includeSubRelationshipTypes, RelationshipDirection relationshipDirection, String typeId, String filter, Boolean includeAllowableActions, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkId("Object Id", objectId);
        includeSubRelationshipTypes = this.getDefaultFalse(includeSubRelationshipTypes);
        relationshipDirection = this.getDefault(relationshipDirection);
        includeAllowableActions = this.getDefaultFalse(includeAllowableActions);
        maxItems = this.getMaxItems(maxItems);
        skipCount = this.getSkipCount(skipCount);
        try {
            return this.getWrappedService().getObjectRelationships(repositoryId, objectId, includeSubRelationshipTypes, relationshipDirection, typeId, filter, includeAllowableActions, maxItems, skipCount, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    @Override
    public Acl applyAcl(String repositoryId, String objectId, Acl aces, AclPropagation aclPropagation) {
        this.checkRepositoryId(repositoryId);
        this.checkId("Object Id", objectId);
        aclPropagation = this.getDefault(aclPropagation);
        try {
            return this.getWrappedService().applyAcl(repositoryId, objectId, aces, aclPropagation);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    @Override
    public Acl applyAcl(String repositoryId, String objectId, Acl addAces, Acl removeAces, AclPropagation aclPropagation, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkId("Object Id", objectId);
        aclPropagation = this.getDefault(aclPropagation);
        try {
            return this.getWrappedService().applyAcl(repositoryId, objectId, addAces, removeAces, aclPropagation, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    @Override
    public Acl getAcl(String repositoryId, String objectId, Boolean onlyBasicPermissions, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkId("Object Id", objectId);
        onlyBasicPermissions = this.getDefaultTrue(onlyBasicPermissions);
        try {
            return this.getWrappedService().getAcl(repositoryId, objectId, onlyBasicPermissions, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    @Override
    public void applyPolicy(String repositoryId, String policyId, String objectId, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkId("Policy Id", policyId);
        this.checkId("Object Id", objectId);
        try {
            this.getWrappedService().applyPolicy(repositoryId, policyId, objectId, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    @Override
    public List<ObjectData> getAppliedPolicies(String repositoryId, String objectId, String filter, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkId("Object Id", objectId);
        try {
            return this.getWrappedService().getAppliedPolicies(repositoryId, objectId, filter, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    @Override
    public void removePolicy(String repositoryId, String policyId, String objectId, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkId("Policy Id", policyId);
        this.checkId("Object Id", objectId);
        try {
            this.getWrappedService().removePolicy(repositoryId, policyId, objectId, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }
}

