/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transaction;

import jakarta.transaction.UserTransaction;
import java.util.ArrayList;
import java.util.Map;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.transaction.TransactionListener;
import org.alfresco.repo.transaction.TransactionListenerAdapter;
import org.alfresco.repo.transaction.TransactionalResourceHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.BaseSpringTest;
import org.junit.Before;
import org.junit.Test;

public class AlfrescoTransactionSupportTest
extends BaseSpringTest {
    private ServiceRegistry serviceRegistry;
    TransactionService transactionService;

    @Before
    public void setUp() throws Exception {
        this.serviceRegistry = (ServiceRegistry)this.applicationContext.getBean("ServiceRegistry");
        this.transactionService = this.serviceRegistry.getTransactionService();
    }

    @Test
    public void testTransactionId() throws Exception {
        TransactionService transactionService = this.serviceRegistry.getTransactionService();
        UserTransaction txn = transactionService.getUserTransaction();
        AlfrescoTransactionSupportTest.assertNull((String)"Thread shouldn't have a txn ID", (Object)AlfrescoTransactionSupport.getTransactionId());
        AlfrescoTransactionSupportTest.assertEquals((String)"No transaction start time expected", (long)-1L, (long)AlfrescoTransactionSupport.getTransactionStartTime());
        txn.begin();
        String txnId = AlfrescoTransactionSupport.getTransactionId();
        AlfrescoTransactionSupportTest.assertNotNull((String)"Expected thread to have a txn id", (Object)txnId);
        long txnStartTime = AlfrescoTransactionSupport.getTransactionStartTime();
        AlfrescoTransactionSupportTest.assertTrue((String)"Expected a transaction start time", (txnStartTime > 0L ? 1 : 0) != 0);
        String txnIdCheck = AlfrescoTransactionSupport.getTransactionId();
        AlfrescoTransactionSupportTest.assertEquals((String)"Transaction ID changed on same thread", (String)txnId, (String)txnIdCheck);
        long txnStartTimeCheck = AlfrescoTransactionSupport.getTransactionStartTime();
        AlfrescoTransactionSupportTest.assertEquals((String)"Transaction start time changed on same thread", (long)txnStartTime, (long)txnStartTimeCheck);
        UserTransaction txnInner = transactionService.getNonPropagatingUserTransaction();
        String txnIdInner = AlfrescoTransactionSupport.getTransactionId();
        AlfrescoTransactionSupportTest.assertEquals((String)"Inner transaction not started, so txn ID should not change", (String)txnId, (String)txnIdInner);
        long txnStartTimeInner = AlfrescoTransactionSupport.getTransactionStartTime();
        AlfrescoTransactionSupportTest.assertEquals((String)"Inner transaction not started, so txn start time should not change", (long)txnStartTime, (long)txnStartTimeInner);
        txnInner.begin();
        txnIdInner = AlfrescoTransactionSupport.getTransactionId();
        AlfrescoTransactionSupportTest.assertNotSame((String)"Inner txn ID must be different from outer txn ID", (Object)txnIdInner, (Object)txnId);
        txnStartTimeInner = AlfrescoTransactionSupport.getTransactionStartTime();
        AlfrescoTransactionSupportTest.assertTrue((String)"Inner transaction start time should be greater or equal (accuracy) to the outer's", (txnStartTime <= txnStartTimeInner ? 1 : 0) != 0);
        txnInner.rollback();
        txnIdCheck = AlfrescoTransactionSupport.getTransactionId();
        AlfrescoTransactionSupportTest.assertEquals((String)"Txn ID not popped inner txn completion", (String)txnId, (String)txnIdCheck);
        txn.rollback();
        AlfrescoTransactionSupportTest.assertNull((String)"Thread shouldn't have a txn ID after rollback", (Object)AlfrescoTransactionSupport.getTransactionId());
        txn = transactionService.getUserTransaction();
        txn.begin();
        txnIdCheck = AlfrescoTransactionSupport.getTransactionId();
        AlfrescoTransactionSupportTest.assertNotSame((String)"New transaction has same ID", (Object)txnId, (Object)txnIdCheck);
        txn.rollback();
        AlfrescoTransactionSupportTest.assertNull((String)"Thread shouldn't have a txn ID after rollback", (Object)AlfrescoTransactionSupport.getTransactionId());
    }

    @Test
    public void testListener() throws Exception {
        final ArrayList strings = new ArrayList(1);
        TransactionListener listener = new TransactionListener(){

            public void flush() {
                strings.add("flush");
            }

            public void beforeCommit(boolean readOnly) {
                strings.add("beforeCommit");
            }

            public void beforeCompletion() {
                strings.add("beforeCompletion");
            }

            public void afterCommit() {
                strings.add("afterCommit");
            }

            public void afterRollback() {
                strings.add("afterRollback");
            }
        };
        UserTransaction txn = this.transactionService.getUserTransaction();
        txn.begin();
        AlfrescoTransactionSupport.bindListener((TransactionListener)listener);
        txn.commit();
        AlfrescoTransactionSupportTest.assertTrue((String)"beforeCommit not called on listener", (boolean)strings.contains("beforeCommit"));
        AlfrescoTransactionSupportTest.assertTrue((String)"beforeCompletion not called on listener", (boolean)strings.contains("beforeCompletion"));
        AlfrescoTransactionSupportTest.assertTrue((String)"afterCommit not called on listener", (boolean)strings.contains("afterCommit"));
    }

    @Test
    public void testListenerNew() throws Exception {
        final ArrayList strings = new ArrayList(1);
        org.alfresco.util.transaction.TransactionListener listener = new org.alfresco.util.transaction.TransactionListener(){

            public void beforeCommit(boolean readOnly) {
                strings.add("beforeCommit");
            }

            public void beforeCompletion() {
                strings.add("beforeCompletion");
            }

            public void afterCommit() {
                strings.add("afterCommit");
            }

            public void afterRollback() {
                strings.add("afterRollback");
            }
        };
        UserTransaction txn = this.transactionService.getUserTransaction();
        txn.begin();
        AlfrescoTransactionSupport.bindListener((org.alfresco.util.transaction.TransactionListener)listener);
        txn.commit();
        AlfrescoTransactionSupportTest.assertTrue((String)"beforeCommit not called on listener", (boolean)strings.contains("beforeCommit"));
        AlfrescoTransactionSupportTest.assertTrue((String)"beforeCompletion not called on listener", (boolean)strings.contains("beforeCompletion"));
        AlfrescoTransactionSupportTest.assertTrue((String)"afterCommit not called on listener", (boolean)strings.contains("afterCommit"));
    }

    @Test
    public void testPreCommitListenerBinding() throws Exception {
        final ArrayList<String> testList = new ArrayList<String>(1);
        testList.add("beforeCommit");
        testList.add("afterCommit - inner");
        testList.add("afterCommit = outer");
        TransactionListenerAdapter listener = new TransactionListenerAdapter(){

            public int hashCode() {
                return 100;
            }

            public void beforeCommit(boolean readOnly) {
                testList.remove("beforeCommit");
                TransactionListenerAdapter postCommitListener = new TransactionListenerAdapter(){

                    public void afterCommit() {
                        testList.remove("afterCommit - inner");
                    }
                };
                AlfrescoTransactionSupport.bindListener((TransactionListener)postCommitListener);
            }

            public void afterCommit() {
                testList.remove("afterCommit = outer");
            }
        };
        TransactionListenerAdapter dummyListener = new TransactionListenerAdapter(){

            public int hashCode() {
                return 200;
            }
        };
        RetryingTransactionHelper.RetryingTransactionCallback<Object> bindWork = new RetryingTransactionHelper.RetryingTransactionCallback<Object>((TransactionListener)dummyListener, (TransactionListener)listener){
            private final /* synthetic */ TransactionListener val$dummyListener;
            private final /* synthetic */ TransactionListener val$listener;
            {
                this.val$dummyListener = transactionListener;
                this.val$listener = transactionListener2;
            }

            public Object execute() throws Exception {
                AlfrescoTransactionSupport.bindListener((TransactionListener)this.val$dummyListener);
                AlfrescoTransactionSupport.bindListener((TransactionListener)this.val$listener);
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)bindWork);
        AlfrescoTransactionSupportTest.assertTrue((String)("Expected callbacks not all processed: " + testList), (testList.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testReadWriteStateRetrieval() throws Exception {
        final AlfrescoTransactionSupport.TxnReadState[] postCommitReadState = new AlfrescoTransactionSupport.TxnReadState[1];
        final TransactionListenerAdapter getReadStatePostCommit = new TransactionListenerAdapter(){

            public void afterCommit() {
                postCommitReadState[0] = AlfrescoTransactionSupport.getTransactionReadState();
            }

            public void afterRollback() {
                postCommitReadState[0] = AlfrescoTransactionSupport.getTransactionReadState();
            }
        };
        RetryingTransactionHelper.RetryingTransactionCallback<AlfrescoTransactionSupport.TxnReadState> getReadStateWork = new RetryingTransactionHelper.RetryingTransactionCallback<AlfrescoTransactionSupport.TxnReadState>(){

            public AlfrescoTransactionSupport.TxnReadState execute() throws Exception {
                AlfrescoTransactionSupport.bindListener((TransactionListener)getReadStatePostCommit);
                return AlfrescoTransactionSupport.getTransactionReadState();
            }
        };
        AlfrescoTransactionSupport.TxnReadState checkTxnReadState = AlfrescoTransactionSupport.getTransactionReadState();
        AlfrescoTransactionSupportTest.assertEquals((String)"Expected 'no transaction'", (Object)AlfrescoTransactionSupport.TxnReadState.TXN_NONE, (Object)checkTxnReadState);
        AlfrescoTransactionSupportTest.assertNull((String)"Expected no post-commit read state", (Object)postCommitReadState[0]);
        checkTxnReadState = (AlfrescoTransactionSupport.TxnReadState)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)getReadStateWork, true);
        AlfrescoTransactionSupportTest.assertEquals((String)"Expected 'read-only transaction'", (Object)AlfrescoTransactionSupport.TxnReadState.TXN_READ_ONLY, (Object)checkTxnReadState);
        AlfrescoTransactionSupportTest.assertEquals((String)"Expected 'no transaction'", (Object)AlfrescoTransactionSupport.TxnReadState.TXN_NONE, (Object)postCommitReadState[0]);
        checkTxnReadState = (AlfrescoTransactionSupport.TxnReadState)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)getReadStateWork, false);
        AlfrescoTransactionSupportTest.assertEquals((String)"Expected 'read-write transaction'", (Object)AlfrescoTransactionSupport.TxnReadState.TXN_READ_WRITE, (Object)checkTxnReadState);
        AlfrescoTransactionSupportTest.assertEquals((String)"Expected 'no transaction'", (Object)AlfrescoTransactionSupport.TxnReadState.TXN_NONE, (Object)postCommitReadState[0]);
        UserTransaction txn = this.transactionService.getUserTransaction();
        txn.begin();
        AlfrescoTransactionSupport.bindListener((TransactionListener)getReadStatePostCommit);
        txn.rollback();
        AlfrescoTransactionSupportTest.assertEquals((String)"Expected 'no transaction'", (Object)AlfrescoTransactionSupport.TxnReadState.TXN_NONE, (Object)postCommitReadState[0]);
        txn = this.transactionService.getUserTransaction();
        txn.begin();
        AlfrescoTransactionSupport.bindListener((TransactionListener)getReadStatePostCommit);
        txn.commit();
        AlfrescoTransactionSupportTest.assertEquals((String)"Expected 'no transaction'", (Object)AlfrescoTransactionSupport.TxnReadState.TXN_NONE, (Object)postCommitReadState[0]);
    }

    @Test
    public void testResourceHelper() throws Exception {
        RetryingTransactionHelper.RetryingTransactionCallback<Object> testWork = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Exception {
                Map map = TransactionalResourceHelper.getMap((Object)"abc");
                AlfrescoTransactionSupportTest.assertNotNull((String)"Map not created", (Object)map);
                map.put("1", "ONE");
                Map mapCheck = TransactionalResourceHelper.getMap((Object)"abc");
                AlfrescoTransactionSupportTest.assertTrue((String)"Same map not retrieved", (map == mapCheck ? 1 : 0) != 0);
                AlfrescoTransactionSupportTest.assertEquals((String)"Transactional count incorrect. ", (int)0, (int)TransactionalResourceHelper.getCount((Object)"myCount"));
                AlfrescoTransactionSupportTest.assertEquals((String)"Transactional count incorrect. ", (int)-1, (int)TransactionalResourceHelper.decrementCount((Object)"myCount", (boolean)true));
                AlfrescoTransactionSupportTest.assertEquals((String)"Transactional count incorrect. ", (int)-2, (int)TransactionalResourceHelper.decrementCount((Object)"myCount", (boolean)true));
                AlfrescoTransactionSupportTest.assertEquals((String)"Transactional count incorrect. ", (int)-2, (int)TransactionalResourceHelper.getCount((Object)"myCount"));
                AlfrescoTransactionSupportTest.assertEquals((String)"Transactional count incorrect. ", (int)-1, (int)TransactionalResourceHelper.incrementCount((Object)"myCount"));
                AlfrescoTransactionSupportTest.assertEquals((String)"Transactional count incorrect. ", (int)0, (int)TransactionalResourceHelper.incrementCount((Object)"myCount"));
                AlfrescoTransactionSupportTest.assertEquals((String)"Transactional count incorrect. ", (int)1, (int)TransactionalResourceHelper.incrementCount((Object)"myCount"));
                AlfrescoTransactionSupportTest.assertEquals((String)"Transactional count incorrect. ", (int)1, (int)TransactionalResourceHelper.getCount((Object)"myCount"));
                AlfrescoTransactionSupportTest.assertEquals((String)"Transactional count incorrect. ", (int)1, (int)TransactionalResourceHelper.getCount((Object)"myCount"));
                TransactionalResourceHelper.resetCount((Object)"myCount");
                AlfrescoTransactionSupportTest.assertEquals((String)"Transactional count incorrect. ", (int)0, (int)TransactionalResourceHelper.getCount((Object)"myCount"));
                AlfrescoTransactionSupportTest.assertEquals((String)"Transactional count incorrect. ", (int)0, (int)TransactionalResourceHelper.decrementCount((Object)"myCount", (boolean)false));
                AlfrescoTransactionSupportTest.assertEquals((String)"Transactional count incorrect. ", (int)0, (int)TransactionalResourceHelper.decrementCount((Object)"myCount", (boolean)false));
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)testWork);
    }
}

