/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication;

import jakarta.transaction.UserTransaction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authentication.CompositePasswordEncoder;
import org.alfresco.repo.security.authentication.RepositoryAuthenticationDao;
import org.alfresco.repo.security.authentication.UpgradePasswordHashWorker;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.util.ApplicationContextHelper;
import org.springframework.context.ApplicationContext;

public class UpgradePasswordHashTest
extends TestCase {
    private static ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private UserTransaction userTransaction;
    private ServiceRegistry serviceRegistry;
    private NodeService nodeService;
    private RepositoryAuthenticationDao repositoryAuthenticationDao;
    private CompositePasswordEncoder compositePasswordEncoder;
    private UpgradePasswordHashWorker upgradePasswordHashWorker;
    private List<String> testUserNames;
    private List<NodeRef> testUsers;

    public UpgradePasswordHashTest() {
    }

    public UpgradePasswordHashTest(String arg0) {
        super(arg0);
    }

    public void setUp() throws Exception {
        if (AlfrescoTransactionSupport.getTransactionReadState() != AlfrescoTransactionSupport.TxnReadState.TXN_NONE) {
            throw new AlfrescoRuntimeException("A previous tests did not clean up transaction: " + AlfrescoTransactionSupport.getTransactionId());
        }
        this.serviceRegistry = (ServiceRegistry)ctx.getBean("ServiceRegistry");
        SimpleCache authenticationCache = (SimpleCache)ctx.getBean("authenticationCache");
        SimpleCache immutableSingletonCache = (SimpleCache)ctx.getBean("immutableSingletonCache");
        TenantService tenantService = (TenantService)ctx.getBean("tenantService");
        this.compositePasswordEncoder = (CompositePasswordEncoder)ctx.getBean("compositePasswordEncoder");
        PolicyComponent policyComponent = (PolicyComponent)ctx.getBean("policyComponent");
        this.repositoryAuthenticationDao = new RepositoryAuthenticationDao();
        this.repositoryAuthenticationDao.setTransactionService(this.serviceRegistry.getTransactionService());
        this.repositoryAuthenticationDao.setAuthorityService(this.serviceRegistry.getAuthorityService());
        this.repositoryAuthenticationDao.setTenantService(tenantService);
        this.repositoryAuthenticationDao.setNodeService(this.serviceRegistry.getNodeService());
        this.repositoryAuthenticationDao.setNamespaceService((NamespacePrefixResolver)this.serviceRegistry.getNamespaceService());
        this.repositoryAuthenticationDao.setCompositePasswordEncoder(this.compositePasswordEncoder);
        this.repositoryAuthenticationDao.setPolicyComponent(policyComponent);
        this.repositoryAuthenticationDao.setAuthenticationCache(authenticationCache);
        this.repositoryAuthenticationDao.setSingletonCache(immutableSingletonCache);
        this.upgradePasswordHashWorker = (UpgradePasswordHashWorker)ctx.getBean("upgradePasswordHashWorker");
        this.nodeService = this.serviceRegistry.getNodeService();
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getSystemUserName());
    }

    protected void createTestUsers(String encoding) throws Exception {
        this.userTransaction = this.serviceRegistry.getTransactionService().getUserTransaction();
        this.userTransaction.begin();
        this.testUsers = new ArrayList<NodeRef>(5);
        this.testUsers.add(this.createUser("king" + encoding, "king".toCharArray(), encoding));
        this.testUsers.add(this.createUser("kin" + encoding, "Kong".toCharArray(), encoding));
        this.testUsers.add(this.createUser("ding" + encoding, "dong".toCharArray(), encoding));
        this.testUsers.add(this.createUser("ping" + encoding, "pong".toCharArray(), encoding));
        this.testUsers.add(this.createUser("pin" + encoding, "pop".toCharArray(), encoding));
        this.userTransaction.commit();
    }

    private NodeRef createUser(String caseSensitiveUserName, char[] password, String encoding) {
        block3: {
            try {
                this.repositoryAuthenticationDao.createUser(caseSensitiveUserName, password);
            }
            catch (AuthenticationException e) {
                if (e.getMessage().contains("User already exists")) break block3;
                throw e;
            }
        }
        NodeRef userNodeRef = this.repositoryAuthenticationDao.getUserOrNull(caseSensitiveUserName);
        if (userNodeRef == null) {
            throw new AuthenticationException("User name does not exist: " + caseSensitiveUserName);
        }
        Map properties = this.nodeService.getProperties(userNodeRef);
        properties.remove(ContentModel.PROP_PASSWORD_HASH);
        properties.remove(ContentModel.PROP_HASH_INDICATOR);
        properties.remove(ContentModel.PROP_PASSWORD);
        properties.remove(ContentModel.PROP_PASSWORD_SHA256);
        String encoded = this.compositePasswordEncoder.encode(encoding, new String(password), null);
        properties.put("sha256".equals(encoding) ? ContentModel.PROP_PASSWORD_SHA256 : ContentModel.PROP_PASSWORD, encoded);
        this.nodeService.setProperties(userNodeRef, properties);
        return userNodeRef;
    }

    protected void deleteTestUsers() throws Exception {
        for (NodeRef testUser : this.testUsers) {
            try {
                this.nodeService.deleteNode(testUser);
            }
            catch (InvalidNodeRefException invalidNodeRefException) {}
        }
        this.testUsers.clear();
    }

    protected void tearDown() throws Exception {
        this.deleteTestUsers();
        if (this.userTransaction.getStatus() == 0 || this.userTransaction.getStatus() == 1) {
            this.userTransaction.rollback();
        }
        AuthenticationUtil.clearCurrentSecurityContext();
        super.tearDown();
    }

    public void testWorkerWithDefaultConfiguration() throws Exception {
        List<String> doubleHashed = Arrays.asList("md4", "bcrypt10");
        this.createTestUsers("md4");
        this.runWorker(doubleHashed);
    }

    public void testWorkerWithCloudDefaultConfiguration() throws Exception {
        List<String> doubleHashed = Arrays.asList("sha256", "bcrypt10");
        this.createTestUsers("sha256");
        this.runWorker(doubleHashed);
    }

    public void testWorkerWithLegacyConfiguration() throws Exception {
        List<String> legacy = Arrays.asList("md4");
        this.createTestUsers("md4");
        this.runWorker(legacy);
    }

    public void testWorkerWithLegacy256Configuration() throws Exception {
        List<String> legacy = Arrays.asList("sha256");
        this.createTestUsers("sha256");
        this.runWorker(legacy);
    }

    private void runWorker(List<String> expectedEncoding) throws Exception {
        this.compositePasswordEncoder.setPreferredEncoding(expectedEncoding.get(expectedEncoding.size() - 1));
        this.upgradePasswordHashWorker.setCompositePasswordEncoder(this.compositePasswordEncoder);
        this.userTransaction = this.serviceRegistry.getTransactionService().getUserTransaction();
        this.userTransaction.begin();
        for (NodeRef testUser : this.testUsers) {
            UpgradePasswordHashTest.assertNull((String)"The hash indicator should not be set", (Object)this.nodeService.getProperty(testUser, ContentModel.PROP_HASH_INDICATOR));
            UpgradePasswordHashTest.assertNull((String)"The password hash should not be set", (Object)this.nodeService.getProperty(testUser, ContentModel.PROP_PASSWORD_HASH));
        }
        this.upgradePasswordHashWorker.execute();
        this.userTransaction.commit();
        this.userTransaction = this.serviceRegistry.getTransactionService().getUserTransaction();
        this.userTransaction.begin();
        for (NodeRef testUser : this.testUsers) {
            UpgradePasswordHashTest.assertNotNull((String)"The password hash should be set", (Object)this.nodeService.getProperty(testUser, ContentModel.PROP_PASSWORD_HASH));
            UpgradePasswordHashTest.assertEquals(expectedEncoding, (Object)this.nodeService.getProperty(testUser, ContentModel.PROP_HASH_INDICATOR));
            UpgradePasswordHashTest.assertNull((String)"The md4 password should not be set", (Object)this.nodeService.getProperty(testUser, ContentModel.PROP_PASSWORD));
            UpgradePasswordHashTest.assertNull((String)"The sh256 password should not be set", (Object)this.nodeService.getProperty(testUser, ContentModel.PROP_PASSWORD_SHA256));
        }
    }
}

