/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.invitation.site;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.repo.admin.SysAdminParams;
import org.alfresco.repo.i18n.MessageService;
import org.alfresco.repo.model.Repository;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.admin.RepoAdminService;
import org.alfresco.service.cmr.invitation.InvitationException;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;

public abstract class InviteSender {
    protected final ActionService actionService;
    protected final NodeService nodeService;
    protected final PersonService personService;
    protected final SearchService searchService;
    protected final SiteService siteService;
    protected final Repository repository;
    protected final MessageService messageService;
    protected final FileFolderService fileFolderService;
    protected final RepoAdminService repoAdminService;
    protected final NamespaceService namespaceService;
    protected final SysAdminParams sysAdminParams;

    public InviteSender(ServiceRegistry services, Repository repository, MessageService messageService) {
        this.actionService = services.getActionService();
        this.nodeService = services.getNodeService();
        this.personService = services.getPersonService();
        this.searchService = services.getSearchService();
        this.siteService = services.getSiteService();
        this.fileFolderService = services.getFileFolderService();
        this.repoAdminService = services.getRepoAdminService();
        this.namespaceService = services.getNamespaceService();
        this.repository = repository;
        this.messageService = messageService;
        this.sysAdminParams = services.getSysAdminParams();
    }

    public abstract void sendMail(String var1, String var2, Map<String, String> var3);

    protected abstract Map<String, Serializable> buildMailTextModel(Map<String, String> var1);

    protected abstract List<String> getRequiredProperties();

    protected void checkProperties(Map<String, String> properties) {
        Set<String> keys = properties.keySet();
        if (!keys.containsAll(this.getRequiredProperties())) {
            LinkedList<String> missingProperties = new LinkedList<String>(this.getRequiredProperties());
            missingProperties.removeAll(keys);
            throw new InvitationException("The following mandatory properties are missing:\n" + missingProperties, new Object[0]);
        }
    }

    protected NodeRef getEmailTemplateNodeRef(String emailTemplateXPath) {
        List nodeRefs = this.searchService.selectNodes(this.repository.getRootHome(), emailTemplateXPath, null, (NamespacePrefixResolver)this.namespaceService, false);
        if (nodeRefs.size() == 1) {
            NodeRef base = (NodeRef)nodeRefs.get(0);
            NodeRef local = this.fileFolderService.getLocalizedSibling(base);
            return local;
        }
        throw new InvitationException("Cannot find the email template!", new Object[0]);
    }

    protected String getSiteName(Map<String, String> properties) {
        String siteFullName = properties.get(this.getWorkflowPropForSiteName());
        SiteInfo site = this.siteService.getSite(siteFullName);
        if (site == null) {
            throw new InvitationException("The site " + siteFullName + " could not be found.", new Object[0]);
        }
        String siteName = site.getShortName();
        String siteTitle = site.getTitle();
        if (siteTitle != null && siteTitle.length() > 0) {
            siteName = siteTitle;
        }
        return siteName;
    }

    protected abstract String getWorkflowPropForSiteName();
}

