/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication;

import junit.framework.TestCase;
import org.alfresco.repo.security.authentication.Authorization;

public class AuthorizationTest
extends TestCase {
    private static String USER = "user";
    private static String PASSWORD = "pass";

    public void testInvalidAuthorization() {
        try {
            new Authorization(null);
            AuthorizationTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            new Authorization("");
            AuthorizationTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void testAuthorization() {
        Authorization auth1 = new Authorization(USER, PASSWORD);
        this.assertUserPass(USER, PASSWORD, auth1);
        Authorization auth2 = new Authorization("", PASSWORD);
        this.assertTicket("", PASSWORD, auth2);
        Authorization auth3 = new Authorization(null, PASSWORD);
        this.assertTicket(null, PASSWORD, auth3);
        Authorization auth4 = new Authorization(Authorization.TICKET_USERID, PASSWORD);
        this.assertTicket(Authorization.TICKET_USERID, PASSWORD, auth4);
        Authorization auth5 = new Authorization(Authorization.TICKET_USERID.toLowerCase(), PASSWORD);
        this.assertTicket(Authorization.TICKET_USERID.toLowerCase(), PASSWORD, auth5);
    }

    public void testUserPass() {
        Authorization auth1 = new Authorization(String.valueOf(USER) + ":" + PASSWORD);
        this.assertUserPass(USER, PASSWORD, auth1);
        Authorization auth2 = new Authorization(":" + PASSWORD);
        this.assertTicket("", PASSWORD, auth2);
        Authorization auth3 = new Authorization(PASSWORD);
        this.assertTicket(null, PASSWORD, auth3);
        Authorization auth4 = new Authorization(String.valueOf(Authorization.TICKET_USERID) + ":" + PASSWORD);
        this.assertTicket(Authorization.TICKET_USERID, PASSWORD, auth4);
        Authorization auth5 = new Authorization(String.valueOf(Authorization.TICKET_USERID.toLowerCase()) + ":" + PASSWORD);
        this.assertTicket(Authorization.TICKET_USERID.toLowerCase(), PASSWORD, auth5);
    }

    private void assertUserPass(String user, String pass, Authorization auth) {
        AuthorizationTest.assertEquals((String)user, (String)auth.getUserName());
        AuthorizationTest.assertEquals((String)pass, (String)auth.getPassword());
        AuthorizationTest.assertFalse((boolean)auth.isTicket());
        AuthorizationTest.assertNull((Object)auth.getTicket());
    }

    private void assertTicket(String user, String pass, Authorization auth) {
        AuthorizationTest.assertEquals((String)user, (String)auth.getUserName());
        AuthorizationTest.assertEquals((String)pass, (String)auth.getPassword());
        AuthorizationTest.assertTrue((boolean)auth.isTicket());
        AuthorizationTest.assertEquals((String)pass, (String)auth.getTicket());
    }
}

