/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.model;

import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.virtual.VirtualContentModel;
import org.alfresco.repo.virtual.VirtualizationIntegrationTest;
import org.alfresco.repo.virtual.config.NodeRefExpression;
import org.alfresco.repo.virtual.config.NodeRefPathExpression;
import org.alfresco.repo.virtual.config.NodeRefPathExpressionFactory;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SystemTemplateLocationsConstraintTest
extends VirtualizationIntegrationTest {
    private ServiceRegistry serviceRegistry;
    private NodeRefPathExpressionFactory nrPathExpressionFactory;
    private NodeRefExpression templatesParentRepositoryPath;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.serviceRegistry = (ServiceRegistry)this.ctx.getBean("ServiceRegistry");
        this.nrPathExpressionFactory = (NodeRefPathExpressionFactory)this.ctx.getBean("config.NodeRefPathExpressionFactory");
    }

    @Override
    @After
    public void tearDown() throws Exception {
        if (this.templatesParentRepositoryPath != null) {
            this.constraints.setTemplatesParentRepositoryPath(this.templatesParentRepositoryPath);
            this.templatesParentRepositoryPath = null;
        }
        super.tearDown();
    }

    @Test
    public void testNullConstraints() throws Exception {
        this.configuredTemplatesClassPath = this.constraints.getTemplatesParentClasspath();
        this.constraints.setTemplatesParentClasspath("/org/alfresco/repo/virtual");
        this.templatesParentRepositoryPath = this.constraints.getTemplatesParentRepositoryPath();
        NodeRefPathExpression aNewPath = this.nrPathExpressionFactory.createInstance();
        this.constraints.setTemplatesParentRepositoryPath((NodeRefExpression)aNewPath);
        List rawAllowedValues = this.constraints.getRawAllowedValues();
        Assert.assertEquals((long)1L, (long)rawAllowedValues.size());
        Assert.assertEquals((Object)"nullSystemTemplate", rawAllowedValues.get(0));
    }

    @Test
    public void testConfiguredConstraints() throws Exception {
        List rawAllowedValues = this.constraints.getRawAllowedValues();
        NodeRefExpression sysTemplatesPath = this.virtualizationConfigTestBootstrap.getSystemTemplatesPath();
        NodeRef templatesLocation = sysTemplatesPath.resolve(true);
        PagingResults templates = this.fileAndFolderService.list(templatesLocation, Collections.singleton(VirtualContentModel.TYPE_VIRTUAL_FOLDER_TEMPLATE), null, null, new PagingRequest(1000));
        List templatesPage = templates.getPage();
        if (!templatesPage.isEmpty()) {
            Assert.assertEquals((long)templatesPage.size(), (long)rawAllowedValues.size());
            LinkedList<String> expectedSysPaths = new LinkedList<String>();
            for (FileInfo fi : templatesPage) {
                expectedSysPaths.add("N" + fi.getNodeRef().toString());
            }
            Assert.assertTrue((boolean)rawAllowedValues.containsAll(expectedSysPaths));
        }
    }

    @Test
    public void testAllConstraints() throws Exception {
        this.configuredTemplatesClassPath = this.constraints.getTemplatesParentClasspath();
        this.constraints.setTemplatesParentClasspath("/org/alfresco/repo/virtual/template");
        NodeRefExpression sysTemplatesPath = this.virtualizationConfigTestBootstrap.getSystemTemplatesPath();
        NodeRef templatesLocation = sysTemplatesPath.resolve(true);
        Assert.assertNotNull((Object)templatesLocation);
        InputStream testTemplsteJsonIS = this.getClass().getResourceAsStream("/org/alfresco/repo/virtual/template/testTemplate1.json");
        ChildAssociationRef templateAssoc = this.createContent(templatesLocation, "testTemplate1.json", testTemplsteJsonIS, "application/json", "UTF-8", QName.createQName((String)this.virtualizationConfigTestBootstrap.getSystemTemplateType(), (NamespacePrefixResolver)this.serviceRegistry.getNamespaceService()));
        testTemplsteJsonIS = this.getClass().getResourceAsStream("/org/alfresco/repo/virtual/template/testTemplate1.json");
        this.createContent(templatesLocation, "nontestTemplate1.json", testTemplsteJsonIS, "application/json", "UTF-8", ContentModel.TYPE_CONTENT);
        List rawAllowedValues = this.constraints.getRawAllowedValues();
        Assert.assertTrue((rawAllowedValues.size() >= 5 ? 1 : 0) != 0);
        Assert.assertTrue((String)("Invalid values " + rawAllowedValues), (boolean)rawAllowedValues.contains("C/org/alfresco/repo/virtual/template/testTemplate1.json"));
        Assert.assertTrue((String)("Invalid values " + rawAllowedValues), (boolean)rawAllowedValues.contains("C/org/alfresco/repo/virtual/template/testTemplate2.json"));
        Assert.assertTrue((String)("Invalid values " + rawAllowedValues), (boolean)rawAllowedValues.contains("C/org/alfresco/repo/virtual/template/testTemplate3.json"));
        Assert.assertTrue((String)("Invalid values " + rawAllowedValues), (boolean)rawAllowedValues.contains("C/org/alfresco/repo/virtual/template/testTemplate4.json"));
        Assert.assertTrue((String)("Invalid values " + rawAllowedValues), (boolean)rawAllowedValues.contains("N" + templateAssoc.getChildRef()));
    }
}

