/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transfer;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.alfresco.repo.transfer.AlienProcessor;
import org.alfresco.repo.transfer.CorrespondingNodeResolver;
import org.alfresco.repo.transfer.CorrespondingNodeResolverFactory;
import org.alfresco.repo.transfer.ManifestProcessorFactory;
import org.alfresco.repo.transfer.RepoPrimaryManifestProcessorImpl;
import org.alfresco.repo.transfer.RepoRequisiteManifestProcessorImpl;
import org.alfresco.repo.transfer.RepoSecondaryManifestProcessorImpl;
import org.alfresco.repo.transfer.RepoTertiaryManifestProcessorImpl;
import org.alfresco.repo.transfer.TransferSummaryReportImpl;
import org.alfresco.repo.transfer.manifest.TransferManifestProcessor;
import org.alfresco.repo.transfer.requisite.TransferRequsiteWriter;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.search.CategoryService;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.tagging.TaggingService;
import org.alfresco.service.cmr.transfer.TransferReceiver;
import org.alfresco.service.namespace.NamespaceService;

public class DefaultManifestProcessorFactoryImpl
implements ManifestProcessorFactory {
    private NodeService nodeService;
    private ContentService contentService;
    private DictionaryService dictionaryService;
    private PermissionService permissionService;
    private CorrespondingNodeResolverFactory nodeResolverFactory;
    private AlienProcessor alienProcessor;
    private CategoryService categoryService;
    private TaggingService taggingService;
    private SearchService searchService;
    private String transferSummaryReportLocation;
    private Properties properties;
    private FileFolderService fileFolderService;
    private NamespaceService namespaceService;

    @Override
    public List<TransferManifestProcessor> getCommitProcessors(TransferReceiver receiver, String transferId) {
        TransferSummaryReportImpl transferSummaryReport = null;
        if (this.isSimpleReportActive()) {
            TransferSummaryReportImpl summaryReport = new TransferSummaryReportImpl(transferId);
            summaryReport.setContentService(this.contentService);
            summaryReport.setNodeService(this.nodeService);
            summaryReport.setSearchService(this.searchService);
            summaryReport.setFileFolderService(this.fileFolderService);
            summaryReport.setTransferSummaryReportLocation(this.transferSummaryReportLocation);
            summaryReport.setNamespaceService(this.namespaceService);
            transferSummaryReport = summaryReport;
        }
        ArrayList<TransferManifestProcessor> processors = new ArrayList<TransferManifestProcessor>();
        CorrespondingNodeResolver nodeResolver = this.nodeResolverFactory.getResolver();
        RepoPrimaryManifestProcessorImpl primaryProcessor = new RepoPrimaryManifestProcessorImpl(receiver, transferId);
        primaryProcessor.setContentService(this.contentService);
        primaryProcessor.setNodeResolver(nodeResolver);
        primaryProcessor.setNodeService(this.nodeService);
        primaryProcessor.setDictionaryService(this.dictionaryService);
        primaryProcessor.setPermissionService(this.getPermissionService());
        primaryProcessor.setAlienProcessor(this.getAlienProcessor());
        primaryProcessor.setCategoryService(this.categoryService);
        primaryProcessor.setTaggingService(this.getTaggingService());
        primaryProcessor.setTransferSummaryReport(transferSummaryReport);
        processors.add(primaryProcessor);
        RepoSecondaryManifestProcessorImpl secondaryProcessor = new RepoSecondaryManifestProcessorImpl(receiver, transferId);
        secondaryProcessor.setNodeResolver(nodeResolver);
        secondaryProcessor.setNodeService(this.nodeService);
        secondaryProcessor.setTransferSummaryReport(transferSummaryReport);
        processors.add(secondaryProcessor);
        RepoTertiaryManifestProcessorImpl tertiaryProcessor = new RepoTertiaryManifestProcessorImpl(receiver, transferId);
        tertiaryProcessor.setNodeService(this.nodeService);
        tertiaryProcessor.setAlienProcessor(this.getAlienProcessor());
        tertiaryProcessor.setNodeResolver(nodeResolver);
        tertiaryProcessor.setTransferSummaryReport(transferSummaryReport);
        processors.add(tertiaryProcessor);
        return processors;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setNodeResolverFactory(CorrespondingNodeResolverFactory nodeResolverFactory) {
        this.nodeResolverFactory = nodeResolverFactory;
    }

    @Override
    public TransferManifestProcessor getRequsiteProcessor(TransferReceiver receiver, String transferId, TransferRequsiteWriter out) {
        RepoRequisiteManifestProcessorImpl processor = new RepoRequisiteManifestProcessorImpl(receiver, transferId, out);
        CorrespondingNodeResolver nodeResolver = this.nodeResolverFactory.getResolver();
        processor.setNodeResolver(nodeResolver);
        processor.setNodeService(this.nodeService);
        return processor;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public PermissionService getPermissionService() {
        return this.permissionService;
    }

    public void setAlienProcessor(AlienProcessor alienProcessor) {
        this.alienProcessor = alienProcessor;
    }

    public AlienProcessor getAlienProcessor() {
        return this.alienProcessor;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void setTransferSummaryReportLocation(String transferSummaryReportLocation) {
        this.transferSummaryReportLocation = transferSummaryReportLocation;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public CategoryService getCategoryService() {
        return this.categoryService;
    }

    public void setCategoryService(CategoryService categoryService) {
        this.categoryService = categoryService;
    }

    public TaggingService getTaggingService() {
        return this.taggingService;
    }

    public void setTaggingService(TaggingService taggingService) {
        this.taggingService = taggingService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    protected boolean isSimpleReportActive() {
        return this.getBooleanProperty("transferservice.simple-report", false);
    }

    private boolean getBooleanProperty(String name, boolean defaultValue) {
        String property;
        boolean value = defaultValue;
        if (this.properties != null && (property = this.properties.getProperty(name)) != null) {
            value = property.trim().equalsIgnoreCase("true");
        }
        return value;
    }
}

