/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.alfresco.repo.workflow.WorkflowNodeConverter;
import org.alfresco.service.cmr.repository.NodeRef;

public abstract class AbstractWorkflowNodeConverter
implements WorkflowNodeConverter {
    @Override
    public Object convertNodes(Object value, boolean isMany) {
        if (value instanceof NodeRef) {
            return this.convertNode((NodeRef)value, isMany);
        }
        if (value instanceof Collection) {
            return this.convertNodes((Collection)value, isMany);
        }
        return value;
    }

    @Override
    public Object convertNode(NodeRef value, boolean isMany) {
        if (isMany) {
            return this.convertNodes(Collections.singleton(value));
        }
        return this.convertNode(value);
    }

    @Override
    public Object convertNodes(Collection<NodeRef> values, boolean isMany) {
        if (isMany) {
            return this.convertNodes(values);
        }
        if (values.isEmpty()) {
            return null;
        }
        return this.convertNode(values.iterator().next());
    }

    @Override
    public List<NodeRef> convertToNodes(Object value) {
        if (value instanceof Collection) {
            return this.convertToNodes((Collection)value);
        }
        return Collections.singletonList(this.convertToNode(value));
    }

    @Override
    public List<NodeRef> convertToNodes(Collection<?> toConvert) {
        ArrayList<NodeRef> results = new ArrayList<NodeRef>(toConvert.size());
        for (Object obj : toConvert) {
            results.add(this.convertToNode(obj));
        }
        return results;
    }

    @Override
    public Serializable convert(Object object) {
        if (object instanceof Collection) {
            return (Serializable)((Object)this.convertToNodes((Collection)object));
        }
        return this.convertToNode(object);
    }

    @Override
    public abstract Object convertNode(NodeRef var1);

    @Override
    public abstract List<? extends Object> convertNodes(Collection<NodeRef> var1);

    @Override
    public abstract NodeRef convertToNode(Object var1);
}

