/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.store;

import java.io.Serializable;
import java.text.Collator;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.virtual.VirtualizationException;
import org.alfresco.repo.virtual.ref.Reference;
import org.alfresco.repo.virtual.store.VirtualStore;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.AlfrescoCollator;
import org.alfresco.util.Pair;
import org.springframework.extensions.surf.util.I18NUtil;

public class ReferenceComparator
implements Comparator<Reference> {
    private VirtualStore smartStore;
    private List<Pair<QName, Boolean>> sortProps;
    private Collator collator;

    public ReferenceComparator(VirtualStore smartStore, List<Pair<QName, Boolean>> sortProps) {
        this.sortProps = sortProps;
        this.collator = AlfrescoCollator.getInstance(I18NUtil.getContentLocale());
        this.smartStore = smartStore;
    }

    @Override
    public int compare(Reference r1, Reference r2) {
        try {
            return this.compareImpl(r1, r2, this.sortProps);
        }
        catch (VirtualizationException e) {
            throw new RuntimeException(e);
        }
    }

    private int compareImpl(Reference ref1In, Reference ref2In, List<Pair<QName, Boolean>> sortProps) throws VirtualizationException {
        Serializable pv1 = null;
        Serializable pv2 = null;
        QName sortPropQName = (QName)sortProps.get(0).getFirst();
        boolean sortAscending = (Boolean)sortProps.get(0).getSecond();
        Reference ref1 = ref1In;
        Reference ref2 = ref2In;
        if (!sortAscending) {
            ref1 = ref2In;
            ref2 = ref1In;
        }
        int result = 0;
        Map<QName, Serializable> properties1 = this.smartStore.getProperties(ref1);
        pv1 = properties1.get(sortPropQName);
        Map<QName, Serializable> properties2 = this.smartStore.getProperties(ref2);
        pv2 = properties2.get(sortPropQName);
        if (pv1 == null) {
            if (pv2 == null && sortProps.size() > 1) {
                return this.compareImpl(ref1In, ref2In, sortProps.subList(1, sortProps.size()));
            }
            return pv2 == null ? 0 : -1;
        }
        if (pv2 == null) {
            return 1;
        }
        if (pv1 instanceof String) {
            result = this.collator.compare((String)((Object)pv1), (String)((Object)pv2));
        } else if (pv1 instanceof Date) {
            result = ((Date)pv1).compareTo((Date)pv2);
        } else if (pv1 instanceof Long) {
            result = ((Long)pv1).compareTo((Long)pv2);
        } else if (pv1 instanceof Integer) {
            result = ((Integer)pv1).compareTo((Integer)pv2);
        } else if (pv1 instanceof QName) {
            result = ((QName)pv1).compareTo((QName)pv2);
        } else if (pv1 instanceof Boolean) {
            result = ((Boolean)pv1).compareTo((Boolean)pv2);
        } else {
            throw new RuntimeException("Unsupported sort type: " + pv1.getClass().getName());
        }
        if (result == 0 && sortProps.size() > 1) {
            return this.compareImpl(ref1In, ref2In, sortProps.subList(1, sortProps.size()));
        }
        return result;
    }
}

