/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.bundle;

import java.io.Serializable;
import java.util.Map;
import org.alfresco.repo.coci.traitextender.CheckOutCheckInServiceExtension;
import org.alfresco.repo.coci.traitextender.CheckOutCheckInServiceTrait;
import org.alfresco.repo.virtual.ref.GetParentReferenceMethod;
import org.alfresco.repo.virtual.ref.NodeProtocol;
import org.alfresco.repo.virtual.ref.Reference;
import org.alfresco.repo.virtual.store.VirtualStore;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.traitextender.SpringBeanExtension;

public class VirtualCheckOutCheckInServiceExtension
extends SpringBeanExtension<CheckOutCheckInServiceExtension, CheckOutCheckInServiceTrait>
implements CheckOutCheckInServiceExtension {
    private VirtualStore smartStore;

    public VirtualCheckOutCheckInServiceExtension() {
        super(CheckOutCheckInServiceTrait.class);
    }

    public void setSmartStore(VirtualStore smartStore) {
        this.smartStore = smartStore;
    }

    @Override
    public NodeRef checkout(NodeRef nodeRef, NodeRef destinationParentNodeRef, QName destinationAssocTypeQName, QName destinationAssocQName) {
        CheckOutCheckInServiceTrait theTrait = (CheckOutCheckInServiceTrait)this.getTrait();
        NodeRef materialNodeRef = this.smartStore.materializeIfPossible(nodeRef);
        NodeRef materialDestination = this.smartStore.materializeIfPossible(destinationParentNodeRef);
        NodeRef workingCopy = theTrait.checkout(materialNodeRef, materialDestination, destinationAssocTypeQName, destinationAssocQName);
        Reference parentReference = Reference.fromNodeRef(destinationParentNodeRef);
        if (parentReference != null) {
            Reference workingCopyReference = NodeProtocol.newReference(workingCopy, parentReference);
            return workingCopyReference.toNodeRef(workingCopy.getStoreRef());
        }
        return workingCopy;
    }

    @Override
    public NodeRef checkout(NodeRef nodeRef) {
        CheckOutCheckInServiceTrait theTrait = (CheckOutCheckInServiceTrait)this.getTrait();
        NodeRef materialNodeRef = this.smartStore.materializeIfPossible(nodeRef);
        NodeRef workingCopy = theTrait.checkout(materialNodeRef);
        return this.virtualizeOriginalIfNeeded(nodeRef, workingCopy);
    }

    @Override
    public NodeRef checkin(NodeRef workingCopyNodeRef, Map<String, Serializable> versionProperties, String contentUrl, boolean keepCheckedOut) {
        CheckOutCheckInServiceTrait theTrait = (CheckOutCheckInServiceTrait)this.getTrait();
        NodeRef materialWorkingCopy = this.smartStore.materializeIfPossible(workingCopyNodeRef);
        NodeRef materialOriginalNode = theTrait.checkin(materialWorkingCopy, versionProperties, contentUrl, keepCheckedOut);
        return this.virtualizeOriginalIfNeeded(workingCopyNodeRef, materialOriginalNode);
    }

    @Override
    public NodeRef checkin(NodeRef workingCopyNodeRef, Map<String, Serializable> versionProperties, String contentUrl) {
        CheckOutCheckInServiceTrait theTrait = (CheckOutCheckInServiceTrait)this.getTrait();
        NodeRef materialWorkingCopy = this.smartStore.materializeIfPossible(workingCopyNodeRef);
        NodeRef materialOriginalNode = theTrait.checkin(materialWorkingCopy, versionProperties, contentUrl);
        return this.virtualizeOriginalIfNeeded(workingCopyNodeRef, materialOriginalNode);
    }

    private NodeRef virtualizeOriginalIfNeeded(NodeRef workingCopyNodeRef, NodeRef materialOriginalNode) {
        Reference workingCopyReference = Reference.fromNodeRef(workingCopyNodeRef);
        if (materialOriginalNode != null && workingCopyReference != null) {
            Reference parentReference = workingCopyReference.execute(new GetParentReferenceMethod());
            Reference originalReference = NodeProtocol.newReference(materialOriginalNode, parentReference);
            return originalReference.toNodeRef(materialOriginalNode.getStoreRef());
        }
        return materialOriginalNode;
    }

    @Override
    public NodeRef checkin(NodeRef workingCopyNodeRef, Map<String, Serializable> versionProperties) {
        CheckOutCheckInServiceTrait theTrait = (CheckOutCheckInServiceTrait)this.getTrait();
        NodeRef materialWorkingCopy = this.smartStore.materializeIfPossible(workingCopyNodeRef);
        NodeRef materialOriginalNode = theTrait.checkin(materialWorkingCopy, versionProperties);
        return this.virtualizeOriginalIfNeeded(workingCopyNodeRef, materialOriginalNode);
    }

    @Override
    public NodeRef cancelCheckout(NodeRef workingCopyNodeRef) {
        NodeRef materialOriginalNode = ((CheckOutCheckInServiceTrait)this.getTrait()).cancelCheckout(this.smartStore.materializeIfPossible(workingCopyNodeRef));
        return this.virtualizeOriginalIfNeeded(workingCopyNodeRef, materialOriginalNode);
    }

    @Override
    public NodeRef getWorkingCopy(NodeRef nodeRef) {
        CheckOutCheckInServiceTrait theTrait = (CheckOutCheckInServiceTrait)this.getTrait();
        NodeRef materialWorkingCopy = theTrait.getWorkingCopy(this.smartStore.materializeIfPossible(nodeRef));
        return this.virtualizeVersionIfNeeded(nodeRef, materialWorkingCopy);
    }

    private NodeRef virtualizeVersionIfNeeded(NodeRef originalNodeRef, NodeRef materialVersion) {
        Reference reference = Reference.fromNodeRef(originalNodeRef);
        if (materialVersion != null && reference != null && Reference.fromNodeRef(materialVersion) == null) {
            Reference parentReference = reference.execute(new GetParentReferenceMethod());
            Reference workingCopyReference = NodeProtocol.newReference(materialVersion, parentReference);
            return workingCopyReference.toNodeRef(materialVersion.getStoreRef());
        }
        return materialVersion;
    }

    @Override
    public NodeRef getCheckedOut(NodeRef nodeRef) {
        CheckOutCheckInServiceTrait theTrait = (CheckOutCheckInServiceTrait)this.getTrait();
        NodeRef materialChekedOut = theTrait.getCheckedOut(this.smartStore.materializeIfPossible(nodeRef));
        return this.virtualizeVersionIfNeeded(nodeRef, materialChekedOut);
    }

    @Override
    public boolean isWorkingCopy(NodeRef nodeRef) {
        return ((CheckOutCheckInServiceTrait)this.getTrait()).isWorkingCopy(this.smartStore.materializeIfPossible(nodeRef));
    }

    @Override
    public boolean isCheckedOut(NodeRef nodeRef) {
        return ((CheckOutCheckInServiceTrait)this.getTrait()).isCheckedOut(this.smartStore.materializeIfPossible(nodeRef));
    }
}

