/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.tagging;

import jakarta.transaction.UserTransaction;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tagging.UpdateTagScopesActionExecuter;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.action.ActionTrackingService;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.tagging.TaggingService;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.testing.category.LuceneTests;
import org.alfresco.util.testing.category.RedundantTests;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.springframework.context.ApplicationContext;

@Category(value={LuceneTests.class, RedundantTests.class})
public class UpdateTagScopesActionExecuterTest
extends TestCase {
    private static final int TAGSCOPE_LAYERS = 3;
    private static final int TEST_TAGS_AMOUNT = 3;
    private static final int TEST_DOCUMENTS_AMOUNT = 3;
    private static final String ACTION_TRACKING_SERVICE_BEAN_NAME = "actionTrackingService";
    private static final String UPDATE_TAGSCOPE_ACTION_EXECUTER_BEAN_NAME = "update-tagscope";
    private static final String TEST_TAG_NAME_PATTERN = "testTag%d-%d-%d";
    private static final String TEST_FOLDER_NAME_PATTERN = "TestFolder-%d";
    private static final String TEST_DOCUMENT_NAME_PATTERN = "InFolder-%d-TestDocument-%d.txt";
    private ApplicationContext applicationContext;
    private NodeService nodeService;
    private ActionService actionService;
    private TaggingService taggingService;
    private FileFolderService fileFolderService;
    private TransactionService transactionService;
    private UpdateTagScopesActionExecuter actionExecuter;
    private ActionTrackingService actionTrackingService;
    private UserTransaction transaction;
    private List<NodeRef> expectedTagScopes;
    private List<String> testTags;

    @Before
    public void setUp() throws Exception {
        this.applicationContext = ApplicationContextHelper.getApplicationContext();
        final ServiceRegistry registry = (ServiceRegistry)this.applicationContext.getBean("ServiceRegistry");
        this.nodeService = registry.getNodeService();
        this.actionService = registry.getActionService();
        this.actionExecuter = (UpdateTagScopesActionExecuter)this.applicationContext.getBean(UPDATE_TAGSCOPE_ACTION_EXECUTER_BEAN_NAME);
        this.taggingService = registry.getTaggingService();
        this.fileFolderService = registry.getFileFolderService();
        this.transactionService = registry.getTransactionService();
        this.actionTrackingService = (ActionTrackingService)this.applicationContext.getBean(ACTION_TRACKING_SERVICE_BEAN_NAME);
        AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
        this.expectedTagScopes = new LinkedList<NodeRef>();
        this.testTags = new LinkedList<String>();
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                UpdateTagScopesActionExecuterTest.this.createTestContent(registry, UpdateTagScopesActionExecuterTest.this.expectedTagScopes);
                return null;
            }
        }, false, true);
        this.waitForTagScopeUpdate();
        this.transaction = this.transactionService.getUserTransaction();
        this.transaction.begin();
    }

    private void createTestContent(ServiceRegistry registry, List<NodeRef> createdTagScopes) {
        NodeRef rootNode;
        NodeRef currentParent = rootNode = registry.getNodeLocatorService().getNode("companyhome", null, null);
        int i = 0;
        while (i < 3) {
            FileInfo newFolder = this.fileFolderService.create(currentParent, String.format(TEST_FOLDER_NAME_PATTERN, i), ContentModel.TYPE_FOLDER);
            currentParent = newFolder.getNodeRef();
            if (createdTagScopes != null) {
                createdTagScopes.add(currentParent);
            }
            this.nodeService.addAspect(currentParent, ContentModel.ASPECT_TAGSCOPE, null);
            int j = 0;
            while (j < 3) {
                FileInfo newDocument = this.fileFolderService.create(currentParent, String.format(TEST_DOCUMENT_NAME_PATTERN, i, j), ContentModel.TYPE_CONTENT);
                this.nodeService.addAspect(newDocument.getNodeRef(), ContentModel.ASPECT_TAGGABLE, null);
                if (i == 0) {
                    int k = 0;
                    while (k < 3) {
                        String tagName = String.format(TEST_TAG_NAME_PATTERN, k, j, i);
                        this.testTags.add(tagName);
                        this.taggingService.addTag(newDocument.getNodeRef(), tagName);
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForTagScopeUpdate() throws Exception {
        List executingActions = null;
        do {
            UpdateTagScopesActionExecuterTest updateTagScopesActionExecuterTest = this;
            synchronized (updateTagScopesActionExecuterTest) {
                ((Object)((Object)this)).wait(1000L);
            }
        } while (!(executingActions = this.actionTrackingService.getExecutingActions(UPDATE_TAGSCOPE_ACTION_EXECUTER_BEAN_NAME)).isEmpty());
    }

    @After
    public void tearDown() throws Exception {
        final NodeRef rootTestFolder = this.expectedTagScopes.iterator().next();
        for (String tagName : this.testTags) {
            this.taggingService.deleteTag(rootTestFolder.getStoreRef(), tagName);
        }
        this.testTags.clear();
        this.testTags = null;
        if (4 != this.transaction.getStatus()) {
            this.transaction.rollback();
        }
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                UpdateTagScopesActionExecuterTest.this.nodeService.deleteNode(rootTestFolder);
                return null;
            }
        }, false, true);
        AuthenticationUtil.clearCurrentSecurityContext();
        this.expectedTagScopes.clear();
        this.expectedTagScopes = null;
    }

    @Test
    public void testSimpleTagScopesUpsdate() throws Exception {
        Action tagScopeUpdateAction = this.actionService.createAction(UPDATE_TAGSCOPE_ACTION_EXECUTER_BEAN_NAME);
        tagScopeUpdateAction.setParameterValue("tag_scopes", (Serializable)((Object)this.expectedTagScopes));
        this.actionExecuter.execute(tagScopeUpdateAction, null);
        Iterator<NodeRef> iterator = this.expectedTagScopes.iterator();
        UpdateTagScopesActionExecuterTest.assertTrue((boolean)iterator.hasNext());
        NodeRef taggedTagScope = iterator.next();
        UpdateTagScopesActionExecuterTest.assertNotNull((Object)taggedTagScope);
        ContentData contentData = this.getTagScopeCacheContentDataProperty(taggedTagScope);
        UpdateTagScopesActionExecuterTest.assertNotNull((Object)contentData);
        UpdateTagScopesActionExecuterTest.assertTrue((contentData.getSize() > 0L ? 1 : 0) != 0);
        UpdateTagScopesActionExecuterTest.assertTrue((boolean)iterator.hasNext());
        NodeRef tagScopeFolder = iterator.next();
        while (iterator.hasNext()) {
            UpdateTagScopesActionExecuterTest.assertNotNull((Object)tagScopeFolder);
            contentData = this.getTagScopeCacheContentDataProperty(tagScopeFolder);
            UpdateTagScopesActionExecuterTest.assertNull((Object)contentData);
            tagScopeFolder = iterator.next();
        }
    }

    @Test
    public void testTagScopesUpdateWhenTagsAreRemoved() throws Exception {
        Action tagScopeUpdateAction = this.actionService.createAction(UPDATE_TAGSCOPE_ACTION_EXECUTER_BEAN_NAME);
        tagScopeUpdateAction.setParameterValue("tag_scopes", (Serializable)((Object)this.expectedTagScopes));
        this.actionExecuter.execute(tagScopeUpdateAction, null);
        this.waitForTagScopeUpdate();
        final NodeRef taggedTagScope = this.expectedTagScopes.iterator().next();
        UpdateTagScopesActionExecuterTest.assertNotNull((Object)taggedTagScope);
        ContentData contentData = this.getTagScopeCacheContentDataProperty(taggedTagScope);
        UpdateTagScopesActionExecuterTest.assertNotNull((Object)contentData);
        this.actionTrackingService.getExecutingActions(UPDATE_TAGSCOPE_ACTION_EXECUTER_BEAN_NAME);
        UpdateTagScopesActionExecuterTest.assertTrue((contentData.getSize() > 0L ? 1 : 0) != 0);
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                for (ChildAssociationRef child : UpdateTagScopesActionExecuterTest.this.nodeService.getChildAssocs(taggedTagScope, Collections.singleton(ContentModel.TYPE_CONTENT))) {
                    UpdateTagScopesActionExecuterTest.this.taggingService.removeTags(child.getChildRef(), UpdateTagScopesActionExecuterTest.this.testTags);
                }
                return null;
            }
        }, false, true);
        this.waitForTagScopeUpdate();
        this.actionExecuter.execute(tagScopeUpdateAction, null);
        for (NodeRef tagScopeFolder : this.expectedTagScopes) {
            UpdateTagScopesActionExecuterTest.assertNotNull((Object)tagScopeFolder);
            contentData = this.getTagScopeCacheContentDataProperty(tagScopeFolder);
            UpdateTagScopesActionExecuterTest.assertNull((Object)contentData);
        }
    }

    private ContentData getTagScopeCacheContentDataProperty(final NodeRef nodeRef) {
        ContentData result = null;
        Serializable contentProperty = (Serializable)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Serializable>(){

            public Serializable execute() throws Throwable {
                return UpdateTagScopesActionExecuterTest.this.nodeService.getProperty(nodeRef, ContentModel.PROP_TAGSCOPE_CACHE);
            }
        }, false, true);
        if (contentProperty instanceof ContentData) {
            result = (ContentData)contentProperty;
        }
        return result;
    }
}

