/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis.mapping;

import java.io.Serializable;
import java.util.List;
import org.alfresco.opencmis.CMISConnector;
import org.alfresco.opencmis.dictionary.CMISNodeInfo;
import org.alfresco.opencmis.mapping.AbstractProperty;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;

public class DirectProperty
extends AbstractProperty {
    private QName alfrescoName;

    public DirectProperty(ServiceRegistry serviceRegistry, CMISConnector connector, String propertyName, QName alfrescoName) {
        super(serviceRegistry, connector, propertyName);
        this.alfrescoName = alfrescoName;
    }

    @Override
    public QName getMappedProperty() {
        return this.alfrescoName;
    }

    @Override
    public Serializable getValueInternal(CMISNodeInfo nodeInfo) {
        if (nodeInfo.getType() == null) {
            return null;
        }
        if (nodeInfo.getNodeRef() != null) {
            Serializable result = (Serializable)nodeInfo.getNodeProps().get(this.alfrescoName);
            if (result instanceof List) {
                List resultList = (List)((Object)result);
                int index = 0;
                while (index < resultList.size()) {
                    Object element = resultList.get(index);
                    if (element instanceof NodeRef) {
                        NodeRef nodeRef = (NodeRef)element;
                        resultList.set(index, nodeRef.getId());
                    }
                    ++index;
                }
            }
            return result;
        }
        if (nodeInfo.getAssociationRef() != null) {
            return this.getServiceRegistry().getNodeService().getProperty(nodeInfo.getAssociationRef().getSourceRef(), this.alfrescoName);
        }
        return null;
    }
}

