/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.template;

import freemarker.ext.dom.NodeModel;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.template.BaseContentNode;
import org.alfresco.repo.template.BasePermissionsNode;
import org.alfresco.repo.template.LuceneSearchResultsMap;
import org.alfresco.repo.template.NamePathResultsMap;
import org.alfresco.repo.template.NodeSearchResultsMap;
import org.alfresco.repo.template.PropertyConverter;
import org.alfresco.repo.template.SavedSearchResultsMap;
import org.alfresco.repo.template.TemplateProperties;
import org.alfresco.repo.template.VersionHistoryNode;
import org.alfresco.repo.template.XPathResultsMap;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.audit.AuditQueryParameters;
import org.alfresco.service.cmr.audit.AuditService;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.TemplateImageResolver;
import org.alfresco.service.cmr.version.Version;
import org.alfresco.service.cmr.version.VersionHistory;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespacePrefixResolverProvider;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNameMap;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.util.ISO9075;
import org.alfresco.util.UrlUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.InputSource;

public class TemplateNode
extends BasePermissionsNode
implements NamespacePrefixResolverProvider {
    private static final long serialVersionUID = 1234390333739034171L;
    private static Log logger = LogFactory.getLog(TemplateNode.class);
    private Map<String, List<TemplateNode>> targetAssocs = null;
    private Map<String, List<TemplateNode>> sourceAssocs = null;
    private Map<String, List<TemplateNode>> childAssocs = null;
    protected NodeRef nodeRef;
    private String name;
    private QName type;
    private QName parentType;
    private String path;
    private String id;
    private QNameMap<String, Serializable> properties;
    private boolean propsRetrieved = false;
    private TemplateNode parent = null;
    private ChildAssociationRef primaryParentAssoc = null;
    private Boolean isCategory = null;
    private PropertyConverter propertyConverter = new TemplatePropertyConverter();

    public TemplateNode(NodeRef nodeRef, ServiceRegistry services, TemplateImageResolver resolver) {
        if (nodeRef == null) {
            throw new IllegalArgumentException("NodeRef must be supplied.");
        }
        if (services == null) {
            throw new IllegalArgumentException("The ServiceRegistry must be supplied.");
        }
        this.nodeRef = nodeRef;
        this.id = nodeRef.getId();
        this.services = services;
        this.imageResolver = resolver;
        this.properties = new QNameMap((NamespacePrefixResolverProvider)this);
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getStoreType() {
        return this.nodeRef.getStoreRef().getProtocol();
    }

    public String getStoreId() {
        return this.nodeRef.getStoreRef().getIdentifier();
    }

    @Override
    public NodeRef getNodeRef() {
        return this.nodeRef;
    }

    public boolean getExists() {
        return this.services.getNodeService().exists(this.nodeRef);
    }

    public boolean getIsWorkingCopy() {
        return this.services.getNodeService().hasAspect(this.nodeRef, ContentModel.ASPECT_WORKING_COPY);
    }

    @Override
    public QName getType() {
        if (this.type == null) {
            this.type = this.services.getNodeService().getType(this.nodeRef);
        }
        return this.type;
    }

    public String getParentTypeShort() {
        if (this.parentType == null) {
            this.parentType = this.services.getDictionaryService().getType(this.getType()).getParentName();
        }
        return this.parentType.toPrefixString((NamespacePrefixResolver)this.services.getNamespaceService());
    }

    public String getTypeShort() {
        return this.getType().toPrefixString((NamespacePrefixResolver)this.services.getNamespaceService());
    }

    @Override
    public String getName() {
        if (this.name == null) {
            this.name = (String)((Object)this.getProperties().get("cm:name"));
            if (this.name == null) {
                ChildAssociationRef parentRef = this.services.getNodeService().getPrimaryParent(this.nodeRef);
                this.name = parentRef != null && parentRef.getQName() != null ? parentRef.getQName().getLocalName() : "";
            }
        }
        return this.name;
    }

    @Override
    public Map<String, Serializable> getProperties() {
        if (!this.propsRetrieved) {
            Map props = this.services.getNodeService().getProperties(this.nodeRef);
            for (QName qname : props.keySet()) {
                Serializable value = this.propertyConverter.convertProperty((Serializable)props.get(qname), qname, this.services, this.getImageResolver());
                this.properties.put((Object)qname.toString(), (Object)value);
            }
            this.propsRetrieved = true;
        }
        return this.properties;
    }

    public Map<String, List<TemplateNode>> getAssocs() {
        if (this.targetAssocs == null) {
            List refs = this.services.getNodeService().getTargetAssocs(this.nodeRef, RegexQNamePattern.MATCH_ALL);
            this.targetAssocs = new QNameMap((NamespacePrefixResolverProvider)this);
            for (AssociationRef ref : refs) {
                String qname = ref.getTypeQName().toString();
                List<TemplateNode> nodes = this.targetAssocs.get(qname);
                if (nodes == null) {
                    nodes = new ArrayList<TemplateNode>(4);
                    this.targetAssocs.put(ref.getTypeQName().toString(), nodes);
                }
                nodes.add(new TemplateNode(ref.getTargetRef(), this.services, this.imageResolver));
            }
        }
        return this.targetAssocs;
    }

    public Map<String, List<TemplateNode>> getAssociations() {
        return this.getAssocs();
    }

    public Map<String, List<TemplateNode>> getSourceAssocs() {
        if (this.sourceAssocs == null) {
            List refs = this.services.getNodeService().getSourceAssocs(this.nodeRef, RegexQNamePattern.MATCH_ALL);
            this.sourceAssocs = new QNameMap((NamespacePrefixResolverProvider)this);
            for (AssociationRef ref : refs) {
                String qname = ref.getTypeQName().toString();
                List<TemplateNode> nodes = this.sourceAssocs.get(qname);
                if (nodes == null) {
                    nodes = new ArrayList<TemplateNode>(4);
                    this.sourceAssocs.put(ref.getTypeQName().toString(), nodes);
                }
                nodes.add(new TemplateNode(ref.getSourceRef(), this.services, this.imageResolver));
            }
        }
        return this.sourceAssocs;
    }

    public Map<String, List<TemplateNode>> getSourceAssociations() {
        return this.getSourceAssocs();
    }

    public Map<String, List<TemplateNode>> getChildAssocs() {
        if (this.childAssocs == null) {
            List refs = this.services.getNodeService().getChildAssocs(this.nodeRef);
            this.childAssocs = new QNameMap((NamespacePrefixResolverProvider)this);
            for (ChildAssociationRef ref : refs) {
                String qname = ref.getTypeQName().toString();
                List<TemplateNode> nodes = this.childAssocs.get(qname);
                if (nodes == null) {
                    nodes = new ArrayList<TemplateNode>(4);
                    this.childAssocs.put(ref.getTypeQName().toString(), nodes);
                }
                nodes.add(new TemplateNode(ref.getChildRef(), this.services, this.imageResolver));
            }
        }
        return this.childAssocs;
    }

    public Map<String, List<TemplateNode>> getChildAssociations() {
        return this.getChildAssocs();
    }

    public List<TemplateNode> getChildAssocsByType(String type) {
        HashSet<QName> types = new HashSet<QName>(1, 1.0f);
        types.add(this.createQName(type));
        List refs = this.services.getNodeService().getChildAssocs(this.nodeRef, types);
        ArrayList<TemplateNode> nodes = new ArrayList<TemplateNode>(refs.size());
        for (ChildAssociationRef ref : refs) {
            ref.getTypeQName().toString();
            nodes.add(new TemplateNode(ref.getChildRef(), this.services, this.imageResolver));
        }
        return nodes;
    }

    public boolean getIsLocked() {
        boolean locked = false;
        if (this.getAspects().contains(ContentModel.ASPECT_LOCKABLE)) {
            locked = this.services.getLockService().isLocked(this.nodeRef);
        }
        return locked;
    }

    public boolean getIsCategory() {
        if (this.isCategory == null) {
            DictionaryService dd = this.services.getDictionaryService();
            this.isCategory = dd.isSubClass(this.getType(), ContentModel.TYPE_CATEGORY);
        }
        return this.isCategory;
    }

    @Override
    public TemplateProperties getParent() {
        NodeRef parentRef;
        if (this.parent == null && (parentRef = this.services.getNodeService().getPrimaryParent(this.nodeRef).getParentRef()) != null) {
            this.parent = new TemplateNode(parentRef, this.services, this.imageResolver);
        }
        return this.parent;
    }

    public ChildAssociationRef getPrimaryParentAssoc() {
        if (this.primaryParentAssoc == null) {
            this.primaryParentAssoc = this.services.getNodeService().getPrimaryParent(this.nodeRef);
        }
        return this.primaryParentAssoc;
    }

    public List<VersionHistoryNode> getVersionHistory() {
        VersionHistory history;
        List<VersionHistoryNode> records = Collections.emptyList();
        if (this.getAspects().contains(ContentModel.ASPECT_VERSIONABLE) && (history = this.services.getVersionService().getVersionHistory(this.nodeRef)) != null) {
            records = new ArrayList<VersionHistoryNode>(8);
            for (Version version : history.getAllVersions()) {
                VersionHistoryNode record = new VersionHistoryNode(version, this, this.services);
                records.add(record);
            }
        }
        return records;
    }

    public NodeModel getXmlNodeModel() {
        try {
            return NodeModel.parse((InputSource)new InputSource(new StringReader(this.getContent())));
        }
        catch (Throwable err) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)err.getMessage(), err);
            }
            return null;
        }
    }

    public Map getChildByNamePath() {
        return new NamePathResultsMap(this, this.services);
    }

    public Map getChildrenByXPath() {
        return new XPathResultsMap(this, this.services);
    }

    public Map getChildrenBySavedSearch() {
        return new SavedSearchResultsMap(this, this.services);
    }

    public Map getChildrenByLuceneSearch() {
        return new LuceneSearchResultsMap(this, this.services);
    }

    public Map getNodeByReference() {
        return new NodeSearchResultsMap(this, this.services);
    }

    public List<TemplateAuditInfo> getAuditTrail() {
        final ArrayList<TemplateAuditInfo> result = new ArrayList<TemplateAuditInfo>();
        final AuditService.AuditQueryCallback callback = new AuditService.AuditQueryCallback(){

            @Override
            public boolean valuesRequired() {
                return true;
            }

            @Override
            public boolean handleAuditEntryError(Long entryId, String errorMsg, Throwable error) {
                throw new AlfrescoRuntimeException("Failed to retrieve audit data.", error);
            }

            @Override
            public boolean handleAuditEntry(Long entryId, String applicationName, String user, long time, Map<String, Serializable> values) {
                TemplateAuditInfo auditInfo = new TemplateAuditInfo(applicationName, user, time, values);
                result.add(auditInfo);
                return true;
            }
        };
        final String nodePath = ISO9075.decode((String)this.services.getNodeService().getPath(this.nodeRef).toPrefixString((NamespacePrefixResolver)this.services.getNamespaceService()));
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                String applicationName = "alfresco-access";
                AuditQueryParameters pathParams = new AuditQueryParameters();
                pathParams.setApplicationName(applicationName);
                pathParams.addSearchKey("/alfresco-access/transaction/path", (Serializable)((Object)nodePath));
                TemplateNode.this.services.getAuditService().auditQuery(callback, pathParams, Integer.MAX_VALUE);
                AuditQueryParameters copyFromPathParams = new AuditQueryParameters();
                copyFromPathParams.setApplicationName(applicationName);
                copyFromPathParams.addSearchKey("/alfresco-access/transaction/copy/from/path", (Serializable)((Object)nodePath));
                TemplateNode.this.services.getAuditService().auditQuery(callback, copyFromPathParams, Integer.MAX_VALUE);
                AuditQueryParameters moveFromPathParams = new AuditQueryParameters();
                moveFromPathParams.setApplicationName(applicationName);
                moveFromPathParams.addSearchKey("/alfresco-access/transaction/move/from/path", (Serializable)((Object)nodePath));
                TemplateNode.this.services.getAuditService().auditQuery(callback, moveFromPathParams, Integer.MAX_VALUE);
                return null;
            }
        }, (String)AuthenticationUtil.getAdminUserName());
        Collections.sort(result, new Comparator<TemplateAuditInfo>(){

            @Override
            public int compare(TemplateAuditInfo o1, TemplateAuditInfo o2) {
                return o1.getDate().compareTo(o2.getDate());
            }
        });
        return result;
    }

    public TemplateImageResolver getImageResolver() {
        return this.imageResolver;
    }

    private QName createQName(String s) {
        QName qname = s.indexOf("{") != -1 ? QName.createQName((String)s) : QName.createQName((String)s, (NamespacePrefixResolver)this.services.getNamespaceService());
        return qname;
    }

    public String getShareUrl() {
        String siteShortName = this.services.getSiteService().getSiteShortName(this.getNodeRef());
        String baseUrl = UrlUtil.getShareUrl(this.services.getSysAdminParams());
        StringBuilder result = new StringBuilder();
        result.append(baseUrl).append("/page/");
        if (siteShortName != null) {
            result.append("site/").append(siteShortName).append("/");
        }
        result.append("document-details?nodeRef=").append(this.getNodeRef());
        return result.toString();
    }

    public NamespacePrefixResolver getNamespacePrefixResolver() {
        return this.services.getNamespaceService();
    }

    public class TemplateAuditInfo {
        private String applicationName;
        private String userName;
        private long time;
        private Map<String, Serializable> values;

        public TemplateAuditInfo(String applicationName, String userName, long time, Map<String, Serializable> values) {
            this.applicationName = applicationName;
            this.userName = userName;
            this.time = time;
            this.values = values;
        }

        public String getAuditApplication() {
            return this.applicationName;
        }

        public String getUserIdentifier() {
            return this.userName;
        }

        public Date getDate() {
            return new Date(this.time);
        }

        public String getAuditMethod() {
            return this.values.get("/alfresco-access/transaction/action").toString();
        }

        public Map<String, Serializable> getValues() {
            return this.values;
        }
    }

    class TemplatePropertyConverter
    extends PropertyConverter {
        TemplatePropertyConverter() {
        }

        @Override
        public Serializable convertProperty(Serializable value, QName name, ServiceRegistry services, TemplateImageResolver resolver) {
            if (value instanceof ContentData) {
                return new BaseContentNode.TemplateContentData((ContentData)value, name);
            }
            return super.convertProperty(value, name, services, resolver);
        }
    }
}

