/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.permissions.impl.acegi;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.Collection;
import net.sf.acegisecurity.Authentication;
import net.sf.acegisecurity.ConfigAttributeDefinition;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.security.permissions.PermissionCheckCollection;
import org.alfresco.repo.security.permissions.impl.acegi.MethodSecurityInterceptor;
import org.alfresco.util.PropertyCheck;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;

public class MethodSecurityBean<R>
implements InitializingBean {
    private Log logger = LogFactory.getLog(MethodSecurityBean.class);
    private MethodInterceptor methodInterceptor;
    private MethodSecurityInterceptor methodSecurityInterceptor;
    private Class<?> service;
    private String methodName;
    private ConfigAttributeDefinition cad;

    public MethodSecurityBean() {
    }

    public MethodSecurityBean(MethodSecurityInterceptor methodSecurityInterceptor, Class<?> service, String methodName) {
        this.methodSecurityInterceptor = methodSecurityInterceptor;
        this.service = service;
        this.methodName = methodName;
    }

    public void setMethodSecurityInterceptor(MethodInterceptor methodInterceptor) {
        this.methodInterceptor = methodInterceptor;
    }

    public void setService(Class<?> service) {
        this.service = service;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public String toString() {
        return "MethodSecurityBean [serviceInterface=" + this.service.getName() + ", methodName=" + this.methodName + "]";
    }

    public void afterPropertiesSet() throws Exception {
        PropertyCheck.mandatory((Object)this, (String)"methodInterceptor", (Object)this.methodInterceptor);
        PropertyCheck.mandatory((Object)this, (String)"service", this.service);
        PropertyCheck.mandatory((Object)this, (String)"methodName", (Object)this.methodName);
        Method method = null;
        Method[] methodArray = this.service.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (m.getName().equals(this.methodName)) {
                method = m;
                break;
            }
            ++n2;
        }
        if (method == null) {
            throw new AlfrescoRuntimeException("Method not found: \n   Interface: " + this.service.getClass() + "\n" + "   Method:    " + this.methodName);
        }
        if (!(this.methodInterceptor instanceof MethodSecurityInterceptor)) {
            this.cad = null;
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Method interceptor doesn't apply security: " + (Object)((Object)this.methodSecurityInterceptor)));
            }
        } else {
            this.methodSecurityInterceptor = (MethodSecurityInterceptor)this.methodInterceptor;
            this.cad = this.methodSecurityInterceptor.getObjectDefinitionSource().getAttributes((Object)new InternalMethodInvocation(method));
        }
    }

    public Collection<R> applyPermissions(Collection<R> toCheck, Authentication authentication, int targetResultCount) {
        return this.applyPermissions(toCheck, authentication, targetResultCount, Long.MAX_VALUE, Integer.MAX_VALUE);
    }

    public Collection<R> applyPermissions(Collection<R> toCheck, Authentication authentication, int targetResultCount, long cutOffAfterTimeMs, int cutOffAfterCount) {
        if (this.cad == null) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("applyPermissions ignored: " + this));
            }
            return toCheck;
        }
        Collection<R> wrappedToCheck = PermissionCheckCollection.PermissionCheckCollectionMixin.create(toCheck, targetResultCount, cutOffAfterTimeMs, cutOffAfterCount);
        long start = System.currentTimeMillis();
        Collection ret = (Collection)this.methodSecurityInterceptor.getAfterInvocationManager().decide(authentication, null, this.cad, wrappedToCheck);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("applyPermissions: " + ret.size() + " items in " + (System.currentTimeMillis() - start) + " msecs"));
        }
        return ret;
    }

    class InternalMethodInvocation
    implements MethodInvocation {
        Method method;

        public InternalMethodInvocation(Method method) {
            this.method = method;
        }

        protected InternalMethodInvocation() {
            throw new UnsupportedOperationException();
        }

        public Object[] getArguments() {
            throw new UnsupportedOperationException();
        }

        public Method getMethod() {
            return this.method;
        }

        public AccessibleObject getStaticPart() {
            throw new UnsupportedOperationException();
        }

        public Object getThis() {
            throw new UnsupportedOperationException();
        }

        public Object proceed() throws Throwable {
            throw new UnsupportedOperationException();
        }
    }
}

