/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.permissions.dynamic;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.DynamicAuthority;
import org.alfresco.repo.security.permissions.PermissionReference;
import org.alfresco.repo.security.permissions.impl.ModelDAO;
import org.alfresco.service.cmr.coci.CheckOutCheckInService;
import org.alfresco.service.cmr.lock.LockService;
import org.alfresco.service.cmr.lock.LockStatus;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.PropertyCheck;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.extensions.surf.util.AbstractLifecycleBean;

public class LockOwnerDynamicAuthority
extends AbstractLifecycleBean
implements DynamicAuthority {
    private LockService lockService;
    private CheckOutCheckInService checkOutCheckInService;
    private ModelDAO modelDAO;
    private List<String> requiredFor;
    private Set<PermissionReference> whenRequired;

    @Override
    public boolean hasAuthority(final NodeRef nodeRef, final String userName) {
        return (Boolean)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Boolean>(){

            public Boolean doWork() throws Exception {
                if (LockOwnerDynamicAuthority.this.lockService.getLockStatus(nodeRef, userName) == LockStatus.LOCK_OWNER) {
                    return true;
                }
                NodeRef original = LockOwnerDynamicAuthority.this.checkOutCheckInService.getCheckedOut(nodeRef);
                if (original != null) {
                    if (LockOwnerDynamicAuthority.this.lockService.getLockStatus(original, userName) == LockStatus.LOCK_OWNER) {
                        return true;
                    }
                    return false;
                }
                return false;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    @Override
    public String getAuthority() {
        return "ROLE_LOCK_OWNER";
    }

    protected void onBootstrap(ApplicationEvent event) {
        ApplicationContext ctx = super.getApplicationContext();
        this.checkOutCheckInService = (CheckOutCheckInService)ctx.getBean("checkOutCheckInService");
        PropertyCheck.mandatory((Object)this, (String)"lockService", (Object)this.lockService);
        PropertyCheck.mandatory((Object)this, (String)"checkOutCheckInService", (Object)this.checkOutCheckInService);
        PropertyCheck.mandatory((Object)this, (String)"modelDAO", (Object)this.modelDAO);
        if (this.requiredFor != null) {
            this.whenRequired = new HashSet<PermissionReference>();
            for (String permission : this.requiredFor) {
                PermissionReference permissionReference = this.modelDAO.getPermissionReference(null, permission);
                this.whenRequired.addAll(this.modelDAO.getGranteePermissions(permissionReference));
                this.whenRequired.addAll(this.modelDAO.getGrantingPermissions(permissionReference));
            }
        }
    }

    protected void onShutdown(ApplicationEvent event) {
    }

    public void setLockService(LockService lockService) {
        this.lockService = lockService;
    }

    public void setCheckOutCheckInService(CheckOutCheckInService checkOutCheckInService) {
        this.checkOutCheckInService = checkOutCheckInService;
    }

    public void setModelDAO(ModelDAO modelDAO) {
        this.modelDAO = modelDAO;
    }

    public void setRequiredFor(List<String> requiredFor) {
        this.requiredFor = requiredFor;
    }

    @Override
    public Set<PermissionReference> requiredFor() {
        return this.whenRequired;
    }
}

