/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authority.script;

import java.text.Collator;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.extensions.surf.util.I18NUtil;

public interface Authority {
    public ScriptAuthorityType getAuthorityType();

    public String getShortName();

    public String getFullName();

    public String getDisplayName();

    public Set<String> getZones();

    public static class AuthorityComparator
    implements Comparator<Authority> {
        private Map<Authority, String> nameCache;
        private String sortBy;
        private Collator col = Collator.getInstance(I18NUtil.getLocale());
        private int orderMultiplicator = 1;

        public AuthorityComparator(String sortBy) {
            this.sortBy = sortBy;
            this.nameCache = new HashMap<Authority, String>();
        }

        public AuthorityComparator(String sortBy, boolean sortAsc) {
            this.sortBy = sortBy;
            this.nameCache = new HashMap<Authority, String>();
            if (!sortAsc) {
                this.orderMultiplicator = -1;
            }
        }

        @Override
        public int compare(Authority g1, Authority g2) {
            return this.col.compare(this.get(g1), this.get(g2)) * this.orderMultiplicator;
        }

        private String get(Authority g) {
            String v = this.nameCache.get(g);
            if (v == null) {
                v = "displayName".equals(this.sortBy) ? g.getDisplayName() : ("shortName".equals(this.sortBy) ? g.getShortName() : g.getFullName());
                v = v.toLowerCase();
                this.nameCache.put(g, v);
            }
            return v;
        }
    }

    public static enum ScriptAuthorityType {
        GROUP,
        USER;

    }
}

