/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.alfresco.filesys.repo.CifsHelper;
import org.alfresco.filesys.repo.ContentDiskDriver;
import org.alfresco.filesys.repo.ContentDiskDriver2;
import org.alfresco.filesys.repo.ContentNetworkFile;
import org.alfresco.opencmis.AlfrescoCmisServiceImpl;
import org.alfresco.repo.action.ActionServiceImpl;
import org.alfresco.repo.action.executer.ContentMetadataExtracter;
import org.alfresco.repo.coci.WorkingCopyAspect;
import org.alfresco.repo.copy.CopyServiceImpl;
import org.alfresco.repo.forms.processor.node.ContentModelFormProcessor;
import org.alfresco.repo.forum.CommentServiceImpl;
import org.alfresco.repo.importer.FileImporterImpl;
import org.alfresco.repo.jscript.ScriptNode;
import org.alfresco.repo.rendition.RenditionNodeManager;
import org.alfresco.repo.transfer.RepoPrimaryManifestProcessorImpl;
import org.alfresco.repo.version.Version2ServiceImpl;
import org.alfresco.repo.workflow.WorkflowDeployer;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.InvalidTypeException;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class ContentPropertyRestrictionInterceptor
implements MethodInterceptor {
    private DictionaryService dictionaryService;
    private NodeService internalNodeService;
    private Set<String> globalContentPropertyRestrictionWhiteList;
    private boolean globalContentPropertyRestrictions = true;
    private Class[] defaultWhiteList = new Class[]{CifsHelper.class, ContentDiskDriver.class, ContentDiskDriver2.class, ContentNetworkFile.class, AlfrescoCmisServiceImpl.class, ActionServiceImpl.class, ContentMetadataExtracter.class, WorkingCopyAspect.class, CopyServiceImpl.class, ContentModelFormProcessor.class, CommentServiceImpl.class, FileImporterImpl.class, ScriptNode.ScriptContentData.class, RenditionNodeManager.class, RepoPrimaryManifestProcessorImpl.class, Version2ServiceImpl.class, WorkflowDeployer.class};

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setGlobalContentPropertyRestrictions(boolean globalContentPropertyRestrictions) {
        this.globalContentPropertyRestrictions = globalContentPropertyRestrictions;
    }

    public void setGlobalContentPropertyRestrictionWhiteList(String whitelist) {
        this.globalContentPropertyRestrictionWhiteList = this.getWhiteList(whitelist);
    }

    public void setNodeService(NodeService nodeService) {
        this.internalNodeService = nodeService;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        block11: {
            Object[] args;
            String methodName;
            block13: {
                block12: {
                    methodName = invocation.getMethod().getName();
                    args = invocation.getArguments();
                    if (!this.globalContentPropertyRestrictions || this.isCallerWhiteListed()) break block11;
                    if (!methodName.equals("setProperties")) break block12;
                    Map properties = args[1] != null ? Collections.unmodifiableMap((Map)args[1]) : Collections.emptyMap();
                    NodeRef nodeRef = (NodeRef)args[0];
                    if (nodeRef == null) break block11;
                    for (QName propQname : properties.keySet()) {
                        if (!this.isContentProperty(propQname, (Serializable)properties.get(propQname)) || !this.isContentNotNullOrEmpty((Serializable)properties.get(propQname)) || !this.isContentChanged(nodeRef, propQname, (Serializable)properties.get(propQname))) continue;
                        throw new InvalidTypeException("The node's content can't be updated via NodeService#setProperties directly: \n   node: " + args[0] + "\n" + "   property name: " + propQname.getLocalName(), propQname);
                    }
                    break block11;
                }
                if (!methodName.equals("addProperties")) break block13;
                Map properties = args[1] != null ? Collections.unmodifiableMap((Map)args[1]) : Collections.emptyMap();
                NodeRef nodeRef = (NodeRef)args[0];
                if (nodeRef == null) break block11;
                for (QName propQname : properties.keySet()) {
                    if (!this.isContentProperty(propQname, (Serializable)properties.get(propQname)) || !this.isContentNotNullOrEmpty((Serializable)properties.get(propQname)) || !this.isContentChanged(nodeRef, propQname, (Serializable)properties.get(propQname))) continue;
                    throw new InvalidTypeException("The node's content can't be updated via NodeService#addProperties directly: \n   node: " + args[0] + "\n" + "   property name: " + propQname.getLocalName(), propQname);
                }
                break block11;
            }
            if (methodName.equals("createNode") && args.length == 5) {
                Map properties = args[4] != null ? Collections.unmodifiableMap((Map)args[4]) : Collections.emptyMap();
                for (QName propQname : properties.keySet()) {
                    if (!this.isContentProperty(propQname, (Serializable)properties.get(propQname)) || !this.isContentNotNullOrEmpty((Serializable)properties.get(propQname))) continue;
                    throw new InvalidTypeException("The node's content can't be updated via NodeService#createNode directly: \n   node: " + args[0] + "\n" + "   property name: " + propQname.getLocalName(), propQname);
                }
            } else if (methodName.equals("setProperty")) {
                QName propQname = (QName)args[1];
                Serializable value = (Serializable)args[2];
                NodeRef nodeRef = (NodeRef)args[0];
                if (nodeRef != null && this.isContentProperty(propQname, value) && this.isContentNotNullOrEmpty(value) && this.isContentChanged(nodeRef, propQname, value)) {
                    throw new InvalidTypeException("The node's content can't be updated via NodeService#setProperty directly: \n   node: " + args[0] + "\n" + "   property name: " + propQname.getLocalName(), propQname);
                }
            } else if (methodName.equals("addAspect")) {
                Map properties = args[2] != null ? Collections.unmodifiableMap((Map)args[2]) : Collections.emptyMap();
                NodeRef nodeRef = (NodeRef)args[0];
                if (nodeRef != null) {
                    for (QName propQname : properties.keySet()) {
                        if (!this.isContentProperty(propQname, (Serializable)properties.get(propQname)) || !this.isContentNotNullOrEmpty((Serializable)properties.get(propQname)) || !this.isContentChanged(nodeRef, propQname, (Serializable)properties.get(propQname))) continue;
                        throw new InvalidTypeException("The node's content can't be updated via NodeService#addAspect directly: \n   node: " + args[0] + "\n" + "   property name: " + propQname.getLocalName(), propQname);
                    }
                }
            }
        }
        return invocation.proceed();
    }

    private boolean isContentChanged(NodeRef nodeRef, QName qname, Serializable newValue) {
        Serializable existingValue = this.internalNodeService.getProperty(nodeRef, qname);
        if (existingValue == null) {
            return newValue != null;
        }
        if (newValue instanceof ContentData && existingValue instanceof ContentData) {
            String newUrl;
            String existingUrl = ((ContentData)existingValue).getContentUrl();
            return !Objects.equals(existingUrl, newUrl = ((ContentData)newValue).getContentUrl());
        }
        return !existingValue.equals(newValue);
    }

    private boolean isContentNotNullOrEmpty(Serializable propValue) {
        if (propValue == null) {
            return false;
        }
        if (propValue instanceof ContentData) {
            String contentUrl = ((ContentData)propValue).getContentUrl();
            return contentUrl != null && !contentUrl.isEmpty();
        }
        return true;
    }

    private boolean isContentProperty(QName propertyQName, Serializable propValue) {
        if (propValue instanceof ContentData) {
            return true;
        }
        PropertyDefinition contentPropDef = this.dictionaryService.getProperty(propertyQName);
        return contentPropDef != null && contentPropDef.getDataType().getName().equals((Object)DataTypeDefinition.CONTENT);
    }

    private boolean isCallerWhiteListed() {
        StackWalker walker = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
        Optional callerClass = walker.walk(s -> s.map(StackWalker.StackFrame::getDeclaringClass).map(Class::getName).filter(this.globalContentPropertyRestrictionWhiteList::contains).findFirst());
        return callerClass.isPresent();
    }

    private Set<String> getWhiteList(String whiteList) {
        HashSet<String> whiteListSet = new HashSet<String>();
        String string = whiteList = whiteList == null ? "" : whiteList.trim();
        if (whiteList.length() > 0) {
            String[] classes;
            String[] stringArray = classes = whiteList.split(",");
            int n = classes.length;
            int n2 = 0;
            while (n2 < n) {
                String className = stringArray[n2];
                className = className.trim();
                whiteListSet.add(className);
                ++n2;
            }
        }
        Set.of(this.defaultWhiteList).forEach(item -> {
            boolean bl = whiteListSet.add(item.getName());
        });
        return whiteListSet;
    }
}

