/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.jscript;

import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import org.alfresco.repo.jscript.ScriptNode;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.version.Version;
import org.alfresco.util.ParameterCheck;
import org.mozilla.javascript.Scriptable;

public final class ScriptVersion
implements Serializable {
    private static final long serialVersionUID = 3896177303419746778L;
    private Scriptable scope;
    private ServiceRegistry services;
    private Version version;

    public ScriptVersion(Version version, ServiceRegistry services, Scriptable scope) {
        this.version = version;
        this.services = services;
        this.scope = scope;
    }

    public Date getCreatedDate() {
        return this.version.getFrozenModifiedDate();
    }

    public String getCreator() {
        return this.version.getFrozenModifier();
    }

    public String getLabel() {
        return this.version.getVersionLabel();
    }

    public String getType() {
        if (this.version.getVersionType() != null) {
            return this.version.getVersionType().name();
        }
        return "";
    }

    public String getDescription() {
        String desc = this.version.getDescription();
        return desc == null ? "" : desc;
    }

    public NodeRef getNodeRef() {
        return this.version.getVersionedNodeRef();
    }

    public ScriptNode getNode() {
        return new ScriptNode(this.version.getFrozenStateNodeRef(), this.services, this.scope);
    }

    public Map<String, Serializable> getVersionProperties() {
        return this.version.getVersionProperties();
    }

    public Serializable getVersionProperty(String name) {
        ParameterCheck.mandatoryString((String)"name", (String)name);
        return this.version.getVersionProperty(name);
    }
}

