/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.jscript;

import java.util.Collection;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.query.PagingRequest;
import org.alfresco.repo.jscript.BaseScopableProcessorExtension;
import org.alfresco.repo.jscript.CategoryNode;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.CategoryService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

public final class Classification
extends BaseScopableProcessorExtension {
    private ServiceRegistry services;
    private StoreRef storeRef;

    public void setStoreUrl(String storeRef) {
        this.storeRef = new StoreRef(storeRef);
    }

    public void setServiceRegistry(ServiceRegistry services) {
        this.services = services;
    }

    public Scriptable getAllCategoryNodes(String aspect) {
        Object[] cats = this.buildCategoryNodes(this.services.getCategoryService().getCategories(this.storeRef, this.createQName(aspect), CategoryService.Depth.ANY));
        return Context.getCurrentContext().newArray(this.getScope(), cats);
    }

    public String[] getAllClassificationAspects() {
        Collection<QName> aspects = this.services.getCategoryService().getClassificationAspects();
        String[] answer = new String[aspects.size()];
        int i = 0;
        for (QName qname : aspects) {
            answer[i++] = qname.toPrefixString((NamespacePrefixResolver)this.services.getNamespaceService());
        }
        return answer;
    }

    public CategoryNode createRootCategory(String aspect, String name) {
        NodeRef categoryNodeRef = this.services.getCategoryService().createRootCategory(this.storeRef, this.createQName(aspect), name);
        CategoryNode categoryNode = new CategoryNode(categoryNodeRef, this.services, this.getScope());
        return categoryNode;
    }

    public CategoryNode getCategory(String categoryRef) {
        CategoryNode result = null;
        NodeRef categoryNodeRef = new NodeRef(categoryRef);
        if (this.services.getNodeService().exists(categoryNodeRef) && this.services.getDictionaryService().isSubClass(ContentModel.TYPE_CATEGORY, this.services.getNodeService().getType(categoryNodeRef))) {
            result = new CategoryNode(categoryNodeRef, this.services, this.getScope());
        }
        return result;
    }

    public Scriptable getRootCategories(String aspect) {
        Object[] cats = this.buildCategoryNodes(this.services.getCategoryService().getRootCategories(this.storeRef, this.createQName(aspect)));
        return Context.getCurrentContext().newArray(this.getScope(), cats);
    }

    public Scriptable getRootCategories(String aspect, String filter, int maxItems, int skipCount) {
        PagingRequest pagingRequest = new PagingRequest(skipCount, maxItems);
        List rootCategories = this.services.getCategoryService().getRootCategories(this.storeRef, this.createQName(aspect), pagingRequest, true, filter).getPage();
        Object[] cats = this.buildCategoryNodes(rootCategories);
        return Context.getCurrentContext().newArray(this.getScope(), cats);
    }

    public Scriptable getCategoryUsage(String aspect, int maxCount) {
        List<Pair<NodeRef, Integer>> topCats = this.services.getCategoryService().getTopCategories(this.storeRef, this.createQName(aspect), maxCount);
        Object[] tags = new Object[topCats.size()];
        int i = 0;
        for (Pair<NodeRef, Integer> topCat : topCats) {
            tags[i++] = new Tag(new CategoryNode((NodeRef)topCat.getFirst(), this.services, this.getScope()), (Integer)topCat.getSecond());
        }
        return Context.getCurrentContext().newArray(this.getScope(), tags);
    }

    private Object[] buildCategoryNodes(Collection<ChildAssociationRef> cars) {
        Object[] categoryNodes = new Object[cars.size()];
        int i = 0;
        for (ChildAssociationRef car : cars) {
            categoryNodes[i++] = new CategoryNode(car.getChildRef(), this.services, this.getScope());
        }
        return categoryNodes;
    }

    private QName createQName(String s) {
        QName qname = s.indexOf(123) != -1 ? QName.createQName((String)s) : QName.createQName((String)s, (NamespacePrefixResolver)this.services.getNamespaceService());
        return qname;
    }

    public final class Tag {
        private CategoryNode categoryNode;
        private int frequency = 0;

        public Tag(CategoryNode categoryNode, int frequency) {
            this.categoryNode = categoryNode;
            this.frequency = frequency;
        }

        public CategoryNode getCategory() {
            return this.categoryNode;
        }

        public int getFrequency() {
            return this.frequency;
        }
    }
}

