/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.forms.processor.node;

import java.util.List;
import org.alfresco.repo.forms.processor.node.AbstractAssocCommand;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class AddChildAssocCommand
extends AbstractAssocCommand {
    private static final Log logger = LogFactory.getLog(AddChildAssocCommand.class);

    public AddChildAssocCommand(NodeRef sourceNodeRef, NodeRef targetNodeRef, QName assocQName) {
        super(sourceNodeRef, targetNodeRef, assocQName);
    }

    @Override
    protected void updateAssociations(NodeService nodeService) {
        List existingChildren = nodeService.getChildAssocs(this.sourceNodeRef);
        for (ChildAssociationRef assoc : existingChildren) {
            if (!assoc.getChildRef().equals((Object)this.targetNodeRef)) continue;
            if (logger.isWarnEnabled()) {
                logger.warn((Object)("Attempt to add existing child association prevented. " + assoc));
            }
            return;
        }
        nodeService.addChild(this.sourceNodeRef, this.targetNodeRef, this.assocQName, this.assocQName);
    }
}

