/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.exporter;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.exporter.ACPExportPackageHandler;
import org.alfresco.repo.importer.system.SystemExporterImporter;
import org.alfresco.service.cmr.model.FileExistsException;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.view.Exporter;
import org.alfresco.service.cmr.view.ExporterCrawlerParameters;
import org.alfresco.service.cmr.view.ExporterException;
import org.alfresco.service.cmr.view.ExporterService;
import org.alfresco.service.cmr.view.Location;
import org.alfresco.service.cmr.view.ReferenceType;
import org.alfresco.service.cmr.view.RepositoryExporterService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.TempFileProvider;
import org.springframework.extensions.surf.util.I18NUtil;
import org.springframework.extensions.surf.util.ParameterCheck;

public class RepositoryExporterComponent
implements RepositoryExporterService {
    private static final String STOREREF_KEY = "storeRef";
    private static final String PACKAGENAME_KEY = "packageName";
    private static final String INCLUDED_PATHS = "includedPaths";
    private ExporterService exporterService;
    private MimetypeService mimetypeService;
    private FileFolderService fileFolderService;
    private SystemExporterImporter systemExporterImporter;
    private NodeService nodeService;
    private List<Properties> exportStores;

    public void setExporterService(ExporterService exporterService) {
        this.exporterService = exporterService;
    }

    public void setMimetypeService(MimetypeService mimetypeService) {
        this.mimetypeService = mimetypeService;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    public void setSystemExporter(SystemExporterImporter systemExporterImporter) {
        this.systemExporterImporter = systemExporterImporter;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setStores(List<Properties> exportStores) {
        this.exportStores = exportStores;
    }

    @Override
    public RepositoryExporterService.FileExportHandle[] export(String packageName) {
        List<RepositoryExporterService.FileExportHandle> exportHandles = this.exportStores(this.exportStores, packageName, new TempFileExporter());
        return exportHandles.toArray(new RepositoryExporterService.FileExportHandle[exportHandles.size()]);
    }

    @Override
    public RepositoryExporterService.FileExportHandle[] export(File directoryDestination, String packageName) {
        ParameterCheck.mandatory((String)"directoryDestination", (Object)directoryDestination);
        if (!directoryDestination.isDirectory()) {
            throw new ExporterException("Export location " + directoryDestination.getAbsolutePath() + " is not a directory");
        }
        List<RepositoryExporterService.FileExportHandle> exportHandles = this.exportStores(this.exportStores, packageName, new FileExporter(directoryDestination));
        return exportHandles.toArray(new RepositoryExporterService.FileExportHandle[exportHandles.size()]);
    }

    @Override
    public RepositoryExporterService.RepositoryExportHandle[] export(NodeRef repositoryDestination, String packageName) {
        ParameterCheck.mandatory((String)"repositoryDestination", (Object)repositoryDestination);
        FileInfo destInfo = this.fileFolderService.getFileInfo(repositoryDestination);
        if (destInfo == null || !destInfo.isFolder()) {
            throw new ExporterException("Repository destination " + repositoryDestination + " is not a folder.");
        }
        List<RepositoryExporterService.FileExportHandle> exportHandles = this.exportStores(this.exportStores, packageName, new TempFileExporter());
        Map mimetypeExtensions = this.mimetypeService.getExtensionsByMimetype();
        ArrayList<RepositoryExporterService.RepositoryExportHandle> repoExportHandles = new ArrayList<RepositoryExporterService.RepositoryExportHandle>(exportHandles.size());
        for (RepositoryExporterService.FileExportHandle exportHandle : exportHandles) {
            String name = String.valueOf(exportHandle.packageName) + "." + (String)mimetypeExtensions.get(exportHandle.mimeType);
            String title = exportHandle.packageName;
            String description = exportHandle.storeRef != null ? I18NUtil.getMessage((String)"export.store.package.description", (Object[])new Object[]{exportHandle.storeRef.toString()}) : I18NUtil.getMessage((String)"export.generic.package.description");
            NodeRef repoExportFile = this.addExportFile(repositoryDestination, name, title, description, exportHandle.mimeType, exportHandle.exportFile);
            RepositoryExporterService.RepositoryExportHandle handle = new RepositoryExporterService.RepositoryExportHandle();
            handle.storeRef = exportHandle.storeRef;
            handle.packageName = exportHandle.packageName;
            handle.mimeType = exportHandle.mimeType;
            handle.exportFile = repoExportFile;
            repoExportHandles.add(handle);
            exportHandle.exportFile.delete();
        }
        return repoExportHandles.toArray(new RepositoryExporterService.RepositoryExportHandle[repoExportHandles.size()]);
    }

    private NodeRef addExportFile(NodeRef repoDestination, String name, String title, String description, String mimeType, File exportFile) {
        ArrayList<String> paths = new ArrayList<String>();
        paths.add(name);
        try {
            FileInfo fileInfo = this.fileFolderService.resolveNamePath(repoDestination, paths);
            this.fileFolderService.delete(fileInfo.getNodeRef());
        }
        catch (org.alfresco.service.cmr.model.FileNotFoundException fileNotFoundException) {}
        NodeRef exportFileNodeRef = null;
        try {
            FileInfo fileInfo = this.fileFolderService.create(repoDestination, name, ContentModel.TYPE_CONTENT);
            ContentWriter writer = this.fileFolderService.getWriter(fileInfo.getNodeRef());
            writer.setMimetype(mimeType);
            writer.putContent(exportFile);
            exportFileNodeRef = fileInfo.getNodeRef();
            HashMap<QName, String> titledProps = new HashMap<QName, String>(3, 1.0f);
            titledProps.put(ContentModel.PROP_TITLE, title);
            titledProps.put(ContentModel.PROP_DESCRIPTION, description);
            this.nodeService.addAspect(exportFileNodeRef, ContentModel.ASPECT_TITLED, titledProps);
        }
        catch (FileExistsException fileExistsException) {}
        return exportFileNodeRef;
    }

    private <ExportHandleType extends RepositoryExporterService.ExportHandle> List<ExportHandleType> exportStores(List<Properties> stores, String packageName, ExportStore<ExportHandleType> exportStore) {
        ArrayList<ExportHandleType> exportHandles = new ArrayList<ExportHandleType>(stores.size() + 1);
        String completePackageName = packageName == null ? "systeminfo" : String.valueOf(packageName) + "_systeminfo";
        ExportHandleType systemInfoHandle = exportStore.exportSystem(completePackageName);
        exportHandles.add(systemInfoHandle);
        for (Properties store : stores) {
            String storeRefStr = (String)store.get(STOREREF_KEY);
            if (storeRefStr == null || storeRefStr.length() == 0) {
                throw new ExporterException("Store Reference has not been provided.");
            }
            StoreRef storeRef = new StoreRef(storeRefStr);
            String storePackageName = (String)store.get(PACKAGENAME_KEY);
            if (storePackageName == null || storePackageName.length() == 0) {
                storePackageName = storeRef.getIdentifier();
            }
            String completePackageName2 = packageName == null ? storePackageName : String.valueOf(packageName) + "_" + storePackageName;
            String includedPathsStr = (String)store.get(INCLUDED_PATHS);
            String[] includedPaths = includedPathsStr != null ? includedPathsStr.split(",\\s*") : null;
            ExporterCrawlerParameters exportParameters = this.getExportParameters(storeRef, includedPaths);
            ExportHandleType exportHandle = exportStore.exportStore(exportParameters, completePackageName2, null);
            exportHandles.add(exportHandle);
        }
        return exportHandles;
    }

    private ExporterCrawlerParameters getExportParameters(StoreRef storeRef, String[] includedPaths) {
        ExporterCrawlerParameters parameters = new ExporterCrawlerParameters();
        parameters.setExportFrom(new Location(storeRef));
        parameters.setCrawlSelf(true);
        parameters.setCrawlChildNodes(true);
        parameters.setCrawlContent(true);
        parameters.setCrawlAssociations(true);
        parameters.setCrawlNullProperties(true);
        parameters.setExcludeNamespaceURIs(new String[0]);
        parameters.setIncludedPaths(includedPaths);
        parameters.setReferenceType(ReferenceType.NODEREF);
        return parameters;
    }

    private static interface ExportStore<ExportHandleType extends RepositoryExporterService.ExportHandle> {
        public ExportHandleType exportStore(ExporterCrawlerParameters var1, String var2, Exporter var3);

        public ExportHandleType exportSystem(String var1);
    }

    private class FileExporter
    implements ExportStore<RepositoryExporterService.FileExportHandle> {
        private File directoryDestination;

        public FileExporter(File directoryDestination) {
            this.directoryDestination = directoryDestination;
        }

        @Override
        public RepositoryExporterService.FileExportHandle exportStore(ExporterCrawlerParameters exportParameters, String packageName, Exporter progress) {
            File file = new File(this.directoryDestination, String.valueOf(packageName) + "." + "acp");
            File dataFile = new File(packageName);
            File contentDir = new File(packageName);
            try {
                FileOutputStream outputStream = new FileOutputStream(file);
                ACPExportPackageHandler acpHandler = new ACPExportPackageHandler(outputStream, dataFile, contentDir, RepositoryExporterComponent.this.mimetypeService);
                RepositoryExporterComponent.this.exporterService.exportView(acpHandler, exportParameters, progress);
            }
            catch (FileNotFoundException fileNotFoundException) {
                file.delete();
                throw new ExporterException("Failed to create file " + file.getAbsolutePath() + " for holding the export of store " + exportParameters.getExportFrom().getStoreRef());
            }
            RepositoryExporterService.FileExportHandle handle = new RepositoryExporterService.FileExportHandle();
            handle.storeRef = exportParameters.getExportFrom().getStoreRef();
            handle.packageName = packageName;
            handle.mimeType = "application/acp";
            handle.exportFile = file;
            return handle;
        }

        @Override
        public RepositoryExporterService.FileExportHandle exportSystem(String packageName) {
            File tempFile = TempFileProvider.createTempFile((String)"repoExpSystemInfo", (String)".xml");
            try {
                FileOutputStream outputStream = new FileOutputStream(tempFile);
                RepositoryExporterComponent.this.systemExporterImporter.exportSystem(outputStream);
            }
            catch (FileNotFoundException fileNotFoundException) {
                tempFile.delete();
                throw new ExporterException("Failed to create temporary file for holding export of system info");
            }
            RepositoryExporterService.FileExportHandle handle = new RepositoryExporterService.FileExportHandle();
            handle.storeRef = null;
            handle.packageName = packageName;
            handle.mimeType = "text/xml";
            handle.exportFile = tempFile;
            return handle;
        }
    }

    private class TempFileExporter
    implements ExportStore<RepositoryExporterService.FileExportHandle> {
        private TempFileExporter() {
        }

        @Override
        public RepositoryExporterService.FileExportHandle exportStore(ExporterCrawlerParameters exportParameters, String packageName, Exporter progress) {
            File systemTempDir = TempFileProvider.getSystemTempDir();
            File tempFile = TempFileProvider.createTempFile((String)("repoExp" + packageName), (String)".acp", (File)systemTempDir);
            File dataFile = new File(packageName);
            File contentDir = new File(packageName);
            try {
                FileOutputStream outputStream = new FileOutputStream(tempFile);
                ACPExportPackageHandler acpHandler = new ACPExportPackageHandler(outputStream, dataFile, contentDir, RepositoryExporterComponent.this.mimetypeService);
                RepositoryExporterComponent.this.exporterService.exportView(acpHandler, exportParameters, progress);
            }
            catch (FileNotFoundException fileNotFoundException) {
                tempFile.delete();
                throw new ExporterException("Failed to create temporary file for holding export of store " + exportParameters.getExportFrom().getStoreRef());
            }
            RepositoryExporterService.FileExportHandle handle = new RepositoryExporterService.FileExportHandle();
            handle.storeRef = exportParameters.getExportFrom().getStoreRef();
            handle.packageName = packageName;
            handle.mimeType = "application/acp";
            handle.exportFile = tempFile;
            return handle;
        }

        @Override
        public RepositoryExporterService.FileExportHandle exportSystem(String packageName) {
            File systemTempDir = TempFileProvider.getSystemTempDir();
            File tempFile = TempFileProvider.createTempFile((String)"repoExpSystemInfo", (String)".xml", (File)systemTempDir);
            try {
                FileOutputStream outputStream = new FileOutputStream(tempFile);
                RepositoryExporterComponent.this.systemExporterImporter.exportSystem(outputStream);
            }
            catch (FileNotFoundException fileNotFoundException) {
                tempFile.delete();
                throw new ExporterException("Failed to create temporary file for holding export of system info");
            }
            RepositoryExporterService.FileExportHandle handle = new RepositoryExporterService.FileExportHandle();
            handle.storeRef = null;
            handle.packageName = packageName;
            handle.mimeType = "text/xml";
            handle.exportFile = tempFile;
            return handle;
        }
    }
}

