/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.node;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.domain.contentdata.ContentDataDAO;
import org.alfresco.repo.domain.locale.LocaleDAO;
import org.alfresco.repo.domain.node.ContentDataId;
import org.alfresco.repo.domain.node.ContentDataWithId;
import org.alfresco.repo.domain.node.NodePropertyKey;
import org.alfresco.repo.domain.node.NodePropertyValue;
import org.alfresco.repo.domain.qname.QNameDAO;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryException;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.MLText;
import org.alfresco.service.cmr.repository.datatype.TypeConversionException;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.EqualsHelper;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NodePropertyHelper {
    private static final Log logger = LogFactory.getLog(NodePropertyHelper.class);
    private final DictionaryService dictionaryService;
    private final QNameDAO qnameDAO;
    private final LocaleDAO localeDAO;
    private final ContentDataDAO contentDataDAO;
    private static final int IDX_NO_COLLECTION = -1;

    public NodePropertyHelper(DictionaryService dictionaryService, QNameDAO qnameDAO, LocaleDAO localeDAO, ContentDataDAO contentDataDAO) {
        this.dictionaryService = dictionaryService;
        this.qnameDAO = qnameDAO;
        this.localeDAO = localeDAO;
        this.contentDataDAO = contentDataDAO;
    }

    public Map<NodePropertyKey, NodePropertyValue> convertToPersistentProperties(Map<QName, Serializable> in) {
        Long propertylocaleId = (Long)this.localeDAO.getOrCreateDefaultLocalePair().getFirst();
        HashMap<NodePropertyKey, NodePropertyValue> propertyMap = new HashMap<NodePropertyKey, NodePropertyValue>(in.size() + 5);
        for (Map.Entry<QName, Serializable> entry : in.entrySet()) {
            Serializable value = entry.getValue();
            QName propertyQName = entry.getKey();
            Long propertyQNameId = (Long)this.qnameDAO.getOrCreateQName(propertyQName).getFirst();
            PropertyDefinition propertyDef = this.dictionaryService.getProperty(propertyQName);
            this.addValueToPersistedProperties(propertyMap, propertyDef, -1, propertyQNameId, propertylocaleId, value);
        }
        return propertyMap;
    }

    private void addValueToPersistedProperties(Map<NodePropertyKey, NodePropertyValue> propertyMap, PropertyDefinition propertyDef, int collectionIndex, Long propertyQNameId, Long propertyLocaleId, Serializable value) {
        if (value == null) {
            NodePropertyValue npValue = this.makeNodePropertyValue(propertyDef, null);
            NodePropertyKey npKey = new NodePropertyKey();
            npKey.setListIndex(collectionIndex);
            npKey.setQnameId(propertyQNameId);
            npKey.setLocaleId(propertyLocaleId);
            propertyMap.put(npKey, npValue);
            return;
        }
        QName propertyTypeQName = propertyDef == null ? DataTypeDefinition.ANY : propertyDef.getDataType().getName();
        boolean isMultiValued = propertyTypeQName.equals((Object)DataTypeDefinition.ANY) ? value != null && value instanceof Collection && collectionIndex == -1 : propertyDef.isMultiValued();
        if (collectionIndex == -1 && isMultiValued && !(value instanceof Collection)) {
            this.addValueToPersistedProperties(propertyMap, propertyDef, 0, propertyQNameId, propertyLocaleId, value);
        } else if (collectionIndex == -1 && value instanceof Collection) {
            if (!isMultiValued) {
                throw new DictionaryException("A single-valued property of this type may not be a collection: \n   Property: " + propertyDef + "\n" + "   Type: " + propertyTypeQName + "\n" + "   Value: " + value);
            }
            Collection collectionValues = (Collection)((Object)value);
            if (collectionValues.size() == 0) {
                NodePropertyValue npValue = this.makeNodePropertyValue(null, (Serializable)((Object)collectionValues));
                NodePropertyKey npKey = new NodePropertyKey();
                npKey.setListIndex(-1);
                npKey.setQnameId(propertyQNameId);
                npKey.setLocaleId(propertyLocaleId);
                propertyMap.put(npKey, npValue);
            }
            collectionIndex = -1;
            for (Object collectionValueObj : collectionValues) {
                ++collectionIndex;
                if (collectionValueObj != null && !(collectionValueObj instanceof Serializable)) {
                    throw new IllegalArgumentException("Node properties must be fully serializable, including values contained in collections. \n   Property: " + propertyDef + "\n" + "   Index:    " + collectionIndex + "\n" + "   Value:    " + collectionValueObj);
                }
                Serializable collectionValue = (Serializable)collectionValueObj;
                try {
                    this.addValueToPersistedProperties(propertyMap, propertyDef, collectionIndex, propertyQNameId, propertyLocaleId, collectionValue);
                }
                catch (Throwable e) {
                    throw new AlfrescoRuntimeException("Failed to persist collection entry: \n   Property: " + propertyDef + "\n" + "   Index:    " + collectionIndex + "\n" + "   Value:    " + collectionValue, e);
                }
            }
        } else {
            if (value instanceof Collection && !propertyTypeQName.equals((Object)DataTypeDefinition.ANY)) {
                throw new DictionaryException("Collections of collections (Serializable) are only supported by type 'd:any': \n   Property: " + propertyDef + "\n" + "   Type: " + propertyTypeQName + "\n" + "   Value: " + value);
            }
            if (value instanceof MLText) {
                MLText mlTextValue = (MLText)value;
                for (Map.Entry mlTextEntry : mlTextValue.entrySet()) {
                    Locale mlTextLocale = (Locale)mlTextEntry.getKey();
                    String mlTextStr = (String)mlTextEntry.getValue();
                    Long mlTextLocaleId = (Long)this.localeDAO.getOrCreateLocalePair(mlTextLocale).getFirst();
                    NodePropertyValue npValue = new NodePropertyValue(DataTypeDefinition.TEXT, (Serializable)((Object)mlTextStr));
                    NodePropertyKey npKey = new NodePropertyKey();
                    npKey.setListIndex(collectionIndex);
                    npKey.setQnameId(propertyQNameId);
                    npKey.setLocaleId(mlTextLocaleId);
                    propertyMap.put(npKey, npValue);
                }
            } else {
                NodePropertyValue npValue = this.makeNodePropertyValue(propertyDef, value);
                NodePropertyKey npKey = new NodePropertyKey();
                npKey.setListIndex(collectionIndex);
                npKey.setQnameId(propertyQNameId);
                npKey.setLocaleId(propertyLocaleId);
                propertyMap.put(npKey, npValue);
            }
        }
    }

    public NodePropertyValue makeNodePropertyValue(PropertyDefinition propertyDef, Serializable value) {
        QName propertyTypeQName = propertyDef == null ? DataTypeDefinition.ANY : propertyDef.getDataType().getName();
        try {
            NodePropertyValue propertyValue = null;
            propertyValue = new NodePropertyValue(propertyTypeQName, value);
            return propertyValue;
        }
        catch (TypeConversionException e) {
            throw new TypeConversionException("The property value is not compatible with the type defined for the property: \n   property: " + (propertyDef == null ? "unknown" : propertyDef) + "\n" + "   value: " + value + "\n" + "   value type: " + value.getClass(), (Throwable)e);
        }
    }

    public Serializable getPublicProperty(Map<NodePropertyKey, NodePropertyValue> propertyValues, QName propertyQName) {
        Pair<Long, QName> qnamePair = this.qnameDAO.getQName(propertyQName);
        if (qnamePair == null) {
            return null;
        }
        Long qnameId = (Long)qnamePair.getFirst();
        TreeMap<NodePropertyKey, NodePropertyValue> scratch = new TreeMap<NodePropertyKey, NodePropertyValue>();
        for (Map.Entry<NodePropertyKey, NodePropertyValue> entry : propertyValues.entrySet()) {
            NodePropertyKey propertyKey = entry.getKey();
            if (!propertyKey.getQnameId().equals(qnameId)) continue;
            scratch.put(propertyKey, entry.getValue());
        }
        if (scratch.size() > 0) {
            PropertyDefinition propertyDef = this.dictionaryService.getProperty(propertyQName);
            Serializable collapsedValue = this.collapsePropertiesWithSameQName(propertyDef, scratch);
            return collapsedValue;
        }
        return null;
    }

    public Map<QName, Serializable> convertToPublicProperties(Map<NodePropertyKey, NodePropertyValue> propertyValues) {
        HashMap<QName, Serializable> propertyMap = new HashMap<QName, Serializable>(propertyValues.size(), 1.0f);
        if (propertyValues.size() == 0) {
            return propertyMap;
        }
        TreeMap<NodePropertyKey, NodePropertyValue> sortedPropertyValues = new TreeMap<NodePropertyKey, NodePropertyValue>(propertyValues);
        TreeMap<NodePropertyKey, NodePropertyValue> scratch = new TreeMap<NodePropertyKey, NodePropertyValue>();
        Long currentQNameId = Long.MIN_VALUE;
        Iterator iterator = sortedPropertyValues.entrySet().iterator();
        while (true) {
            Long nextQNameId = null;
            NodePropertyKey nextPropertyKey = null;
            NodePropertyValue nextPropertyValue = null;
            if (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                nextPropertyKey = (NodePropertyKey)entry.getKey();
                nextPropertyValue = (NodePropertyValue)entry.getValue();
                nextQNameId = nextPropertyKey.getQnameId();
            }
            if (!(scratch.size() <= 0 || nextQNameId != null && nextQNameId.equals(currentQNameId))) {
                QName currentQName = (QName)this.qnameDAO.getQName(currentQNameId).getSecond();
                PropertyDefinition currentPropertyDef = this.dictionaryService.getProperty(currentQName);
                Serializable collapsedValue = null;
                collapsedValue = scratch.size() == 1 ? this.collapsePropertiesWithSameQNameAndListIndex(currentPropertyDef, scratch) : this.collapsePropertiesWithSameQName(currentPropertyDef, scratch);
                boolean forceCollection = false;
                if (currentPropertyDef != null && currentPropertyDef.isMultiValued()) {
                    forceCollection = true;
                } else if (scratch.size() == 1 && ((NodePropertyKey)scratch.firstKey()).getListIndex() > -1) {
                    forceCollection = true;
                }
                if (forceCollection && collapsedValue != null && !(collapsedValue instanceof Collection)) {
                    ArrayList collection = new ArrayList(1);
                    collection.add(collapsedValue);
                    collapsedValue = collection;
                }
                propertyMap.put(currentQName, collapsedValue);
                scratch.clear();
            }
            if (nextQNameId == null) break;
            scratch.put(nextPropertyKey, nextPropertyValue);
            currentQNameId = nextQNameId;
        }
        return propertyMap;
    }

    private Serializable collapsePropertiesWithSameQName(PropertyDefinition propertyDef, SortedMap<NodePropertyKey, NodePropertyValue> sortedPropertyValues) {
        Serializable result = null;
        ArrayList collectionResult = null;
        HashMap<NodePropertyKey, NodePropertyValue> scratch = new HashMap<NodePropertyKey, NodePropertyValue>(3);
        Integer currentListIndex = Integer.MIN_VALUE;
        Iterator<Map.Entry<NodePropertyKey, NodePropertyValue>> iterator = sortedPropertyValues.entrySet().iterator();
        while (true) {
            Integer nextListIndex = null;
            NodePropertyKey nextPropertyKey = null;
            NodePropertyValue nextPropertyValue = null;
            if (iterator.hasNext()) {
                Map.Entry<NodePropertyKey, NodePropertyValue> entry = iterator.next();
                nextPropertyKey = entry.getKey();
                nextPropertyValue = entry.getValue();
                nextListIndex = nextPropertyKey.getListIndex();
            }
            if (!(scratch.size() <= 0 || nextListIndex != null && nextListIndex.equals(currentListIndex))) {
                ArrayList collapsedValue = this.collapsePropertiesWithSameQNameAndListIndex(propertyDef, scratch);
                if (result == null) {
                    result = collapsedValue;
                } else if (collectionResult != null) {
                    collectionResult.add(collapsedValue);
                } else {
                    collectionResult = new ArrayList(20);
                    collectionResult.add(result);
                    collectionResult.add(collapsedValue);
                    result = collectionResult;
                }
                scratch.clear();
            }
            if (nextListIndex == null) break;
            scratch.put(nextPropertyKey, nextPropertyValue);
            currentListIndex = nextListIndex;
        }
        if (propertyDef != null && propertyDef.isMultiValued() && result != null && !(result instanceof Collection)) {
            ArrayList collection = new ArrayList(1);
            collection.add(result);
            result = collection;
        }
        return result;
    }

    private Serializable collapsePropertiesWithSameQNameAndListIndex(PropertyDefinition propertyDef, Map<NodePropertyKey, NodePropertyValue> propertyValues) {
        int propertyValuesSize = propertyValues.size();
        Serializable value = null;
        if (propertyValuesSize == 0) {
            return value;
        }
        boolean isMLText = propertyDef != null && propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.MLTEXT);
        Pair<Long, Locale> defaultLocalePair = this.localeDAO.getDefaultLocalePair();
        Long defaultLocaleId = defaultLocalePair == null ? null : (Long)defaultLocalePair.getFirst();
        Integer listIndex = null;
        for (Map.Entry<NodePropertyKey, NodePropertyValue> entry : propertyValues.entrySet()) {
            NodePropertyKey propertyKey = entry.getKey();
            NodePropertyValue propertyValue = entry.getValue();
            if (listIndex == null) {
                listIndex = propertyKey.getListIndex();
            } else if (!listIndex.equals(propertyKey.getListIndex())) {
                throw new IllegalStateException("Expecting to collapse properties with same list index: " + propertyValues);
            }
            Long localeId = propertyKey.getLocaleId();
            boolean isDefaultLocale = EqualsHelper.nullSafeEquals((Object)defaultLocaleId, (Object)localeId);
            Serializable entryValue = this.makeSerializableValue(propertyDef, propertyValue);
            if (isDefaultLocale && !isMLText) {
                if (propertyValuesSize > 1) {
                    logger.warn((Object)("Found localized properties along with a 'null' value in the default locale. \n   The localized values will be ignored; 'null' will be returned: \n   Default locale ID: " + defaultLocaleId + "\n" + "   Property:          " + propertyDef + "\n" + "   Values:            " + propertyValues));
                }
                value = entryValue;
                break;
            }
            Locale locale = (Locale)this.localeDAO.getLocalePair(localeId).getSecond();
            if (value == null) {
                value = new MLText();
            }
            if (entryValue == null || entryValue instanceof String) {
                ((MLText)value).put((Object)locale, (Object)((String)((Object)entryValue)));
                continue;
            }
            logger.warn((Object)("Found localized non-String properties. \n   The non-String values will be ignored: \n   Default locale ID: " + defaultLocaleId + "\n" + "   Property:          " + propertyDef + "\n" + "   Values:            " + propertyValues));
        }
        return value;
    }

    public Serializable makeSerializableValue(PropertyDefinition propertyDef, NodePropertyValue propertyValue) {
        if (propertyValue == null) {
            return null;
        }
        QName propertyTypeQName = propertyDef == null ? DataTypeDefinition.ANY : propertyDef.getDataType().getName();
        try {
            Object value = propertyValue.getValue(propertyTypeQName);
            if (value instanceof ContentDataId) {
                Long contentDataId = ((ContentDataId)value).getId();
                ContentData contentData = (ContentData)this.contentDataDAO.getContentData(contentDataId).getSecond();
                value = new ContentDataWithId(contentData, contentDataId);
            } else if (value instanceof Long && propertyTypeQName.equals((Object)DataTypeDefinition.CONTENT)) {
                Long contentDataId = (Long)value;
                ContentData contentData = (ContentData)this.contentDataDAO.getContentData(contentDataId).getSecond();
                value = new ContentDataWithId(contentData, contentDataId);
            }
            return value;
        }
        catch (TypeConversionException e) {
            throw new TypeConversionException("The property value is not compatible with the type defined for the property: \n   property: " + (propertyDef == null ? "unknown" : propertyDef) + "\n" + "   property value: " + propertyValue, (Throwable)e);
        }
    }
}

