/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.filestore;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.text.MessageFormat;
import org.alfresco.api.AlfrescoPublicApi;
import org.alfresco.repo.content.AbstractContentReader;
import org.alfresco.repo.content.filestore.FileContentWriter;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.util.TempFileProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@AlfrescoPublicApi
public class FileContentReader
extends AbstractContentReader
implements org.alfresco.service.cmr.repository.FileContentReader {
    public static final String MSG_MISSING_CONTENT = "content.content_missing";
    private static final Log logger = LogFactory.getLog(FileContentReader.class);
    private File file;
    private boolean allowRandomAccess;

    public static ContentReader getSafeContentReader(ContentReader existingReader, String msgTemplate, Object ... args) {
        ContentReader reader = existingReader;
        if (existingReader == null || !existingReader.exists()) {
            String fakeContent = MessageFormat.format(msgTemplate, args);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)fakeContent);
            }
            File tempFile = TempFileProvider.createTempFile((String)"getSafeContentReader_", (String)".txt");
            FileContentWriter writer = new FileContentWriter(tempFile);
            writer.setMimetype("text/plain");
            writer.setEncoding("UTF-8");
            writer.putContent(fakeContent);
            reader = writer.getReader();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Created safe content reader: \n   existing reader: " + existingReader + "\n" + "   safe reader: " + reader));
        }
        return reader;
    }

    public FileContentReader(File file) {
        this(file, "store://" + file.getAbsolutePath());
    }

    public FileContentReader(File file, String url) {
        super(url);
        this.file = file;
        this.allowRandomAccess = true;
    }

    void setAllowRandomAccess(boolean allow) {
        this.allowRandomAccess = allow;
    }

    public File getFile() {
        return this.file;
    }

    public boolean exists() {
        return this.file.exists();
    }

    public long getSize() {
        if (!this.exists()) {
            return 0L;
        }
        return this.file.length();
    }

    public long getLastModified() {
        if (!this.exists()) {
            return 0L;
        }
        return this.file.lastModified();
    }

    @Override
    protected ContentReader createReader() throws ContentIOException {
        FileContentReader reader = new FileContentReader(this.file, this.getContentUrl());
        reader.setAllowRandomAccess(this.allowRandomAccess);
        return reader;
    }

    @Override
    protected ReadableByteChannel getDirectReadableChannel() throws ContentIOException {
        try {
            if (!this.file.exists()) {
                throw new IOException("File does not exist: " + this.file);
            }
            ReadableByteChannel channel = null;
            if (this.allowRandomAccess) {
                RandomAccessFile randomAccessFile = new RandomAccessFile(this.file, "r");
                channel = randomAccessFile.getChannel();
            } else {
                FileInputStream is = new FileInputStream(this.file);
                channel = Channels.newChannel(is);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Opened read channel to file: \n   file: " + this.file + "\n" + "   random-access: " + this.allowRandomAccess));
            }
            return channel;
        }
        catch (Throwable e) {
            throw new ContentIOException("Failed to open file channel: " + this, e);
        }
    }

    @Deprecated
    public boolean canWrite() {
        return false;
    }
}

