/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.AbstractContentStreamListener;
import org.alfresco.repo.content.ContentContext;
import org.alfresco.repo.content.ContentServicePolicies;
import org.alfresco.repo.content.ContentStore;
import org.alfresco.repo.content.EmptyContentReader;
import org.alfresco.repo.content.NodeContentContext;
import org.alfresco.repo.content.UnsupportedContentUrlException;
import org.alfresco.repo.content.cleanup.EagerContentStoreCleaner;
import org.alfresco.repo.content.directurl.DirectAccessUrlDisabledException;
import org.alfresco.repo.content.directurl.SystemWideDirectUrlConfig;
import org.alfresco.repo.content.filestore.FileContentStore;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.ClassPolicyDelegate;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.InvalidTypeException;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentStreamListener;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.DirectAccessUrl;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.MimetypeServiceAware;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.usage.ContentQuotaException;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.EqualsHelper;
import org.alfresco.util.TempFileProvider;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.extensions.surf.util.I18NUtil;

public class ContentServiceImpl
implements ContentService,
ApplicationContextAware {
    private static final Log logger = LogFactory.getLog(ContentServiceImpl.class);
    private DictionaryService dictionaryService;
    private NodeService nodeService;
    private MimetypeService mimetypeService;
    private RetryingTransactionHelper transactionHelper;
    private ApplicationContext applicationContext;
    private EagerContentStoreCleaner eagerContentStoreCleaner;
    private ContentStore store;
    private ContentStore tempStore;
    private boolean ignoreEmptyContent;
    private SystemWideDirectUrlConfig systemWideDirectUrlConfig;
    private Set<String> nonAttachContentTypes = Collections.emptySet();
    private PolicyComponent policyComponent;
    ClassPolicyDelegate<ContentServicePolicies.OnContentUpdatePolicy> onContentUpdateDelegate;
    ClassPolicyDelegate<ContentServicePolicies.OnContentPropertyUpdatePolicy> onContentPropertyUpdateDelegate;
    ClassPolicyDelegate<ContentServicePolicies.OnContentReadPolicy> onContentReadDelegate;

    public void setRetryingTransactionHelper(RetryingTransactionHelper helper) {
        this.transactionHelper = helper;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setMimetypeService(MimetypeService mimetypeService) {
        this.mimetypeService = mimetypeService;
    }

    public void setEagerContentStoreCleaner(EagerContentStoreCleaner eagerContentStoreCleaner) {
        this.eagerContentStoreCleaner = eagerContentStoreCleaner;
    }

    public void setStore(ContentStore store) {
        this.store = store;
    }

    public void setSystemWideDirectUrlConfig(SystemWideDirectUrlConfig systemWideDirectUrlConfig) {
        this.systemWideDirectUrlConfig = systemWideDirectUrlConfig;
    }

    public void setNonAttachContentTypes(String nonAttachAllowListStr) {
        if (nonAttachAllowListStr != null && !nonAttachAllowListStr.isEmpty()) {
            this.nonAttachContentTypes = Set.of(nonAttachAllowListStr.trim().split("\\s*,\\s*"));
        }
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setIgnoreEmptyContent(boolean ignoreEmptyContent) {
        this.ignoreEmptyContent = ignoreEmptyContent;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void init() {
        this.tempStore = new FileContentStore(this.applicationContext, TempFileProvider.getTempDir().getAbsolutePath());
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnUpdatePropertiesPolicy.QNAME, this, (Behaviour)new JavaBehaviour(this, "onUpdateProperties"));
        this.onContentUpdateDelegate = this.policyComponent.registerClassPolicy(ContentServicePolicies.OnContentUpdatePolicy.class);
        this.onContentPropertyUpdateDelegate = this.policyComponent.registerClassPolicy(ContentServicePolicies.OnContentPropertyUpdatePolicy.class);
        this.onContentReadDelegate = this.policyComponent.registerClassPolicy(ContentServicePolicies.OnContentReadPolicy.class);
    }

    public void onUpdateProperties(NodeRef nodeRef, Map<QName, Serializable> before, Map<QName, Serializable> after) {
        if (this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_NO_CONTENT)) {
            return;
        }
        Set<QName> types = null;
        ContentServicePolicies.OnContentPropertyUpdatePolicy propertyPolicy = null;
        boolean fire = false;
        boolean isNewContent = false;
        for (QName propertyQName : after.keySet()) {
            PropertyDefinition propertyDef = this.dictionaryService.getProperty(propertyQName);
            if (propertyDef == null || !propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.CONTENT) || propertyDef.isMultiValued()) continue;
            try {
                boolean hasContentAfter;
                ContentData beforeValue = (ContentData)before.get(propertyQName);
                ContentData afterValue = (ContentData)after.get(propertyQName);
                boolean hasContentBefore = ContentData.hasContent((ContentData)beforeValue) && (!this.ignoreEmptyContent || beforeValue.getSize() > 0L);
                boolean bl = hasContentAfter = ContentData.hasContent((ContentData)afterValue) && (!this.ignoreEmptyContent || afterValue.getSize() > 0L);
                if (!hasContentBefore && !hasContentAfter || EqualsHelper.nullSafeEquals((Object)beforeValue, (Object)afterValue)) continue;
                boolean bl2 = isNewContent = isNewContent || !hasContentBefore && hasContentAfter;
                if (!hasContentBefore) {
                    beforeValue = null;
                }
                if (!hasContentAfter) {
                    afterValue = null;
                }
                if (logger.isDebugEnabled()) {
                    String name = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_NAME));
                    logger.debug((Object)("Content property updated: \n   Node Name:   " + name + "\n" + "   Property:    " + propertyQName + "\n" + "   Is new:      " + isNewContent + "\n" + "   Before:      " + beforeValue + "\n" + "   After:       " + afterValue));
                }
                types = this.getTypes(nodeRef, types);
                if (propertyPolicy == null) {
                    propertyPolicy = this.onContentPropertyUpdateDelegate.get(nodeRef, types);
                }
                propertyPolicy.onContentPropertyUpdate(nodeRef, propertyQName, beforeValue, afterValue);
                fire = true;
            }
            catch (ClassCastException classCastException) {}
        }
        if (fire) {
            types = this.getTypes(nodeRef, types);
            ContentServicePolicies.OnContentUpdatePolicy policy = this.onContentUpdateDelegate.get(nodeRef, types);
            policy.onContentUpdate(nodeRef, isNewContent);
        }
    }

    private Set<QName> getTypes(NodeRef nodeRef, Set<QName> types) {
        if (types != null) {
            return types;
        }
        types = new HashSet<QName>(this.nodeService.getAspects(nodeRef));
        types.add(this.nodeService.getType(nodeRef));
        return types;
    }

    @Override
    public long getStoreFreeSpace() {
        return this.store.getSpaceFree();
    }

    @Override
    public long getStoreTotalSpace() {
        return this.store.getSpaceTotal();
    }

    @Override
    public ContentReader getRawReader(String contentUrl) {
        ContentReader reader = null;
        try {
            reader = this.store.getReader(contentUrl);
        }
        catch (UnsupportedContentUrlException unsupportedContentUrlException) {
            reader = new EmptyContentReader(contentUrl);
        }
        if (reader == null) {
            throw new AlfrescoRuntimeException("ContentStore implementations may not return null ContentReaders");
        }
        reader.setMimetype("application/octet-stream");
        reader.setEncoding("UTF-8");
        reader.setLocale(I18NUtil.getLocale());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Direct request for reader: \n   Content URL: " + contentUrl + "\n" + "   Reader:      " + reader));
        }
        return reader;
    }

    @Override
    public ContentReader getReader(NodeRef nodeRef, QName propertyQName) {
        return this.getReader(nodeRef, propertyQName, true);
    }

    private ContentReader getReader(NodeRef nodeRef, QName propertyQName, boolean fireContentReadPolicy) {
        ContentData contentData = this.getContentData(nodeRef, propertyQName);
        if (contentData == null || contentData.getContentUrl() == null) {
            return null;
        }
        String contentUrl = contentData.getContentUrl();
        ContentReader reader = this.store.getReader(contentUrl);
        if (reader == null) {
            throw new AlfrescoRuntimeException("ContentStore implementations may not return null ContentReaders");
        }
        reader.setMimetype(contentData.getMimetype());
        reader.setEncoding(contentData.getEncoding());
        reader.setLocale(contentData.getLocale());
        if (reader != null && fireContentReadPolicy) {
            HashSet<QName> types = new HashSet<QName>(this.nodeService.getAspects(nodeRef));
            types.add(this.nodeService.getType(nodeRef));
            ContentServicePolicies.OnContentReadPolicy policy = this.onContentReadDelegate.get(nodeRef, types);
            policy.onContentRead(nodeRef);
        }
        return reader;
    }

    private ContentData getContentData(NodeRef nodeRef, QName propertyQName) {
        PropertyDefinition contentPropDef;
        Collection colPropValue;
        ContentData contentData = null;
        Serializable propValue = this.nodeService.getProperty(nodeRef, propertyQName);
        if (propValue instanceof Collection && (colPropValue = (Collection)((Object)propValue)).size() > 0) {
            propValue = (Serializable)colPropValue.iterator().next();
        }
        if (propValue instanceof ContentData) {
            contentData = (ContentData)propValue;
        }
        if (contentData == null && (contentPropDef = this.dictionaryService.getProperty(propertyQName)) != null && !contentPropDef.getDataType().getName().equals((Object)DataTypeDefinition.CONTENT) && !contentPropDef.getDataType().getName().equals((Object)DataTypeDefinition.ANY)) {
            throw new InvalidTypeException("The node property must be of type content: \n   node: " + nodeRef + "\n" + "   property name: " + propertyQName + "\n" + "   property type: " + (contentPropDef == null ? "unknown" : contentPropDef.getDataType()), propertyQName);
        }
        return contentData;
    }

    @Override
    public ContentWriter getWriter(NodeRef nodeRef, QName propertyQName, boolean update) {
        if (nodeRef == null) {
            ContentContext ctx = new ContentContext(null, null);
            ContentWriter writer = this.store.getWriter(ctx);
            this.eagerContentStoreCleaner.registerNewContentUrl(writer.getContentUrl());
            return writer;
        }
        ContentReader existingContentReader = this.getReader(nodeRef, propertyQName, false);
        NodeContentContext ctx = new NodeContentContext(existingContentReader, null, nodeRef, propertyQName);
        ContentWriter writer = this.store.getWriter((ContentContext)ctx);
        this.eagerContentStoreCleaner.registerNewContentUrl(writer.getContentUrl());
        Serializable contentValue = this.nodeService.getProperty(nodeRef, propertyQName);
        if (contentValue != null && contentValue instanceof ContentData) {
            ContentData contentData = (ContentData)contentValue;
            writer.setMimetype(contentData.getMimetype());
            writer.setEncoding(contentData.getEncoding());
            writer.setLocale(contentData.getLocale());
        }
        if (update) {
            WriteStreamListener listener = new WriteStreamListener(this.nodeService, nodeRef, propertyQName, writer);
            listener.setRetryingTransactionHelper(this.transactionHelper);
            writer.addListener((ContentStreamListener)listener);
        }
        if (writer instanceof MimetypeServiceAware) {
            ((MimetypeServiceAware)writer).setMimetypeService(this.mimetypeService);
        }
        return writer;
    }

    @Override
    public ContentWriter getTempWriter() {
        return this.tempStore.getWriter(ContentContext.NULL_CONTEXT);
    }

    @Override
    public boolean isContentDirectUrlEnabled() {
        return this.systemWideDirectUrlConfig.isEnabled() != false && this.store.isContentDirectUrlEnabled();
    }

    @Override
    public boolean isContentDirectUrlEnabled(NodeRef nodeRef, QName propertyQName) {
        boolean contentDirectUrlEnabled = false;
        if (this.systemWideDirectUrlConfig.isEnabled().booleanValue()) {
            ContentData contentData = this.getContentData(nodeRef, propertyQName);
            if (contentData == null || contentData.getContentUrl() == null) {
                throw new IllegalArgumentException("The supplied nodeRef " + nodeRef + " has no content.");
            }
            contentDirectUrlEnabled = this.store.isContentDirectUrlEnabled(contentData.getContentUrl());
        }
        return contentDirectUrlEnabled;
    }

    @Override
    public DirectAccessUrl requestContentDirectUrl(NodeRef nodeRef, QName propertyQName, boolean attachment, Long validFor, String fileNameOverride) {
        if (!this.systemWideDirectUrlConfig.isEnabled().booleanValue()) {
            throw new DirectAccessUrlDisabledException("Direct access url isn't available.");
        }
        ContentData contentData = this.getContentData(nodeRef, propertyQName);
        if (contentData == null || contentData.getContentUrl() == null) {
            throw new IllegalArgumentException("The supplied nodeRef " + nodeRef + " has no content.");
        }
        String contentUrl = contentData.getContentUrl();
        String contentMimetype = contentData.getMimetype();
        String fileName = StringUtils.isEmpty((CharSequence)fileNameOverride) ? this.getFileName(nodeRef) : fileNameOverride;
        validFor = this.adjustValidFor(validFor);
        attachment = this.adjustAttachment(nodeRef, contentMimetype, attachment);
        DirectAccessUrl directAccessUrl = null;
        if (this.store.isContentDirectUrlEnabled()) {
            try {
                directAccessUrl = this.store.requestContentDirectUrl(contentUrl, attachment, fileName, contentMimetype, validFor);
                if (directAccessUrl != null) {
                    directAccessUrl.setFileName(fileName);
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
        }
        return directAccessUrl;
    }

    @Override
    public Map<String, String> getStorageProperties(NodeRef nodeRef, QName propertyQName) {
        ContentData contentData = this.getContentDataOrThrowError(nodeRef, propertyQName);
        return this.store.getStorageProperties(contentData.getContentUrl());
    }

    @Override
    public boolean requestSendContentToArchive(NodeRef nodeRef, QName propertyQName, Map<String, Serializable> archiveParams) {
        ContentData contentData = this.getContentDataOrThrowError(nodeRef, propertyQName);
        return this.store.requestSendContentToArchive(contentData.getContentUrl(), archiveParams);
    }

    @Override
    public boolean requestRestoreContentFromArchive(NodeRef nodeRef, QName propertyQName, Map<String, Serializable> restoreParams) {
        ContentData contentData = this.getContentDataOrThrowError(nodeRef, propertyQName);
        return this.store.requestRestoreContentFromArchive(contentData.getContentUrl(), restoreParams);
    }

    protected String getFileName(NodeRef nodeRef) {
        String fileName = null;
        try {
            fileName = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_NAME));
        }
        catch (InvalidNodeRefException invalidNodeRefException) {}
        return fileName;
    }

    private Long adjustValidFor(Long validFor) {
        if (validFor == null || validFor > this.systemWideDirectUrlConfig.getDefaultExpiryTimeInSec()) {
            validFor = this.systemWideDirectUrlConfig.getDefaultExpiryTimeInSec();
        }
        return validFor;
    }

    private boolean adjustAttachment(NodeRef nodeRef, String mimeType, boolean attachmentIn) {
        boolean attachment = true;
        if (!attachmentIn) {
            if (this.nonAttachContentTypes != null && this.nonAttachContentTypes.contains(mimeType)) {
                attachment = false;
            } else {
                logger.warn((Object)("Ignored attachment=false for " + nodeRef.getId() + " since " + mimeType + " is not in the whitelist for non-attach content types"));
            }
        }
        return attachment;
    }

    private ContentData getContentDataOrThrowError(NodeRef nodeRef, QName propertyQName) {
        ContentData contentData = this.getContentData(nodeRef, propertyQName);
        if (contentData == null || contentData.getContentUrl() == null) {
            throw new IllegalArgumentException("The supplied nodeRef " + nodeRef + " and property name: " + propertyQName + " has no content.");
        }
        return contentData;
    }

    private static class WriteStreamListener
    extends AbstractContentStreamListener {
        private NodeService nodeService;
        private NodeRef nodeRef;
        private QName propertyQName;
        private ContentWriter writer;

        public WriteStreamListener(NodeService nodeService, NodeRef nodeRef, QName propertyQName, ContentWriter writer) {
            this.nodeService = nodeService;
            this.nodeRef = nodeRef;
            this.propertyQName = propertyQName;
            this.writer = writer;
        }

        @Override
        public void contentStreamClosedImpl() throws ContentIOException {
            try {
                ContentData contentData = this.writer.getContentData();
                this.nodeService.setProperty(this.nodeRef, this.propertyQName, (Serializable)contentData);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Stream listener updated node: \n   node: " + this.nodeRef + "\n" + "   property: " + this.propertyQName + "\n" + "   value: " + contentData));
                }
            }
            catch (ContentQuotaException qe) {
                throw qe;
            }
            catch (Throwable e) {
                throw new ContentIOException("Failed to set content property on stream closure: \n   node: " + this.nodeRef + "\n" + "   property: " + this.propertyQName + "\n" + "   writer: " + this.writer + "\n" + e.toString(), e);
            }
        }
    }
}

