/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.bundle;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.model.RenditionModel;
import org.alfresco.repo.download.DownloadModel;
import org.alfresco.repo.download.DownloadStorage;
import org.alfresco.repo.node.integrity.IntegrityChecker;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.virtual.VirtualContentModel;
import org.alfresco.repo.virtual.VirtualizationIntegrationTest;
import org.alfresco.repo.virtual.config.NodeRefExpression;
import org.alfresco.repo.virtual.ref.GetActualNodeRefMethod;
import org.alfresco.repo.virtual.ref.GetParentReferenceMethod;
import org.alfresco.repo.virtual.ref.ProtocolMethod;
import org.alfresco.repo.virtual.ref.Protocols;
import org.alfresco.repo.virtual.ref.Reference;
import org.alfresco.repo.virtual.ref.VirtualProtocol;
import org.alfresco.repo.virtual.store.VirtualStore;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.CopyService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.util.testing.category.LuceneTests;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.mockito.junit.MockitoJUnitRunner;

@Category(value={LuceneTests.class})
@RunWith(value=MockitoJUnitRunner.class)
public class VirtualNodeServiceExtensionTest
extends VirtualizationIntegrationTest {
    private static final String NODE2TEST1_2_TXT = "NODE2test1_2.txt";
    private static Log logger = LogFactory.getLog(VirtualNodeServiceExtensionTest.class);
    private VirtualStore smartStore;
    private DownloadStorage downloadStorage;
    private QName[] node2ChildrenQNames;
    private QName[] rootChildrenQNames;
    private QName[] node2_1ChildrenQNames;
    private NodeRef node2Test1_2_TXTNodeRef;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.smartStore = (VirtualStore)this.ctx.getBean("smartStore", VirtualStore.class);
        this.downloadStorage = (DownloadStorage)this.ctx.getBean("downloadStorage", DownloadStorage.class);
    }

    @Test
    public void testCreateNode_withFilingRuleAspects() throws Exception {
        NodeRef assocNode2 = this.nodeService.getChildByName(this.virtualFolder1NodeRef, ContentModel.ASSOC_CONTAINS, "Node2");
        NodeRef assocNode2_1 = this.nodeService.getChildByName(assocNode2, ContentModel.ASSOC_CONTAINS, "Node2_1");
        ChildAssociationRef childAssocRef = this.createContent(assocNode2_1, "ContentWithAspects");
        this.assertNewVirtualChildAssocRef(assocNode2_1, childAssocRef);
        this.nodeService.hasAspect(childAssocRef.getChildRef(), ContentModel.ASPECT_AUTHOR);
        this.nodeService.hasAspect(childAssocRef.getChildRef(), ContentModel.ASPECT_DUBLINCORE);
    }

    @Test
    public void testCreateNode_noFilingRule() throws Exception {
        NodeRef testTemplate2 = this.createVirtualizedFolder(this.testRootFolder.getNodeRef(), "aVFTestTemplate2", "C/org/alfresco/repo/virtual/template/testTemplate2.json");
        NodeRef testTemplate2Node2 = this.nodeService.getChildByName(testTemplate2, ContentModel.ASSOC_CONTAINS, "Node2");
        try {
            this.createContent(testTemplate2Node2, "shouldNotBeCreated");
            Assert.fail((String)"Should not be able to create node in a readonly context.");
        }
        catch (AccessDeniedException e) {
            logger.info((Object)"Succesfully denied creation in readonly", (Throwable)e);
        }
    }

    @Test
    public void testCreate_NodeProtocolParent() throws Exception {
        NodeRef assocNode2 = this.nodeService.getChildByName(this.virtualFolder1NodeRef, ContentModel.ASSOC_CONTAINS, "Node2");
        NodeRef assocNode2_1 = this.nodeService.getChildByName(assocNode2, ContentModel.ASSOC_CONTAINS, "Node2_1");
        ChildAssociationRef childAssocRef = this.createContent(assocNode2_1, "Content");
        NodeRef node = childAssocRef.getChildRef();
        Reference reference = Reference.fromNodeRef((NodeRef)node);
        Assert.assertNotNull((Object)reference);
        Assert.assertTrue((boolean)reference.getProtocol().equals(Protocols.NODE.protocol));
        QName nodeTypeQName = ContentModel.TYPE_THUMBNAIL;
        QName assocQName = QName.createQName((String)"cm", (String)"contentThumbnail", (NamespacePrefixResolver)this.environment.getNamespacePrefixResolver());
        QName assocTypeQName = RenditionModel.ASSOC_RENDITION;
        ChildAssociationRef assoc = this.nodeService.createNode(node, assocTypeQName, assocQName, nodeTypeQName);
        NodeRef virtualRenditionNode = assoc.getChildRef();
        NodeRef virtualRenditionParent = assoc.getParentRef();
        Assert.assertEquals((Object)node, (Object)virtualRenditionParent);
        Reference child = Reference.fromNodeRef((NodeRef)virtualRenditionNode);
        Reference parent = Reference.fromNodeRef((NodeRef)virtualRenditionParent);
        NodeRef physicalRenditionNode = (NodeRef)child.execute((ProtocolMethod)new GetActualNodeRefMethod(this.environment));
        NodeRef physicalRenditionParent = (NodeRef)parent.execute((ProtocolMethod)new GetActualNodeRefMethod(this.environment));
        List refs = this.nodeService.getChildAssocs(physicalRenditionParent);
        Assert.assertEquals((Object)physicalRenditionNode, (Object)((ChildAssociationRef)refs.get(0)).getChildRef());
        List virtualRefs = this.nodeService.getChildAssocs(virtualRenditionParent);
        Assert.assertEquals((Object)physicalRenditionNode, (Object)((ChildAssociationRef)virtualRefs.get(0)).getChildRef());
    }

    @Test
    public void testCreateNode_CM_528_folder_filing_type() throws Exception {
        NodeRef testTemplate5 = this.createVirtualizedFolder(this.testRootFolder.getNodeRef(), "aVFTestTemplate5", "C/org/alfresco/repo/virtual/template/testTemplate5.json");
        NodeRef folderFilingTypeNode = this.nodeService.getChildByName(testTemplate5, ContentModel.ASSOC_CONTAINS, "FolderFilingType");
        ChildAssociationRef forcedCmContentAssocRef = this.createContent(folderFilingTypeNode, "forcedCmContent");
        NodeRef forcedCmContent = forcedCmContentAssocRef.getChildRef();
        QName actualType = this.nodeService.getType(forcedCmContent);
        Assert.assertEquals((Object)ContentModel.TYPE_CONTENT, (Object)actualType);
    }

    @Test
    public void testCreateNode() throws Exception {
        Assert.assertTrue((boolean)this.smartStore.canVirtualize(this.virtualFolder1NodeRef));
        Reference semiVirtualFolder = this.smartStore.virtualize(this.virtualFolder1NodeRef);
        Assert.assertNotNull((Object)semiVirtualFolder);
        Assert.assertTrue((boolean)(semiVirtualFolder.getProtocol() instanceof VirtualProtocol));
        Reference firstChild = this.smartStore.getChildByName(semiVirtualFolder, ContentModel.ASSOC_CONTAINS, "Node1");
        Assert.assertNotNull((Object)firstChild);
        Reference secondChild = this.smartStore.getChildByName(semiVirtualFolder, ContentModel.ASSOC_CONTAINS, "Node2");
        Assert.assertNotNull((Object)secondChild);
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        String fileName = "testfile.txt";
        this.uploadNode(firstChild, fileName);
        Assert.assertNotNull((Object)this.nodeService.getChildByName(firstChild.toNodeRef(), ContentModel.ASSOC_CONTAINS, "testfile.txt"));
        this.uploadNode(firstChild, fileName);
        Assert.assertNotNull((Object)this.nodeService.getChildByName(firstChild.toNodeRef(), ContentModel.ASSOC_CONTAINS, "testfile-1.txt"));
        this.uploadNode(secondChild, fileName);
        Assert.assertNotNull((Object)this.nodeService.getChildByName(secondChild.toNodeRef(), ContentModel.ASSOC_CONTAINS, "testfile-2.txt"));
        this.uploadNode(secondChild, fileName);
        Assert.assertNotNull((Object)this.nodeService.getChildByName(secondChild.toNodeRef(), ContentModel.ASSOC_CONTAINS, "testfile-3.txt"));
        fileName = "testfile-2.txt";
        this.uploadNode(firstChild, fileName);
        Assert.assertNotNull((Object)this.nodeService.getChildByName(firstChild.toNodeRef(), ContentModel.ASSOC_CONTAINS, "testfile-4.txt"));
        fileName = "testfile-5.txt";
        this.fileAndFolderService.create(this.virtualFolder1NodeRef, fileName, ContentModel.TYPE_CONTENT);
        Assert.assertNotNull((Object)this.nodeService.getChildByName(this.virtualFolder1NodeRef, ContentModel.ASSOC_CONTAINS, "testfile-5.txt"));
        fileName = "testfile-6.txt";
        this.fileAndFolderService.create(this.virtualFolder1NodeRef, fileName, ContentModel.TYPE_CONTENT);
        Assert.assertNotNull((Object)this.nodeService.getChildByName(this.virtualFolder1NodeRef, ContentModel.ASSOC_CONTAINS, "testfile-6.txt"));
        fileName = "testfile-4.txt";
        this.uploadNode(secondChild, fileName);
        Assert.assertNotNull((Object)this.nodeService.getChildByName(secondChild.toNodeRef(), ContentModel.ASSOC_CONTAINS, "testfile-7.txt"));
        fileName = "testfile1-1.txt";
        this.fileAndFolderService.create(secondChild.toNodeRef(), fileName, ContentModel.TYPE_CONTENT);
        Assert.assertNotNull((Object)this.nodeService.getChildByName(secondChild.toNodeRef(), ContentModel.ASSOC_CONTAINS, "testfile1-1.txt"));
        this.fileAndFolderService.create(secondChild.toNodeRef(), fileName, ContentModel.TYPE_CONTENT);
        Assert.assertNotNull((Object)this.nodeService.getChildByName(secondChild.toNodeRef(), ContentModel.ASSOC_CONTAINS, "testfile1-1-1.txt"));
    }

    @Test
    @Ignore(value="CM-533 Suppress options to create folders in a virtual folder (repo)")
    public void ignore_testCreateFilingIrregularNode() throws Exception {
        NodeRef vf = this.createVirtualizedFolder(this.testRootFolder.getNodeRef(), "testCreateFolderOnContentFilingRule", "C/org/alfresco/repo/virtual/template/testTemplate3.json");
        NodeRef node1 = this.nodeService.getChildByName(vf, ContentModel.ASSOC_CHILDREN, "Node1");
        HashMap<QName, String> properties = new HashMap<QName, String>();
        properties.put(ContentModel.PROP_NAME, "Folder1");
        QName assocQName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)QName.createValidLocalName((String)"Folder1"));
        ChildAssociationRef folderChilAssoc = this.nodeService.createNode(node1, ContentModel.ASSOC_CONTAINS, assocQName, ContentModel.TYPE_FOLDER, properties);
        NodeRef folderChildRef = folderChilAssoc.getChildRef();
        Assert.assertEquals((Object)ContentModel.TYPE_FOLDER, (Object)this.environment.getType(folderChildRef));
        Assert.assertEquals((Object)"Node1_content_FR", this.environment.getProperties(folderChildRef).get(ContentModel.PROP_DESCRIPTION));
        NodeRef node2 = this.nodeService.getChildByName(vf, ContentModel.ASSOC_CHILDREN, "Node2");
        properties = new HashMap();
        properties.put(ContentModel.PROP_NAME, "Content2");
        assocQName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)QName.createValidLocalName((String)"Content2"));
        folderChilAssoc = this.nodeService.createNode(node2, ContentModel.ASSOC_CONTAINS, assocQName, ContentModel.TYPE_CONTENT, properties);
        folderChildRef = folderChilAssoc.getChildRef();
        Assert.assertEquals((Object)ContentModel.TYPE_CONTENT, (Object)this.environment.getType(folderChildRef));
        Assert.assertEquals((Object)"Node2_folder_FR", this.environment.getProperties(folderChildRef).get(ContentModel.PROP_DESCRIPTION));
    }

    private void uploadNode(Reference reference, String name) {
        this.fileAndFolderService.create(reference.toNodeRef(), name, ContentModel.TYPE_CONTENT);
    }

    private void assertNewVirtualChildAssocRef(NodeRef nodeRef, ChildAssociationRef childAssocsRef) {
        Reference reference = Reference.fromNodeRef((NodeRef)nodeRef);
        Assert.assertNotNull((Object)reference);
        this.assertNewVirtualChildAssocRef(reference, childAssocsRef);
    }

    private void assertNewVirtualChildAssocRef(Reference reference, ChildAssociationRef childAssocsRef) {
        Assert.assertNotNull((Object)childAssocsRef);
        NodeRef childNodeRef = childAssocsRef.getChildRef();
        NodeRef parentNodeRef = childAssocsRef.getParentRef();
        Reference parentNodeRefV = Reference.fromNodeRef((NodeRef)parentNodeRef);
        Assert.assertNotNull((Object)parentNodeRefV);
        Assert.assertEquals((Object)reference, (Object)parentNodeRefV);
        Reference childReference = Reference.fromNodeRef((NodeRef)childNodeRef);
        Assert.assertNotNull((Object)childReference);
        Reference parent = (Reference)childReference.execute((ProtocolMethod)new GetParentReferenceMethod());
        Assert.assertEquals((Object)reference, (Object)parent);
    }

    @Test
    public void testGetPath() throws Exception {
        NodeRef node2 = this.nodeService.getChildByName(this.virtualFolder1NodeRef, ContentModel.ASSOC_CHILDREN, "Node2");
        Assert.assertNotNull((Object)node2);
        Path node2Path = this.nodeService.getPath(node2);
        Assert.assertNotNull((Object)node2Path);
        Assert.assertEquals((Object)"/app:company_home/cm:TestFolder/cm:VirtualFolder1/smf:Node2", (Object)node2Path.toPrefixString(this.environment.getNamespacePrefixResolver()));
    }

    @Test
    public void testNodeProtocolReferencePath() throws Exception {
        NodeRef node2 = this.nodeService.getChildByName(this.virtualFolder1NodeRef, ContentModel.ASSOC_CONTAINS, "Node2");
        String fileName = "testfile.txt";
        this.fileAndFolderService.create(node2, fileName, ContentModel.TYPE_CONTENT);
        NodeRef childRef = this.nodeService.getChildByName(node2, ContentModel.ASSOC_CONTAINS, "testfile.txt");
        Path path = this.nodeService.getPath(childRef);
        Assert.assertEquals((Object)"/app:company_home/cm:TestFolder/cm:VirtualFolder1/smf:Node2/cm:testfile.txt", (Object)path.toPrefixString(this.environment.getNamespacePrefixResolver()));
        NodeRef physicalNode = this.nodeService.getChildByName(this.virtualFolder1NodeRef, ContentModel.ASSOC_CONTAINS, "testfile.txt");
        Assert.assertNotNull((Object)physicalNode);
        Path physicalPath = this.nodeService.getPath(physicalNode);
        Assert.assertEquals((Object)"/app:company_home/cm:TestFolder/cm:VirtualFolder1/cm:testfile.txt", (Object)physicalPath.toPrefixString(this.environment.getNamespacePrefixResolver()));
        NodeRef node2_1 = this.nodeService.getChildByName(node2, ContentModel.ASSOC_CONTAINS, "Node2_1");
        Assert.assertNotNull((Object)node2_1);
        this.fileAndFolderService.create(node2_1, fileName, ContentModel.TYPE_CONTENT);
        NodeRef childRef_1 = this.nodeService.getChildByName(node2_1, ContentModel.ASSOC_CONTAINS, "testfile-1.txt");
        Path path_1 = this.nodeService.getPath(childRef_1);
        Assert.assertEquals((Object)"/app:company_home/cm:TestFolder/cm:VirtualFolder1/smf:Node2/smf:Node2_1/cm:testfile-1.txt", (Object)path_1.toPrefixString(this.environment.getNamespacePrefixResolver()));
    }

    private void setUpTestAssociations(NodeRef actualNodeRef) {
        this.rootChildrenQNames = new QName[13];
        this.rootChildrenQNames[0] = QName.createQNameWithValidLocalName((String)"http://www.alfresco.org/model/content/smartfolder/1.0", (String)"Node2");
        this.rootChildrenQNames[1] = QName.createQNameWithValidLocalName((String)"http://www.alfresco.org/model/content/smartfolder/1.0", (String)"Node1");
        NodeRef node2 = this.nodeService.getChildByName(this.virtualFolder1NodeRef, ContentModel.ASSOC_CONTAINS, "Node2");
        String node2ChildNameString = "test1_2.txt";
        ChildAssociationRef node2ChildAssoc = this.createContent(node2, node2ChildNameString);
        this.node2Test1_2_TXTNodeRef = node2ChildAssoc.getChildRef();
        this.rootChildrenQNames[2] = QName.createQNameWithValidLocalName((String)"http://www.alfresco.org/model/content/1.0", (String)node2ChildNameString);
        this.nodeService.setProperty(node2ChildAssoc.getChildRef(), ContentModel.PROP_TITLE, (Serializable)((Object)NODE2TEST1_2_TXT));
        this.node2ChildrenQNames = new QName[2];
        this.node2ChildrenQNames[0] = QName.createQNameWithValidLocalName((String)"http://www.alfresco.org/model/content/smartfolder/1.0", (String)"Node2_1");
        this.node2ChildrenQNames[1] = node2ChildAssoc.getQName();
        NodeRef node2_1 = this.nodeService.getChildByName(node2, ContentModel.ASSOC_CONTAINS, "Node2_1");
        this.node2_1ChildrenQNames = new QName[10];
        int i = 1;
        while (i <= 10) {
            ChildAssociationRef childAssoc = this.createContent(node2_1, "test" + i + "_2_1.txt");
            this.rootChildrenQNames[2 + i] = QName.createQNameWithValidLocalName((String)"http://www.alfresco.org/model/content/1.0", (String)childAssoc.getQName().getLocalName());
            this.node2_1ChildrenQNames[i - 1] = childAssoc.getQName();
            ++i;
        }
    }

    protected QName[] copyOf(QName[] from, int count) {
        QName[] tmp = new QName[count];
        if (count < from.length) {
            System.arraycopy(from, 0, tmp, 0, count);
        } else {
            System.arraycopy(from, 0, tmp, 0, from.length);
        }
        return tmp;
    }

    private ChildAssociationRef findActualAssocPeer(ChildAssociationRef virtualAssoc, NodeRef actualParentNodeRef) {
        List actualAssocs = this.nodeService.getChildAssocs(actualParentNodeRef);
        NodeRef virtualChildNodeRef = virtualAssoc.getChildRef();
        Reference vChildNodeRef = Reference.fromNodeRef((NodeRef)virtualChildNodeRef);
        Assert.assertNotNull((Object)vChildNodeRef);
        NodeRef materialNodeRef = this.smartStore.materialize(vChildNodeRef);
        for (ChildAssociationRef actualAssocRef : actualAssocs) {
            if (!materialNodeRef.equals((Object)actualAssocRef.getChildRef()) || !virtualAssoc.getQName().getLocalName().equals(actualAssocRef.getQName().getLocalName()) || !virtualAssoc.getTypeQName().equals((Object)actualAssocRef.getTypeQName())) continue;
            return actualAssocRef;
        }
        return null;
    }

    @Test
    public void testRemoveChildAssoc_1() throws Exception {
        NodeRef node2 = this.nodeService.getChildByName(this.virtualFolder1NodeRef, ContentModel.ASSOC_CONTAINS, "Node2");
        ChildAssociationRef node2ChildAssoc = this.createContent(node2, "TestPresentation4_pdf_removeAssoc");
        Assert.assertNotNull((Object)this.findActualAssocPeer(node2ChildAssoc, this.virtualFolder1NodeRef));
        boolean removed = this.nodeService.removeChildAssociation(node2ChildAssoc);
        Assert.assertTrue((String)"No association", (boolean)removed);
        Assert.assertNull((Object)this.findActualAssocPeer(node2ChildAssoc, this.virtualFolder1NodeRef));
    }

    @Test
    public void testGetChildAssocs_1() throws Exception {
        List childAssocs = this.nodeService.getChildAssocs(this.virtualFolder1NodeRef);
        Assert.assertEquals((long)2L, (long)childAssocs.size());
        this.setUpTestAssociations(this.virtualFolder1NodeRef);
        NodeRef node2 = this.nodeService.getChildByName(this.virtualFolder1NodeRef, ContentModel.ASSOC_CONTAINS, "Node2");
        NodeRef node2_1 = this.nodeService.getChildByName(node2, ContentModel.ASSOC_CONTAINS, "Node2_1");
        childAssocs = this.nodeService.getChildAssocs(this.virtualFolder1NodeRef);
        Assert.assertEquals((long)13L, (long)childAssocs.size());
        this.assertAssocNames(childAssocs, this.rootChildrenQNames);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Getting children of node2 " + node2));
        }
        childAssocs = this.nodeService.getChildAssocs(node2);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Got children of node2 " + childAssocs));
        }
        Assert.assertEquals((long)2L, (long)childAssocs.size());
        childAssocs = this.nodeService.getChildAssocs(node2_1);
        Assert.assertEquals((long)10L, (long)childAssocs.size());
        this.assertAssocNames(childAssocs, this.node2_1ChildrenQNames);
    }

    protected void assertAssocNames(List<ChildAssociationRef> assocs, QName ... expectedNames) {
        LinkedList<QName> actualNames = new LinkedList<QName>();
        for (ChildAssociationRef childAssociationRef : assocs) {
            actualNames.add(childAssociationRef.getQName());
        }
        Assert.assertEquals((long)expectedNames.length, (long)actualNames.size());
        int i = 0;
        while (i < expectedNames.length) {
            Assert.assertTrue((String)(expectedNames[i] + " assoc name was expected  within " + actualNames), (boolean)actualNames.contains(expectedNames[i]));
            actualNames.remove(expectedNames[i]);
            ++i;
        }
    }

    @Test
    public void testGetChildAssocs_2() throws Exception {
        List childAssocs = this.nodeService.getChildAssocs(this.virtualFolder1NodeRef);
        Assert.assertEquals((long)2L, (long)childAssocs.size());
        this.setUpTestAssociations(this.virtualFolder1NodeRef);
        NodeRef node2 = this.nodeService.getChildByName(this.virtualFolder1NodeRef, ContentModel.ASSOC_CONTAINS, "Node2");
        NodeRef node2_1 = this.nodeService.getChildByName(node2, ContentModel.ASSOC_CONTAINS, "Node2_1");
        childAssocs = this.nodeService.getChildAssocs(node2, (QNamePattern)ContentModel.ASSOC_ARCHIVED_LINK, (QNamePattern)ContentModel.ASSOC_ARCHIVED_LINK, 7, true);
        Assert.assertTrue((boolean)childAssocs.isEmpty());
        childAssocs = this.nodeService.getChildAssocs(node2, RegexQNamePattern.MATCH_ALL, RegexQNamePattern.MATCH_ALL, 7, true);
        Assert.assertEquals((long)2L, (long)childAssocs.size());
        this.assertAssocNames(childAssocs, this.copyOf(this.node2ChildrenQNames, 2));
        childAssocs = this.nodeService.getChildAssocs(this.virtualFolder1NodeRef, RegexQNamePattern.MATCH_ALL, new QNamePattern(){

            public boolean isMatch(QName qname) {
                return qname.getLocalName().startsWith("test") && qname.getLocalName().endsWith("txt");
            }
        }, 15, true);
        Assert.assertEquals((long)11L, (long)childAssocs.size());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Getting children of node2 " + node2));
        }
        childAssocs = this.nodeService.getChildAssocs(node2, RegexQNamePattern.MATCH_ALL, RegexQNamePattern.MATCH_ALL, 2, true);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Got children of node2 " + childAssocs));
        }
        Assert.assertEquals((long)2L, (long)childAssocs.size());
        childAssocs = this.nodeService.getChildAssocs(node2_1, RegexQNamePattern.MATCH_ALL, RegexQNamePattern.MATCH_ALL, 10, true);
        Assert.assertEquals((long)10L, (long)childAssocs.size());
        this.assertAssocNames(childAssocs, this.copyOf(this.node2_1ChildrenQNames, 10));
    }

    @Test
    public void testGetChildAssocs_3() throws Exception {
        List childAssocs = this.nodeService.getChildAssocs(this.virtualFolder1NodeRef);
        Assert.assertEquals((long)2L, (long)childAssocs.size());
        this.setUpTestAssociations(this.virtualFolder1NodeRef);
        List folderAssocs = this.nodeService.getChildAssocs(this.virtualFolder1NodeRef, new HashSet<QName>(Arrays.asList(ContentModel.TYPE_FOLDER)));
        Assert.assertEquals((long)2L, (long)folderAssocs.size());
        List contentAssocs = this.nodeService.getChildAssocs(this.virtualFolder1NodeRef, new HashSet<QName>(Arrays.asList(ContentModel.TYPE_CONTENT)));
        Assert.assertEquals((long)11L, (long)contentAssocs.size());
    }

    @Test
    public void testGetChildAssocsByPropertyValue() throws Exception {
        this.setUpTestAssociations(this.virtualFolder1NodeRef);
        NodeRef node2 = this.nodeService.getChildByName(this.virtualFolder1NodeRef, ContentModel.ASSOC_CONTAINS, "Node2");
        List children = this.nodeService.getChildAssocsByPropertyValue(node2, ContentModel.PROP_TITLE, (Serializable)((Object)NODE2TEST1_2_TXT));
        Assert.assertNotNull((Object)children);
        Assert.assertEquals((long)1L, (long)children.size());
        Assert.assertEquals((Object)this.node2Test1_2_TXTNodeRef, (Object)((ChildAssociationRef)children.get(0)).getChildRef());
        children = this.nodeService.getChildAssocsByPropertyValue(node2, ContentModel.PROP_TITLE, (Serializable)((Object)"nonNODE2test1_2.txt"));
        Assert.assertTrue((boolean)children.isEmpty());
    }

    @Test
    public void testGetProperties() throws Exception {
        NodeRef template2VF = this.createVirtualizedFolder(this.testRootFolder.getNodeRef(), "VirtualFolder2", "C/org/alfresco/repo/virtual/template/testTemplate2.json");
        this.nodeService.setProperty(template2VF, ContentModel.PROP_DESCRIPTION, (Serializable)((Object)"ParentDescription"));
        NodeRef node1 = this.nodeService.getChildByName(template2VF, ContentModel.ASSOC_CONTAINS, "Node1");
        this.assertVirtualNode(node1);
        NodeRef node2 = this.nodeService.getChildByName(template2VF, ContentModel.ASSOC_CONTAINS, "Node2");
        HashMap<QName, Serializable> expectedProperties = new HashMap<QName, Serializable>();
        expectedProperties.put(ContentModel.PROP_DESCRIPTION, (Serializable)((Object)"ParentDescription"));
        this.assertVirtualNode(node2, expectedProperties);
    }

    @Test
    public void testCreateAssociation() throws Exception {
        NodeRef createDownloadNode = this.createDownloadNode();
        NodeRef node2 = this.nodeService.getChildByName(this.virtualFolder1NodeRef, ContentModel.ASSOC_CONTAINS, "Node2");
        this.nodeService.createAssociation(createDownloadNode, node2, DownloadModel.ASSOC_REQUESTED_NODES);
    }

    @Test
    public void testGetParentAssocs() throws Exception {
        NodeRef node2 = this.nodeService.getChildByName(this.virtualFolder1NodeRef, ContentModel.ASSOC_CONTAINS, "Node2");
        List node2Parents = this.nodeService.getParentAssocs(node2);
        Assert.assertNotNull((Object)node2Parents);
        Assert.assertTrue((!node2Parents.isEmpty() ? 1 : 0) != 0);
        ChildAssociationRef firstAssoc = (ChildAssociationRef)node2Parents.get(0);
        NodeRef child = firstAssoc.getChildRef();
        NodeRef parent = firstAssoc.getParentRef();
        Assert.assertEquals((Object)ContentModel.ASSOC_CONTAINS, (Object)firstAssoc.getTypeQName());
        Assert.assertEquals((Object)node2, (Object)child);
        Assert.assertEquals((Object)this.virtualFolder1NodeRef, (Object)parent);
        Assert.assertNotNull((Object)firstAssoc.getQName());
        Assert.assertEquals((Object)QName.createQNameWithValidLocalName((String)"http://www.alfresco.org/model/content/smartfolder/1.0", (String)"Node2"), (Object)firstAssoc.getQName());
        node2Parents = this.nodeService.getParentAssocs(node2, RegexQNamePattern.MATCH_ALL, (QNamePattern)new RegexQNamePattern("http://www.alfresco.org/model/content/smartfolder/1.0", "Node."));
        Assert.assertNotNull((Object)node2Parents);
        Assert.assertTrue((!node2Parents.isEmpty() ? 1 : 0) != 0);
        firstAssoc = (ChildAssociationRef)node2Parents.get(0);
        child = firstAssoc.getChildRef();
        parent = firstAssoc.getParentRef();
        Assert.assertEquals((Object)ContentModel.ASSOC_CONTAINS, (Object)firstAssoc.getTypeQName());
        Assert.assertEquals((Object)node2, (Object)child);
        Assert.assertEquals((Object)this.virtualFolder1NodeRef, (Object)parent);
        Assert.assertNotNull((Object)firstAssoc.getQName());
        Assert.assertEquals((Object)QName.createQName((String)"http://www.alfresco.org/model/content/smartfolder/1.0", (String)"Node2"), (Object)firstAssoc.getQName());
        node2Parents = this.nodeService.getParentAssocs(node2, RegexQNamePattern.MATCH_ALL, (QNamePattern)new RegexQNamePattern("http://www.alfresco.org/model/content/smartfolder/1.0", "Foo."));
        Assert.assertNotNull((Object)node2Parents);
        Assert.assertTrue((boolean)node2Parents.isEmpty());
    }

    @Test
    public void testGetSourceAssocs_download() throws Exception {
        NodeRef node2 = this.nodeService.getChildByName(this.virtualFolder1NodeRef, ContentModel.ASSOC_CONTAINS, "Node2");
        List sourceAssocs = null;
        sourceAssocs = this.nodeService.getSourceAssocs(node2, RegexQNamePattern.MATCH_ALL);
        Assert.assertEquals((long)0L, (long)sourceAssocs.size());
        sourceAssocs = this.nodeService.getSourceAssocs(node2, (QNamePattern)DownloadModel.ASSOC_REQUESTED_NODES);
        Assert.assertEquals((long)0L, (long)sourceAssocs.size());
        NodeRef createDownloadNode = this.createDownloadNode();
        this.nodeService.createAssociation(createDownloadNode, node2, DownloadModel.ASSOC_REQUESTED_NODES);
        sourceAssocs = this.nodeService.getSourceAssocs(node2, (QNamePattern)DownloadModel.ASSOC_REQUESTED_NODES);
        Assert.assertEquals((long)0L, (long)sourceAssocs.size());
    }

    @Test
    public void testGetTargetAssocs_download() throws Exception {
        NodeRef node2 = this.nodeService.getChildByName(this.virtualFolder1NodeRef, ContentModel.ASSOC_CONTAINS, "Node2");
        List targetAssocs = this.nodeService.getTargetAssocs(node2, (QNamePattern)DownloadModel.ASSOC_REQUESTED_NODES);
        Assert.assertEquals((long)0L, (long)targetAssocs.size());
        NodeRef createDownloadNode = this.createDownloadNode();
        this.nodeService.createAssociation(createDownloadNode, node2, DownloadModel.ASSOC_REQUESTED_NODES);
        targetAssocs = this.nodeService.getTargetAssocs(createDownloadNode, (QNamePattern)ContentModel.ASSOC_CONTAINS);
        Assert.assertEquals((long)0L, (long)targetAssocs.size());
        targetAssocs = this.nodeService.getTargetAssocs(createDownloadNode, (QNamePattern)DownloadModel.ASSOC_REQUESTED_NODES);
        Assert.assertEquals((long)1L, (long)targetAssocs.size());
        NodeRef node2_1 = this.nodeService.getChildByName(node2, ContentModel.ASSOC_CONTAINS, "Node2_1");
        this.nodeService.createAssociation(createDownloadNode, node2, DownloadModel.ASSOC_REQUESTED_NODES);
        this.nodeService.createAssociation(createDownloadNode, node2_1, DownloadModel.ASSOC_REQUESTED_NODES);
        targetAssocs = this.nodeService.getTargetAssocs(createDownloadNode, (QNamePattern)ContentModel.ASSOC_CONTAINS);
        Assert.assertEquals((long)0L, (long)targetAssocs.size());
        int i = 0;
        while (i < 2) {
            targetAssocs = this.nodeService.getTargetAssocs(createDownloadNode, (QNamePattern)DownloadModel.ASSOC_REQUESTED_NODES);
            Assert.assertEquals((String)("Try # " + (i + 1)), (long)2L, (long)targetAssocs.size());
            ++i;
        }
        LinkedList<NodeRef> targets = new LinkedList<NodeRef>();
        for (AssociationRef assocs : targetAssocs) {
            targets.add(assocs.getTargetRef());
        }
        Assert.assertTrue((boolean)targets.contains(node2));
        Assert.assertTrue((boolean)targets.contains(node2_1));
        NodeRefExpression downloadAsocsFolderExpr = this.virtualizationConfigTestBootstrap.getDownloadAssocaiationsFolder();
        NodeRef downloadAssocsFolder = downloadAsocsFolderExpr.resolve();
        NodeRef tempDownloadSourceAssocs = this.nodeService.getChildByName(downloadAssocsFolder, ContentModel.ASSOC_CONTAINS, createDownloadNode.getId());
        Assert.assertNotNull((Object)tempDownloadSourceAssocs);
        this.downloadStorage.delete(createDownloadNode);
        Assert.assertFalse((String)"Association information was not removed when removing the source.", (boolean)this.nodeService.exists(tempDownloadSourceAssocs));
    }

    @Test
    public void testGetChildByName() {
        NodeRef virtualFolder = this.createVirtualizedFolder(this.testRootFolder.getNodeRef(), "VirtualFolder2", "C/org/alfresco/repo/virtual/template/testTemplate4.json");
        Assert.assertTrue((boolean)this.smartStore.canVirtualize(virtualFolder));
        Reference semiVirtualFolder = this.smartStore.virtualize(virtualFolder);
        Assert.assertNotNull((Object)semiVirtualFolder);
        NodeRef virtualChild = this.nodeService.getChildByName(semiVirtualFolder.toNodeRef(), ContentModel.ASSOC_CONTAINS, "All My Content");
        Assert.assertNotNull((Object)virtualChild);
        this.assertVirtualNode(virtualChild);
        NodeRef phys1 = this.nodeService.getChildByName(virtualChild, ContentModel.ASSOC_CONTAINS, "Company Home");
        Assert.assertNotNull((Object)phys1);
        this.assertVirtualNode(virtualChild);
        NodeRef phys2 = this.nodeService.getChildByName(phys1, ContentModel.ASSOC_CONTAINS, "Data Dictionary");
        Assert.assertNotNull((Object)phys2);
        this.assertVirtualNode(virtualChild);
    }

    @Test
    public void testGetPrimaryParent() throws Exception {
        NodeRef node2 = this.nodeService.getChildByName(this.virtualFolder1NodeRef, ContentModel.ASSOC_CONTAINS, "Node2");
        Assert.assertNotNull((Object)node2);
        ChildAssociationRef primaryParent = this.nodeService.getPrimaryParent(node2);
        Assert.assertNotNull((Object)primaryParent);
        NodeRef parentRef = primaryParent.getParentRef();
        Assert.assertEquals((Object)this.virtualFolder1NodeRef, (Object)parentRef);
        Assert.assertEquals((Object)QName.createQNameWithValidLocalName((String)"http://www.alfresco.org/model/content/smartfolder/1.0", (String)"Node2"), (Object)primaryParent.getQName());
        NodeRef node2_1 = this.nodeService.getChildByName(node2, ContentModel.ASSOC_CONTAINS, "Node2_1");
        Assert.assertNotNull((Object)node2_1);
        primaryParent = this.nodeService.getPrimaryParent(node2_1);
        Assert.assertNotNull((Object)primaryParent);
        parentRef = primaryParent.getParentRef();
        Assert.assertEquals((Object)node2, (Object)parentRef);
    }

    @Test
    public void testGetAssocs_CM_673() throws Exception {
        NodeRef createFolder = this.createFolder(this.testRootFolder.getNodeRef(), "FOLDER").getChildRef();
        this.createContent(createFolder, "testFile1", "0", "text/plain", "UTF-8");
        NodeRef virtualFolder = this.createVirtualizedFolder(this.testRootFolder.getNodeRef(), "VirtualFolder2", "C/org/alfresco/repo/virtual/template/testTemplate6.json");
        NodeRef node1 = this.nodeService.getChildByName(virtualFolder, ContentModel.ASSOC_CONTAINS, "Node1");
        Assert.assertNotNull((Object)node1);
        this.prepareMocks("cm:TestFolder//cm:FOLDER", createFolder);
        try {
            NodeRef physicalFolderInVirtualContext = this.nodeService.getChildByName(node1, ContentModel.ASSOC_CONTAINS, "FOLDER");
            Assert.assertNotNull((Object)physicalFolderInVirtualContext);
            List childAssocs = this.nodeService.getChildAssocs(physicalFolderInVirtualContext);
            Assert.assertNotNull((Object)childAssocs);
            Assert.assertEquals((long)1L, (long)childAssocs.size());
            Assert.assertEquals((Object)"testFile1", (Object)this.nodeService.getProperty(((ChildAssociationRef)childAssocs.get(0)).getChildRef(), ContentModel.PROP_NAME));
        }
        finally {
            this.resetMocks();
        }
    }

    @Test
    public void testCopySemivirtualFolder() throws Exception {
        this.configuredTemplatesClassPath = this.constraints.getTemplatesParentClasspath();
        this.constraints.setTemplatesParentClasspath("/org/alfresco/repo/virtual/template");
        IntegrityChecker integrityChecker = (IntegrityChecker)this.ctx.getBean("integrityChecker");
        NodeRef childRef = this.createFolder(this.testRootFolder.getNodeRef(), "TT").getChildRef();
        CopyService copyService = (CopyService)this.ctx.getBean("copyService", CopyService.class);
        copyService.copyAndRename(this.virtualFolder1NodeRef, childRef, ContentModel.ASSOC_CONTAINS, null, true);
        NodeRef copiedNodeRef = this.nodeService.getChildByName(childRef, ContentModel.ASSOC_CONTAINS, "VirtualFolder1");
        Assert.assertNotNull((Object)copiedNodeRef);
        NodeRef node2 = this.nodeService.getChildByName(copiedNodeRef, ContentModel.ASSOC_CONTAINS, "Node2");
        Assert.assertNotNull((Object)node2);
        NodeRef node2_1 = this.nodeService.getChildByName(node2, ContentModel.ASSOC_CONTAINS, "Node2_1");
        Assert.assertNotNull((Object)node2_1);
        integrityChecker.checkIntegrity();
    }

    @Test
    public void testCreateFileAndFolderInFolderInVirtualContext() throws Exception {
        NodeRef physicalFolder = this.createFolder(this.testRootFolder.getNodeRef(), "FOLDER").getChildRef();
        NodeRef virtualFolder = this.createVirtualizedFolder(this.testRootFolder.getNodeRef(), "VirtualFolder2", "C/org/alfresco/repo/virtual/template/testTemplate6.json");
        NodeRef node1 = this.nodeService.getChildByName(virtualFolder, ContentModel.ASSOC_CONTAINS, "Node1");
        Assert.assertNotNull((Object)node1);
        this.prepareMocks("FOLDER", physicalFolder);
        try {
            NodeRef physicalFolderInVirtualContext = this.nodeService.getChildByName(node1, ContentModel.ASSOC_CONTAINS, "FOLDER");
            Assert.assertNotNull((Object)physicalFolderInVirtualContext);
            this.createContent(physicalFolderInVirtualContext, "testFile1", "0", "text/plain", "UTF-8");
            NodeRef childFileNodeRef = this.nodeService.getChildByName(physicalFolderInVirtualContext, ContentModel.ASSOC_CONTAINS, "testFile1");
            Assert.assertNotNull((Object)childFileNodeRef);
            childFileNodeRef = this.nodeService.getChildByName(physicalFolder, ContentModel.ASSOC_CONTAINS, "testFile1");
            Assert.assertNotNull((Object)childFileNodeRef);
            this.createFolder(physicalFolderInVirtualContext, "testFolder1");
            NodeRef childFolderNodeRef = this.nodeService.getChildByName(physicalFolderInVirtualContext, ContentModel.ASSOC_CONTAINS, "testFolder1");
            Assert.assertNotNull((Object)childFolderNodeRef);
            childFolderNodeRef = this.nodeService.getChildByName(physicalFolder, ContentModel.ASSOC_CONTAINS, "testFolder1");
            Assert.assertNotNull((Object)childFolderNodeRef);
        }
        finally {
            this.resetMocks();
        }
    }

    @Test
    public void testChildByName_ACE_4700() throws Exception {
        NodeRef node1 = this.nodeService.getChildByName(this.virtualFolder1NodeRef, ContentModel.ASSOC_CONTAINS, "Node1");
        Assert.assertNotNull((Object)node1);
        String filename = "2015-11_11_1557_folder_empty_space.txt";
        this.fileAndFolderService.create(node1, filename, ContentModel.TYPE_CONTENT);
        this.fileAndFolderService.create(node1, filename, ContentModel.TYPE_CONTENT);
        Assert.assertNotNull((Object)this.nodeService.getChildByName(node1, ContentModel.ASSOC_CONTAINS, "2015-11_11_1557_folder_empty_space.txt"));
        Assert.assertNotNull((Object)this.nodeService.getChildByName(node1, ContentModel.ASSOC_CONTAINS, "2015-11_11_1557_folder_empty_space-1.txt"));
        Assert.assertNull((Object)this.nodeService.getChildByName(node1, ContentModel.ASSOC_CONTAINS, "2015-11_11_1557_folder_empty_space-2.txt"));
        String suportedCharsFileName = "file~!@#$%^&-=+][';.,.txt";
        String suportedCharsFileName1 = "file~!@#$%^&-=+][';.,-1.txt";
        String suportedCharsFileName2 = "file~!@#$%^&-=+][';.,-2.txt";
        this.fileAndFolderService.create(node1, suportedCharsFileName, ContentModel.TYPE_CONTENT);
        this.fileAndFolderService.create(node1, suportedCharsFileName, ContentModel.TYPE_CONTENT);
        Assert.assertNotNull((Object)this.nodeService.getChildByName(node1, ContentModel.ASSOC_CONTAINS, suportedCharsFileName));
        Assert.assertNotNull((Object)this.nodeService.getChildByName(node1, ContentModel.ASSOC_CONTAINS, suportedCharsFileName1));
        Assert.assertNull((Object)this.nodeService.getChildByName(node1, ContentModel.ASSOC_CONTAINS, suportedCharsFileName2));
    }

    @Test
    public void testHasAspect() throws Exception {
        NodeRef node1 = this.nodeService.getChildByName(this.virtualFolder1NodeRef, ContentModel.ASSOC_CONTAINS, "Node1");
        Assert.assertNotNull((Object)node1);
        Assert.assertTrue((boolean)this.nodeService.hasAspect(node1, VirtualContentModel.ASPECT_VIRTUAL));
        Assert.assertFalse((boolean)this.nodeService.hasAspect(node1, VirtualContentModel.ASPECT_VIRTUAL_DOCUMENT));
        String filename = "testName.txt";
        NodeRef fileNodeRef = this.fileAndFolderService.create(node1, filename, ContentModel.TYPE_CONTENT).getNodeRef();
        Assert.assertFalse((boolean)this.nodeService.hasAspect(fileNodeRef, VirtualContentModel.ASPECT_VIRTUAL));
        Assert.assertTrue((boolean)this.nodeService.hasAspect(fileNodeRef, VirtualContentModel.ASPECT_VIRTUAL_DOCUMENT));
        NodeRef realFolderNode = this.createFolder(this.testRootFolder.getNodeRef(), "FOLDER").getChildRef();
        NodeRef virtualFolder = this.createVirtualizedFolder(this.testRootFolder.getNodeRef(), "VirtualFolder2", "C/org/alfresco/repo/virtual/template/testTemplate6.json");
        NodeRef node1_1 = this.nodeService.getChildByName(virtualFolder, ContentModel.ASSOC_CONTAINS, "Node1");
        Assert.assertNotNull((Object)node1_1);
        this.prepareMocks("cm:TestFolder//cm:FOLDER", realFolderNode);
        try {
            NodeRef physicalFolderInVirtualContext = this.nodeService.getChildByName(node1_1, ContentModel.ASSOC_CONTAINS, "FOLDER");
            Assert.assertNotNull((Object)physicalFolderInVirtualContext);
            Assert.assertFalse((boolean)this.nodeService.hasAspect(physicalFolderInVirtualContext, VirtualContentModel.ASPECT_VIRTUAL));
            Assert.assertTrue((boolean)this.nodeService.hasAspect(physicalFolderInVirtualContext, VirtualContentModel.ASPECT_VIRTUAL_DOCUMENT));
            this.createContent(physicalFolderInVirtualContext, "testFile1", "0", "text/plain", "UTF-8");
            NodeRef childFileNodeRef = this.nodeService.getChildByName(physicalFolderInVirtualContext, ContentModel.ASSOC_CONTAINS, "testFile1");
            Assert.assertNotNull((Object)childFileNodeRef);
            Assert.assertFalse((boolean)this.nodeService.hasAspect(childFileNodeRef, VirtualContentModel.ASPECT_VIRTUAL));
            Assert.assertFalse((boolean)this.nodeService.hasAspect(childFileNodeRef, VirtualContentModel.ASPECT_VIRTUAL_DOCUMENT));
        }
        finally {
            this.resetMocks();
        }
    }

    private NodeRef createDownloadNode() {
        NodeRef createDownloadNode = this.downloadStorage.createDownloadNode(true);
        return createDownloadNode;
    }
}

