/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.security.authentication.CompositePasswordEncoder;
import org.alfresco.repo.security.authentication.MD4PasswordEncoderImpl;
import org.alfresco.repo.security.authentication.ShaPasswordEncoderImpl;
import org.alfresco.util.GUID;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;

public class CompositePasswordEncoderTest {
    CompositePasswordEncoder encoder;
    public static Map<String, Object> encodersConfig = new HashMap<String, Object>();
    private static final String SOURCE_PASSWORD = "SOURCE PASS Word $%%^ #';/,_+{+} like \u20acthis\u4eca\u65e5\u306f\u4e16\u754c";

    static {
        encodersConfig.put("md4", new MD4PasswordEncoderImpl());
        encodersConfig.put("sha256", new ShaPasswordEncoderImpl(256));
        encodersConfig.put("bcrypt10", new BCryptPasswordEncoder(10));
        encodersConfig.put("bcrypt11", new BCryptPasswordEncoder(11));
        encodersConfig.put("bcrypt12", new BCryptPasswordEncoder(12));
        encodersConfig.put("badencoder", new Object());
    }

    @Before
    public void setUp() throws Exception {
        this.encoder = new CompositePasswordEncoder();
        this.encoder.setEncoders(encodersConfig);
    }

    @Test
    public void testInvalidParamsEncode() throws Exception {
        try {
            this.encoder.encode(null, null, null);
            Assert.fail((String)"Should throw exception");
        }
        catch (IllegalArgumentException are) {
            Assert.assertTrue((boolean)are.getMessage().contains("rawPassword is a mandatory"));
        }
        try {
            this.encoder.encode(null, "fred", null);
            Assert.fail((String)"Should throw exception");
        }
        catch (IllegalArgumentException are) {
            Assert.assertTrue((boolean)are.getMessage().contains("encoderKey is a mandatory parameter"));
        }
        try {
            this.encoder.encode("nonsense", "fred", null);
            Assert.fail((String)"Should throw exception");
        }
        catch (AlfrescoRuntimeException are) {
            Assert.assertTrue((boolean)are.getMessage().contains("Invalid encoder specified"));
            Assert.assertTrue((boolean)are.getMessage().endsWith("nonsense"));
        }
        try {
            this.encoder.encode("badencoder", "fred", null);
            Assert.fail((String)"Should throw exception");
        }
        catch (AlfrescoRuntimeException are) {
            Assert.assertTrue((boolean)are.getMessage().contains("Unsupported encoder specified"));
            Assert.assertTrue((boolean)are.getMessage().endsWith("badencoder"));
        }
    }

    @Test
    public void testInvalidParamsMatches() throws Exception {
        try {
            this.encoder.matches(null, null, null, null);
            Assert.fail((String)"Should throw exception");
        }
        catch (IllegalArgumentException are) {
            Assert.assertTrue((boolean)are.getMessage().contains("rawPassword is a mandatory"));
        }
        try {
            this.encoder.matches(null, "fred", null, null);
            Assert.fail((String)"Should throw exception");
        }
        catch (IllegalArgumentException are) {
            Assert.assertTrue((boolean)are.getMessage().contains("encodedPassword is a mandatory parameter"));
        }
        try {
            this.encoder.matches(null, "fred", "xyz", null);
            Assert.fail((String)"Should throw exception");
        }
        catch (IllegalArgumentException are) {
            Assert.assertTrue((boolean)are.getMessage().contains("encoderKey is a mandatory parameter"));
        }
        try {
            this.encoder.matches("nonsense", "fred", "xyz", null);
            Assert.fail((String)"Should throw exception");
        }
        catch (AlfrescoRuntimeException are) {
            Assert.assertTrue((boolean)are.getMessage().contains("Invalid matches encoder specified"));
            Assert.assertTrue((boolean)are.getMessage().endsWith("nonsense"));
        }
        try {
            this.encoder.matches("badencoder", "fred", "xyz", null);
            Assert.fail((String)"Should throw exception");
        }
        catch (AlfrescoRuntimeException are) {
            Assert.assertTrue((boolean)are.getMessage().contains("Unsupported encoder for matching"));
            Assert.assertTrue((boolean)are.getMessage().endsWith("badencoder"));
        }
    }

    @Test
    public void testEncodeMD4() throws Exception {
        String salt = GUID.generate();
        MD4PasswordEncoderImpl md4 = new MD4PasswordEncoderImpl();
        String sourceEncoded = md4.encodePassword(SOURCE_PASSWORD, (Object)salt);
        String sourceEncodedSaltFree = md4.encodePassword(SOURCE_PASSWORD, null);
        String encoded = this.encoder.encode("md4", SOURCE_PASSWORD, (Object)salt);
        Assert.assertTrue((boolean)this.encoder.matches("md4", SOURCE_PASSWORD, encoded, (Object)salt));
        Assert.assertTrue((boolean)this.encoder.matchesPassword(SOURCE_PASSWORD, encoded, (Object)salt, Arrays.asList("md4")));
        Assert.assertNotEquals((String)"The salt must be ignored for MD4", (Object)sourceEncoded, (Object)encoded);
        Assert.assertNotEquals((String)"The salt must be ignored for MD4", (Object)sourceEncoded, (Object)this.encoder.encodePassword(SOURCE_PASSWORD, (Object)salt, Arrays.asList("md4")));
        encoded = this.encoder.encode("md4", SOURCE_PASSWORD, null);
        Assert.assertEquals((Object)sourceEncodedSaltFree, (Object)encoded);
        Assert.assertTrue((boolean)this.encoder.matches("md4", SOURCE_PASSWORD, sourceEncodedSaltFree, null));
        Assert.assertTrue((boolean)this.encoder.matchesPassword(SOURCE_PASSWORD, sourceEncodedSaltFree, null, Arrays.asList("md4")));
        Assert.assertEquals((Object)sourceEncodedSaltFree, (Object)this.encoder.encodePassword(SOURCE_PASSWORD, null, Arrays.asList("md4")));
        encoded = this.encoder.encode("sha256", SOURCE_PASSWORD, null);
        Assert.assertNotEquals((Object)sourceEncodedSaltFree, (Object)encoded);
    }

    @Test
    public void testEncodeSha256() throws Exception {
        String salt = GUID.generate();
        ShaPasswordEncoderImpl sha = new ShaPasswordEncoderImpl(256);
        String sourceEncoded = sha.encodePassword(SOURCE_PASSWORD, (Object)salt);
        String sourceEncodedSaltFree = sha.encodePassword(SOURCE_PASSWORD, null);
        String encoded = this.encoder.encode("sha256", SOURCE_PASSWORD, (Object)salt);
        Assert.assertEquals((Object)sourceEncoded, (Object)encoded);
        Assert.assertTrue((boolean)this.encoder.matches("sha256", SOURCE_PASSWORD, encoded, (Object)salt));
        Assert.assertTrue((boolean)this.encoder.matchesPassword(SOURCE_PASSWORD, encoded, (Object)salt, Arrays.asList("sha256")));
        Assert.assertEquals((Object)sourceEncoded, (Object)this.encoder.encodePassword(SOURCE_PASSWORD, (Object)salt, Arrays.asList("sha256")));
        encoded = this.encoder.encode("sha256", SOURCE_PASSWORD, null);
        Assert.assertEquals((Object)sourceEncodedSaltFree, (Object)encoded);
        Assert.assertTrue((boolean)this.encoder.matches("sha256", SOURCE_PASSWORD, sourceEncodedSaltFree, null));
        Assert.assertTrue((boolean)this.encoder.matchesPassword(SOURCE_PASSWORD, sourceEncodedSaltFree, null, Arrays.asList("sha256")));
        Assert.assertEquals((Object)sourceEncodedSaltFree, (Object)this.encoder.encodePassword(SOURCE_PASSWORD, null, Arrays.asList("sha256")));
        encoded = this.encoder.encode("md4", SOURCE_PASSWORD, null);
        Assert.assertNotEquals((Object)sourceEncodedSaltFree, (Object)encoded);
    }

    @Test
    public void testEncodeBcrypt() throws Exception {
        String encoded = this.encoder.encode("bcrypt10", SOURCE_PASSWORD, null);
        Assert.assertTrue((boolean)this.encoder.matches("bcrypt10", SOURCE_PASSWORD, encoded, null));
        Assert.assertTrue((boolean)this.encoder.matchesPassword(SOURCE_PASSWORD, encoded, null, Arrays.asList("bcrypt10")));
        Assert.assertFalse((boolean)this.encoder.matches("sha256", SOURCE_PASSWORD, encoded, null));
    }

    @Test
    public void testSafeEncodingChain() throws Exception {
        List<String> mdbChain = Arrays.asList("bcrypt10");
        Assert.assertTrue((boolean)this.encoder.isSafeToEncodeChain(mdbChain));
        mdbChain = Arrays.asList("md4", "bcrypt10");
        Assert.assertTrue((boolean)this.encoder.isSafeToEncodeChain(mdbChain));
        mdbChain = Arrays.asList("sha256", "bcrypt10");
        Assert.assertTrue((boolean)this.encoder.isSafeToEncodeChain(mdbChain));
        mdbChain = Arrays.asList("md4", "sha256", "bcrypt10");
        Assert.assertTrue((boolean)this.encoder.isSafeToEncodeChain(mdbChain));
        mdbChain = Arrays.asList("sha256", "md4");
        Assert.assertTrue((boolean)this.encoder.isSafeToEncodeChain(mdbChain));
        mdbChain = Arrays.asList("bcrypt10", "sha256", "md4");
        Assert.assertFalse((boolean)this.encoder.isSafeToEncodeChain(mdbChain));
        mdbChain = Arrays.asList("bcrypt10", "bcrypt11");
        Assert.assertFalse((boolean)this.encoder.isSafeToEncodeChain(mdbChain));
        mdbChain = Arrays.asList("bcrypt10", "sha256", "bcrypt11");
        Assert.assertFalse((boolean)this.encoder.isSafeToEncodeChain(mdbChain));
        mdbChain = Arrays.asList("md4", "bcrypt10", "sha256");
        Assert.assertFalse((boolean)this.encoder.isSafeToEncodeChain(mdbChain));
    }

    @Test
    public void testEncodeChain() throws Exception {
        String salt = GUID.generate();
        List<String> mdbChain = Arrays.asList("bcrypt10");
        String encoded = this.encoder.encodePassword(SOURCE_PASSWORD, null, mdbChain);
        Assert.assertTrue((boolean)this.encoder.matchesPassword(SOURCE_PASSWORD, encoded, null, mdbChain));
        mdbChain = Arrays.asList("md4", "bcrypt10");
        encoded = this.encoder.encodePassword(SOURCE_PASSWORD, (Object)salt, mdbChain);
        Assert.assertTrue((boolean)this.encoder.matchesPassword(SOURCE_PASSWORD, encoded, (Object)salt, mdbChain));
        mdbChain = Arrays.asList("sha256", "bcrypt10");
        encoded = this.encoder.encodePassword(SOURCE_PASSWORD, (Object)salt, mdbChain);
        Assert.assertTrue((boolean)this.encoder.matchesPassword(SOURCE_PASSWORD, encoded, (Object)salt, mdbChain));
        mdbChain = Arrays.asList("md4", "sha256", "bcrypt10");
        encoded = this.encoder.encodePassword(SOURCE_PASSWORD, (Object)salt, mdbChain);
        Assert.assertTrue((boolean)this.encoder.matchesPassword(SOURCE_PASSWORD, encoded, (Object)salt, mdbChain));
        mdbChain = Arrays.asList("sha256", "md4");
        encoded = this.encoder.encodePassword(SOURCE_PASSWORD, (Object)salt, mdbChain);
        Assert.assertTrue((boolean)this.encoder.matchesPassword(SOURCE_PASSWORD, encoded, (Object)salt, mdbChain));
        mdbChain = Arrays.asList("bcrypt10", "sha256", "md4");
        encoded = this.encoder.encodePassword(SOURCE_PASSWORD, (Object)salt, mdbChain);
        Assert.assertFalse((String)"bcrypt10 has its own internal salt so needs to be at the end of the chain.", (boolean)this.encoder.matchesPassword(SOURCE_PASSWORD, encoded, (Object)salt, mdbChain));
        mdbChain = Arrays.asList("bcrypt10", "bcrypt11");
        encoded = this.encoder.encodePassword(SOURCE_PASSWORD, (Object)salt, mdbChain);
        Assert.assertFalse((String)"bcrypt10 has its own internal salt so you can only use it once.", (boolean)this.encoder.matchesPassword(SOURCE_PASSWORD, encoded, (Object)salt, mdbChain));
        mdbChain = Arrays.asList("md4", "sha256");
        encoded = this.encoder.encodePassword(SOURCE_PASSWORD, (Object)salt, mdbChain);
        Assert.assertTrue((boolean)this.encoder.matchesPassword(SOURCE_PASSWORD, encoded, (Object)salt, mdbChain));
        mdbChain = Arrays.asList("md4", "sha256", "md4", "sha256", "bcrypt10");
        encoded = this.encoder.encodePassword(SOURCE_PASSWORD, (Object)salt, mdbChain);
        Assert.assertTrue((boolean)this.encoder.matchesPassword(SOURCE_PASSWORD, encoded, (Object)salt, mdbChain));
    }

    @Test
    public void testUserChain() throws Exception {
        String rawPassword = "0000006.cjob@00000.example.com";
        String salt = GUID.generate();
        ShaPasswordEncoderImpl sha = new ShaPasswordEncoderImpl(256);
        String shaEncoded = sha.encodePassword(rawPassword, (Object)salt);
        Assert.assertTrue((boolean)this.encoder.matches("sha256", rawPassword, shaEncoded, (Object)salt));
        ArrayList<String> nowHashed = new ArrayList<String>();
        nowHashed.add("sha256");
        nowHashed.add("bcrypt10");
        String nowEncoded = this.encoder.encode("bcrypt10", shaEncoded, (Object)salt);
        String nowEncoded2 = this.encoder.encode("bcrypt10", shaEncoded, (Object)salt);
        String nowEncoded3 = this.encoder.encode("bcrypt10", shaEncoded, (Object)salt);
        Assert.assertTrue((boolean)this.encoder.matchesPassword(rawPassword, nowEncoded, (Object)salt, nowHashed));
        Assert.assertTrue((boolean)this.encoder.matchesPassword(rawPassword, nowEncoded2, (Object)salt, nowHashed));
        Assert.assertTrue((boolean)this.encoder.matchesPassword(rawPassword, nowEncoded3, (Object)salt, nowHashed));
    }

    @Test
    public void testEncodePreferred() throws Exception {
        this.encoder.setPreferredEncoding("bcrypt10");
        String encoded = this.encoder.encodePreferred(SOURCE_PASSWORD, null);
        Assert.assertTrue((boolean)this.encoder.matches("bcrypt10", SOURCE_PASSWORD, encoded, null));
    }

    @Test
    public void testMandatoryProperties() throws Exception {
        CompositePasswordEncoder subject = new CompositePasswordEncoder();
        try {
            subject.init();
        }
        catch (AlfrescoRuntimeException expected) {
            expected.getMessage().contains("property_not_set");
        }
        subject.setEncoders(encodersConfig);
        try {
            subject.init();
        }
        catch (AlfrescoRuntimeException expected) {
            expected.getMessage().contains("property_not_set");
        }
        subject.setPreferredEncoding("nice_encoding");
        try {
            subject.init();
        }
        catch (AlfrescoRuntimeException expected) {
            expected.getMessage().contains("Invalid preferredEncoding specified");
        }
        subject.setPreferredEncoding("bcrypt12");
        subject.init();
        Assert.assertEquals((Object)"bcrypt12", (Object)subject.getPreferredEncoding());
    }

    @Test
    public void testIsPreferredEncoding() throws Exception {
        CompositePasswordEncoder subject = new CompositePasswordEncoder();
        subject.setPreferredEncoding("fish");
        Assert.assertTrue((boolean)subject.lastEncodingIsPreferred(Arrays.asList("fish")));
        Assert.assertEquals((Object)"fish", (Object)subject.getPreferredEncoding());
        Assert.assertFalse((boolean)subject.lastEncodingIsPreferred(null));
        Assert.assertFalse((boolean)subject.lastEncodingIsPreferred(Collections.emptyList()));
        Assert.assertTrue((boolean)subject.lastEncodingIsPreferred(Arrays.asList("fish")));
        Assert.assertFalse((boolean)subject.lastEncodingIsPreferred(Arrays.asList("bird")));
        Assert.assertTrue((boolean)subject.lastEncodingIsPreferred(Arrays.asList("bird", "fish")));
        Assert.assertFalse((boolean)subject.lastEncodingIsPreferred(Arrays.asList("bird", "fish", "dog", "cat")));
        Assert.assertTrue((boolean)subject.lastEncodingIsPreferred(Arrays.asList("bird", "dog", "cat", "fish")));
    }
}

