/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.solr;

import java.io.IOException;
import java.net.ConnectException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.admin.RepositoryState;
import org.alfresco.repo.index.shard.Floc;
import org.alfresco.repo.index.shard.ShardRegistry;
import org.alfresco.repo.search.QueryParserException;
import org.alfresco.repo.search.impl.solr.AbstractSolrQueryHTTPClient;
import org.alfresco.repo.search.impl.solr.ExplicitSolrStoreMappingWrapper;
import org.alfresco.repo.search.impl.solr.SolrClientUtil;
import org.alfresco.repo.search.impl.solr.SolrJsonProcessor;
import org.alfresco.repo.search.impl.solr.SolrQueryClient;
import org.alfresco.repo.search.impl.solr.SolrSQLJSONResultSet;
import org.alfresco.repo.search.impl.solr.SolrStoreMapping;
import org.alfresco.repo.search.impl.solr.SolrStoreMappingWrapper;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.search.BasicSearchParameters;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.search.StatsParameters;
import org.alfresco.service.cmr.search.StatsResultSet;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.util.Pair;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.net.URLCodec;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.extensions.surf.util.I18NUtil;

public class SolrSQLHttpClient
extends AbstractSolrQueryHTTPClient
implements SolrQueryClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(SolrSQLHttpClient.class);
    private HashMap<StoreRef, SolrStoreMappingWrapper> mappingLookup = new HashMap();
    private List<SolrStoreMapping> storeMappings;
    private BeanFactory beanFactory;
    private RepositoryState repositoryState;
    private boolean includeGroupsForRoleAdmin = false;
    private boolean anyDenyDenies;
    private boolean useDynamicShardRegistration;
    private ShardRegistry shardRegistry;
    private TenantService tenantService;
    private PermissionService permissionService;
    public static final int DEFAULT_SAVEPOST_BUFFER = 4096;

    public void afterPropertiesSet() throws Exception {
        this.mappingLookup.clear();
        for (SolrStoreMapping mapping : this.storeMappings) {
            this.mappingLookup.put(mapping.getStoreRef(), new ExplicitSolrStoreMappingWrapper(mapping, this.beanFactory));
        }
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void init() {
        PropertyCheck.mandatory((Object)this, (String)"PermissionService", (Object)this.permissionService);
        PropertyCheck.mandatory((Object)this, (String)"StoreMappings", this.storeMappings);
        PropertyCheck.mandatory((Object)this, (String)"RepositoryState", (Object)this.repositoryState);
        PropertyCheck.mandatory((Object)this, (String)"TenantService", (Object)this.tenantService);
    }

    @Override
    public ResultSet executeQuery(SearchParameters searchParameters, String language) {
        if (this.repositoryState.isBootstrapping()) {
            throw new AlfrescoRuntimeException("SOLR queries can not be executed while the repository is bootstrapping");
        }
        if (StringUtils.isEmpty((CharSequence)searchParameters.getQuery())) {
            throw new AlfrescoRuntimeException("SOLR query statement is missing");
        }
        try {
            StoreRef store = SolrClientUtil.extractStoreRef((BasicSearchParameters)searchParameters);
            SolrStoreMappingWrapper mapping = SolrClientUtil.extractMapping(store, this.mappingLookup, this.shardRegistry, this.useDynamicShardRegistration, this.beanFactory);
            Pair<HttpClient, String> httpClientAndBaseUrl = mapping.getHttpClientAndBaseUrl();
            HttpClient httpClient = (HttpClient)httpClientAndBaseUrl.getFirst();
            URLCodec encoder = new URLCodec();
            StringBuilder url = new StringBuilder();
            url.append((String)httpClientAndBaseUrl.getSecond());
            if (!url.toString().endsWith("/")) {
                url.append("/");
            }
            url.append("sql?stmt=" + encoder.encode(searchParameters.getQuery()));
            SearchParameters sp = searchParameters;
            url.append("&includeMetadata=" + sp.isIncludeMetadata());
            url.append("&aggregationMode=facet");
            if (searchParameters.getTimezone() != null && !searchParameters.getTimezone().isEmpty()) {
                url.append("&TZ=").append(encoder.encode(searchParameters.getTimezone(), "UTF-8"));
            }
            url.append("&alfresco.shards=");
            if (mapping.isSharded()) {
                url.append(mapping.getShards());
            } else {
                String solrurl = String.valueOf(httpClient.getHostConfiguration().getHostURL()) + (String)httpClientAndBaseUrl.getSecond();
                url.append(solrurl);
            }
            JSONObject body = new JSONObject();
            Set allAuthorisations = this.permissionService.getAuthorisations();
            boolean includeGroups = this.includeGroupsForRoleAdmin ? true : !allAuthorisations.contains("ROLE_ADMINISTRATOR");
            JSONArray authorities = new JSONArray();
            for (String authority : allAuthorisations) {
                if (includeGroups) {
                    authorities.put((Object)authority);
                    continue;
                }
                if (AuthorityType.getAuthorityType((String)authority) == AuthorityType.GROUP) continue;
                authorities.put((Object)authority);
            }
            body.put("authorities", (Object)authorities);
            body.put("anyDenyDenies", this.anyDenyDenies);
            JSONArray tenants = new JSONArray();
            tenants.put((Object)this.tenantService.getCurrentUserDomain());
            body.put("tenants", (Object)tenants);
            JSONArray locales = new JSONArray();
            for (Locale currentLocale : searchParameters.getLocales()) {
                locales.put(DefaultTypeConverter.INSTANCE.convert(String.class, (Object)currentLocale));
            }
            if (locales.length() == 0) {
                locales.put((Object)I18NUtil.getLocale());
            }
            body.put("locales", (Object)locales);
            JSONArray filterQueries = new JSONArray();
            for (String filterQuery : searchParameters.getFilterQueries()) {
                filterQueries.put((Object)filterQuery);
            }
            body.put("filterQueries", (Object)filterQueries);
            return this.postSolrQuery(httpClient, url.toString(), body, json -> new SolrSQLJSONResultSet(json, searchParameters));
        }
        catch (ConnectException ce) {
            throw new QueryParserException("Unable to reach InsightEngine", ce);
        }
        catch (IOException | EncoderException | JSONException e) {
            throw new QueryParserException("Unable to parse the solr response ", e);
        }
    }

    protected ResultSet postSolrQuery(HttpClient httpClient, String url, JSONObject body, SolrJsonProcessor<?> jsonProcessor) throws IOException, JSONException {
        JSONObject json = this.postQuery(httpClient, url, body);
        Object results = jsonProcessor.getResult(json);
        LOGGER.debug("Sent : {}", (Object)url);
        LOGGER.debug("with: {}", (Object)body);
        LOGGER.debug("Got: {} in {} ms", (Object)results.getNumberFound(), (Object)results.getQueryTime());
        return (ResultSet)results;
    }

    public void setStoreMappings(List<SolrStoreMapping> storeMappings) {
        this.storeMappings = storeMappings;
    }

    public void setRepositoryState(RepositoryState repositoryState) {
        this.repositoryState = repositoryState;
    }

    public void setIncludeGroupsForRoleAdmin(boolean includeGroupsForRoleAdmin) {
        this.includeGroupsForRoleAdmin = includeGroupsForRoleAdmin;
    }

    public void setAnyDenyDenies(boolean anyDenyDenies) {
        this.anyDenyDenies = anyDenyDenies;
    }

    public void setMappingLookup(HashMap<StoreRef, SolrStoreMappingWrapper> mappingLookup) {
        this.mappingLookup = mappingLookup;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setUseDynamicShardRegistration(boolean useDynamicShardRegistration) {
        this.useDynamicShardRegistration = useDynamicShardRegistration;
    }

    public void setShardRegistry(ShardRegistry shardRegistry) {
        this.shardRegistry = shardRegistry;
    }

    public RepositoryState getRepositoryState() {
        return this.repositoryState;
    }

    public boolean isIncludeGroupsForRoleAdmin() {
        return this.includeGroupsForRoleAdmin;
    }

    public boolean isAnyDenyDenies() {
        return this.anyDenyDenies;
    }

    public boolean isUseDynamicShardRegistration() {
        return this.useDynamicShardRegistration;
    }

    public ShardRegistry getShardRegistry() {
        return this.shardRegistry;
    }

    public TenantService getTenantService() {
        return this.tenantService;
    }

    public PermissionService getPermissionService() {
        return this.permissionService;
    }

    @Override
    public StatsResultSet executeStatsQuery(StatsParameters searchParameters) {
        return null;
    }

    @Override
    public boolean isSharded() {
        if (this.shardRegistry != null && this.useDynamicShardRegistration) {
            for (Floc floc : this.shardRegistry.getFlocs().keySet()) {
                if (floc.getNumberOfShards() <= 1) continue;
                return true;
            }
            return false;
        }
        for (SolrStoreMappingWrapper mapping : this.mappingLookup.values()) {
            if (!mapping.isSharded()) continue;
            return true;
        }
        return false;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }
}

