/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.preference.script;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.repo.jscript.BaseScopableProcessorExtension;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.preference.PreferenceService;
import org.alfresco.service.transaction.TransactionService;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;

public class ScriptPreferenceService
extends BaseScopableProcessorExtension {
    private ServiceRegistry services;
    private PreferenceService preferenceService;
    private TransactionService transactionService;

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setServiceRegistry(ServiceRegistry services) {
        this.services = services;
    }

    public void setPreferenceService(PreferenceService preferenceService) {
        this.preferenceService = preferenceService;
    }

    public boolean getAllowWrite() {
        return this.transactionService.getAllowWrite();
    }

    public NativeObject getPreferences(String userName) {
        return this.getPreferences(userName, null);
    }

    public NativeObject getPreferences(String userName, String preferenceFilter) {
        Map<String, Serializable> prefs = this.preferenceService.getPreferences(userName, preferenceFilter);
        NativeObjectDV result = new NativeObjectDV();
        for (Map.Entry<String, Serializable> entry : prefs.entrySet()) {
            String[] keys;
            String key = entry.getKey();
            int colonIndex = key.indexOf(":");
            if (colonIndex > -1) {
                keys = key.substring(0, colonIndex).replace(".", "+").split("\\+");
                keys[keys.length - 1] = keys[keys.length - 1].concat(key.substring(colonIndex));
            } else {
                keys = key.replace(".", "+").split("\\+");
            }
            this.setPrefValue(keys, entry.getValue(), result);
        }
        return result;
    }

    private void setPrefValue(String[] keys, Serializable value, NativeObject object) {
        NativeObject currentObject = object;
        int index = 0;
        String[] stringArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            if (index == keys.length - 1) {
                currentObject.put(key, (Scriptable)currentObject, (Object)value);
            } else {
                NativeObjectDV newObject = null;
                Object temp = currentObject.get(key, (Scriptable)currentObject);
                if (temp == null || !(temp instanceof NativeObject)) {
                    newObject = new NativeObjectDV();
                    currentObject.put(key, (Scriptable)currentObject, (Object)newObject);
                } else {
                    newObject = (NativeObject)temp;
                }
                currentObject = newObject;
            }
            ++index;
            ++n2;
        }
    }

    public void setPreferences(String userName, NativeObject preferences) {
        HashMap<String, Serializable> values = new HashMap<String, Serializable>(10);
        this.getPrefValues(preferences, null, values);
        this.preferenceService.setPreferences(userName, values);
    }

    private void getPrefValues(NativeObject currentObject, String currentKey, Map<String, Serializable> values) {
        Object[] ids;
        Object[] objectArray = ids = currentObject.getIds();
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            Object id = objectArray[n2];
            String key = this.getAppendedKey(currentKey, id.toString());
            Object value = currentObject.get(id.toString(), (Scriptable)currentObject);
            if (value instanceof NativeObject) {
                this.getPrefValues((NativeObject)value, key, values);
            } else {
                values.put(key, (Serializable)value);
            }
            ++n2;
        }
    }

    public void clearPreferences(String userName) {
        this.preferenceService.clearPreferences(userName, null);
    }

    public void clearPreferences(String userName, String preferenceFilter) {
        this.preferenceService.clearPreferences(userName, preferenceFilter);
    }

    private String getAppendedKey(String currentKey, String key) {
        StringBuffer buffer = new StringBuffer(64);
        if (currentKey != null && currentKey.length() != 0) {
            buffer.append(currentKey).append(".").append(key);
        } else {
            buffer.append(key);
        }
        return buffer.toString();
    }

    private static class NativeObjectDV
    extends NativeObject {
        private static final long serialVersionUID = 1L;

        private NativeObjectDV() {
        }

        public Object getDefaultValue(Class typeHint) {
            return this.toString();
        }
    }
}

