/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.scheduled;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.alfresco.repo.action.scheduled.CompensatingActionException;
import org.alfresco.repo.action.scheduled.ScheduledActionDefinition;
import org.alfresco.repo.action.scheduled.TemplateActionDefinition;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.transaction.TransactionService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;

public abstract class AbstractScheduledAction
implements ScheduledActionDefinition {
    private static Log s_logger = LogFactory.getLog(AbstractScheduledAction.class);
    private static final String ACTION_JOB_DATA_MAP_KEY = "Action";
    private ActionService actionService;
    private String runAsUser;
    private TemplateActionDefinition templateActionDefinition;
    private TransactionMode transactionMode = TransactionMode.ISOLATED_TRANSACTIONS;
    private CompensatingActionMode compensatingActionMode = CompensatingActionMode.IGNORE;
    private TransactionService transactionService;

    public String getRunAsUser() {
        return this.runAsUser;
    }

    public void setRunAsUser(String runAsUser) {
        this.runAsUser = runAsUser;
    }

    @Override
    public TemplateActionDefinition getTemplateActionDefinition() {
        return this.templateActionDefinition;
    }

    public void setActionService(ActionService actionService) {
        this.actionService = actionService;
    }

    public ActionService getActionService() {
        return this.actionService;
    }

    public void setCompensatingActionMode(String compensatingActionModeString) {
        this.compensatingActionMode = CompensatingActionMode.getCompensatingActionMode(compensatingActionModeString);
    }

    public void setTransactionMode(String transactionModeString) {
        this.transactionMode = TransactionMode.getTransactionMode(transactionModeString);
    }

    public TransactionService getTransactionService() {
        return this.transactionService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    @Override
    public void setTemplateActionDefinition(TemplateActionDefinition templateActionDefinition) {
        this.templateActionDefinition = templateActionDefinition;
    }

    public CompensatingActionMode getCompensatingActionModeEnum() {
        return this.compensatingActionMode;
    }

    public TransactionMode getTransactionModeEnum() {
        return this.transactionMode;
    }

    @Override
    public void register(Scheduler scheduler) throws SchedulerException {
        JobDetail jobDetail = this.getJobDetail();
        Trigger trigger = this.getTrigger();
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("Registering job: " + jobDetail));
            s_logger.debug((Object)("With trigger: " + trigger));
        }
        scheduler.scheduleJob(jobDetail, trigger);
    }

    public abstract Trigger getTrigger();

    public abstract List<NodeRef> getNodes();

    public abstract Action getAction(NodeRef var1);

    private JobDetail getJobDetail() {
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.put(ACTION_JOB_DATA_MAP_KEY, (Object)this);
        JobDetail jobDetail = JobBuilder.newJob().withIdentity(this.getJobName(), this.getJobGroup()).usingJobData(jobDataMap).ofType(JobDefinition.class).build();
        return jobDetail;
    }

    private static Object throwRuntimeException(Throwable t) {
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        throw new RuntimeException("Error during execution of transaction.", t);
    }

    public static enum CompensatingActionMode {
        RUN_COMPENSATING_ACTIONS_ON_FAILURE,
        IGNORE;


        public static CompensatingActionMode getCompensatingActionMode(String compensatingActionModeString) {
            CompensatingActionMode compensatingActionMode = compensatingActionModeString.equalsIgnoreCase("RUN_COMPENSATING_ACTIONS_ON_FAILURE") ? RUN_COMPENSATING_ACTIONS_ON_FAILURE : (compensatingActionModeString.equalsIgnoreCase("IGNORE") ? IGNORE : IGNORE);
            return compensatingActionMode;
        }
    }

    public static class JobDefinition
    implements Job {
        public void execute(JobExecutionContext ctx) throws JobExecutionException {
            final AbstractScheduledAction abstractScheduledAction = (AbstractScheduledAction)ctx.getJobDetail().getJobDataMap().get((Object)AbstractScheduledAction.ACTION_JOB_DATA_MAP_KEY);
            AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

                public Object doWork() {
                    List<NodeRef> nodes = abstractScheduledAction.getNodes();
                    if (s_logger.isDebugEnabled()) {
                        s_logger.debug((Object)("Found " + nodes.size()));
                    }
                    if (abstractScheduledAction.getTransactionModeEnum() == TransactionMode.ONE_TRANSACTION) {
                        if (s_logger.isDebugEnabled()) {
                            s_logger.debug((Object)"Executing in one transaction");
                        }
                        this.runTransactionalActions(nodes);
                        return null;
                    }
                    if (s_logger.isDebugEnabled()) {
                        s_logger.debug((Object)"Executing in individual transaction");
                    }
                    for (NodeRef nodeRef : nodes) {
                        try {
                            this.runTransactionalAction(nodeRef);
                        }
                        catch (Throwable t) {
                            if (abstractScheduledAction.getTransactionModeEnum() == TransactionMode.ISOLATED_TRANSACTIONS) {
                                s_logger.error((Object)"Error in scheduled action executed in isolated transactions (other actions will continue", t);
                                continue;
                            }
                            AbstractScheduledAction.throwRuntimeException(t);
                        }
                    }
                    return null;
                }

                public void runTransactionalActions(final List<NodeRef> nodes) {
                    boolean runCompensatingActions = abstractScheduledAction.getCompensatingActionModeEnum() == CompensatingActionMode.RUN_COMPENSATING_ACTIONS_ON_FAILURE;
                    try {
                        abstractScheduledAction.getTransactionService().getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                            @Override
                            public Object execute() throws Exception {
                                Action action;
                                ArrayList<Pair<Action, NodeRef>> compensatingActions = new ArrayList<Pair<Action, NodeRef>>(nodes.size());
                                for (NodeRef nodeRef : nodes) {
                                    action = abstractScheduledAction.getAction(nodeRef);
                                    Action compensatingAction = action.getCompensatingAction();
                                    if (compensatingAction == null) continue;
                                    compensatingActions.add(new Pair<Action, NodeRef>(compensatingAction, nodeRef));
                                }
                                try {
                                    for (NodeRef nodeRef : nodes) {
                                        action = abstractScheduledAction.getAction(nodeRef);
                                        abstractScheduledAction.getActionService().executeAction(action, nodeRef);
                                    }
                                    return null;
                                }
                                catch (Throwable t) {
                                    throw new CompensatingActionException("Requires compensating action", t, compensatingActions);
                                }
                            }
                        });
                    }
                    catch (Throwable t) {
                        this.doCompensation(runCompensatingActions, true, t);
                    }
                }

                private void doCompensation(boolean runCompensatingActions, boolean rethrow, Throwable t) {
                    if (runCompensatingActions && t instanceof CompensatingActionException) {
                        CompensatingActionException cae = (CompensatingActionException)((Object)t);
                        for (Pair<Action, NodeRef> pair : cae.getCompensatingActions()) {
                            if (pair == null || pair.getFirst() == null || pair.getSecond() == null) continue;
                            try {
                                this.runTransactionalCompensatingAction(pair);
                            }
                            catch (Throwable throwable) {
                                s_logger.error((Object)"Error executing compensating action", t);
                            }
                        }
                    }
                    if (rethrow) {
                        AbstractScheduledAction.throwRuntimeException(t);
                    }
                }

                public void runTransactionalAction(final NodeRef nodeRef) {
                    boolean runCompensatingActions = abstractScheduledAction.getCompensatingActionModeEnum() == CompensatingActionMode.RUN_COMPENSATING_ACTIONS_ON_FAILURE;
                    boolean rethrow = abstractScheduledAction.getTransactionModeEnum() != TransactionMode.ISOLATED_TRANSACTIONS;
                    try {
                        abstractScheduledAction.getTransactionService().getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                            @Override
                            public Object execute() throws Exception {
                                Action action = abstractScheduledAction.getAction(nodeRef);
                                Action compensatingAction = action.getCompensatingAction();
                                try {
                                    abstractScheduledAction.getActionService().executeAction(action, nodeRef);
                                    return null;
                                }
                                catch (Throwable t) {
                                    if (compensatingAction != null) {
                                        throw new CompensatingActionException("Requires compensating action", t, Collections.singletonList(new Pair<Action, NodeRef>(action.getCompensatingAction(), nodeRef)));
                                    }
                                    return AbstractScheduledAction.throwRuntimeException(t);
                                }
                            }
                        });
                    }
                    catch (Throwable t) {
                        this.doCompensation(runCompensatingActions, rethrow, t);
                    }
                }

                public void runTransactionalCompensatingAction(final Pair<Action, NodeRef> pair) {
                    boolean runCompensatingActions = abstractScheduledAction.getCompensatingActionModeEnum() == CompensatingActionMode.RUN_COMPENSATING_ACTIONS_ON_FAILURE;
                    try {
                        abstractScheduledAction.getTransactionService().getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                            @Override
                            public Object execute() throws Exception {
                                try {
                                    abstractScheduledAction.getActionService().executeAction((Action)pair.getFirst(), (NodeRef)pair.getSecond());
                                    return null;
                                }
                                catch (Throwable t) {
                                    ArrayList<Pair<Action, NodeRef>> compensatingActions = new ArrayList<Pair<Action, NodeRef>>(1);
                                    if (((Action)pair.getFirst()).getCompensatingAction() != null) {
                                        compensatingActions.add(new Pair<Action, NodeRef>(((Action)pair.getFirst()).getCompensatingAction(), (NodeRef)pair.getSecond()));
                                    }
                                    throw new CompensatingActionException("Requires compensating action", t, compensatingActions);
                                }
                            }
                        });
                    }
                    catch (Throwable t) {
                        this.doCompensation(runCompensatingActions, true, t);
                    }
                }
            }, (String)abstractScheduledAction.getRunAsUser());
        }
    }

    public static class Pair<FIRST, SECOND> {
        FIRST first;
        SECOND second;

        public Pair(FIRST first, SECOND second) {
            this.first = first;
            this.second = second;
        }

        FIRST getFirst() {
            return this.first;
        }

        SECOND getSecond() {
            return this.second;
        }
    }

    public static enum TransactionMode {
        ISOLATED_TRANSACTIONS,
        UNTIL_FIRST_FAILURE,
        ONE_TRANSACTION;


        public static TransactionMode getTransactionMode(String transactionModeString) {
            TransactionMode transactionMode = transactionModeString.equalsIgnoreCase("ISOLATED_TRANSACTIONS") ? ISOLATED_TRANSACTIONS : (transactionModeString.equalsIgnoreCase("UNTIL_FIRST_FAILURE") ? UNTIL_FIRST_FAILURE : (transactionModeString.equalsIgnoreCase("ONE_TRANSACTION") ? ONE_TRANSACTION : ISOLATED_TRANSACTIONS));
            return transactionMode;
        }
    }
}

