/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication.identityservice;

import java.util.function.Supplier;
import org.alfresco.repo.security.authentication.identityservice.IdentityServiceFacade;
import org.alfresco.repo.security.authentication.identityservice.IdentityServiceFacadeFactoryBean;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class LazyInstantiatingIdentityServiceFacadeUnitTest {
    private static final String USER_NAME = "marlon";
    private static final String PASSWORD = "brando";
    private static final String TOKEN = "token";

    @Test
    public void shouldRecoverFromInitialAuthorizationServerUnavailability() {
        IdentityServiceFacade targetFacade = (IdentityServiceFacade)Mockito.mock(IdentityServiceFacade.class);
        IdentityServiceFacadeFactoryBean.LazyInstantiatingIdentityServiceFacade facade = new IdentityServiceFacadeFactoryBean.LazyInstantiatingIdentityServiceFacade(this.faultySupplier(3, targetFacade));
        Assertions.assertThatExceptionOfType(IdentityServiceFacade.IdentityServiceFacadeException.class).isThrownBy(() -> {
            IdentityServiceFacade.DecodedAccessToken decodedAccessToken = facade.decodeToken(TOKEN);
        }).havingCause().withNoCause().withMessage("Expected failure #1");
        Mockito.verifyNoInteractions((Object[])new Object[]{targetFacade});
        Assertions.assertThatExceptionOfType(IdentityServiceFacade.IdentityServiceFacadeException.class).isThrownBy(() -> {
            IdentityServiceFacade.AccessTokenAuthorization accessTokenAuthorization = facade.authorize(IdentityServiceFacade.AuthorizationGrant.password((String)USER_NAME, (String)PASSWORD));
        }).havingCause().withNoCause().withMessage("Expected failure #2");
        Mockito.verifyNoInteractions((Object[])new Object[]{targetFacade});
        Assertions.assertThatExceptionOfType(IdentityServiceFacade.IdentityServiceFacadeException.class).isThrownBy(() -> {
            IdentityServiceFacade.DecodedAccessToken decodedAccessToken = facade.decodeToken(TOKEN);
        }).havingCause().withNoCause().withMessage("Expected failure #3");
        Mockito.verifyNoInteractions((Object[])new Object[]{targetFacade});
        IdentityServiceFacade.AuthorizationGrant grant = IdentityServiceFacade.AuthorizationGrant.password((String)USER_NAME, (String)PASSWORD);
        facade.authorize(grant);
        ((IdentityServiceFacade)Mockito.verify((Object)targetFacade)).authorize(grant);
    }

    @Test
    public void shouldAvoidCreatingMultipleInstanceOfOAuth2AuthorizedClientManager() {
        IdentityServiceFacade targetFacade = (IdentityServiceFacade)Mockito.mock(IdentityServiceFacade.class);
        Supplier supplier = (Supplier)Mockito.mock(Supplier.class);
        Mockito.when((Object)((IdentityServiceFacade)supplier.get())).thenReturn((Object)targetFacade);
        IdentityServiceFacadeFactoryBean.LazyInstantiatingIdentityServiceFacade facade = new IdentityServiceFacadeFactoryBean.LazyInstantiatingIdentityServiceFacade(supplier);
        facade.authorize(IdentityServiceFacade.AuthorizationGrant.password((String)USER_NAME, (String)PASSWORD));
        facade.decodeToken(TOKEN);
        facade.authorize(IdentityServiceFacade.AuthorizationGrant.password((String)USER_NAME, (String)PASSWORD));
        facade.decodeToken(TOKEN);
        facade.authorize(IdentityServiceFacade.AuthorizationGrant.password((String)USER_NAME, (String)PASSWORD));
        ((Supplier)Mockito.verify((Object)supplier, (VerificationMode)Mockito.times((int)1))).get();
        ((IdentityServiceFacade)Mockito.verify((Object)targetFacade, (VerificationMode)Mockito.times((int)3))).authorize(IdentityServiceFacade.AuthorizationGrant.password((String)USER_NAME, (String)PASSWORD));
        ((IdentityServiceFacade)Mockito.verify((Object)targetFacade, (VerificationMode)Mockito.times((int)2))).decodeToken(TOKEN);
    }

    private Supplier<IdentityServiceFacade> faultySupplier(int numberOfInitialFailures, IdentityServiceFacade facade) {
        int[] counter = new int[1];
        return () -> {
            int n2 = counter[0];
            nArray[0] = n2 + 1;
            if (n2 < numberOfInitialFailures) {
                throw new RuntimeException("Expected failure #" + counter[0]);
            }
            return facade;
        };
    }
}

