/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rendition2;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.content.transform.magick.ImageResizeOptions;
import org.alfresco.repo.content.transform.magick.ImageTransformationOptions;
import org.alfresco.repo.content.transform.swf.SWFTransformationOptions;
import org.alfresco.repo.rendition2.TransformationOptionsConverter;
import org.alfresco.service.cmr.repository.CropSourceOptions;
import org.alfresco.service.cmr.repository.PagedSourceOptions;
import org.alfresco.service.cmr.repository.TransformationOptions;
import org.alfresco.service.cmr.repository.TransformationSourceOptions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class TransformationOptionsConverterTest {
    private static final String TO_STRING_OF_UNSET_TRANSFORMATION_OPTIONS = "{maxSourceSizeKBytes=-1, pageLimit=-1, use=null, timeoutMs=-1, maxPages=-1, contentReaderNodeRef=null, sourceContentProperty=null, readLimitKBytes=-1, contentWriterNodeRef=null, targetContentProperty=null, includeEmbedded=null, readLimitTimeMs=-1}";
    private TransformationOptionsConverter converter;
    private static final String[] DISCARD_OPTIONS = new String[]{"autoOrient", "false", "maintainAspectRatio", "true", "allowEnlargement", "true"};

    @Before
    public void setUp() throws Exception {
        this.converter = new TransformationOptionsConverter();
        this.converter.setMaxSourceSizeKBytes("-1");
        this.converter.setReadLimitTimeMs("-1");
        this.converter.setReadLimitKBytes("-1");
        this.converter.setPageLimit("-1");
        this.converter.setMaxPages("-1");
    }

    private void assertConverterToMapAndBack(TransformationOptions oldOptions, String sourceMimetype, String targetMimetype, String expectedOldOptionsToString, String expectedArgs) {
        String sortedOldOptions = this.getSortedOptions(oldOptions, sourceMimetype, targetMimetype);
        Assert.assertEquals((String)"oldOptions was not set up correctly", (Object)expectedOldOptionsToString, (Object)oldOptions.toString());
        Map newOptions = this.converter.getOptions(oldOptions, sourceMimetype, targetMimetype);
        Map<String, String> newOptionsWithoutDiscards = TransformationOptionsConverterTest.discardNoopOptions(newOptions);
        String sortedNewOptions = TransformationOptionsConverterTest.getSortedOptions(newOptionsWithoutDiscards);
        Assert.assertEquals((String)"Conversion to a map appears to be wrong", (Object)expectedArgs, (Object)sortedNewOptions);
        TransformationOptions backToOldOptions = this.converter.getTransformationOptions("null", newOptions);
        String sortedBackToOldOptions = this.getSortedOptions(backToOldOptions, sourceMimetype, targetMimetype);
        Assert.assertEquals((String)"Having converted twice the toString is different", (Object)expectedOldOptionsToString, (Object)backToOldOptions.toString());
        Assert.assertEquals((String)"Having converted twice the map is different", (Object)sortedOldOptions, (Object)sortedBackToOldOptions);
    }

    private String getSortedOptions(TransformationOptions options, String sourceMimetype, String targetMimetype) {
        Map map = this.converter.getOptions(options, sourceMimetype, targetMimetype);
        return TransformationOptionsConverterTest.getSortedOptions(map);
    }

    private static String getSortedOptions(Map<String, String> options) {
        ArrayList<String> list = new ArrayList<String>();
        options.entrySet().forEach(e -> {
            if (e.getValue() != null) {
                list.add(String.valueOf((String)e.getKey()) + '=' + (String)e.getValue() + ' ');
            }
        });
        return TransformationOptionsConverterTest.getSortedOptions(list);
    }

    public static Map<String, String> discardNoopOptions(Map<String, String> options1) {
        HashMap<String, String> options2 = new HashMap<String, String>(options1);
        int i = 0;
        while (i < DISCARD_OPTIONS.length) {
            options2.remove(DISCARD_OPTIONS[i], DISCARD_OPTIONS[i + 1]);
            i += 2;
        }
        return options2;
    }

    private static String getSortedOptions(String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < args.length) {
            if (args[i + 1] != null) {
                list.add(String.valueOf(args[i]) + "=" + args[i + 1] + ' ');
            }
            i += 2;
        }
        return TransformationOptionsConverterTest.getSortedOptions(list);
    }

    private static String getSortedOptions(List<String> list) {
        StringBuilder sb = new StringBuilder();
        Collections.sort(list);
        list.forEach(a -> {
            StringBuilder stringBuilder2 = sb.append((String)a);
        });
        return sb.toString();
    }

    @Test
    public void testCompositeReformatAndResizeRendition() {
        ImageTransformationOptions oldOptions = new ImageTransformationOptions();
        ImageResizeOptions imageResizeOptions = new ImageResizeOptions();
        imageResizeOptions.setHeight(30);
        imageResizeOptions.setWidth(20);
        oldOptions.setResizeOptions(imageResizeOptions);
        PagedSourceOptions pagedSourceOptions = new PagedSourceOptions();
        pagedSourceOptions.setStartPageNumber(Integer.valueOf(1));
        pagedSourceOptions.setEndPageNumber(Integer.valueOf(1));
        oldOptions.addSourceOptions((TransformationSourceOptions)pagedSourceOptions);
        this.assertConverterToMapAndBack((TransformationOptions)oldOptions, "image/jpeg", "image/jpeg", "ImageTransformationOptions [commandOptions=, resizeOptions=ImageResizeOptions [width=20, height=30, maintainAspectRatio=true, percentResize=false, resizeToThumbnail=false, allowEnlargement=true], autoOrient=true], sourceOptions={ PagedSourceOptionsPagedSourceOptions {1, 1}} ]", "alphaRemove=true autoOrient=true endPage=0 resizeHeight=30 resizeWidth=20 startPage=0 timeout=-1 ");
    }

    @Test
    public void testImageTransformationOptions() {
        ImageTransformationOptions oldOptions = new ImageTransformationOptions();
        this.assertConverterToMapAndBack((TransformationOptions)oldOptions, "image/jpeg", "image/png", "ImageTransformationOptions [commandOptions=, resizeOptions=null, autoOrient=true]]", "autoOrient=true timeout=-1 ");
    }

    @Test
    public void testImageTransformationOptionsNoAutoOrient() {
        ImageTransformationOptions oldOptions = new ImageTransformationOptions();
        oldOptions.setAutoOrient(false);
        this.assertConverterToMapAndBack((TransformationOptions)oldOptions, "image/jpeg", "image/png", "ImageTransformationOptions [commandOptions=, resizeOptions=null, autoOrient=false]]", "timeout=-1 ");
    }

    @Test
    public void testImageTransformationOptionsAlphaRemove() {
        ImageTransformationOptions oldOptions = new ImageTransformationOptions();
        oldOptions.setAutoOrient(false);
        this.assertConverterToMapAndBack((TransformationOptions)oldOptions, "image/jpeg", "image/jpeg", "ImageTransformationOptions [commandOptions=, resizeOptions=null, autoOrient=false]]", "alphaRemove=true timeout=-1 ");
    }

    @Test
    public void testImageTransformationOptionsCrop() {
        ImageTransformationOptions oldOptions = new ImageTransformationOptions();
        oldOptions.setAutoOrient(false);
        CropSourceOptions cropOptions = new CropSourceOptions();
        oldOptions.addSourceOptions((TransformationSourceOptions)cropOptions);
        this.assertConverterToMapAndBack((TransformationOptions)oldOptions, "image/jpeg", "image/png", "ImageTransformationOptions [commandOptions=, resizeOptions=null, autoOrient=false], sourceOptions={ CropSourceOptionsCropSourceOptions [height=-1, width=-1, xOffset=0, yOffset=0, isPercentageCrop=false, gravity=null]} ]", "cropXOffset=0 cropYOffset=0 timeout=-1 ");
    }

    @Test
    public void testImageTransformationOptionsCropGravity() {
        ImageTransformationOptions oldOptions = new ImageTransformationOptions();
        oldOptions.setAutoOrient(false);
        CropSourceOptions cropOptions = new CropSourceOptions();
        cropOptions.setGravity("North");
        oldOptions.addSourceOptions((TransformationSourceOptions)cropOptions);
        this.assertConverterToMapAndBack((TransformationOptions)oldOptions, "image/jpeg", "image/png", "ImageTransformationOptions [commandOptions=, resizeOptions=null, autoOrient=false], sourceOptions={ CropSourceOptionsCropSourceOptions [height=-1, width=-1, xOffset=0, yOffset=0, isPercentageCrop=false, gravity=North]} ]", "cropGravity=North cropXOffset=0 cropYOffset=0 timeout=-1 ");
    }

    @Test
    public void testImageTransformationOptionsCropWidthHeight() {
        ImageTransformationOptions oldOptions = new ImageTransformationOptions();
        oldOptions.setAutoOrient(false);
        CropSourceOptions cropOptions = new CropSourceOptions();
        cropOptions.setWidth(30);
        cropOptions.setHeight(48);
        oldOptions.addSourceOptions((TransformationSourceOptions)cropOptions);
        this.assertConverterToMapAndBack((TransformationOptions)oldOptions, "image/jpeg", "image/png", "ImageTransformationOptions [commandOptions=, resizeOptions=null, autoOrient=false], sourceOptions={ CropSourceOptionsCropSourceOptions [height=48, width=30, xOffset=0, yOffset=0, isPercentageCrop=false, gravity=null]} ]", "cropHeight=48 cropWidth=30 cropXOffset=0 cropYOffset=0 timeout=-1 ");
    }

    @Test
    public void testImageTransformationOptionsCropPercentage() {
        ImageTransformationOptions oldOptions = new ImageTransformationOptions();
        oldOptions.setAutoOrient(false);
        CropSourceOptions cropOptions = new CropSourceOptions();
        cropOptions.setPercentageCrop(true);
        oldOptions.addSourceOptions((TransformationSourceOptions)cropOptions);
        this.assertConverterToMapAndBack((TransformationOptions)oldOptions, "image/jpeg", "image/png", "ImageTransformationOptions [commandOptions=, resizeOptions=null, autoOrient=false], sourceOptions={ CropSourceOptionsCropSourceOptions [height=-1, width=-1, xOffset=0, yOffset=0, isPercentageCrop=true, gravity=null]} ]", "cropPercentage=true cropXOffset=0 cropYOffset=0 timeout=-1 ");
    }

    @Test
    public void testImageTransformationOptionsCropOffset() {
        ImageTransformationOptions oldOptions = new ImageTransformationOptions();
        oldOptions.setAutoOrient(false);
        CropSourceOptions cropOptions = new CropSourceOptions();
        cropOptions.setXOffset(20);
        cropOptions.setYOffset(59);
        oldOptions.addSourceOptions((TransformationSourceOptions)cropOptions);
        this.assertConverterToMapAndBack((TransformationOptions)oldOptions, "image/jpeg", "image/png", "ImageTransformationOptions [commandOptions=, resizeOptions=null, autoOrient=false], sourceOptions={ CropSourceOptionsCropSourceOptions [height=-1, width=-1, xOffset=20, yOffset=59, isPercentageCrop=false, gravity=null]} ]", "cropXOffset=20 cropYOffset=59 timeout=-1 ");
    }

    @Test
    public void testImageTransformationOptionsResize() {
        ImageTransformationOptions oldOptions = new ImageTransformationOptions();
        oldOptions.setAutoOrient(false);
        ImageResizeOptions imageResizeOptions = new ImageResizeOptions();
        oldOptions.setResizeOptions(imageResizeOptions);
        this.assertConverterToMapAndBack((TransformationOptions)oldOptions, "image/jpeg", "image/png", "ImageTransformationOptions [commandOptions=, resizeOptions=ImageResizeOptions [width=-1, height=-1, maintainAspectRatio=true, percentResize=false, resizeToThumbnail=false, allowEnlargement=true], autoOrient=false]]", "timeout=-1 ");
    }

    @Test
    public void testImageTransformationOptionsResizeNoEnlargement() {
        ImageTransformationOptions oldOptions = new ImageTransformationOptions();
        oldOptions.setAutoOrient(false);
        ImageResizeOptions imageResizeOptions = new ImageResizeOptions();
        imageResizeOptions.setAllowEnlargement(false);
        oldOptions.setResizeOptions(imageResizeOptions);
        this.assertConverterToMapAndBack((TransformationOptions)oldOptions, "image/jpeg", "image/png", "ImageTransformationOptions [commandOptions=, resizeOptions=ImageResizeOptions [width=-1, height=-1, maintainAspectRatio=true, percentResize=false, resizeToThumbnail=false, allowEnlargement=false], autoOrient=false]]", "allowEnlargement=false timeout=-1 ");
    }

    @Test
    public void testImageTransformationOptionsResizeNoAspectRatio() {
        ImageTransformationOptions oldOptions = new ImageTransformationOptions();
        oldOptions.setAutoOrient(false);
        ImageResizeOptions imageResizeOptions = new ImageResizeOptions();
        imageResizeOptions.setMaintainAspectRatio(false);
        oldOptions.setResizeOptions(imageResizeOptions);
        this.assertConverterToMapAndBack((TransformationOptions)oldOptions, "image/jpeg", "image/png", "ImageTransformationOptions [commandOptions=, resizeOptions=ImageResizeOptions [width=-1, height=-1, maintainAspectRatio=false, percentResize=false, resizeToThumbnail=false, allowEnlargement=true], autoOrient=false]]", "maintainAspectRatio=false timeout=-1 ");
    }

    @Test
    public void testImageTransformationOptionsResizeNoEnlargementOrAspectRatio() {
        ImageTransformationOptions oldOptions = new ImageTransformationOptions();
        oldOptions.setAutoOrient(false);
        ImageResizeOptions imageResizeOptions = new ImageResizeOptions();
        imageResizeOptions.setAllowEnlargement(false);
        imageResizeOptions.setMaintainAspectRatio(false);
        oldOptions.setResizeOptions(imageResizeOptions);
        this.assertConverterToMapAndBack((TransformationOptions)oldOptions, "image/jpeg", "image/png", "ImageTransformationOptions [commandOptions=, resizeOptions=ImageResizeOptions [width=-1, height=-1, maintainAspectRatio=false, percentResize=false, resizeToThumbnail=false, allowEnlargement=false], autoOrient=false]]", "allowEnlargement=false maintainAspectRatio=false timeout=-1 ");
    }

    @Test
    public void testImageTransformationOptionsResizeThumbnnail() {
        ImageTransformationOptions oldOptions = new ImageTransformationOptions();
        oldOptions.setAutoOrient(false);
        ImageResizeOptions imageResizeOptions = new ImageResizeOptions();
        imageResizeOptions.setAllowEnlargement(false);
        imageResizeOptions.setMaintainAspectRatio(false);
        imageResizeOptions.setResizeToThumbnail(true);
        oldOptions.setResizeOptions(imageResizeOptions);
        this.assertConverterToMapAndBack((TransformationOptions)oldOptions, "image/jpeg", "image/png", "ImageTransformationOptions [commandOptions=, resizeOptions=ImageResizeOptions [width=-1, height=-1, maintainAspectRatio=false, percentResize=false, resizeToThumbnail=true, allowEnlargement=false], autoOrient=false]]", "allowEnlargement=false maintainAspectRatio=false thumbnail=true timeout=-1 ");
    }

    @Test
    public void testImageTransformationOptionsResizeWidthHeight() {
        ImageTransformationOptions oldOptions = new ImageTransformationOptions();
        oldOptions.setAutoOrient(false);
        ImageResizeOptions imageResizeOptions = new ImageResizeOptions();
        imageResizeOptions.setAllowEnlargement(false);
        imageResizeOptions.setMaintainAspectRatio(false);
        imageResizeOptions.setWidth(18);
        imageResizeOptions.setHeight(15);
        oldOptions.setResizeOptions(imageResizeOptions);
        this.assertConverterToMapAndBack((TransformationOptions)oldOptions, "image/jpeg", "image/png", "ImageTransformationOptions [commandOptions=, resizeOptions=ImageResizeOptions [width=18, height=15, maintainAspectRatio=false, percentResize=false, resizeToThumbnail=false, allowEnlargement=false], autoOrient=false]]", "allowEnlargement=false maintainAspectRatio=false resizeHeight=15 resizeWidth=18 timeout=-1 ");
    }

    @Test
    public void testImageTransformationOptionsResizePercent() {
        ImageTransformationOptions oldOptions = new ImageTransformationOptions();
        oldOptions.setAutoOrient(false);
        ImageResizeOptions imageResizeOptions = new ImageResizeOptions();
        imageResizeOptions.setAllowEnlargement(false);
        imageResizeOptions.setMaintainAspectRatio(false);
        imageResizeOptions.setPercentResize(true);
        oldOptions.setResizeOptions(imageResizeOptions);
        this.assertConverterToMapAndBack((TransformationOptions)oldOptions, "image/jpeg", "image/png", "ImageTransformationOptions [commandOptions=, resizeOptions=ImageResizeOptions [width=-1, height=-1, maintainAspectRatio=false, percentResize=true, resizeToThumbnail=false, allowEnlargement=false], autoOrient=false]]", "allowEnlargement=false maintainAspectRatio=false resizePercentage=true timeout=-1 ");
    }

    @Test
    public void testImageTransformationOptionsPage() {
        ImageTransformationOptions oldOptions = new ImageTransformationOptions();
        oldOptions.setAutoOrient(false);
        PagedSourceOptions pagedSourceOptions = new PagedSourceOptions();
        pagedSourceOptions.setStartPageNumber(Integer.valueOf(1));
        pagedSourceOptions.setEndPageNumber(Integer.valueOf(1));
        oldOptions.addSourceOptions((TransformationSourceOptions)pagedSourceOptions);
        this.assertConverterToMapAndBack((TransformationOptions)oldOptions, "image/jpeg", "image/png", "ImageTransformationOptions [commandOptions=, resizeOptions=null, autoOrient=false], sourceOptions={ PagedSourceOptionsPagedSourceOptions {1, 1}} ]", "endPage=0 startPage=0 timeout=-1 ");
    }

    @Test
    public void testSWFTransformationOptionsPage() {
        SWFTransformationOptions oldOptions = new SWFTransformationOptions();
        PagedSourceOptions pagedSourceOptions = new PagedSourceOptions();
        pagedSourceOptions.setStartPageNumber(Integer.valueOf(1));
        pagedSourceOptions.setEndPageNumber(Integer.valueOf(1));
        oldOptions.addSourceOptions((TransformationSourceOptions)pagedSourceOptions);
        this.assertConverterToMapAndBack((TransformationOptions)oldOptions, "image/jpeg", "image/png", "{maxSourceSizeKBytes=-1, use=null, contentReaderNodeRef=null, readLimitKBytes=-1, contentWriterNodeRef=null, pageLimit=-1, flashVersion=9, timeoutMs=-1, maxPages=-1, sourceContentProperty=null, targetContentProperty=null, includeEmbedded=null, readLimitTimeMs=-1}", "flashVersion=9 timeout=-1 ");
    }

    @Test
    public void testRenditionImagepreview() {
        String sourceMimetype = null;
        String targetMimetype = null;
        HashMap<String, String> newOptions = new HashMap<String, String>();
        newOptions.put("thumbnail", "true");
        newOptions.put("resizeWidth", "960");
        newOptions.put("autoOrient", "true");
        newOptions.put("resizeHeight", "960");
        newOptions.put("allowEnlargement", "true");
        newOptions.put("maintainAspectRatio", "true");
        String sortedNewOptions = TransformationOptionsConverterTest.getSortedOptions(newOptions);
        TransformationOptions oldOptions = this.converter.getTransformationOptions("null", newOptions);
        String sortedOldOptions = this.getSortedOptions(oldOptions, sourceMimetype, targetMimetype);
        if (sortedOldOptions.endsWith("timeout=-1 ")) {
            sortedOldOptions = sortedOldOptions.substring(0, sortedOldOptions.length() - "timeout=-1 ".length());
        }
        Assert.assertEquals((String)"Maps are different", (Object)sortedNewOptions, (Object)sortedOldOptions);
    }

    @Test
    public void testResize() {
        ImageTransformationOptions oldOptions = new ImageTransformationOptions();
        ImageResizeOptions imageResizeOptions = new ImageResizeOptions();
        imageResizeOptions.setAllowEnlargement(false);
        imageResizeOptions.setWidth(20);
        imageResizeOptions.setHeight(30);
        oldOptions.setResizeOptions(imageResizeOptions);
        PagedSourceOptions pagedSourceOptions = new PagedSourceOptions();
        pagedSourceOptions.setStartPageNumber(Integer.valueOf(1));
        pagedSourceOptions.setEndPageNumber(Integer.valueOf(1));
        oldOptions.addSourceOptions((TransformationSourceOptions)pagedSourceOptions);
        this.assertConverterToMapAndBack((TransformationOptions)oldOptions, "image/jpeg", "image/png", "ImageTransformationOptions [commandOptions=, resizeOptions=ImageResizeOptions [width=20, height=30, maintainAspectRatio=true, percentResize=false, resizeToThumbnail=false, allowEnlargement=false], autoOrient=true], sourceOptions={ PagedSourceOptionsPagedSourceOptions {1, 1}} ]", "allowEnlargement=false autoOrient=true endPage=0 resizeHeight=30 resizeWidth=20 startPage=0 timeout=-1 ");
    }

    @Test
    public void testCommandOptionsFromOldOptions() {
        ImageTransformationOptions oldOptions = new ImageTransformationOptions();
        oldOptions.setCommandOptions("-resize 350x50> -background none -gravity center");
        this.assertConverterToMapAndBack((TransformationOptions)oldOptions, "image/jpeg", "image/png", "ImageTransformationOptions [commandOptions=-resize 350x50> -background none -gravity center, resizeOptions=null, autoOrient=true]]", "autoOrient=true commandOptions=-resize 350x50> -background none -gravity center timeout=-1 ");
    }
}

