/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transaction;

import jakarta.transaction.UserTransaction;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.VmShutdownListener;
import org.alfresco.util.transaction.SpringAwareUserTransaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.transaction.PlatformTransactionManager;

public class TransactionServiceImpl
implements TransactionService {
    private static VmShutdownListener shutdownListener = new VmShutdownListener("TransactionService");
    private PlatformTransactionManager transactionManager;
    private int maxRetries = -1;
    private int minRetryWaitMs = -1;
    private int maxRetryWaitMs = -1;
    private int retryWaitIncrementMs = -1;
    private static final Log logger = LogFactory.getLog(TransactionServiceImpl.class);
    private Set<QName> writeVeto = new HashSet<QName>();
    private final QName generalVetoName = QName.createQName((String)"http://www.alfresco.org/model/application/1.0", (String)"GeneralVeto");
    private ReentrantReadWriteLock.ReadLock vetoReadLock;
    private ReentrantReadWriteLock.WriteLock vetoWriteLock;

    public TransactionServiceImpl() {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.vetoReadLock = lock.readLock();
        this.vetoWriteLock = lock.writeLock();
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    @Override
    public boolean getAllowWrite() {
        this.vetoReadLock.lock();
        try {
            boolean bl = this.writeVeto.isEmpty();
            return bl;
        }
        finally {
            this.vetoReadLock.unlock();
        }
    }

    public void setAllowWrite(boolean allowWrite) {
        this.setAllowWrite(allowWrite, this.generalVetoName);
    }

    public void setAllowWrite(boolean allowWrite, QName nameOfVeto) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("setAllowWrite:" + allowWrite + ". Name of veto:" + nameOfVeto));
        }
        this.vetoWriteLock.lock();
        try {
            if (allowWrite) {
                boolean removed = this.writeVeto.remove(nameOfVeto);
                if (removed) {
                    logger.warn((Object)("setAllowWrite:" + allowWrite + ".  Removing veto on write operations: " + nameOfVeto));
                }
            } else {
                this.writeVeto.add(nameOfVeto);
                logger.warn((Object)("setAllowWrite:" + allowWrite + ".  Applying veto on write operations: " + nameOfVeto));
            }
        }
        finally {
            this.vetoWriteLock.unlock();
        }
    }

    @Override
    public boolean isReadOnly() {
        if (shutdownListener.isVmShuttingDown()) {
            return true;
        }
        this.vetoReadLock.lock();
        try {
            if (AuthenticationUtil.isRunAsUserTheSystemUser()) {
                return false;
            }
            boolean bl = !this.writeVeto.isEmpty();
            return bl;
        }
        finally {
            this.vetoReadLock.unlock();
        }
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public void setMinRetryWaitMs(int minRetryWaitMs) {
        this.minRetryWaitMs = minRetryWaitMs;
    }

    public void setMaxRetryWaitMs(int maxRetryWaitMs) {
        this.maxRetryWaitMs = maxRetryWaitMs;
    }

    public void setRetryWaitIncrementMs(int retryWaitIncrementMs) {
        this.retryWaitIncrementMs = retryWaitIncrementMs;
    }

    @Override
    public UserTransaction getUserTransaction() {
        return this.getUserTransaction(false, false);
    }

    @Override
    public UserTransaction getUserTransaction(boolean readOnly) {
        return this.getUserTransaction(readOnly, false);
    }

    @Override
    public UserTransaction getUserTransaction(boolean readOnly, boolean ignoreSystemReadOnly) {
        if (ignoreSystemReadOnly) {
            SpringAwareUserTransaction txn = new SpringAwareUserTransaction(this.transactionManager, readOnly, -1, 0, -1);
            return txn;
        }
        SpringAwareUserTransaction txn = new SpringAwareUserTransaction(this.transactionManager, readOnly | this.isReadOnly(), -1, 0, -1);
        return txn;
    }

    @Override
    public UserTransaction getNonPropagatingUserTransaction() {
        return this.getNonPropagatingUserTransaction(false, false);
    }

    @Override
    public UserTransaction getNonPropagatingUserTransaction(boolean readOnly) {
        return this.getNonPropagatingUserTransaction(readOnly, false);
    }

    @Override
    public UserTransaction getNonPropagatingUserTransaction(boolean readOnly, boolean ignoreSystemReadOnly) {
        if (ignoreSystemReadOnly) {
            SpringAwareUserTransaction txn = new SpringAwareUserTransaction(this.transactionManager, readOnly, -1, 3, -1);
            return txn;
        }
        SpringAwareUserTransaction txn = new SpringAwareUserTransaction(this.transactionManager, readOnly | this.isReadOnly(), -1, 3, -1);
        return txn;
    }

    @Override
    public RetryingTransactionHelper getRetryingTransactionHelper() {
        RetryingTransactionHelper helper = new RetryingTransactionHelper();
        helper.setTransactionService(this);
        helper.setReadOnly(this.isReadOnly());
        if (this.maxRetries >= 0) {
            helper.setMaxRetries(this.maxRetries);
        }
        if (this.minRetryWaitMs > 0) {
            helper.setMinRetryWaitMs(this.minRetryWaitMs);
        }
        if (this.maxRetryWaitMs > 0) {
            helper.setMaxRetryWaitMs(this.maxRetryWaitMs);
        }
        if (this.retryWaitIncrementMs > 0) {
            helper.setRetryWaitIncrementMs(this.retryWaitIncrementMs);
        }
        return helper;
    }
}

