/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.solr;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.index.shard.ShardRegistry;
import org.alfresco.repo.search.QueryParserException;
import org.alfresco.repo.search.impl.JSONAPIResult;
import org.alfresco.repo.search.impl.JSONAPIResultFactory;
import org.alfresco.repo.search.impl.solr.AbstractSolrAdminHTTPClient;
import org.alfresco.repo.search.impl.solr.ExplicitSolrStoreMappingWrapper;
import org.alfresco.repo.search.impl.solr.SolrActionStatusResult;
import org.alfresco.repo.search.impl.solr.SolrAdminClientInterface;
import org.alfresco.repo.search.impl.solr.SolrClientUtil;
import org.alfresco.repo.search.impl.solr.SolrCommandBackupResult;
import org.alfresco.repo.search.impl.solr.SolrStoreMapping;
import org.alfresco.repo.search.impl.solr.SolrStoreMappingWrapper;
import org.alfresco.repo.solr.SOLRWatcherJob;
import org.alfresco.repo.solr.SolrActiveEvent;
import org.alfresco.repo.solr.SolrInactiveEvent;
import org.alfresco.service.cmr.repository.StoreRef;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.net.URLCodec;
import org.apache.commons.httpclient.HttpClient;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;

public class SOLRAdminClient
extends AbstractSolrAdminHTTPClient
implements ApplicationEventPublisherAware,
DisposableBean,
SolrAdminClientInterface {
    private String solrPingCronExpression;
    private String baseUrl;
    private ApplicationEventPublisher applicationEventPublisher;
    private SolrTracker solrTracker;
    private Scheduler scheduler;
    private List<SolrStoreMapping> storeMappings;
    private HashMap<StoreRef, SolrStoreMappingWrapper> mappingLookup = new HashMap();
    private BeanFactory beanFactory;
    private ShardRegistry shardRegistry;
    private boolean useDynamicShardRegistration;

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public void setSolrPingCronExpression(String solrPingCronExpression) {
        this.solrPingCronExpression = solrPingCronExpression;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public void setStoreMappings(List<SolrStoreMapping> storeMappings) {
        this.storeMappings = storeMappings;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void setShardRegistry(ShardRegistry shardRegistry) {
        this.shardRegistry = shardRegistry;
    }

    public void setUseDynamicShardRegistration(boolean useDynamicShardRegistration) {
        this.useDynamicShardRegistration = useDynamicShardRegistration;
    }

    public void afterPropertiesSet() throws Exception {
        this.mappingLookup.clear();
        for (SolrStoreMapping mapping : this.storeMappings) {
            this.mappingLookup.put(mapping.getStoreRef(), new ExplicitSolrStoreMappingWrapper(mapping, this.beanFactory));
        }
    }

    public void init() {
        this.solrTracker = new SolrTracker(this.scheduler);
    }

    @Override
    public JSONAPIResult executeAction(String core, JSONAPIResultFactory.ACTION action, Map<String, String> parameters) {
        StoreRef store = StoreRef.STORE_REF_WORKSPACE_SPACESSTORE;
        SolrStoreMappingWrapper mapping = SolrClientUtil.extractMapping(store, this.mappingLookup, this.shardRegistry, this.useDynamicShardRegistration, this.beanFactory);
        HttpClient httpClient = (HttpClient)mapping.getHttpClientAndBaseUrl().getFirst();
        StringBuilder url = new StringBuilder();
        url.append(this.baseUrl);
        if (!url.toString().endsWith("/")) {
            url.append("/");
        }
        url.append("admin/cores");
        URLCodec encoder = new URLCodec();
        url.append("?action=" + (Object)((Object)action));
        parameters.forEach((key, value) -> {
            try {
                url.append("&" + key + "=" + encoder.encode(value));
            }
            catch (EncoderException e) {
                throw new RuntimeException(e);
            }
        });
        url.append("&alfresco.shards=");
        if (mapping.isSharded()) {
            url.append(mapping.getShards());
        } else {
            String solrurl = String.valueOf(httpClient.getHostConfiguration().getHostURL()) + (String)mapping.getHttpClientAndBaseUrl().getSecond();
            url.append(solrurl);
        }
        if (core != null) {
            url.append("&core=" + core);
        }
        try {
            return JSONAPIResultFactory.buildActionResult(action, this.getOperation(httpClient, url.toString()));
        }
        catch (IOException e) {
            throw new QueryParserException("action", e);
        }
    }

    @Override
    public JSONAPIResult executeCommand(String core, JSONAPIResultFactory.HANDLER handler, JSONAPIResultFactory.COMMAND command, Map<String, String> parameters) {
        StoreRef store = StoreRef.STORE_REF_WORKSPACE_SPACESSTORE;
        SolrStoreMappingWrapper mapping = SolrClientUtil.extractMapping(store, this.mappingLookup, this.shardRegistry, this.useDynamicShardRegistration, this.beanFactory);
        HttpClient httpClient = (HttpClient)mapping.getHttpClientAndBaseUrl().getFirst();
        StringBuilder url = new StringBuilder();
        url.append(this.baseUrl);
        if (!url.toString().endsWith("/")) {
            url.append("/");
        }
        url.append(String.valueOf(core) + "/" + handler.toString().toLowerCase());
        URLCodec encoder = new URLCodec();
        url.append("?command=" + command.toString().toLowerCase());
        parameters.forEach((key, value) -> {
            try {
                url.append("&" + key + "=" + encoder.encode(value));
            }
            catch (EncoderException e) {
                throw new RuntimeException(e);
            }
        });
        url.append("&alfresco.shards=");
        if (mapping.isSharded()) {
            url.append(mapping.getShards());
        } else {
            String solrurl = String.valueOf(httpClient.getHostConfiguration().getHostURL()) + (String)mapping.getHttpClientAndBaseUrl().getSecond();
            url.append(solrurl);
        }
        try {
            SolrCommandBackupResult response = new SolrCommandBackupResult(this.getOperation(httpClient, url.toString()));
            if (response.getStatus() != 0L) {
                this.solrTracker.setSolrActive(false);
            }
            return response;
        }
        catch (IOException e) {
            throw new QueryParserException("action", e);
        }
    }

    public List<String> getRegisteredCores() {
        return this.solrTracker.getRegisteredCores();
    }

    public void destroy() throws Exception {
        this.solrTracker.stopTimer();
    }

    class SolrTracker {
        private final ReentrantReadWriteLock.WriteLock writeLock;
        private boolean solrActive = false;
        private Scheduler scheduler = null;
        private Trigger trigger;
        private List<String> cores;

        SolrTracker(Scheduler scheduler) {
            this.scheduler = scheduler;
            ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
            this.writeLock = lock.writeLock();
            this.cores = new ArrayList<String>(5);
            this.setupTimer();
        }

        protected void pingSolr() {
            SolrActionStatusResult result = (SolrActionStatusResult)SOLRAdminClient.this.executeAction(null, JSONAPIResultFactory.ACTION.STATUS, SolrAdminClientInterface.JSON_PARAM);
            if (result != null) {
                this.registerCores(result.getCores());
                this.setSolrActive(true);
            } else {
                this.setSolrActive(false);
            }
        }

        void setSolrActive(boolean active) {
            boolean statusChanged = false;
            try {
                this.writeLock.lock();
                try {
                    if (this.solrActive != active) {
                        this.solrActive = active;
                        statusChanged = true;
                    }
                }
                finally {
                    this.writeLock.unlock();
                }
                if (statusChanged) {
                    if (this.solrActive) {
                        this.stopTimer();
                        SOLRAdminClient.this.applicationEventPublisher.publishEvent((ApplicationEvent)new SolrActiveEvent(this));
                    } else {
                        this.startTimer();
                        SOLRAdminClient.this.applicationEventPublisher.publishEvent((ApplicationEvent)new SolrInactiveEvent(this));
                    }
                }
            }
            catch (Exception e) {
                throw new AlfrescoRuntimeException("", (Throwable)e);
            }
        }

        boolean isSolrActive() {
            return this.solrActive;
        }

        protected void setupTimer() {
            try {
                JobDetail existingJob = this.scheduler.getJobDetail(new JobKey("SolrWatcher", "Solr"));
                if (existingJob != null) {
                    this.scheduler.deleteJob(existingJob.getKey());
                }
                JobDataMap jobDataMap = new JobDataMap();
                jobDataMap.put("SOLR_TRACKER", (Object)this);
                JobDetail jobDetail = JobBuilder.newJob().withIdentity("SolrWatcher", "Solr").usingJobData(jobDataMap).ofType(SOLRWatcherJob.class).build();
                this.trigger = TriggerBuilder.newTrigger().withIdentity("rmt").withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)SOLRAdminClient.this.solrPingCronExpression)).build();
                this.scheduler.scheduleJob(jobDetail, this.trigger);
            }
            catch (Exception e) {
                throw new AlfrescoRuntimeException("Unable to set up SOLRTracker timer", (Throwable)e);
            }
        }

        protected void startTimer() throws SchedulerException {
            this.scheduler.resumeTrigger(this.trigger.getKey());
        }

        protected void stopTimer() throws SchedulerException {
            this.scheduler.pauseTrigger(this.trigger.getKey());
        }

        void registerCores(List<String> cores) {
            this.writeLock.lock();
            try {
                this.cores = cores;
            }
            finally {
                this.writeLock.unlock();
            }
        }

        List<String> getRegisteredCores() {
            this.writeLock.lock();
            try {
                List<String> list = this.cores != null ? this.cores : Collections.EMPTY_LIST;
                return list;
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }
}

