/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rendition2;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.rendition2.RenditionEventProcessor;
import org.alfresco.repo.rendition2.RenditionService2Impl;
import org.alfresco.repo.rendition2.TransformDefinition;
import org.alfresco.repo.rendition2.TransformRequest;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ParameterCheck;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TransformRequestProcessor
implements Processor {
    private static Log logger = LogFactory.getLog(RenditionEventProcessor.class);
    private RenditionService2Impl renditionService2;
    private ObjectMapper messagingObjectMapper;
    private TransactionService transactionService;

    public void setRenditionService2(RenditionService2Impl renditionService2) {
        this.renditionService2 = renditionService2;
    }

    public void setMessagingObjectMapper(ObjectMapper messagingObjectMapper) {
        this.messagingObjectMapper = messagingObjectMapper;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void process(Exchange exchange) throws Exception {
        String body = (String)exchange.getMessage().getBody();
        if (logger.isDebugEnabled()) {
            logger.info((Object)("Processing message [thread=" + Thread.currentThread().getId() + ", body=" + body + "]"));
        }
        if (body == null || body.isEmpty()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Exchange message is null or empty");
            }
            return;
        }
        try {
            TransformRequest event;
            try {
                event = (TransformRequest)this.messagingObjectMapper.readValue(body, TransformRequest.class);
            }
            catch (IOException e) {
                logger.error((Object)("Failed to unmarshal event [" + body + "]"), (Throwable)e);
                throw new AlfrescoRuntimeException("Failed to unmarshal event, skipping processing of this event.");
            }
            this.processEvent(event);
        }
        catch (Exception e) {
            logger.error((Object)("Failed to process transform request event: " + body), (Throwable)e);
        }
    }

    private void validateEvent(TransformRequest event) {
        ParameterCheck.mandatory((String)"event", (Object)event);
        ParameterCheck.mandatoryString((String)"requestId", (String)event.getRequestId());
        ParameterCheck.mandatoryString((String)"nodeRef", (String)event.getNodeRef());
        ParameterCheck.mandatoryString((String)"targetMediaType", (String)event.getTargetMediaType());
        ParameterCheck.mandatoryString((String)"replyQueue", (String)event.getReplyQueue());
    }

    private void processEvent(TransformRequest event) {
        this.validateEvent(event);
        String transformName = event.getTransformName();
        String targetMediaType = event.getTargetMediaType();
        Map<String, String> transformOptions = event.getTransformOptions();
        String clientData = event.getClientData();
        String replyQueue = this.processReplyQueue(event.getReplyQueue());
        String requestId = event.getRequestId();
        TransformDefinition transformDefinition = new TransformDefinition(transformName, targetMediaType, transformOptions, clientData, replyQueue, requestId, null);
        NodeRef nodeRef = new NodeRef(event.getNodeRef());
        AuthenticationUtil.runAs(() -> this.transactionService.getRetryingTransactionHelper().doInTransaction(() -> {
            this.renditionService2.transform(nodeRef, transformDefinition);
            return null;
        }), (String)AuthenticationUtil.getSystemUserName());
    }

    String processReplyQueue(String replyQueue) {
        return replyQueue.startsWith("jms:") ? replyQueue.substring("jms:".length()) : (replyQueue.startsWith("queue://") ? replyQueue.substring("queue://".length()) : replyQueue);
    }
}

