/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.model.filefolder;

import java.io.Serializable;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;
import org.alfresco.api.AlfrescoPublicApi;
import org.alfresco.model.ContentModel;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.model.filefolder.ConfigurableHiddenFileInfo;
import org.alfresco.repo.model.filefolder.FileInfoImpl;
import org.alfresco.repo.model.filefolder.HiddenFileFilter;
import org.alfresco.repo.model.filefolder.HiddenFileInfo;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileFolderServiceType;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.FileFilterMode;
import org.alfresco.util.SearchLanguageConversion;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@AlfrescoPublicApi
public class HiddenAspect {
    private static Log logger = LogFactory.getLog(HiddenAspect.class);
    public static Set<QName> HIDDEN_PROPERTIES = new HashSet<QName>();
    private List<HiddenFileInfo> filters = new ArrayList<HiddenFileInfo>(10);
    private NodeService nodeService;
    private FileFolderService fileFolderService;
    private SearchService searchService;
    private PolicyComponent policyComponent;
    private BehaviourFilter behaviourFilter;

    static {
        HIDDEN_PROPERTIES.add(ContentModel.PROP_CLIENT_CONTROLLED);
        HIDDEN_PROPERTIES.add(ContentModel.PROP_CASCADE_HIDDEN);
        HIDDEN_PROPERTIES.add(ContentModel.PROP_CASCADE_INDEX_CONTROL);
        HIDDEN_PROPERTIES.add(ContentModel.PROP_VISIBILITY_MASK);
    }

    public void setBehaviourFilter(BehaviourFilter behaviourFilter) {
        this.behaviourFilter = behaviourFilter;
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setPatterns(List<HiddenFileFilter> filters) {
        for (HiddenFileFilter filter : filters) {
            this.filters.add(new HiddenFileInfoImpl(filter.getFilter(), filter.getVisibility(), filter.getHiddenAttribute(), filter.cascadeHiddenAspect(), filter.cascadeIndexControlAspect(), filter.isCmisDisableHideConfig()));
        }
    }

    public void init() {
    }

    public List<HiddenFileInfo> getPatterns() {
        return this.filters;
    }

    public FileFilterMode.Client[] getClients() {
        return FileFilterMode.Client.values();
    }

    private ResultSet searchForName(StoreRef storeRef, String name) {
        SearchParameters sp = new SearchParameters();
        sp.addStore(storeRef);
        sp.setLanguage("lucene");
        sp.setQuery("@" + SearchLanguageConversion.escapeLuceneQuery((String)ContentModel.PROP_NAME.toString()) + ":\"" + name + "\"");
        sp.addLocale(new Locale("en"));
        return this.searchService.query(sp);
    }

    private Integer getClientIndex(FileFilterMode.Client client) {
        return client.ordinal();
    }

    private void addIndexControlAspect(NodeRef nodeRef) {
        HashMap<QName, Boolean> props = new HashMap<QName, Boolean>(2);
        props.put(ContentModel.PROP_IS_INDEXED, Boolean.FALSE);
        props.put(ContentModel.PROP_IS_CONTENT_INDEXED, Boolean.FALSE);
        this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_INDEX_CONTROL, props);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Applied index control marker: " + nodeRef));
        }
    }

    private void removeIndexControlAspect(NodeRef nodeRef) {
        this.nodeService.removeAspect(nodeRef, ContentModel.ASPECT_INDEX_CONTROL);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Removed index control marker: " + nodeRef));
        }
    }

    public void hideNodeExplicit(NodeRef nodeRef) {
        int mask = 0;
        mask |= this.getClientVisibilityMask(FileFilterMode.Client.cifs, Visibility.HiddenAttribute);
        mask |= this.getClientVisibilityMask(FileFilterMode.Client.webdav, Visibility.Visible);
        mask |= this.getClientVisibilityMask(FileFilterMode.Client.nfs, Visibility.Visible);
        this.addHiddenAspect(nodeRef, mask |= this.getClientVisibilityMask(FileFilterMode.Client.ftp, Visibility.Visible), true);
    }

    public void unhideExplicit(NodeRef nodeRef) {
        this.nodeService.setProperty(nodeRef, ContentModel.PROP_HIDDEN_FLAG, (Serializable)Boolean.valueOf(false));
        this.checkHidden(nodeRef, true, false);
    }

    private void addHiddenAspect(NodeRef nodeRef, int visibilityMask, boolean explicit) {
        HashMap<QName, Constable> props = new HashMap<QName, Constable>(1);
        props.put(ContentModel.PROP_VISIBILITY_MASK, Integer.valueOf(visibilityMask));
        props.put(ContentModel.PROP_HIDDEN_FLAG, Boolean.valueOf(explicit));
        this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_HIDDEN, props);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Applied hidden marker: " + nodeRef));
        }
    }

    private void addHiddenAspect(NodeRef nodeRef, int visibilityMask, boolean cascadeHiddenAspect, boolean cascadeIndexControlAspect, boolean clientControlled) {
        HashMap<QName, Constable> props = new HashMap<QName, Constable>(1);
        props.put(ContentModel.PROP_VISIBILITY_MASK, Integer.valueOf(visibilityMask));
        props.put(ContentModel.PROP_CASCADE_HIDDEN, Boolean.valueOf(cascadeHiddenAspect));
        props.put(ContentModel.PROP_CASCADE_INDEX_CONTROL, Boolean.valueOf(cascadeIndexControlAspect));
        props.put(ContentModel.PROP_CLIENT_CONTROLLED, Boolean.valueOf(clientControlled));
        this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_HIDDEN, props);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Applied hidden marker: " + nodeRef));
        }
    }

    private void addHiddenAspect(NodeRef nodeRef, HiddenFileInfo filter) {
        HashMap<QName, Constable> props = new HashMap<QName, Constable>(1);
        props.put(ContentModel.PROP_VISIBILITY_MASK, Integer.valueOf(filter.getVisibilityMask()));
        props.put(ContentModel.PROP_CASCADE_HIDDEN, Boolean.valueOf(filter.cascadeHiddenAspect()));
        props.put(ContentModel.PROP_CASCADE_INDEX_CONTROL, Boolean.valueOf(filter.cascadeIndexControlAspect()));
        props.put(ContentModel.PROP_CLIENT_CONTROLLED, Boolean.valueOf(filter.isClientControlled()));
        this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_HIDDEN, props);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Applied hidden marker: " + nodeRef));
        }
    }

    public void removeHiddenAspect(NodeRef nodeRef) {
        this.nodeService.removeAspect(nodeRef, ContentModel.ASPECT_HIDDEN);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Removed hidden marker: " + nodeRef));
        }
    }

    private Visibility getVisibility(Integer mask, FileFilterMode.Client client) {
        if (mask == null || mask == 0) {
            return Visibility.NotVisible;
        }
        mask = mask >> this.getClientIndex(client) * 2 & 3;
        return Visibility.getVisibility(mask);
    }

    private HiddenFileInfo isHidden(String name) {
        HiddenFileInfo matched = null;
        for (HiddenFileInfo filter : this.filters) {
            if (!filter.isHidden(name)) continue;
            matched = filter;
            break;
        }
        return matched;
    }

    public boolean hasHiddenAspect(NodeRef nodeRef) {
        return this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_HIDDEN);
    }

    private boolean hasIndexControlAspect(NodeRef nodeRef) {
        return this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_INDEX_CONTROL);
    }

    private void applyHidden(FileInfo fileInfo, HiddenFileInfo filter) {
        NodeRef nodeRef = fileInfo.getNodeRef();
        if (!this.hasHiddenAspect(nodeRef)) {
            this.addHiddenAspect(nodeRef, filter);
        } else {
            this.nodeService.setProperty(nodeRef, ContentModel.PROP_VISIBILITY_MASK, (Serializable)Integer.valueOf(filter.getVisibilityMask()));
            this.nodeService.setProperty(nodeRef, ContentModel.PROP_CASCADE_HIDDEN, (Serializable)Boolean.valueOf(filter.cascadeHiddenAspect()));
            this.nodeService.setProperty(nodeRef, ContentModel.PROP_CASCADE_INDEX_CONTROL, (Serializable)Boolean.valueOf(filter.cascadeIndexControlAspect()));
        }
        if (!this.hasIndexControlAspect(nodeRef)) {
            this.addIndexControlAspect(nodeRef);
        }
        if (fileInfo.isFolder() && (filter.cascadeHiddenAspect() || filter.cascadeIndexControlAspect())) {
            PagingRequest pagingRequest = new PagingRequest(0, Integer.MAX_VALUE, null);
            PagingResults<FileInfo> results = this.fileFolderService.list(nodeRef, true, true, null, null, pagingRequest);
            List files = results.getPage();
            for (FileInfo file : files) {
                this.behaviourFilter.disableBehaviour(file.getNodeRef(), ContentModel.ASPECT_LOCKABLE);
                try {
                    this.applyHidden(file, filter);
                }
                finally {
                    this.behaviourFilter.enableBehaviour(file.getNodeRef(), ContentModel.ASPECT_LOCKABLE);
                }
            }
        }
    }

    private void applyHidden(NodeRef nodeRef, HiddenFileInfo filter, boolean checkChildren) {
        QName typeQName;
        FileFolderServiceType type;
        boolean isFolder;
        if (!this.hasHiddenAspect(nodeRef)) {
            this.addHiddenAspect(nodeRef, filter);
        } else {
            this.nodeService.setProperty(nodeRef, ContentModel.PROP_VISIBILITY_MASK, (Serializable)Integer.valueOf(filter.getVisibilityMask()));
            this.nodeService.setProperty(nodeRef, ContentModel.PROP_CASCADE_HIDDEN, (Serializable)Boolean.valueOf(filter.cascadeHiddenAspect()));
            this.nodeService.setProperty(nodeRef, ContentModel.PROP_CASCADE_INDEX_CONTROL, (Serializable)Boolean.valueOf(filter.cascadeIndexControlAspect()));
        }
        if (!this.hasIndexControlAspect(nodeRef)) {
            this.addIndexControlAspect(nodeRef);
        }
        boolean bl = isFolder = (type = this.fileFolderService.getType(typeQName = this.nodeService.getType(nodeRef))).equals((Object)FileFolderServiceType.FOLDER) || type.equals((Object)FileFolderServiceType.SYSTEM_FOLDER);
        if (isFolder && checkChildren && (filter.cascadeHiddenAspect() || filter.cascadeIndexControlAspect())) {
            PagingRequest pagingRequest = new PagingRequest(0, Integer.MAX_VALUE, null);
            PagingResults<FileInfo> results = this.fileFolderService.list(nodeRef, true, true, null, null, pagingRequest);
            List files = results.getPage();
            for (FileInfo file : files) {
                this.behaviourFilter.disableBehaviour(file.getNodeRef(), ContentModel.ASPECT_LOCKABLE);
                try {
                    this.applyHidden(file, filter);
                }
                finally {
                    this.behaviourFilter.enableBehaviour(file.getNodeRef(), ContentModel.ASPECT_LOCKABLE);
                }
            }
        }
    }

    public void removeHidden(NodeRef nodeRef) {
        FileFilterMode.Client saveClient = FileFilterMode.getClient();
        FileFilterMode.setClient((FileFilterMode.Client)FileFilterMode.Client.admin);
        try {
            PagingRequest pagingRequest = new PagingRequest(0, Integer.MAX_VALUE, null);
            PagingResults<FileInfo> results = this.fileFolderService.list(nodeRef, true, true, null, null, pagingRequest);
            List files = results.getPage();
            for (FileInfo file : files) {
                String name = (String)((Object)this.nodeService.getProperty(file.getNodeRef(), ContentModel.PROP_NAME));
                if (this.isHidden(name) != null) continue;
                this.behaviourFilter.disableBehaviour(file.getNodeRef(), ContentModel.ASPECT_LOCKABLE);
                try {
                    if (this.hasHiddenAspect(file.getNodeRef())) {
                        this.removeHiddenAspect(file.getNodeRef());
                    }
                    if (this.hasIndexControlAspect(file.getNodeRef())) {
                        this.removeIndexControlAspect(file.getNodeRef());
                    }
                }
                finally {
                    this.behaviourFilter.enableBehaviour(file.getNodeRef(), ContentModel.ASPECT_LOCKABLE);
                }
                if (!file.isFolder()) continue;
                this.removeHidden(file.getNodeRef());
            }
        }
        finally {
            FileFilterMode.setClient((FileFilterMode.Client)saveClient);
        }
    }

    private HiddenFileInfo findMatch(NodeRef nodeRef) {
        HiddenFileInfo ret = null;
        Path path = null;
        String name = null;
        block0: for (HiddenFileInfo filter : this.filters) {
            if (FileFilterMode.Client.cmis.equals((Object)FileFilterMode.getClient()) && filter instanceof ConfigurableHiddenFileInfo && ((ConfigurableHiddenFileInfo)filter).isCmisDisableHideConfig()) continue;
            if (filter.cascadeHiddenAspect() || filter.cascadeIndexControlAspect()) {
                if (path == null) {
                    path = this.nodeService.getPath(nodeRef);
                }
                for (Path.ChildAssocElement elem : path) {
                    QName qname = elem.getRef().getQName();
                    if (qname == null || !filter.isHidden(qname.getLocalName())) continue;
                    ret = filter;
                    break block0;
                }
                continue;
            }
            if (name == null) {
                name = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_NAME));
            }
            if (!filter.isHidden(name)) continue;
            ret = filter;
            break;
        }
        return ret;
    }

    public int getClientVisibilityMask(FileFilterMode.Client client, Visibility visibility) {
        return visibility.getMask() << this.getClientIndex(client) * 2;
    }

    public HiddenFileInfo onHiddenPath(NodeRef nodeRef) {
        HiddenFileInfo ret = null;
        Path path = this.nodeService.getPath(nodeRef);
        this.nodeService.getProperty(nodeRef, ContentModel.PROP_NAME);
        for (Path.ChildAssocElement elem : path) {
            QName qname = elem.getRef().getQName();
            if (qname != null && (ret = this.isHidden(qname.getLocalName())) != null) break;
        }
        return ret;
    }

    public void hideNode(NodeRef nodeRef, boolean cascadeHiddenAspect, boolean cascadeIndexControlAspect, boolean clientControlled) {
        this.addHiddenAspect(nodeRef, 0, cascadeHiddenAspect, cascadeIndexControlAspect, clientControlled);
        this.addIndexControlAspect(nodeRef);
    }

    public void showNode(NodeRef nodeRef, boolean cascade) {
        this.removeHiddenAspect(nodeRef);
        this.removeIndexControlAspect(nodeRef);
        if (cascade) {
            for (ChildAssociationRef childRef : this.nodeService.getChildAssocs(nodeRef)) {
                this.showNode(childRef.getChildRef(), cascade);
            }
        }
    }

    public void hideNode(NodeRef nodeRef, int clientVisibilityMask, boolean cascadeHiddenAspect, boolean cascadeIndexControlAspect, boolean clientControlled) {
        this.addHiddenAspect(nodeRef, clientVisibilityMask, cascadeHiddenAspect, cascadeIndexControlAspect, clientControlled);
        this.addIndexControlAspect(nodeRef);
    }

    public void checkHidden(StoreRef storeRef) {
        for (HiddenFileInfo filter : this.filters) {
            String pattern = filter.getFilter();
            ResultSet rs = this.searchForName(storeRef, pattern);
            for (NodeRef nodeRef : rs.getNodeRefs()) {
                if (this.hasHiddenAspect(nodeRef)) continue;
                this.hideNode(nodeRef, filter.getVisibilityMask(), true, true, false);
            }
        }
    }

    public boolean checkHidden(FileInfo fileInfo, boolean both, boolean checkChildren) {
        NodeRef nodeRef = fileInfo.getNodeRef();
        boolean ret = this.checkHidden(nodeRef, both, checkChildren);
        return ret;
    }

    public void hideNode(FileInfoImpl fileInfo, int visibilityMask, boolean cascadeHiddenAspect, boolean cascadeIndexControlAspect, boolean clientControlled) {
        this.hideNode(fileInfo.getNodeRef(), visibilityMask, cascadeHiddenAspect, cascadeIndexControlAspect, clientControlled);
        fileInfo.setHidden(true);
    }

    private HiddenFileInfo isParentHidden(NodeRef nodeRef) {
        boolean isParentHidden;
        NodeRef primaryParentNodeRef;
        HiddenFileInfo info = null;
        ChildAssociationRef childAssocRef = this.nodeService.getPrimaryParent(nodeRef);
        if (childAssocRef != null && (primaryParentNodeRef = childAssocRef.getParentRef()) != null && (isParentHidden = this.hasHiddenAspect(primaryParentNodeRef))) {
            final Integer visibilityMask = (Integer)this.nodeService.getProperty(primaryParentNodeRef, ContentModel.PROP_VISIBILITY_MASK);
            final Boolean cascadeHidden = (Boolean)this.nodeService.getProperty(primaryParentNodeRef, ContentModel.PROP_CASCADE_HIDDEN);
            final Boolean cascadeIndexControl = (Boolean)this.nodeService.getProperty(primaryParentNodeRef, ContentModel.PROP_CASCADE_HIDDEN);
            final Boolean clientControlled = (Boolean)this.nodeService.getProperty(primaryParentNodeRef, ContentModel.PROP_CLIENT_CONTROLLED);
            info = new HiddenFileInfo(){

                @Override
                public boolean isHidden(String path) {
                    return false;
                }

                @Override
                public int getVisibilityMask() {
                    return visibilityMask != null ? visibilityMask : 0;
                }

                @Override
                public boolean isClientControlled() {
                    return clientControlled != null ? clientControlled : false;
                }

                @Override
                public String getFilter() {
                    return null;
                }

                @Override
                public boolean cascadeIndexControlAspect() {
                    return cascadeIndexControl != null ? cascadeIndexControl : false;
                }

                @Override
                public boolean cascadeHiddenAspect() {
                    return cascadeHidden != null ? cascadeHidden : false;
                }
            };
        }
        return info;
    }

    public boolean isClientControlled(NodeRef nodeRef) {
        Boolean clientControlled = (Boolean)this.nodeService.getProperty(nodeRef, ContentModel.PROP_CLIENT_CONTROLLED);
        return clientControlled != null && clientControlled != false;
    }

    public boolean checkHidden(NodeRef nodeRef, boolean both, boolean checkChildren) {
        Boolean isHiddenFlag;
        if (this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_HIDDEN) && (isHiddenFlag = (Boolean)this.nodeService.getProperty(nodeRef, ContentModel.PROP_HIDDEN_FLAG)) != null && isHiddenFlag.booleanValue()) {
            logger.debug((Object)"node has hidden flag set");
            return true;
        }
        boolean isHidden = false;
        if (this.hasHiddenAspect(nodeRef) && this.isClientControlled(nodeRef)) {
            isHidden = true;
        } else {
            HiddenFileInfo info = this.isParentHidden(nodeRef);
            if (info != null && info.cascadeHiddenAspect()) {
                isHidden = true;
                if (!this.hasHiddenAspect(nodeRef)) {
                    this.addHiddenAspect(nodeRef, info);
                }
                if (!this.hasIndexControlAspect(nodeRef)) {
                    this.addIndexControlAspect(nodeRef);
                }
                this.applyHidden(nodeRef, info, checkChildren);
            } else {
                info = this.findMatch(nodeRef);
                if (info != null) {
                    isHidden = true;
                    if (!this.hasHiddenAspect(nodeRef)) {
                        this.addHiddenAspect(nodeRef, info);
                    } else {
                        this.nodeService.setProperty(nodeRef, ContentModel.PROP_VISIBILITY_MASK, (Serializable)Integer.valueOf(info.getVisibilityMask()));
                        this.nodeService.setProperty(nodeRef, ContentModel.PROP_CASCADE_HIDDEN, (Serializable)Boolean.valueOf(info.cascadeHiddenAspect()));
                        this.nodeService.setProperty(nodeRef, ContentModel.PROP_CASCADE_INDEX_CONTROL, (Serializable)Boolean.valueOf(info.cascadeIndexControlAspect()));
                    }
                    if (!this.hasIndexControlAspect(nodeRef)) {
                        this.addIndexControlAspect(nodeRef);
                    }
                    this.applyHidden(nodeRef, info, checkChildren);
                } else if (both) {
                    if (this.hasHiddenAspect(nodeRef)) {
                        this.removeHiddenAspect(nodeRef);
                    }
                    if (this.hasIndexControlAspect(nodeRef)) {
                        this.removeIndexControlAspect(nodeRef);
                    }
                    this.removeHidden(nodeRef);
                }
            }
        }
        return isHidden;
    }

    public Visibility getVisibility(FileFilterMode.Client client, NodeRef nodeRef) {
        Visibility ret = Visibility.Visible;
        if (!AuthenticationUtil.isRunAsUserTheSystemUser() && this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_HIDDEN)) {
            Integer visibilityMask = (Integer)this.nodeService.getProperty(nodeRef, ContentModel.PROP_VISIBILITY_MASK);
            ret = visibilityMask != null ? (client != null && client.equals((Object)FileFilterMode.Client.admin) ? Visibility.Visible : (visibilityMask == 0 ? Visibility.NotVisible : (client == null ? Visibility.NotVisible : this.getVisibility((int)visibilityMask, client)))) : (client == FileFilterMode.Client.cifs ? Visibility.HiddenAttribute : (client == FileFilterMode.Client.webdav || client == FileFilterMode.Client.nfs || client == FileFilterMode.Client.imap ? Visibility.Visible : Visibility.NotVisible));
        }
        return ret;
    }

    private class HiddenFileInfoImpl
    implements ConfigurableHiddenFileInfo {
        private Pattern filter;
        private Set<FileFilterMode.Client> clientVisibility = new HashSet<FileFilterMode.Client>(10);
        private Set<FileFilterMode.Client> hiddenAttribute = new HashSet<FileFilterMode.Client>(10);
        private int visibilityMask;
        private boolean cascadeHiddenAspect;
        private boolean cascadeIndexControlAspect;
        private boolean cmisDisableHideConfig;

        public HiddenFileInfoImpl(String regexp, String visibility, String hiddenAttribute, boolean cascadeHiddenAspect, boolean cascadeIndexControlAspect) {
            this.filter = Pattern.compile(regexp);
            this.cascadeHiddenAspect = cascadeHiddenAspect;
            this.cascadeIndexControlAspect = cascadeIndexControlAspect;
            this.setVisibility(visibility);
            this.setHiddenAttribute(hiddenAttribute);
            this.calculateVisibilityMask();
        }

        public HiddenFileInfoImpl(String regexp, String visibility, String hiddenAttribute, boolean cascadeHiddenAspect, boolean cascadeIndexControlAspect, boolean cmisDisableHideConfig) {
            this(regexp, visibility, hiddenAttribute, cascadeHiddenAspect, cascadeIndexControlAspect);
            this.cmisDisableHideConfig = cmisDisableHideConfig;
        }

        private void setVisibility(String visibility) {
            if (visibility != null && !visibility.equals("")) {
                String[] stringArray = visibility.split(",");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String clientStr = stringArray[n2];
                    FileFilterMode.Client client = FileFilterMode.Client.getClient((String)clientStr);
                    this.clientVisibility.add(client);
                    ++n2;
                }
            }
        }

        private void setHiddenAttribute(String hiddenAttribute) {
            if (hiddenAttribute != null && !hiddenAttribute.equals("")) {
                String[] stringArray = hiddenAttribute.split(",");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String clientStr = stringArray[n2];
                    FileFilterMode.Client client = FileFilterMode.Client.getClient((String)clientStr);
                    this.hiddenAttribute.add(client);
                    ++n2;
                }
            }
        }

        private void calculateVisibilityMask() {
            this.visibilityMask = 0;
            FileFilterMode.Client[] clientArray = HiddenAspect.this.getClients();
            int n = clientArray.length;
            int n2 = 0;
            while (n2 < n) {
                FileFilterMode.Client client = clientArray[n2];
                this.visibilityMask = this.clientVisibility.contains(client) ? (this.visibilityMask |= HiddenAspect.this.getClientVisibilityMask(client, Visibility.Visible)) : (this.hiddenAttribute.contains(client) ? (this.visibilityMask |= HiddenAspect.this.getClientVisibilityMask(client, Visibility.HiddenAttribute)) : (this.visibilityMask |= HiddenAspect.this.getClientVisibilityMask(client, Visibility.NotVisible)));
                ++n2;
            }
        }

        @Override
        public String getFilter() {
            return this.filter.pattern();
        }

        @Override
        public int getVisibilityMask() {
            return this.visibilityMask;
        }

        @Override
        public boolean isHidden(String path) {
            return this.filter.matcher(path).matches();
        }

        @Override
        public boolean cascadeHiddenAspect() {
            return this.cascadeHiddenAspect;
        }

        @Override
        public boolean cascadeIndexControlAspect() {
            return this.cascadeIndexControlAspect;
        }

        @Override
        public boolean isClientControlled() {
            return false;
        }

        @Override
        public boolean isCmisDisableHideConfig() {
            return this.cmisDisableHideConfig;
        }

        @Override
        public void setCmisDisableHideConfig(boolean cmisDisableHideConfig) {
            this.cmisDisableHideConfig = cmisDisableHideConfig;
        }
    }

    public static enum Visibility {
        NotVisible,
        Visible,
        HiddenAttribute;


        public int getMask() {
            if (this == Visible) {
                return 2;
            }
            if (this == HiddenAttribute) {
                return 1;
            }
            if (this == NotVisible) {
                return 0;
            }
            throw new IllegalArgumentException();
        }

        public static Visibility getVisibility(int mask) {
            if (mask == 2) {
                return Visible;
            }
            if (mask == 1) {
                return HiddenAttribute;
            }
            if (mask == 0) {
                return NotVisible;
            }
            throw new IllegalArgumentException();
        }
    }
}

