/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.heartbeat;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.alfresco.heartbeat.HBBaseDataCollector;
import org.alfresco.heartbeat.datasender.HBData;
import org.alfresco.heartbeat.jobs.HeartBeatJobScheduler;
import org.alfresco.repo.descriptor.DescriptorDAO;
import org.alfresco.repo.management.subsystems.ChildApplicationContextFactory;
import org.alfresco.repo.management.subsystems.DefaultChildApplicationContextManager;
import org.alfresco.repo.mode.ServerModeProvider;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.usage.RepoUsageComponent;
import org.alfresco.service.cmr.audit.AuditService;
import org.alfresco.service.cmr.module.ModuleDetails;
import org.alfresco.service.cmr.module.ModuleService;
import org.alfresco.service.cmr.thumbnail.ThumbnailService;
import org.alfresco.service.cmr.webdav.WebDavService;
import org.alfresco.service.cmr.workflow.WorkflowAdminService;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.traitextender.SpringExtensionBundle;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;

public class ConfigurationDataCollector
extends HBBaseDataCollector
implements InitializingBean {
    private DescriptorDAO currentRepoDescriptorDAO;
    private static final Log logger = LogFactory.getLog(ConfigurationDataCollector.class);
    private SpringExtensionBundle smartFoldersBundle;
    private DataSource dataSource;
    private RepoUsageComponent repoUsageComponent;
    private ModuleService moduleService;
    private AuditService auditService;
    private TransactionService transactionService;
    private ThumbnailService thumbnailService;
    private WebDavService webdavService;
    private WorkflowAdminService workflowAdminService;
    private ChildApplicationContextFactory replicationSubsystem;
    private ChildApplicationContextFactory imapSubsystem;
    private ChildApplicationContextFactory inboundSMTPSubsystem;
    private ChildApplicationContextFactory activitiesFeedSubsystem;
    private ChildApplicationContextFactory fileServersSubsystem;
    private DefaultChildApplicationContextManager authenticationSubsystem;
    private ServerModeProvider serverModeProvider;

    public ConfigurationDataCollector(String collectorId, String collectorVersion, String cronExpression, HeartBeatJobScheduler hbJobScheduler) {
        super(collectorId, collectorVersion, cronExpression, hbJobScheduler);
    }

    public void setReplicationSubsystem(ChildApplicationContextFactory replicationSubsystem) {
        this.replicationSubsystem = replicationSubsystem;
    }

    public void setCurrentRepoDescriptorDAO(DescriptorDAO currentRepoDescriptorDAO) {
        this.currentRepoDescriptorDAO = currentRepoDescriptorDAO;
    }

    public void setSmartFoldersBundle(SpringExtensionBundle smartFoldersBundle) {
        this.smartFoldersBundle = smartFoldersBundle;
    }

    public void setAuthenticationSubsystem(DefaultChildApplicationContextManager authenticationSubsystem) {
        this.authenticationSubsystem = authenticationSubsystem;
    }

    public void setFileServersSubsystem(ChildApplicationContextFactory fileServersSubsystem) {
        this.fileServersSubsystem = fileServersSubsystem;
    }

    public void setActivitiesFeedSubsystem(ChildApplicationContextFactory activitiesFeedSubsystem) {
        this.activitiesFeedSubsystem = activitiesFeedSubsystem;
    }

    public void setInboundSMTPSubsystem(ChildApplicationContextFactory inboundSMTPSubsystem) {
        this.inboundSMTPSubsystem = inboundSMTPSubsystem;
    }

    public void setImapSubsystem(ChildApplicationContextFactory imapSubsystem) {
        this.imapSubsystem = imapSubsystem;
    }

    public void setWorkflowAdminService(WorkflowAdminService workflowAdminService) {
        this.workflowAdminService = workflowAdminService;
    }

    public void setWebdavService(WebDavService webdavService) {
        this.webdavService = webdavService;
    }

    public void setThumbnailService(ThumbnailService thumbnailService) {
        this.thumbnailService = thumbnailService;
    }

    public void setServerModeProvider(ServerModeProvider serverModeProvider) {
        this.serverModeProvider = serverModeProvider;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setRepoUsageComponent(RepoUsageComponent repoUsageComponent) {
        this.repoUsageComponent = repoUsageComponent;
    }

    public void setModuleService(ModuleService moduleService) {
        this.moduleService = moduleService;
    }

    public void setAuditService(AuditService auditService) {
        this.auditService = auditService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void afterPropertiesSet() throws Exception {
        PropertyCheck.mandatory((Object)this, (String)"currentRepoDescriptorDAO", (Object)this.currentRepoDescriptorDAO);
        PropertyCheck.mandatory((Object)this, (String)"smartFoldersBundle", (Object)this.smartFoldersBundle);
        PropertyCheck.mandatory((Object)this, (String)"dataSource", (Object)this.dataSource);
        PropertyCheck.mandatory((Object)this, (String)"repoUsageComponent", (Object)this.repoUsageComponent);
        PropertyCheck.mandatory((Object)this, (String)"moduleService", (Object)this.moduleService);
        PropertyCheck.mandatory((Object)this, (String)"auditService", (Object)this.auditService);
        PropertyCheck.mandatory((Object)this, (String)"transactionService", (Object)this.transactionService);
        PropertyCheck.mandatory((Object)this, (String)"thumbnailService", (Object)this.thumbnailService);
        PropertyCheck.mandatory((Object)this, (String)"webdavService", (Object)this.webdavService);
        PropertyCheck.mandatory((Object)this, (String)"workflowAdminService", (Object)this.workflowAdminService);
        PropertyCheck.mandatory((Object)this, (String)"replicationSubsystem", (Object)this.replicationSubsystem);
        PropertyCheck.mandatory((Object)this, (String)"imapSubsystem", (Object)this.imapSubsystem);
        PropertyCheck.mandatory((Object)this, (String)"inboundSMTPSubsystem", (Object)this.inboundSMTPSubsystem);
        PropertyCheck.mandatory((Object)this, (String)"serverModeProvider", (Object)this.serverModeProvider);
        PropertyCheck.mandatory((Object)this, (String)"activitiesFeedSubsystem", (Object)this.activitiesFeedSubsystem);
        PropertyCheck.mandatory((Object)this, (String)"fileServersSubsystem", (Object)this.fileServersSubsystem);
        PropertyCheck.mandatory((Object)this, (String)"authenticationSubsystem", (Object)this.authenticationSubsystem);
    }

    @Override
    public List<HBData> collectData() {
        logger.debug((Object)"Preparing repository configuration data...");
        HashMap<String, Object> configurationValues = new HashMap<String, Object>();
        configurationValues.put("smartFoldersEnabled", this.smartFoldersBundle.isEnabled());
        boolean readOnly = this.transactionService.getRetryingTransactionHelper().doInTransaction(() -> this.repoUsageComponent.getUsage().isReadOnly(), true);
        configurationValues.put("serverReadOnly", readOnly);
        configurationValues.put("serverMode", this.serverModeProvider.getServerMode().toString());
        boolean ftpEnabled = Boolean.valueOf(this.fileServersSubsystem.getProperty("ftp.enabled"));
        configurationValues.put("ftpEnabled", ftpEnabled);
        configurationValues.put("webDAVEnabled", this.webdavService.getEnabled());
        configurationValues.put("thumbnailsEnabled", this.thumbnailService.getThumbnailsEnabled());
        boolean activitiesFeedEnabled = Boolean.valueOf(this.activitiesFeedSubsystem.getProperty("activities.feed.notifier.enabled"));
        configurationValues.put("activitiesFeedEnabled", activitiesFeedEnabled);
        configurationValues.put("activitiEngineEnabled", this.workflowAdminService.isEngineEnabled("activiti"));
        boolean inboundEnabled = Boolean.valueOf(this.inboundSMTPSubsystem.getProperty("email.inbound.enabled"));
        boolean emailServerEnabled = Boolean.valueOf(this.inboundSMTPSubsystem.getProperty("email.server.enabled"));
        boolean inboundServerEnabled = inboundEnabled && emailServerEnabled;
        configurationValues.put("inboundServerEnabled", inboundServerEnabled);
        boolean imapEnabled = Boolean.valueOf(this.imapSubsystem.getProperty("imap.server.enabled"));
        configurationValues.put("imapEnabled", imapEnabled);
        HashMap<String, String> replicationInfo = new HashMap<String, String>();
        replicationInfo.put("enabled", this.replicationSubsystem.getProperty("replication.enabled"));
        replicationInfo.put("readOnly", this.replicationSubsystem.getProperty("replication.transfer.readonly"));
        configurationValues.put("replication", replicationInfo);
        if (this.dataSource instanceof BasicDataSource) {
            HashMap<String, Integer> db = new HashMap<String, Integer>();
            db.put("maxConnections", ((BasicDataSource)this.dataSource).getMaxTotal());
            configurationValues.put("db", db);
        }
        List<ModuleDetails> rawInstalledModules = this.moduleService.getAllModules();
        HashMap modules = new HashMap();
        HashMap<String, Serializable> installedModules = new HashMap<String, Serializable>();
        installedModules.put("count", Integer.valueOf(rawInstalledModules.size()));
        HashMap installedModulesList = new HashMap();
        for (ModuleDetails md : rawInstalledModules) {
            HashMap<String, String> moduleInfo = new HashMap<String, String>();
            moduleInfo.put("version", md.getModuleVersionNumber().toString());
            installedModulesList.put(md.getId(), moduleInfo);
        }
        if (!installedModulesList.isEmpty()) {
            installedModules.put("modules", installedModulesList);
        }
        modules.put("installed", installedModules);
        List<ModuleDetails> rawMissingModules = this.getMissingModules();
        HashMap missingModules = new HashMap();
        HashMap missingModulesList = new HashMap();
        for (ModuleDetails md : rawMissingModules) {
            HashMap<String, String> moduleInfo = new HashMap<String, String>();
            moduleInfo.put("version", md.getModuleVersionNumber().toString());
            missingModulesList.put(md.getId(), moduleInfo);
        }
        if (!missingModulesList.isEmpty()) {
            missingModules.put("modules", missingModulesList);
            modules.put("missing", missingModules);
        }
        configurationValues.put("module", modules);
        HashMap<String, Serializable> audit = new HashMap<String, Serializable>();
        audit.put("enabled", Boolean.valueOf(this.auditService.isAuditEnabled()));
        HashMap auditAppList = new HashMap();
        Map rawAppList = this.transactionService.getRetryingTransactionHelper().doInTransaction(() -> this.auditService.getAuditApplications(), true);
        for (Map.Entry entry : rawAppList.entrySet()) {
            AuditService.AuditApplication app = (AuditService.AuditApplication)entry.getValue();
            HashMap<String, Boolean> appInfo = new HashMap<String, Boolean>();
            appInfo.put("enabled", app.isEnabled());
            String appName = ((String)entry.getKey()).replace(" ", "-");
            auditAppList.put(appName, appInfo);
        }
        if (!auditAppList.isEmpty()) {
            audit.put("apps", auditAppList);
        }
        configurationValues.put("audit", audit);
        String chainString = this.authenticationSubsystem.getProperty("chain");
        configurationValues.put("authenticationChain", chainString);
        HBData configurationData = new HBData(this.currentRepoDescriptorDAO.getDescriptor().getId(), this.getCollectorId(), this.getCollectorVersion(), new Date(), configurationValues);
        return Arrays.asList(configurationData);
    }

    private List<ModuleDetails> getMissingModules() {
        AuthenticationUtil.RunAsWork missingModulesWork = () -> {
            try {
                return this.moduleService.getMissingModules();
            }
            catch (Throwable e) {
                logger.warn((Object)("Heartbeat failed to collect information about missing modules: " + e));
                return Collections.emptyList();
            }
        };
        return (List)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)missingModulesWork, (String)AuthenticationUtil.getSystemUserName());
    }
}

