/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.executer;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.alfresco.repo.action.executer.ImporterActionExecuter;
import org.alfresco.util.GUID;
import org.alfresco.util.TempFileProvider;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.junit.Assert;
import org.junit.Test;

public class ImporterActionExecutorUnitTest {
    private static final String TEST_RESOURCE_PATHNAME = "import-archive-test";

    @Test
    public void testExtractFileDoesNotFailWhenCalledWithNoTracker() throws Exception {
        File destinationDir = TempFileProvider.getTempDir((String)GUID.generate());
        ZipFile zipFile = this.getZipResource("exceedsRatio.zip");
        Assert.assertTrue((String)"Expected destination folder to be empty.", (destinationDir.list().length == 0 ? 1 : 0) != 0);
        ImporterActionExecuter.extractFile((ZipFile)zipFile, (String)destinationDir.getPath());
        Assert.assertTrue((String)"Expected destination folder to contain at least one file.", (destinationDir.list().length > 0 ? 1 : 0) != 0);
        ImporterActionExecuter.deleteDir((File)destinationDir);
    }

    private ZipFile getZipResource(String zipFileName) throws URISyntaxException, IOException {
        String zipFilePath = TEST_RESOURCE_PATHNAME + File.separator + zipFileName;
        URL url = ImporterActionExecutorUnitTest.class.getClassLoader().getResource(zipFilePath);
        Path path = Paths.get(url.toURI());
        File file = new File(path.toString());
        return new ZipFile(file, "UTF-8", true);
    }
}

