/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.traitextender;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.alfresco.traitextender.ExtensionFactory;
import org.alfresco.traitextender.ExtensionPoint;
import org.alfresco.traitextender.InvalidExtension;
import org.alfresco.traitextender.SingletonExtension;
import org.alfresco.traitextender.Trait;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SingletonExtensionFactory<E, S extends SingletonExtension<E, T>, T extends Trait>
implements ExtensionFactory<E> {
    private Log logger = LogFactory.getLog(SingletonExtensionFactory.class);
    private S singleton;
    private Class<E> extensionAPI;

    public SingletonExtensionFactory(S singleton, Class<E> extensionAPI) throws InvalidExtension {
        if (!extensionAPI.isAssignableFrom(singleton.getClass())) {
            throw new InvalidExtension(singleton.getClass() + " is not an " + extensionAPI + " extension.");
        }
        this.singleton = singleton;
        this.extensionAPI = extensionAPI;
    }

    @Override
    public <TO extends Trait> E createExtension(TO traitObject) {
        TO tTrait = traitObject;
        if (!((SingletonExtension)this.singleton).acceptsTrait(traitObject)) {
            throw new InvalidExtension("Extension factory error : " + this.singleton.getClass() + " does not support trait " + traitObject);
        }
        if (this.logger.isDebugEnabled()) {
            String traitTrace = traitObject != null ? traitObject.getClass().toString() : "<null> trait";
            this.logger.info((Object)("Creating singleton extension " + this.singleton.getClass() + "<-" + traitTrace));
        } else {
            this.logger.info((Object)("Creating singleton extension " + this.singleton.getClass()));
        }
        return (E)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{this.extensionAPI}, (InvocationHandler)new TraiSingletontHandler(this, this.singleton, tTrait));
    }

    @Override
    public boolean canCreateExtensionFor(ExtensionPoint<?, ?> point) {
        return point.getExtensionAPI().isAssignableFrom(this.singleton.getClass()) && ((SingletonExtension)this.singleton).acceptsTraitClass(point.getTraitAPI());
    }

    private static class TraiSingletontHandler
    implements InvocationHandler {
        private S singleton;
        private T trait;
        final /* synthetic */ SingletonExtensionFactory this$0;

        public TraiSingletontHandler(S singleton, T trait) {
            this.this$0 = var1_1;
            this.singleton = singleton;
            this.trait = trait;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object stackedTrait = ((SingletonExtension)this.singleton).getTrait();
            ((SingletonExtension)this.singleton).setTrait(this.trait);
            try {
                Object object = method.invoke(this.singleton, args);
                return object;
            }
            catch (IllegalAccessException error) {
                throw new InvalidExtension(error);
            }
            catch (IllegalArgumentException error) {
                throw new InvalidExtension(error);
            }
            catch (InvocationTargetException error) {
                Throwable targetException = error.getTargetException();
                throw targetException;
            }
            finally {
                ((SingletonExtension)this.singleton).setTrait(stackedTrait);
            }
        }
    }
}

