/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.traitextender;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import org.alfresco.traitextender.Extend;
import org.alfresco.traitextender.Extensible;
import org.alfresco.traitextender.ExtensionTargetException;
import org.alfresco.traitextender.InvalidExtension;
import org.alfresco.util.ParameterCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;

public class AJExtender {
    private static final Object[] SAFE_NULL_ARGS = new Object[0];
    private static Log logger = LogFactory.getLog(AJExtender.class);
    private static ConcurrentHashMap.KeySetView<ExtensionRoute, Boolean> oneTimeLogSet = null;
    private static final ThreadLocal<Stack<Boolean>> ajPointsLocalEnabled = new ThreadLocal<Stack<Boolean>>(){

        @Override
        protected Stack<Boolean> initialValue() {
            Stack<Boolean> enablementStack = new Stack<Boolean>();
            enablementStack.push(true);
            return enablementStack;
        }
    };
    private static final ThreadLocal<Stack<ProceedingContext>> ajLocalProceedingJoinPoints = new ThreadLocal<Stack<ProceedingContext>>(){

        @Override
        protected Stack<ProceedingContext> initialValue() {
            return new Stack<ProceedingContext>();
        }
    };

    static boolean areAJPointsEnabled() {
        return ajPointsLocalEnabled.get().peek();
    }

    static void enableAJPoints() {
        ajPointsLocalEnabled.get().push(true);
    }

    static void revertAJPoints() {
        ajPointsLocalEnabled.get().pop();
    }

    static <R> R throwableRun(ExtensionBypass<R> closure) throws Throwable {
        try {
            ajPointsLocalEnabled.get().push(false);
            R r = closure.run();
            return r;
        }
        finally {
            ajPointsLocalEnabled.get().pop();
        }
    }

    public static <R> R run(ExtensionBypass<R> closure, Class<?>[] exTypes) throws Throwable {
        try {
            return AJExtender.throwableRun(closure);
        }
        catch (Error | RuntimeException error) {
            throw error;
        }
        catch (Throwable error) {
            throw AJExtender.asCheckThrowable(error, exTypes);
        }
    }

    static Throwable asCheckThrowable(Throwable error, Class<?> ... checkedThrowableTypes) {
        Class<?> errorClass = error.getClass();
        int i = 0;
        while (i < checkedThrowableTypes.length) {
            if (errorClass.equals(checkedThrowableTypes[i])) {
                return error;
            }
            ++i;
        }
        return new UndeclaredThrowableException(error);
    }

    public static <R> R run(ExtensionBypass<R> closure) {
        try {
            return AJExtender.throwableRun(closure);
        }
        catch (Error | RuntimeException error) {
            throw error;
        }
        catch (Throwable error) {
            throw new UndeclaredThrowableException(error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void oneTimeLiveLog(Log logger, ExtensionRoute route) {
        Object object = AJExtender.class;
        synchronized (AJExtender.class) {
            if (oneTimeLogSet == null) {
                oneTimeLogSet = ConcurrentHashMap.newKeySet();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            object = oneTimeLogSet;
            synchronized (object) {
                if (oneTimeLogSet.contains(route)) {
                    return;
                }
                logger.debug((Object)route.toString());
                oneTimeLogSet.add(route);
            }
            return;
        }
    }

    static CompiledExtensible compile(Class<? extends Extensible> extensible) throws AJExtensibleCompilingException {
        logger.info((Object)("Compiling extensible " + extensible));
        CompiledExtensible compiledExtensible = new CompiledExtensible(extensible);
        ArrayList<Method> methods = new ArrayList<Method>();
        Class<? extends Extensible> extendDeclaring = extensible;
        while (extendDeclaring != null) {
            Method[] declaredMethods = extendDeclaring.getDeclaredMethods();
            methods.addAll(Arrays.asList(declaredMethods));
            extendDeclaring = extendDeclaring.getSuperclass();
        }
        HashSet<Extend> extendDeclarations = new HashSet<Extend>();
        HashSet<Method> routedExtensionMethods = new HashSet<Method>();
        for (Method method : methods) {
            AJExtensibleCompilingException ajCompilingError;
            Extend extend = method.getAnnotation(Extend.class);
            if (extend == null) continue;
            try {
                extendDeclarations.add(extend);
                Class<?> extensionAPI = extend.extensionAPI();
                Method extensionMethod = extensionAPI.getMethod(method.getName(), method.getParameterTypes());
                compiledExtensible.add(new ExtensionRoute(extend, method, extensionMethod));
                routedExtensionMethods.add(extensionMethod);
            }
            catch (NoSuchMethodException error) {
                ajCompilingError = new AJExtensibleCompilingException("No route for " + method.toGenericString() + " @" + extend, error);
                compiledExtensible.add(ajCompilingError);
            }
            catch (SecurityException error) {
                ajCompilingError = new AJExtensibleCompilingException("Access denined to route for " + method.toGenericString() + " @" + extend, error);
                compiledExtensible.add(ajCompilingError);
            }
        }
        HashSet<Method> allObjectMethods = new HashSet<Method>(Arrays.asList(Object.class.getMethods()));
        for (Extend extend : extendDeclarations) {
            Class<?> extension = extend.extensionAPI();
            HashSet<Method> allExtensionMethods = new HashSet<Method>(Arrays.asList(extension.getMethods()));
            allExtensionMethods.removeAll(allObjectMethods);
            allExtensionMethods.removeAll(routedExtensionMethods);
            if (allExtensionMethods.isEmpty()) continue;
            for (Method method : allExtensionMethods) {
                compiledExtensible.add(new AJDanglingExtensionError(method, extend));
            }
        }
        logger.info((Object)compiledExtensible.getInfo());
        return compiledExtensible;
    }

    static Object extendAroundAdvice(JoinPoint thisJoinPoint, Extensible extensible, Extend extendAnnotation, Object extension) {
        MethodSignature ms = (MethodSignature)thisJoinPoint.getSignature();
        Method method = ms.getMethod();
        try {
            ajLocalProceedingJoinPoints.get().push(new ProceedingContext(extendAnnotation, (ProceedingJoinPoint)thisJoinPoint));
            Method extensionMethod = extension.getClass().getMethod(method.getName(), method.getParameterTypes());
            if (logger.isDebugEnabled()) {
                AJExtender.oneTimeLiveLog(logger, new ExtensionRoute(extendAnnotation, method, extensionMethod));
            }
            Object object = extensionMethod.invoke(extension, thisJoinPoint.getArgs());
            return object;
        }
        catch (IllegalAccessException error) {
            throw new InvalidExtension("Ivalid extension : " + error.getMessage(), error);
        }
        catch (IllegalArgumentException error) {
            throw new InvalidExtension("Ivalid extension : " + error.getMessage(), error);
        }
        catch (InvocationTargetException error) {
            Throwable targetException = error.getTargetException();
            if (targetException instanceof RuntimeException) {
                throw (RuntimeException)targetException;
            }
            throw new ExtensionTargetException(targetException);
        }
        catch (NoSuchMethodException error) {
            throw new InvalidExtension("Ivalid extension : " + error.getMessage(), error);
        }
        catch (SecurityException error) {
            throw new InvalidExtension("Ivalid extension : " + error.getMessage(), error);
        }
        finally {
            ajLocalProceedingJoinPoints.get().pop();
        }
    }

    static boolean isLocalProceeder(Method method) {
        if (!ajLocalProceedingJoinPoints.get().isEmpty()) {
            ProceedingContext proceedingCotext = ajLocalProceedingJoinPoints.get().peek();
            MethodSignature ms = (MethodSignature)proceedingCotext.proceedingJoinPoint.getSignature();
            Method jpMethod = ms.getMethod();
            return jpMethod.getName().endsWith(method.getName()) && Arrays.equals(jpMethod.getParameterTypes(), method.getParameterTypes());
        }
        return false;
    }

    static Object localProceed(Object[] args) throws Throwable {
        ProceedingContext proceedingCotext = ajLocalProceedingJoinPoints.get().peek();
        Object[] safeArgs = args == null ? SAFE_NULL_ARGS : args;
        return proceedingCotext.proceedingJoinPoint.proceed(safeArgs);
    }

    static class AJDanglingExtensionError
    implements AJExtensibleCompilingError {
        private Method danglingMethod;
        private Extend extendDeclaration;

        AJDanglingExtensionError(Method danglingMethod, Extend extendDeclaration) {
            this.danglingMethod = danglingMethod;
            this.extendDeclaration = extendDeclaration;
        }

        @Override
        public String getShortMessage() {
            return "Dangling extension method " + this.danglingMethod + " " + this.extendDeclaration;
        }
    }

    static interface AJExtensibleCompilingError {
        public String getShortMessage();
    }

    static class AJExtensibleCompilingException
    extends Exception
    implements AJExtensibleCompilingError {
        private static final long serialVersionUID = 1L;

        AJExtensibleCompilingException() {
        }

        AJExtensibleCompilingException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
            super(message, cause, enableSuppression, writableStackTrace);
        }

        AJExtensibleCompilingException(String message, Throwable cause) {
            super(message, cause);
        }

        AJExtensibleCompilingException(String message) {
            super(message);
        }

        AJExtensibleCompilingException(Throwable cause) {
            super(cause);
        }

        @Override
        public String getShortMessage() {
            return this.getMessage();
        }
    }

    static class CompiledExtensible {
        private Class<? extends Extensible> extensible;
        private Map<Method, ExtensionRoute> routedMethods = new HashMap<Method, ExtensionRoute>();
        private Map<Method, ExtensionRoute> notRoutedMethods = new HashMap<Method, ExtensionRoute>();
        private List<AJExtensibleCompilingError> errors = new LinkedList<AJExtensibleCompilingError>();

        CompiledExtensible(Class<? extends Extensible> extensible) {
            this.extensible = extensible;
        }

        Class<? extends Extensible> getExtensible() {
            return this.extensible;
        }

        void add(AJExtensibleCompilingError error) {
            this.errors.add(error);
        }

        boolean hasErrors() {
            return !this.errors.isEmpty();
        }

        String getErrorsString() {
            StringBuilder builder = new StringBuilder();
            for (AJExtensibleCompilingError error : this.errors) {
                builder.append(error.getShortMessage());
                builder.append("\n");
            }
            return builder.toString();
        }

        List<AJExtensibleCompilingError> getErrors() {
            return this.errors;
        }

        void add(ExtensionRoute route) {
            if (route.extensionMethod == null) {
                this.notRoutedMethods.remove(route.extendedMethod);
                this.routedMethods.put(route.extendedMethod, route);
            } else if (!this.routedMethods.containsKey(route.extendedMethod)) {
                this.routedMethods.put(route.extendedMethod, route);
            }
        }

        Collection<ExtensionRoute> getAllNotRouted() {
            return this.notRoutedMethods.values();
        }

        int getExtendedMethodCount() {
            return this.routedMethods.size() + this.notRoutedMethods.size();
        }

        String getInfo() {
            return String.valueOf(this.extensible.getName()) + "{ " + this.routedMethods.size() + " routed methods; " + this.notRoutedMethods.size() + " not routed methods;" + this.errors.size() + " errors}";
        }
    }

    public static interface ExtensionBypass<R> {
        public R run() throws Throwable;
    }

    static class ExtensionRoute {
        final Extend extendAnnotation;
        final Method extendedMethod;
        final Method extensionMethod;

        ExtensionRoute(Extend extendAnnotation, Method traitMethod) {
            this(extendAnnotation, traitMethod, null);
        }

        ExtensionRoute(Extend extendAnnotation, Method extendedMethod, Method extensionMethod) {
            ParameterCheck.mandatory((String)"extendAnnotation", (Object)extendAnnotation);
            ParameterCheck.mandatory((String)"traitMethod", (Object)extendedMethod);
            this.extendAnnotation = extendAnnotation;
            this.extendedMethod = extendedMethod;
            this.extensionMethod = extensionMethod;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ExtensionRoute) {
                ExtensionRoute route = (ExtensionRoute)obj;
                return this.extendAnnotation.traitAPI().equals(route.extendAnnotation.traitAPI()) && this.extendAnnotation.extensionAPI().equals(route.extendAnnotation.extensionAPI()) && this.extendedMethod.equals(route.extendedMethod) && (this.extensionMethod == null && route.extensionMethod == null || this.extensionMethod != null && this.extensionMethod.equals(route.extensionMethod));
            }
            return false;
        }

        public String toString() {
            String extensionString = "NOT ROUTED";
            if (this.extensionMethod != null) {
                Class<?> exDeclClass = this.extendedMethod.getDeclaringClass();
                extensionString = String.valueOf(this.extensionMethod.toGenericString()) + "#" + exDeclClass;
            }
            return String.valueOf(this.extendAnnotation.toString()) + "\t\n[" + this.extendedMethod.toGenericString() + " -> " + extensionString + "]";
        }

        public int hashCode() {
            return this.extendAnnotation.hashCode();
        }
    }

    static class ProceedingContext {
        final Extend extend;
        final ProceedingJoinPoint proceedingJoinPoint;

        ProceedingContext(Extend extend, ProceedingJoinPoint proceedingJoinPoint) {
            this.extend = extend;
            this.proceedingJoinPoint = proceedingJoinPoint;
        }
    }
}

