/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.cmr.tagging;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.alfresco.api.AlfrescoPublicApi;
import org.alfresco.query.EmptyPagingResults;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.service.Auditable;
import org.alfresco.service.NotAuditable;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.tagging.TagScope;
import org.alfresco.util.Pair;

@AlfrescoPublicApi
public interface TaggingService {
    public static final NodeRef TAG_ROOT_NODE_REF = new NodeRef("workspace://SpacesStore/tag:tag-root");

    @NotAuditable
    public boolean isTag(StoreRef var1, String var2);

    public String getTagName(NodeRef var1);

    @NotAuditable
    public List<String> getTags(StoreRef var1);

    @NotAuditable
    public PagingResults<Pair<NodeRef, String>> getTags(StoreRef var1, PagingRequest var2);

    @NotAuditable
    default public PagingResults<Pair<NodeRef, String>> getTags(StoreRef storeRef, PagingRequest pagingRequest, Collection<String> exactNamesFilter, Collection<String> alikeNamesFilter) {
        return new EmptyPagingResults();
    }

    public Map<NodeRef, Long> getTags(StoreRef var1, List<String> var2, Pair<String, Boolean> var3, Collection<String> var4, Collection<String> var5);

    @NotAuditable
    public List<String> getTags(StoreRef var1, String var2);

    @Auditable(parameters={"tag"})
    public NodeRef createTag(StoreRef var1, String var2);

    @Auditable(parameters={"tag"})
    public void deleteTag(StoreRef var1, String var2);

    @Auditable(parameters={"existingTag", "newTag"})
    public NodeRef changeTag(StoreRef var1, String var2, String var3);

    @Auditable(parameters={"tag"})
    public boolean hasTag(NodeRef var1, String var2);

    @Auditable(parameters={"tag"})
    public NodeRef addTag(NodeRef var1, String var2);

    @NotAuditable
    public NodeRef getTagNodeRef(StoreRef var1, String var2);

    @Auditable(parameters={"tags"})
    public List<Pair<String, NodeRef>> addTags(NodeRef var1, List<String> var2);

    @Auditable(parameters={"tag"})
    public void removeTag(NodeRef var1, String var2);

    @Auditable(parameters={"tags"})
    public void removeTags(NodeRef var1, List<String> var2);

    @NotAuditable
    public List<String> getTags(NodeRef var1);

    @NotAuditable
    public PagingResults<Pair<NodeRef, String>> getTags(NodeRef var1, PagingRequest var2);

    @Auditable(parameters={"tags"})
    public void setTags(NodeRef var1, List<String> var2);

    @Auditable
    public void clearTags(NodeRef var1);

    @NotAuditable
    public boolean isTagScope(NodeRef var1);

    @Auditable
    public void addTagScope(NodeRef var1);

    @Auditable
    public void refreshTagScope(NodeRef var1, boolean var2);

    @Auditable
    public void removeTagScope(NodeRef var1);

    @NotAuditable
    public TagScope findTagScope(NodeRef var1);

    @NotAuditable
    public List<TagScope> findAllTagScopes(NodeRef var1);

    @NotAuditable
    public List<NodeRef> findTaggedNodes(StoreRef var1, String var2);

    @NotAuditable
    public List<NodeRef> findTaggedNodes(StoreRef var1, String var2, NodeRef var3);

    @NotAuditable
    public Pair<List<String>, Integer> getPagedTags(StoreRef var1, int var2, int var3);

    @NotAuditable
    public Pair<List<String>, Integer> getPagedTags(StoreRef var1, String var2, int var3, int var4);

    @NotAuditable
    public List<Pair<String, Integer>> findTaggedNodesAndCountByTagName(StoreRef var1);

    @NotAuditable
    public long findCountByTagName(StoreRef var1, String var2);

    @Auditable(parameters={"tagNames"})
    default public List<Pair<String, NodeRef>> createTags(StoreRef storeRef, List<String> tagNames) {
        return Collections.emptyList();
    }

    public Map<String, Long> calculateCount(StoreRef var1);
}

