/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.solr;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.zip.CRC32;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.domain.node.Node;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.domain.node.NodeEntity;
import org.alfresco.repo.domain.permissions.AclDAO;
import org.alfresco.repo.domain.qname.QNameDAO;
import org.alfresco.repo.domain.solr.SearchDAO;
import org.alfresco.repo.index.shard.ShardRegistry;
import org.alfresco.repo.index.shard.ShardState;
import org.alfresco.repo.search.AspectIndexFilter;
import org.alfresco.repo.search.SearchTrackingComponent;
import org.alfresco.repo.search.TypeIndexFilter;
import org.alfresco.repo.search.impl.QueryParserUtils;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.solr.Acl;
import org.alfresco.repo.solr.AclChangeSet;
import org.alfresco.repo.solr.AclReaders;
import org.alfresco.repo.solr.AlfrescoModel;
import org.alfresco.repo.solr.AlfrescoModelDiff;
import org.alfresco.repo.solr.MetaDataResultsFilter;
import org.alfresco.repo.solr.NodeMetaData;
import org.alfresco.repo.solr.NodeMetaDataParameters;
import org.alfresco.repo.solr.NodeParameters;
import org.alfresco.repo.solr.Transaction;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.version.Version2Model;
import org.alfresco.repo.version.VersionModel;
import org.alfresco.repo.version.common.VersionUtil;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.ModelDefinition;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.security.OwnableService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SOLRTrackingComponentImpl
implements SearchTrackingComponent {
    private NodeDAO nodeDAO;
    private QNameDAO qnameDAO;
    private SearchDAO searchDAO;
    private DictionaryDAO dictionaryDAO;
    private PermissionService permissionService;
    private AclDAO aclDAO;
    private OwnableService ownableService;
    private TenantService tenantService;
    private DictionaryService dictionaryService;
    private boolean enabled = true;
    private boolean cacheAncestors = true;
    private TypeIndexFilter typeIndexFilter;
    private AspectIndexFilter aspectIndexFilter;
    private ShardRegistry shardRegistry;
    private NamespaceService namespaceService;
    private static Log logger = LogFactory.getLog(SOLRTrackingComponentImpl.class);

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setCacheAncestors(boolean cacheAncestors) {
        this.cacheAncestors = cacheAncestors;
    }

    public void setSearchDAO(SearchDAO searchDAO) {
        this.searchDAO = searchDAO;
    }

    public void setNodeDAO(NodeDAO nodeDAO) {
        this.nodeDAO = nodeDAO;
    }

    public void setQnameDAO(QNameDAO qnameDAO) {
        this.qnameDAO = qnameDAO;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setOwnableService(OwnableService ownableService) {
        this.ownableService = ownableService;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setAclDAO(AclDAO aclDAO) {
        this.aclDAO = aclDAO;
    }

    public void setDictionaryDAO(DictionaryDAO dictionaryDAO) {
        this.dictionaryDAO = dictionaryDAO;
    }

    public void setTypeIndexFilter(TypeIndexFilter typeIndexFilter) {
        this.typeIndexFilter = typeIndexFilter;
    }

    public void setAspectIndexFilter(AspectIndexFilter aspectIndexFilter) {
        this.aspectIndexFilter = aspectIndexFilter;
    }

    public void setShardRegistry(ShardRegistry shardRegistry) {
        this.shardRegistry = shardRegistry;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void init() {
        PropertyCheck.mandatory((Object)this, (String)"solrDAO", (Object)this.searchDAO);
        PropertyCheck.mandatory((Object)this, (String)"nodeDAO", (Object)this.nodeDAO);
        PropertyCheck.mandatory((Object)this, (String)"qnameDAO", (Object)this.qnameDAO);
        PropertyCheck.mandatory((Object)this, (String)"permissionService", (Object)this.permissionService);
        PropertyCheck.mandatory((Object)this, (String)"ownableService", (Object)this.ownableService);
        PropertyCheck.mandatory((Object)this, (String)"tenantService", (Object)this.tenantService);
        PropertyCheck.mandatory((Object)this, (String)"dictionaryService", (Object)this.dictionaryService);
        PropertyCheck.mandatory((Object)this, (String)"dictionaryDAO", (Object)this.dictionaryDAO);
        PropertyCheck.mandatory((Object)this, (String)"aclDAO", (Object)this.aclDAO);
        PropertyCheck.mandatory((Object)this, (String)"typeIndexFilter", (Object)this.typeIndexFilter);
        PropertyCheck.mandatory((Object)this, (String)"aspectIndexFilter", (Object)this.aspectIndexFilter);
        PropertyCheck.mandatory((Object)this, (String)"namespaceService", (Object)this.namespaceService);
    }

    @Override
    public List<AclChangeSet> getAclChangeSets(Long minAclChangeSetId, Long fromCommitTime, Long maxAclChangeSetId, Long toCommitTime, int maxResults) {
        if (this.enabled) {
            List<AclChangeSet> changesets = this.searchDAO.getAclChangeSets(minAclChangeSetId, fromCommitTime, maxAclChangeSetId, toCommitTime, maxResults);
            return changesets;
        }
        return Collections.emptyList();
    }

    @Override
    public List<Acl> getAcls(List<Long> aclChangeSetIds, Long minAclId, int maxResults) {
        if (this.enabled) {
            List<Acl> acls = this.searchDAO.getAcls(aclChangeSetIds, minAclId, maxResults);
            return acls;
        }
        return Collections.emptyList();
    }

    @Override
    public List<AclReaders> getAclsReaders(List<Long> aclIds) {
        if (this.enabled) {
            this.aclDAO.setCheckAclConsistency();
            HashMap<Long, String> aclChangeSetTenant = new HashMap<Long, String>(aclIds.size());
            ArrayList<AclReaders> aclsReaders = new ArrayList<AclReaders>(aclIds.size() * 10);
            for (Long aclId : aclIds) {
                AclReaders readers = new AclReaders();
                readers.setAclId(aclId);
                Set readersSet = this.permissionService.getReaders(aclId);
                readers.setReaders(readersSet);
                Set deniedSet = this.permissionService.getReadersDenied(aclId);
                readers.setDenied(deniedSet);
                Long aclChangeSetId = this.aclDAO.getAccessControlList(aclId).getProperties().getAclChangeSetId();
                readers.setAclChangeSetId(aclChangeSetId);
                if (AuthenticationUtil.isMtEnabled()) {
                    String tenantDomain = (String)aclChangeSetTenant.get(aclChangeSetId);
                    if (tenantDomain == null) {
                        tenantDomain = this.getTenant(aclId, aclChangeSetId);
                        if (tenantDomain == null) continue;
                        aclChangeSetTenant.put(aclChangeSetId, tenantDomain);
                    }
                    readers.setTenantDomain(tenantDomain);
                }
                aclsReaders.add(readers);
            }
            return aclsReaders;
        }
        return Collections.emptyList();
    }

    private String getTenant(long aclId, long aclChangeSetId) {
        String tenantDomain = this.getAclTenant(aclId);
        if (tenantDomain == null) {
            ArrayList<Long> aclChangeSetIds = new ArrayList<Long>(1);
            aclChangeSetIds.add(aclChangeSetId);
            List<Acl> acls = this.searchDAO.getAcls(aclChangeSetIds, null, 1024);
            for (Acl acl : acls) {
                tenantDomain = this.getAclTenant(acl.getId());
                if (tenantDomain != null) break;
            }
            if (tenantDomain == null) {
                tenantDomain = null;
            }
        }
        return tenantDomain;
    }

    private String getAclTenant(long aclId) {
        List<Long> nodeIds = this.aclDAO.getADMNodesByAcl(aclId, 1);
        if (nodeIds.size() == 0) {
            return null;
        }
        this.nodeDAO.setCheckNodeConsistency();
        Pair<Long, NodeRef> nodePair = this.nodeDAO.getNodePair(nodeIds.get(0));
        if (nodePair == null) {
            return null;
        }
        return this.tenantService.getDomain(((NodeRef)nodePair.getSecond()).getStoreRef().getIdentifier());
    }

    @Override
    public List<Transaction> getTransactions(Long minTxnId, Long fromCommitTime, Long maxTxnId, Long toCommitTime, int maxResults) {
        if (this.enabled) {
            List<Transaction> txns = this.searchDAO.getTransactions(minTxnId, fromCommitTime, maxTxnId, toCommitTime, maxResults);
            return txns;
        }
        return Collections.emptyList();
    }

    @Override
    public void getNodes(NodeParameters nodeParameters, SearchTrackingComponent.NodeQueryCallback callback) {
        if (this.enabled) {
            QName shardPropertQName = null;
            QName shardPropertyType = null;
            if (nodeParameters.getShardProperty() != null) {
                PropertyDefinition pdef = QueryParserUtils.matchPropertyDefinition((String)"http://www.alfresco.org/model/content/1.0", (NamespacePrefixResolver)this.namespaceService, (DictionaryService)this.dictionaryService, (String)nodeParameters.getShardProperty());
                if (pdef == null) {
                    logger.warn((Object)("Invalid shard property: " + nodeParameters.getShardProperty()));
                } else {
                    shardPropertyType = pdef.getDataType().getName();
                    if (!(shardPropertyType.equals((Object)DataTypeDefinition.TEXT) || shardPropertyType.equals((Object)DataTypeDefinition.DATE) || shardPropertyType.equals((Object)DataTypeDefinition.DATETIME) || shardPropertyType.equals((Object)DataTypeDefinition.INT) || shardPropertyType.equals((Object)DataTypeDefinition.LONG))) {
                        logger.warn((Object)("Unsupported shard property type: " + pdef.getDataType().getName() + " for " + nodeParameters.getShardProperty()));
                    } else {
                        shardPropertQName = pdef.getName();
                    }
                }
            }
            List<Node> nodes = this.searchDAO.getNodes(nodeParameters, shardPropertQName, shardPropertyType);
            for (Node node : nodes) {
                if (this.shardRegistry != null) {
                    this.shardRegistry.getShardInstanceByTransactionTimestamp(nodeParameters.getCoreName(), node.getTransaction().getCommitTimeMs()).ifPresent(shardId -> ((NodeEntity)node).setExplicitShardId(shardId));
                }
                callback.handleNode(node);
            }
        }
    }

    private boolean isCategorised(AspectDefinition aspDef) {
        if (aspDef == null) {
            return false;
        }
        AspectDefinition current = aspDef;
        while (current != null) {
            if (current.getName().equals((Object)ContentModel.ASPECT_CLASSIFIABLE)) {
                return true;
            }
            QName parentName = current.getParentName();
            if (parentName == null) break;
            current = this.dictionaryService.getAspect(parentName);
        }
        return false;
    }

    private CategoryPaths getCategoryPaths(NodeRef nodeRef, Set<QName> aspects, Map<QName, Serializable> properties) {
        ArrayList<Pair<Path, QName>> categoryPaths = new ArrayList<Pair<Path, QName>>();
        ArrayList<ChildAssociationRef> categoryParents = new ArrayList<ChildAssociationRef>();
        this.nodeDAO.setCheckNodeConsistency();
        for (QName qName : aspects) {
            AspectDefinition aspDef = this.dictionaryService.getAspect(qName);
            if (!this.isCategorised(aspDef)) continue;
            LinkedList<Pair> aspectPaths = new LinkedList<Pair>();
            for (PropertyDefinition propDef : aspDef.getProperties().values()) {
                Serializable propVal;
                if (!propDef.getDataType().getName().equals((Object)DataTypeDefinition.CATEGORY) || (propVal = properties.get(propDef.getName())) == null) continue;
                for (NodeRef catRef : DefaultTypeConverter.INSTANCE.getCollection(NodeRef.class, (Object)propVal)) {
                    if (catRef == null) continue;
                    catRef = this.tenantService.getName(nodeRef, catRef);
                    try {
                        Pair<Long, NodeRef> pair = this.nodeDAO.getNodePair(catRef);
                        if (pair == null) continue;
                        for (Path path : this.nodeDAO.getPaths(pair, false)) {
                            aspectPaths.add(new Pair((Object)path, (Object)aspDef.getName()));
                        }
                    }
                    catch (InvalidNodeRefException invalidNodeRefException) {}
                }
            }
            categoryPaths.addAll(aspectPaths);
        }
        for (Pair pair : categoryPaths) {
            if (!(((Path)pair.getFirst()).last() instanceof Path.ChildAssocElement)) continue;
            Path.ChildAssocElement cae = (Path.ChildAssocElement)((Path)pair.getFirst()).last();
            ChildAssociationRef assocRef = cae.getRef();
            ChildAssociationRef categoryParentRef = new ChildAssociationRef(assocRef.getTypeQName(), assocRef.getChildRef(), QName.createQName((String)"member"), nodeRef);
            ((Path)pair.getFirst()).append((Path.Element)new Path.ChildAssocElement(categoryParentRef));
            categoryParents.add(categoryParentRef);
        }
        return new CategoryPaths(categoryPaths, categoryParents);
    }

    private List<Long> preCacheNodes(NodeMetaDataParameters nodeMetaDataParameters) {
        int maxResults = nodeMetaDataParameters.getMaxResults();
        boolean isLimitSet = maxResults != 0 && maxResults != Integer.MAX_VALUE;
        List<Long> nodeIds = null;
        Iterable<Long> iterable = null;
        List<Long> allNodeIds = nodeMetaDataParameters.getNodeIds();
        if (allNodeIds != null) {
            int toIndex = maxResults > allNodeIds.size() ? allNodeIds.size() : maxResults;
            nodeIds = isLimitSet ? allNodeIds.subList(0, toIndex) : nodeMetaDataParameters.getNodeIds();
            iterable = nodeMetaDataParameters.getNodeIds();
        } else {
            Long fromNodeId = nodeMetaDataParameters.getFromNodeId();
            Long toNodeId = nodeMetaDataParameters.getToNodeId();
            nodeIds = new ArrayList<Long>(isLimitSet ? maxResults : 100);
            iterable = new SequenceIterator(fromNodeId, toNodeId, maxResults);
            int counter = 1;
            for (Long nodeId : iterable) {
                if (isLimitSet && counter++ > maxResults) break;
                nodeIds.add(nodeId);
            }
        }
        List<Long> ancestors = this.cacheAncestors ? this.cacheAncestors(nodeIds) : nodeIds;
        this.nodeDAO.setCheckNodeConsistency();
        this.nodeDAO.cacheNodesById(ancestors);
        return nodeIds;
    }

    private List<Long> cacheAncestors(List<Long> nodeIds) {
        Long nodeId;
        final LinkedList<Long> toVisit = new LinkedList<Long>(nodeIds);
        TreeSet<Long> visited = new TreeSet<Long>();
        this.nodeDAO.cacheNodesById(toVisit);
        Long lastCached = toVisit.peekLast();
        while ((nodeId = toVisit.pollFirst()) != null) {
            boolean nodeIdEqualsLastCached;
            if (visited.add(nodeId) && this.nodeDAO.getNodeIdStatus(nodeId) != null && !this.nodeDAO.getNodeIdStatus(nodeId).isDeleted()) {
                this.nodeDAO.getParentAssocs(nodeId, null, null, null, new NodeDAO.ChildAssocRefQueryCallback(){

                    @Override
                    public boolean preLoadNodes() {
                        return false;
                    }

                    @Override
                    public boolean orderResults() {
                        return false;
                    }

                    @Override
                    public boolean handle(Pair<Long, ChildAssociationRef> childAssocPair, Pair<Long, NodeRef> parentNodePair, Pair<Long, NodeRef> childNodePair) {
                        toVisit.add((Long)parentNodePair.getFirst());
                        return true;
                    }

                    @Override
                    public void done() {
                    }
                });
            }
            boolean bl = nodeIdEqualsLastCached = nodeId == null && lastCached == null || nodeId != null && nodeId.equals(lastCached);
            if (!nodeIdEqualsLastCached || toVisit.isEmpty()) continue;
            this.nodeDAO.cacheNodesById(toVisit);
            lastCached = toVisit.peekLast();
        }
        return new ArrayList<Long>(visited);
    }

    protected Map<QName, Serializable> getProperties(Long nodeId) {
        this.nodeDAO.setCheckNodeConsistency();
        Map<QName, Serializable> sourceProps = this.nodeDAO.getNodeProperties(nodeId);
        HashMap<QName, Serializable> props = new HashMap<QName, Serializable>(sourceProps.size());
        for (QName propertyQName : sourceProps.keySet()) {
            PropertyDefinition propDef = this.dictionaryService.getProperty(propertyQName);
            if (propDef == null || !propDef.isIndexed()) continue;
            props.put(propertyQName, sourceProps.get(propertyQName));
        }
        return props;
    }

    @Override
    public long getCRC(Long nodeId) {
        final ArrayList parentAssocs = new ArrayList(100);
        this.nodeDAO.getParentAssocs(nodeId, null, null, null, new NodeDAO.ChildAssocRefQueryCallback(){

            @Override
            public boolean preLoadNodes() {
                return false;
            }

            @Override
            public boolean orderResults() {
                return false;
            }

            @Override
            public boolean handle(Pair<Long, ChildAssociationRef> childAssocPair, Pair<Long, NodeRef> parentNodePair, Pair<Long, NodeRef> childNodePair) {
                parentAssocs.add(SOLRTrackingComponentImpl.this.tenantService.getBaseName((ChildAssociationRef)childAssocPair.getSecond(), true));
                return true;
            }

            @Override
            public void done() {
            }
        });
        CRC32 crc = new CRC32();
        for (ChildAssociationRef car : parentAssocs) {
            try {
                crc.update(car.toString().getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException("UTF-8 encoding is not supported");
            }
        }
        return crc.getValue();
    }

    @Override
    public void getNodesMetadata(NodeMetaDataParameters nodeMetaDataParameters, MetaDataResultsFilter resultFilter, SearchTrackingComponent.NodeMetaDataQueryCallback callback) {
        if (!this.enabled) {
            return;
        }
        NodeMetaDataQueryRowHandler rowHandler = new NodeMetaDataQueryRowHandler(callback);
        boolean includeType = resultFilter == null ? true : resultFilter.getIncludeType();
        boolean includeProperties = resultFilter == null ? true : resultFilter.getIncludeProperties();
        boolean includeAspects = resultFilter == null ? true : resultFilter.getIncludeAspects();
        boolean includePaths = resultFilter == null ? true : resultFilter.getIncludePaths();
        boolean includeNodeRef = resultFilter == null ? true : resultFilter.getIncludeNodeRef();
        boolean includeParentAssociations = resultFilter == null ? true : resultFilter.getIncludeParentAssociations();
        final boolean includeChildAssociations = resultFilter == null ? true : resultFilter.getIncludeChildAssociations();
        boolean includeOwner = resultFilter == null ? true : resultFilter.getIncludeOwner();
        final boolean includeChildIds = resultFilter == null ? true : resultFilter.getIncludeChildIds();
        boolean includeTxnId = resultFilter == null ? true : resultFilter.getIncludeTxnId();
        List<Long> nodeIds = this.preCacheNodes(nodeMetaDataParameters);
        for (Long nodeId : nodeIds) {
            NodeRef.Status status = this.nodeDAO.getNodeIdStatus(nodeId);
            if (status == null) continue;
            NodeRef nodeRef = status.getNodeRef();
            NodeRef unversionedNodeRef = null;
            if (this.isVersionNodeRef(nodeRef)) {
                unversionedNodeRef = this.convertVersionNodeRefToVersionedNodeRef(VersionUtil.convertNodeRef(nodeRef));
            }
            NodeMetaData nodeMetaData = new NodeMetaData();
            nodeMetaData.setNodeId(nodeId);
            if (includeNodeRef) {
                nodeMetaData.setNodeRef(this.tenantService.getBaseName(nodeRef, true));
            }
            if (includeTxnId) {
                nodeMetaData.setTxnId(status.getDbTxnId());
            }
            if (status.isDeleted()) {
                rowHandler.processResult(nodeMetaData);
                continue;
            }
            Map<QName, Serializable> props = null;
            Set<QName> aspects = null;
            NodeRef.Status unversionedStatus = null;
            if (unversionedNodeRef != null) {
                unversionedStatus = this.nodeDAO.getNodeRefStatus(unversionedNodeRef);
            }
            if (unversionedStatus != null) {
                nodeMetaData.setAclId(this.nodeDAO.getNodeAclId(unversionedStatus.getDbId()));
            } else {
                nodeMetaData.setAclId(this.nodeDAO.getNodeAclId(nodeId));
            }
            if (includeType) {
                QName nodeType = this.getNodeType(nodeId);
                if (nodeType != null) {
                    nodeMetaData.setNodeType(nodeType);
                } else {
                    QName typeQName = null;
                    String errorMessage = "NodeId " + nodeId + " with nodeRef " + nodeRef;
                    typeQName = this.nodeDAO.getNodeType(nodeId);
                    errorMessage = typeQName != null ? String.valueOf(errorMessage) + " has type " + typeQName + ", but this type is not registered in DictionaryService." : String.valueOf(errorMessage) + " has no type.";
                    throw new AlfrescoRuntimeException(String.valueOf(errorMessage) + " It will be ignored by SOLR.");
                }
            }
            if (includeProperties) {
                if (props == null) {
                    props = this.getProperties(nodeId);
                }
                nodeMetaData.setProperties(props);
            } else {
                nodeMetaData.setProperties(Collections.emptyMap());
            }
            if (includeAspects || includePaths || includeParentAssociations) {
                aspects = this.getNodeAspects(nodeId);
            }
            nodeMetaData.setAspects(aspects);
            boolean ignoreLargeMetadata = this.typeIndexFilter.shouldBeIgnored(this.getNodeType(nodeId)) || this.aspectIndexFilter.shouldBeIgnored(this.getNodeAspects(nodeId));
            CategoryPaths categoryPaths = new CategoryPaths(new ArrayList<Pair<Path, QName>>(), new ArrayList<ChildAssociationRef>());
            if (!ignoreLargeMetadata && (includePaths || includeParentAssociations)) {
                if (props == null) {
                    props = this.getProperties(nodeId);
                }
                categoryPaths = this.getCategoryPaths(status.getNodeRef(), aspects, props);
            }
            if (!ignoreLargeMetadata && (this.typeIndexFilter.isIgnorePathsForSpecificTypes() || this.aspectIndexFilter.isIgnorePathsForSpecificAspects() || includeParentAssociations)) {
                final LinkedList parentIds = new LinkedList();
                final ArrayList<ChildAssociationRef> parentAssocs = new ArrayList<ChildAssociationRef>(100);
                this.nodeDAO.getParentAssocs(nodeId, null, null, true, new NodeDAO.ChildAssocRefQueryCallback(){

                    @Override
                    public boolean preLoadNodes() {
                        return false;
                    }

                    @Override
                    public boolean orderResults() {
                        return false;
                    }

                    @Override
                    public boolean handle(Pair<Long, ChildAssociationRef> childAssocPair, Pair<Long, NodeRef> parentNodePair, Pair<Long, NodeRef> childNodePair) {
                        parentIds.add((Long)parentNodePair.getFirst());
                        parentAssocs.add(SOLRTrackingComponentImpl.this.tenantService.getBaseName((ChildAssociationRef)childAssocPair.getSecond(), true));
                        return false;
                    }

                    @Override
                    public void done() {
                    }
                });
                if (!parentIds.isEmpty()) {
                    Long parentId = (Long)parentIds.iterator().next();
                    if (this.typeIndexFilter.isIgnorePathsForSpecificTypes()) {
                        QName qName = this.getNodeType(parentId);
                        ignoreLargeMetadata = this.typeIndexFilter.shouldBeIgnored(qName);
                    }
                    if (!ignoreLargeMetadata && this.aspectIndexFilter.isIgnorePathsForSpecificAspects()) {
                        ignoreLargeMetadata = this.aspectIndexFilter.shouldBeIgnored(this.getNodeAspects(parentId));
                    }
                }
                if (includeParentAssociations) {
                    for (ChildAssociationRef ref : categoryPaths.getCategoryParents()) {
                        parentAssocs.add(this.tenantService.getBaseName(ref, true));
                    }
                    CRC32 crc = new CRC32();
                    for (ChildAssociationRef childAssociationRef : parentAssocs) {
                        try {
                            crc.update(childAssociationRef.toString().getBytes("UTF-8"));
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            throw new RuntimeException("UTF-8 encoding is not supported");
                        }
                    }
                    nodeMetaData.setParentAssocs(parentAssocs, crc.getValue());
                }
            }
            nodeMetaData.setTenantDomain(this.tenantService.getDomain(nodeRef.getStoreRef().getIdentifier()));
            if (includeChildAssociations || includeChildIds) {
                final ArrayList<ChildAssociationRef> childAssocs = new ArrayList<ChildAssociationRef>(100);
                final ArrayList<Long> childIds = new ArrayList<Long>(100);
                this.nodeDAO.getChildAssocs(nodeId, null, null, null, null, null, new NodeDAO.ChildAssocRefQueryCallback(){

                    @Override
                    public boolean preLoadNodes() {
                        return false;
                    }

                    @Override
                    public boolean orderResults() {
                        return false;
                    }

                    @Override
                    public boolean handle(Pair<Long, ChildAssociationRef> childAssocPair, Pair<Long, NodeRef> parentNodePair, Pair<Long, NodeRef> childNodePair) {
                        QName nodeType = SOLRTrackingComponentImpl.this.nodeDAO.getNodeType((Long)childNodePair.getFirst());
                        if (includeChildAssociations) {
                            boolean addCurrentChildAssoc = true;
                            if (SOLRTrackingComponentImpl.this.typeIndexFilter.isIgnorePathsForSpecificTypes()) {
                                boolean bl = addCurrentChildAssoc = !SOLRTrackingComponentImpl.this.typeIndexFilter.shouldBeIgnored(nodeType);
                            }
                            if (!addCurrentChildAssoc && SOLRTrackingComponentImpl.this.aspectIndexFilter.isIgnorePathsForSpecificAspects()) {
                                boolean bl = addCurrentChildAssoc = !SOLRTrackingComponentImpl.this.aspectIndexFilter.shouldBeIgnored(SOLRTrackingComponentImpl.this.getNodeAspects((Long)childNodePair.getFirst()));
                            }
                            if (addCurrentChildAssoc) {
                                childAssocs.add(SOLRTrackingComponentImpl.this.tenantService.getBaseName((ChildAssociationRef)childAssocPair.getSecond(), true));
                            }
                        }
                        if (includeChildIds) {
                            boolean addCurrentId = true;
                            if (SOLRTrackingComponentImpl.this.typeIndexFilter.isIgnorePathsForSpecificTypes()) {
                                boolean bl = addCurrentId = !SOLRTrackingComponentImpl.this.typeIndexFilter.shouldBeIgnored(nodeType);
                            }
                            if (!addCurrentId) {
                                boolean bl = addCurrentId = !SOLRTrackingComponentImpl.this.aspectIndexFilter.shouldBeIgnored(SOLRTrackingComponentImpl.this.getNodeAspects((Long)childNodePair.getFirst()));
                            }
                            if (addCurrentId) {
                                childIds.add((Long)childNodePair.getFirst());
                            }
                        }
                        return true;
                    }

                    @Override
                    public void done() {
                    }
                });
                nodeMetaData.setChildAssocs(childAssocs);
                nodeMetaData.setChildIds(childIds);
            }
            if (includePaths && !ignoreLargeMetadata) {
                List<Path> directPaths = this.nodeDAO.getPaths((Pair<Long, NodeRef>)new Pair((Object)nodeId, (Object)status.getNodeRef()), false);
                ArrayList<Pair<Path, QName>> paths = new ArrayList<Pair<Path, QName>>(directPaths.size() + categoryPaths.getPaths().size());
                for (Path path : directPaths) {
                    paths.add((Pair<Path, QName>)new Pair((Object)path.getBaseNamePath(this.tenantService), null));
                }
                for (Pair<Path, QName> catPair : categoryPaths.getPaths()) {
                    paths.add((Pair<Path, QName>)new Pair((Object)((Path)catPair.getFirst()).getBaseNamePath(this.tenantService), (Object)((QName)catPair.getSecond())));
                }
                if (unversionedStatus != null) {
                    List<Path> unversionedPaths = this.nodeDAO.getPaths((Pair<Long, NodeRef>)new Pair((Object)unversionedStatus.getDbId(), (Object)unversionedStatus.getNodeRef()), false);
                    for (Path path : unversionedPaths) {
                        paths.add((Pair<Path, QName>)new Pair((Object)path.getBaseNamePath(this.tenantService), null));
                    }
                }
                nodeMetaData.setPaths(paths);
                ArrayList<Collection<String>> namePaths = new ArrayList<Collection<String>>(2);
                nodeMetaData.setNamePaths(namePaths);
                block8: for (Pair pair : paths) {
                    Path path = (Path)pair.getFirst();
                    boolean added = false;
                    ArrayList<String> namePath = new ArrayList<String>(path.size());
                    for (Path.Element pathElement : path) {
                        Path.ChildAssocElement pathChildAssocElement;
                        NodeRef childNodeRef;
                        Pair<Long, NodeRef> childNodePair;
                        if (!(pathElement instanceof Path.ChildAssocElement) || (childNodePair = this.nodeDAO.getNodePair(childNodeRef = (pathChildAssocElement = (Path.ChildAssocElement)pathElement).getRef().getChildRef())) == null) continue block8;
                        Long childNodeId = (Long)childNodePair.getFirst();
                        String childNodeName = (String)((Object)this.nodeDAO.getNodeProperty(childNodeId, ContentModel.PROP_NAME));
                        if (childNodeName == null) {
                            namePath.clear();
                            continue;
                        }
                        namePath.add(childNodeName);
                        if (added) continue;
                        namePaths.add(namePath);
                        added = true;
                    }
                }
            }
            if (includeOwner) {
                nodeMetaData.setOwner(this.ownableService.getOwner(status.getNodeRef()));
            }
            rowHandler.processResult(nodeMetaData);
        }
    }

    private boolean isVersionNodeRef(NodeRef nodeRef) {
        return nodeRef.getStoreRef().getProtocol().equals("versionStore") || nodeRef.getStoreRef().getIdentifier().equals("version2Store");
    }

    protected NodeRef convertVersionNodeRefToVersionedNodeRef(NodeRef versionNodeRef) {
        NodeRef.Status status = this.nodeDAO.getNodeRefStatus(versionNodeRef);
        if (status == null) {
            return versionNodeRef;
        }
        Map<QName, Serializable> properties = this.nodeDAO.getNodeProperties(status.getDbId());
        NodeRef nodeRef = null;
        if (versionNodeRef.getStoreRef().getIdentifier().equals("version2Store")) {
            nodeRef = (NodeRef)properties.get(Version2Model.PROP_QNAME_FROZEN_NODE_REF);
        } else if (versionNodeRef.getStoreRef().getIdentifier().equals("lightWeightVersionStore")) {
            nodeRef = new NodeRef((String)((Object)properties.get(VersionModel.PROP_QNAME_FROZEN_NODE_STORE_PROTOCOL)), (String)((Object)properties.get(VersionModel.PROP_QNAME_FROZEN_NODE_STORE_ID)), (String)((Object)properties.get(VersionModel.PROP_QNAME_FROZEN_NODE_ID)));
        }
        return nodeRef;
    }

    private QName getNodeType(Long nodeId) {
        QName result = this.nodeDAO.getNodeType(nodeId);
        TypeDefinition type = this.dictionaryService.getType(result);
        return type == null ? null : result;
    }

    private Set<QName> getNodeAspects(Long nodeId) {
        HashSet<QName> aspects = new HashSet<QName>();
        if (nodeId == null) {
            return aspects;
        }
        Set<QName> sourceAspects = this.nodeDAO.getNodeAspects(nodeId);
        for (QName aspectQName : sourceAspects) {
            AspectDefinition aspect = this.dictionaryService.getAspect(aspectQName);
            if (aspect == null) continue;
            aspects.add(aspectQName);
        }
        return aspects;
    }

    @Override
    public AlfrescoModel getModel(QName modelName) {
        if (this.enabled) {
            ModelDefinition modelDef = this.dictionaryService.getModel(modelName);
            return modelDef != null ? new AlfrescoModel(modelDef) : null;
        }
        return null;
    }

    @Override
    public List<AlfrescoModelDiff> getModelDiffs(Map<QName, Long> models) {
        if (!this.enabled) {
            return Collections.emptyList();
        }
        ArrayList<AlfrescoModelDiff> diffs = new ArrayList<AlfrescoModelDiff>();
        Collection allModels = this.dictionaryService.getAllModels();
        for (QName modelName : models.keySet()) {
            if (allModels.contains(modelName)) {
                Long checksum = models.get(modelName);
                AlfrescoModel serverModel = this.getModel(modelName);
                if (serverModel.getChecksum() == checksum.longValue()) continue;
                diffs.add(new AlfrescoModelDiff(modelName, AlfrescoModelDiff.TYPE.CHANGED, checksum, (Long)serverModel.getChecksum()));
                continue;
            }
            diffs.add(new AlfrescoModelDiff(modelName, AlfrescoModelDiff.TYPE.REMOVED, null, null));
        }
        for (QName modelName : allModels) {
            if (models.containsKey(modelName)) continue;
            AlfrescoModel model = this.getModel(modelName);
            diffs.add(new AlfrescoModelDiff(modelName, AlfrescoModelDiff.TYPE.NEW, null, (Long)model.getChecksum()));
        }
        return diffs;
    }

    @Override
    public Long getMaxTxnCommitTime() {
        this.nodeDAO.setCheckNodeConsistency();
        return this.nodeDAO.getMaxTxnCommitTime();
    }

    @Override
    public Long getMaxTxnId() {
        long maxCommitTime = System.currentTimeMillis() + 1L;
        this.nodeDAO.setCheckNodeConsistency();
        return this.nodeDAO.getMaxTxnIdByCommitTime(maxCommitTime);
    }

    @Override
    public Long getMaxChangeSetCommitTime() {
        return this.aclDAO.getMaxChangeSetCommitTime();
    }

    @Override
    public Long getMaxChangeSetId() {
        long maxCommitTime = System.currentTimeMillis() + 1L;
        return this.aclDAO.getMaxChangeSetIdByCommitTime(maxCommitTime);
    }

    @Override
    public void registerShardState(ShardState shardState) {
        if (this.shardRegistry != null) {
            this.shardRegistry.registerShardState(shardState);
        }
    }

    @Override
    public ShardRegistry getShardRegistry() {
        return this.shardRegistry;
    }

    static class CategoryPaths {
        Collection<Pair<Path, QName>> paths;
        List<ChildAssociationRef> categoryParents;

        CategoryPaths(Collection<Pair<Path, QName>> paths, List<ChildAssociationRef> categoryParents) {
            this.paths = paths;
            this.categoryParents = categoryParents;
        }

        public Collection<Pair<Path, QName>> getPaths() {
            return this.paths;
        }

        public List<ChildAssociationRef> getCategoryParents() {
            return this.categoryParents;
        }
    }

    protected class NodeMetaDataQueryRowHandler {
        private final SearchTrackingComponent.NodeMetaDataQueryCallback callback;
        private boolean more;

        private NodeMetaDataQueryRowHandler(SearchTrackingComponent.NodeMetaDataQueryCallback callback) {
            this.callback = callback;
            this.more = true;
        }

        public void processResult(NodeMetaData row) {
            if (!this.more) {
                return;
            }
            this.more = this.callback.handleNodeMetaData(row);
        }
    }

    protected class NodeQueryRowHandler {
        private final SearchTrackingComponent.NodeQueryCallback callback;
        private boolean more;

        private NodeQueryRowHandler(SearchTrackingComponent.NodeQueryCallback callback) {
            this.callback = callback;
            this.more = true;
        }

        public void processResult(Node row) {
            if (!this.more) {
                return;
            }
            this.more = this.callback.handleNode(row);
        }
    }

    private static class SequenceIterator
    implements Iterable<Long>,
    Iterator<Long> {
        private long fromId;
        private long toId;
        private long counter;
        private int maxResults;
        private boolean inUse = false;

        SequenceIterator(Long fromId, Long toId, int maxResults) {
            this.fromId = fromId == null ? 1L : fromId;
            this.toId = toId == null ? Long.MAX_VALUE : toId;
            this.maxResults = maxResults;
            this.counter = this.fromId;
        }

        @Override
        public Iterator<Long> iterator() {
            if (this.inUse) {
                throw new IllegalStateException("Already in use");
            }
            this.counter = this.fromId;
            this.inUse = true;
            return this;
        }

        @Override
        public boolean hasNext() {
            return this.counter - this.fromId < (long)this.maxResults && this.counter <= this.toId;
        }

        @Override
        public Long next() {
            return this.counter++;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

