/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication.identityservice.user;

import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authentication.identityservice.user.DecodedTokenUser;
import org.alfresco.repo.security.authentication.identityservice.user.OIDCUserInfo;
import org.alfresco.service.cmr.security.PersonService;

public class TokenUserToOIDCUserMapper {
    private final PersonService personService;

    public TokenUserToOIDCUserMapper(PersonService personService) {
        this.personService = personService;
    }

    public OIDCUserInfo toOIDCUser(DecodedTokenUser decodedTokenUser) {
        return new OIDCUserInfo(this.usernameToUserId(decodedTokenUser.username()), decodedTokenUser.firstName(), decodedTokenUser.lastName(), decodedTokenUser.email());
    }

    private String usernameToUserId(final String caseSensitiveUserName) {
        if (caseSensitiveUserName == null) {
            return null;
        }
        String normalized = (String)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<String>(){

            public String doWork() throws Exception {
                return TokenUserToOIDCUserMapper.this.personService.getUserIdentifier(caseSensitiveUserName);
            }
        }, (String)AuthenticationUtil.getSystemUserName());
        return normalized == null ? caseSensitiveUserName : normalized;
    }
}

