/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.admin.patch.AsynchronousPatch;
import org.alfresco.repo.batch.BatchProcessWorkProvider;
import org.alfresco.repo.batch.BatchProcessor;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.site.SiteModel;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.site.SiteService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;

public class AddUnmovableAspectToSitesPatch
extends AsynchronousPatch {
    private static Log logger = LogFactory.getLog(AddUnmovableAspectToSitesPatch.class);
    private static final String MSG_SUCCESS = "patch.addUnmovableAspect.result";
    private final int NUM_THREADS = 4;
    private final int BATCH_SIZE = 200;
    private SiteService siteService;
    private BehaviourFilter behaviourFilter;

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setBehaviourFilter(BehaviourFilter behaviourFilter) {
        this.behaviourFilter = behaviourFilter;
    }

    @Override
    protected String applyInternal() throws Exception {
        BatchProcessWorkProvider<ChildAssociationRef> workProvider = new BatchProcessWorkProvider<ChildAssociationRef>(){
            NodeRef sitesRoot;
            List<ChildAssociationRef> sites;
            final Iterator<ChildAssociationRef> iterator;
            {
                this.sitesRoot = AddUnmovableAspectToSitesPatch.this.siteService.getSiteRoot();
                this.sites = AddUnmovableAspectToSitesPatch.this.nodeService.getChildAssocs(this.sitesRoot, Collections.singleton(SiteModel.TYPE_SITE));
                this.iterator = this.sites.listIterator();
            }

            @Override
            public int getTotalEstimatedWorkSize() {
                return this.sites.size();
            }

            @Override
            public long getTotalEstimatedWorkSizeLong() {
                return this.sites.size();
            }

            @Override
            public Collection<ChildAssociationRef> getNextWork() {
                ArrayList<ChildAssociationRef> sites = new ArrayList<ChildAssociationRef>(200);
                while (this.iterator.hasNext() && sites.size() <= 200) {
                    sites.add(this.iterator.next());
                }
                return sites;
            }
        };
        RetryingTransactionHelper txnHelper = this.transactionService.getRetryingTransactionHelper();
        txnHelper.setForceWritable(true);
        BatchProcessor<ChildAssociationRef> batchProcessor = new BatchProcessor<ChildAssociationRef>("AddUnmovableAspectToSitesPatch", txnHelper, workProvider, 4, 200, this.applicationEventPublisher, logger, 1000);
        final String authenticatedUser = AuthenticationUtil.getFullyAuthenticatedUser();
        BatchProcessor.BatchProcessWorker<ChildAssociationRef> worker = new BatchProcessor.BatchProcessWorker<ChildAssociationRef>(){

            @Override
            public void afterProcess() throws Throwable {
            }

            @Override
            public void beforeProcess() throws Throwable {
            }

            @Override
            public String getIdentifier(ChildAssociationRef entry) {
                return entry.toString();
            }

            @Override
            public void process(final ChildAssociationRef child) throws Throwable {
                AuthenticationUtil.RunAsWork<Void> work = new AuthenticationUtil.RunAsWork<Void>(){

                    public Void doWork() throws Exception {
                        try {
                            AddUnmovableAspectToSitesPatch.this.behaviourFilter.disableBehaviour(ContentModel.ASPECT_AUDITABLE);
                            AddUnmovableAspectToSitesPatch.this.nodeService.addAspect(child.getChildRef(), ContentModel.ASPECT_UNMOVABLE, null);
                        }
                        finally {
                            AddUnmovableAspectToSitesPatch.this.behaviourFilter.enableBehaviour(ContentModel.ASPECT_AUDITABLE);
                        }
                        return null;
                    }
                };
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)work, (String)authenticatedUser);
            }
        };
        batchProcessor.process(worker, true);
        return I18NUtil.getMessage((String)MSG_SUCCESS);
    }
}

