/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.traitextender;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.alfresco.traitextender.Extender;
import org.alfresco.traitextender.ExtensionBundle;
import org.alfresco.traitextender.ExtensionFactory;
import org.alfresco.traitextender.ExtensionPoint;
import org.alfresco.traitextender.InstanceExtensionFactory;
import org.alfresco.traitextender.RegistryExtensionBundle;
import org.alfresco.traitextender.SingletonExtension;
import org.alfresco.traitextender.SingletonExtensionFactory;
import org.alfresco.traitextender.TestException;
import org.alfresco.traitextender.TestExtension;
import org.alfresco.traitextender.TestExtensionImpl;
import org.alfresco.traitextender.TestPublicExtension;
import org.alfresco.traitextender.TestPublicExtensionImpl;
import org.alfresco.traitextender.TestPublicService;
import org.alfresco.traitextender.TestPublicServiceExtension;
import org.alfresco.traitextender.TestPublicTrait;
import org.alfresco.traitextender.TestRuntimeException;
import org.alfresco.traitextender.TestService;
import org.alfresco.traitextender.TestServiceExtension;
import org.alfresco.traitextender.TestSingletonExtensionImpl;
import org.alfresco.traitextender.TestTrait;

public class TraitExtenderIntegrationTest
extends TestCase {
    private RegistryExtensionBundle extensionBundle;
    private RegistryExtensionBundle singletonExtensionBundle;
    private RegistryExtensionBundle publicExtensionBundle;

    protected void setUp() throws Exception {
        Extender.getInstance().stopAll();
        this.extensionBundle = new RegistryExtensionBundle("extensionBundle");
        this.extensionBundle.register(new ExtensionPoint(TestExtension.class, TestTrait.class), (ExtensionFactory)new InstanceExtensionFactory(TestExtensionImpl.class, TestTrait.class, TestExtension.class));
        TestSingletonExtensionImpl sigletonExtension = new TestSingletonExtensionImpl("s1");
        this.singletonExtensionBundle = new RegistryExtensionBundle("singletonExtensionBundle");
        this.singletonExtensionBundle.register(new ExtensionPoint(TestExtension.class, TestTrait.class), (ExtensionFactory)new SingletonExtensionFactory((SingletonExtension)sigletonExtension, TestExtension.class));
        this.publicExtensionBundle = new RegistryExtensionBundle("publicExtensionBundle");
        this.publicExtensionBundle.register(new ExtensionPoint(TestPublicExtension.class, TestPublicTrait.class), (ExtensionFactory)new InstanceExtensionFactory(TestPublicExtensionImpl.class, TestPublicTrait.class, TestPublicExtension.class));
    }

    public void testIntegration() {
        Extender.getInstance().start((ExtensionBundle)this.extensionBundle);
        TraitExtenderIntegrationTest.assertEquals((String)"TestService.privateServiceMethod1(testIntegration) TestExtensionImpl.privateServiceMethod1(testIntegration)", (String)new TestService("psm1").publicServiceMethod1("testIntegration"));
    }

    public void testIntegration_overrideExtensible_1() {
        Extender.getInstance().start((ExtensionBundle)this.extensionBundle);
        String expectedSuffix = new TestService("psm1").publicServiceMethod3("testIntegration");
        TraitExtenderIntegrationTest.assertEquals((String)("x" + expectedSuffix), (String)new TestServiceExtension("psm1").publicServiceMethod3("testIntegration"));
    }

    public void testIntegration_stoppedBundle() {
        TestService preStopService = new TestService("psm1");
        Extender.getInstance().start((ExtensionBundle)this.extensionBundle);
        TraitExtenderIntegrationTest.assertEquals((String)"TestService.privateServiceMethod1(testIntegration) TestExtensionImpl.privateServiceMethod1(testIntegration)", (String)preStopService.publicServiceMethod1("testIntegration"));
        Extender.getInstance().stop((ExtensionBundle)this.extensionBundle);
        TestService postStopService = new TestService("psm1");
        TraitExtenderIntegrationTest.assertEquals((String)"TestService.privateServiceMethod1(testIntegration)", (String)postStopService.publicServiceMethod1("testIntegration"));
        TraitExtenderIntegrationTest.assertEquals((String)"TestService.privateServiceMethod1(testIntegration)", (String)preStopService.publicServiceMethod1("testIntegration"));
    }

    public void testIntegration_singletonExtension() {
        Extender.getInstance().start((ExtensionBundle)this.singletonExtensionBundle);
        TraitExtenderIntegrationTest.assertEquals((String)"psm1 TestSingletonExtensionImpl.publicServiceMethod2(testIntegration)@s1", (String)new TestService("psm1").publicServiceMethod2("testIntegration"));
        TraitExtenderIntegrationTest.assertEquals((String)"psm2 TestSingletonExtensionImpl.publicServiceMethod2(testIntegration)@s1", (String)new TestService("psm2").publicServiceMethod2("testIntegration"));
    }

    public void testIntegration_publicTrait() {
        Extender.getInstance().start((ExtensionBundle)this.publicExtensionBundle);
        TraitExtenderIntegrationTest.assertEquals((String)"EPM1PM1testIntegration", (String)new TestPublicService().publicMethod1("testIntegration"));
        TraitExtenderIntegrationTest.assertEquals((String)"EPM2PM2testIntegration", (String)new TestPublicService().publicMethod2("testIntegration"));
    }

    public void testIntegration_publicOverridenExtensible_1() {
        Extender.getInstance().start((ExtensionBundle)this.publicExtensionBundle);
        TraitExtenderIntegrationTest.assertEquals((String)"XEPM1PM1testIntegration", (String)new TestPublicServiceExtension().publicMethod1("testIntegration"));
    }

    public void testIntegration_publicOverridenExtensible_2() {
        Extender.getInstance().start((ExtensionBundle)this.publicExtensionBundle);
        TraitExtenderIntegrationTest.assertEquals((String)"XEPM2PM2testIntegration", (String)new TestPublicServiceExtension().publicMethod2("testIntegration"));
    }

    public void testIntegration_bypass() {
        Extender.getInstance().start((ExtensionBundle)this.singletonExtensionBundle);
        TraitExtenderIntegrationTest.assertEquals((String)"PSM3TestService.privateServiceMethod1(bypass) TestSingletonExtensionImpl.privateServiceMethod1(bypass)@s1 TestSingletonExtensionImpl.publicServiceMethod3(bypass)@s1", (String)new TestService("SBP").publicServiceMethod3("bypass"));
    }

    public void testIntegration_exceptionHandling() {
        Extender.getInstance().start((ExtensionBundle)this.publicExtensionBundle);
        try {
            new TestPublicService().publicMethod3(true, false);
            TraitExtenderIntegrationTest.fail((String)"An exception was expected!");
        }
        catch (TestException testException) {
        }
        catch (Exception e) {
            TraitExtenderIntegrationTest.fail((String)(TestException.class + " wa expected but got " + e));
        }
    }

    public void testIntegration_runtimeExceptionHandling() {
        Extender.getInstance().start((ExtensionBundle)this.publicExtensionBundle);
        try {
            new TestPublicService().publicMethod4(true, false);
            TraitExtenderIntegrationTest.fail((String)"An exception was expected!");
        }
        catch (TestRuntimeException testRuntimeException) {
        }
        catch (Exception e) {
            e.printStackTrace();
            TraitExtenderIntegrationTest.fail((String)(TestRuntimeException.class + " wa expected but got " + e.getClass()));
        }
        try {
            new TestPublicService().publicMethod4(false, true);
            TraitExtenderIntegrationTest.fail((String)"An exception was expected!");
        }
        catch (TestRuntimeException testRuntimeException) {
        }
        catch (Exception e) {
            e.printStackTrace();
            TraitExtenderIntegrationTest.fail((String)(TestRuntimeException.class + " wa expected but got " + e.getClass()));
        }
    }

    private void assertNoThreadTraitSideEffect() {
        TestService s1 = new TestService("psm1");
        TestService s2 = new TestService("psm2");
        Integer s1Id = System.identityHashCode(s1);
        Integer s2Id = System.identityHashCode(s2);
        ArrayList<Integer> traitIdentities = new ArrayList<Integer>();
        s1.publicServiceMethod3(s2, traitIdentities);
        TraitExtenderIntegrationTest.assertEquals((int)6, (int)traitIdentities.size());
        Integer s1TraitId = (Integer)traitIdentities.get(0);
        Integer s2TraitId = (Integer)traitIdentities.get(1);
        TraitExtenderIntegrationTest.assertFalse((boolean)s1TraitId.equals(s2TraitId));
        TraitExtenderIntegrationTest.assertEquals((Object)s2TraitId, traitIdentities.get(2));
        TraitExtenderIntegrationTest.assertEquals((Object)s2Id, traitIdentities.get(3));
        TraitExtenderIntegrationTest.assertEquals((Object)s1TraitId, traitIdentities.get(4));
        TraitExtenderIntegrationTest.assertEquals((Object)s1Id, traitIdentities.get(5));
    }

    public void testIntegration_threadTraitSideEffect() {
        Extender.getInstance().start((ExtensionBundle)this.singletonExtensionBundle);
        this.assertNoThreadTraitSideEffect();
        Extender.getInstance().stop((ExtensionBundle)this.singletonExtensionBundle);
        Extender.getInstance().start((ExtensionBundle)this.extensionBundle);
        this.assertNoThreadTraitSideEffect();
        Extender.getInstance().stop((ExtensionBundle)this.extensionBundle);
    }
}

